/*
 * Decompiled with CFR 0.152.
 */
package com.gentleware.poseidon.ui;

import com.gentleware.anvil.kernel.LicenseData;
import com.gentleware.anvil.kernel.ProductEditionImpl;
import com.gentleware.jboogie.command_framework.UndoManager;
import com.gentleware.jboogie.kernel.JBoogie;
import com.gentleware.jboogie.kernel.ProjectImpl;
import com.gentleware.jboogie.util.JBoogieUtils;
import com.gentleware.locksmith.client.LicenseChecker;
import com.gentleware.locksmith.client.LicenseKeys;
import com.gentleware.openapi.jboogie.Project;
import com.gentleware.openapi.jboogie.ProjectAction;
import com.gentleware.openapi.swingx.Localizer;
import com.gentleware.openapi.swingx.ResourceId;
import com.gentleware.openapi.util.Files;
import com.gentleware.openapi.util.Utils;
import com.gentleware.poseidon.BuildProperties;
import com.gentleware.poseidon.kernel.PoseidonProject;
import com.gentleware.poseidon.kernel.PoseidonProjectMemberManager;
import com.gentleware.poseidon.openapi.PoseidonUIConnector;
import com.gentleware.poseidon.ui.ActionSaveProjectAs;
import com.gentleware.poseidon.ui.CoreResourceBundle;
import com.gentleware.poseidon.ui.MenuResourceBundle;
import com.gentleware.poseidon.ui.PoseidonFrame;
import com.gentleware.poseidon.ui.ProjectPanel;
import com.gentleware.poseidon.util.UmlFunctions;
import com.gentleware.swingx.ProgressDialog;
import com.gentleware.swingx.SwingWorker;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.beans.PropertyVetoException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.text.MessageFormat;
import javax.jmi.reflect.InvalidObjectException;
import org.apache.log4j.Logger;

public class ActionSaveProject
extends ProjectAction {
    private static final Logger I = Logger.getLogger((String)"com.gentleware.poseidon.ui.ActionSaveProject");
    protected boolean ready = true;
    public static final String ARGO_TEE = "/com/gentleware/poseidon/xml/dtd/proj.tee";
    protected boolean _canceled;
    private static int K;
    private File J;

    public ActionSaveProject(Project project) {
        super(project, MenuResourceBundle.SaveProject);
    }

    protected ActionSaveProject(Project project, ResourceId resourceId) {
        super(project, resourceId);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.getProject().updateProjectBeforeAction();
        this.updateEnabled();
        if (!this.isEnabled()) {
            I.info((Object)"[ActionSave] Do nothing. The action is not enabled.");
            return;
        }
        this.B();
    }

    private void B() {
        boolean bl;
        URL uRL = this.getProject().getUrl();
        boolean bl2 = uRL == null;
        boolean bl3 = bl = uRL != null && uRL.toExternalForm().indexOf(".jar!") > 0;
        if (bl2 || bl) {
            new ActionSaveProjectAs(this.getProject()).trySave(false);
        } else {
            LicenseData licenseData = LicenseKeys.getInstance().getPoseidonLicenseData(BuildProperties.getPoseidonProduct());
            if (LicenseChecker.getInstance().runsAsEvaluation(licenseData) && licenseData.getApplication().getEdition() != ProductEditionImpl.CE && this.getProject().getDiagrams().size() > 8) {
                String string = Localizer.localize((ResourceId)CoreResourceBundle.evaluationLimit);
                Object[] objectArray = new Object[]{BuildProperties.getPoseidonNameShort(), BuildProperties.getEvalLimit()};
                String string2 = MessageFormat.format(string, objectArray);
                String string3 = Localizer.localize((ResourceId)CoreResourceBundle.evalLimitTitle);
                JBoogieUtils.showMessageDialog((Component)PoseidonUIConnector.getApplicationWindow(), (Object)string2, (String)string3, (int)1);
            } else {
                this.trySave(true);
            }
        }
        I.debug((Object)("[" + ((Object)((Object)this)).getClass() + "] project saved"));
    }

    public boolean trySave(String string) {
        return this.trySave(string, true);
    }

    public boolean trySave(boolean bl) {
        return this.trySave(null, bl);
    }

    public boolean trySave(String string, boolean bl) {
        Object[] objectArray;
        int n2;
        File file;
        this._canceled = false;
        PoseidonProject poseidonProject = (PoseidonProject)this.getProject();
        String string2 = "Untitled.zuml";
        URL uRL = poseidonProject.getUrl();
        if (uRL != null) {
            file = Utils.urlToFile((URL)uRL);
            string2 = file.getPath();
        }
        if (string != null) {
            string2 = string;
        }
        if (!string2.endsWith(".zuml")) {
            string2 = string2 + ".zuml";
        }
        if (string2.charAt(0) == '/' && string2.charAt(2) == ':') {
            string2 = string2.substring(1);
        }
        file = new File(string2);
        Object[] objectArray2 = new String[]{string2};
        Frame frame = PoseidonUIConnector.getApplicationWindow();
        if (file.exists() && !bl && ((n2 = JBoogieUtils.showConfirmDialog((Component)frame, (Object)(objectArray = MessageFormat.format(Localizer.localize((ResourceId)MenuResourceBundle.SureOverwrite), objectArray2)), (String)Localizer.localize((ResourceId)MenuResourceBundle.SaveProject), (int)0)) == 1 || n2 == -1)) {
            this._canceled = true;
            return false;
        }
        if (file.exists() && file.length() > 0L && !file.canWrite()) {
            objectArray = new String[]{string2};
            String string3 = MessageFormat.format(Localizer.localize((ResourceId)MenuResourceBundle.SureIgnoreWriteProtection), objectArray);
            int n3 = JBoogieUtils.showConfirmDialog((Component)frame, (Object)string3, (String)Localizer.localize((ResourceId)MenuResourceBundle.SaveProject), (int)0);
            if (n3 == 1 || n3 == -1) {
                this._canceled = true;
                return false;
            }
        }
        objectArray = null;
        if (ProjectImpl.isGuiMode()) {
            frame.setCursor(Cursor.getPredefinedCursor(3));
            objectArray = new ProgressDialog(frame, MenuResourceBundle.SavingProject);
            objectArray.setIndeterminate(true);
        }
        n2 = this.save(string2, poseidonProject, bl, (ProgressDialog)objectArray, frame) ? 1 : 0;
        return n2 != 0;
    }

    public File getTempFile_FOR_TESTING() {
        return this.J;
    }

    public boolean save(final String string, final PoseidonProject poseidonProject, boolean bl, final ProgressDialog progressDialog, final Frame frame) {
        PoseidonUIConnector.showStatus("Writing " + string);
        final File file = new File(string);
        File file2 = file.getParentFile();
        if (!file2.exists()) {
            file2.mkdirs();
        }
        String string2 = string + String.valueOf(System.currentTimeMillis()) + ".tmp";
        this.J = new File(string2);
        final String string3 = Localizer.localize((ResourceId)MenuResourceBundle.SavingProjectFailed);
        try {
            this.J.createNewFile();
        }
        catch (IOException iOException) {
            I.error((Object)"Exception during creation of new file. Saving stopped.", (Throwable)iOException);
            JBoogieUtils.showMessageDialog((Component)frame, (Object)"A problem occurred while saving.\nMaybe the destination folder is write protected. Please retry saving to another location.", (String)string3, (int)0);
            if (frame != null) {
                frame.setCursor(Cursor.getPredefinedCursor(0));
            }
            this._canceled = true;
            PoseidonProject.fireProjectChanged(poseidonProject, null, "LoadingFailed");
            return false;
        }
        SwingWorker swingWorker = new SwingWorker("Saving SwingWorker", true){

            public Object construct() {
                try {
                    URL uRL = Files.toUrl((File)file);
                    UmlFunctions.saveProject(poseidonProject, ActionSaveProject.this.J, PoseidonProject.getNameFromUrl(uRL), progressDialog);
                    if (ActionSaveProject.this.J.length() == 0L) {
                        ActionSaveProject.this._canceled = true;
                    } else {
                        boolean bl;
                        if (file.exists() && file.length() > 0L) {
                            K = K % 5;
                            File file2 = new File(string + ".bak." + K);
                            K++;
                            if (file2.exists()) {
                                file2.delete();
                            }
                            file.renameTo(file2);
                        }
                        if (!(bl = ActionSaveProject.this.J.renameTo(file))) {
                            JBoogieUtils.showMessageDialog((Component)frame, (Object)"A problem occurred while saving.\nMaybe the destination folder is write protected. Please retry saving to another location.", (String)string3, (int)0);
                            ActionSaveProject.this._canceled = true;
                        }
                    }
                }
                catch (InvalidObjectException invalidObjectException) {
                    if (frame != null) {
                        JBoogieUtils.showMessageDialog((Component)frame, (Object)("A problem occurred while saving: \"" + invalidObjectException.getMessage() + "\".\n" + "The project seems to be corrupted."), (String)string3, (int)0);
                    }
                    ActionSaveProject.this._canceled = true;
                    I.warn((Object)("[ActionSaveProject] caught unspecified Exception " + invalidObjectException.getMessage()), (Throwable)invalidObjectException);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    if (frame != null) {
                        JBoogieUtils.showMessageDialog((Component)frame, (Object)("A problem occurred while saving: \"" + fileNotFoundException.getMessage() + "\".\n" + "Maybe the file is corrupted. Please retry saving to another location."), (String)string3, (int)0);
                    }
                    ActionSaveProject.this._canceled = true;
                    I.error((Object)("[ActionSaveProject] caught FileNotFoundException " + fileNotFoundException.getMessage()), (Throwable)fileNotFoundException);
                }
                catch (IOException iOException) {
                    if (frame != null) {
                        JBoogieUtils.showMessageDialog((Component)frame, (Object)("A problem occurred while saving: \"" + iOException.getMessage() + "\".\n" + "Maybe the file is corrupted. Please retry saving to another location."), (String)string3, (int)0);
                    }
                    ActionSaveProject.this._canceled = true;
                    I.error((Object)("[ActionSaveProject] caught FileNotFoundException " + iOException.getMessage()), (Throwable)iOException);
                }
                catch (Exception exception) {
                    if (frame != null) {
                        JBoogieUtils.showMessageDialog((Component)frame, (Object)("A problem occurred while saving: \"" + exception.getMessage() + "\".\n" + "Maybe the file is corrupted. Please retry saving to another location."), (String)string3, (int)0);
                    }
                    ActionSaveProject.this._canceled = true;
                    I.warn((Object)("[ActionSaveProject] caught unspecified Exception " + exception.getMessage()), (Throwable)exception);
                }
                if (ActionSaveProject.this._canceled) {
                    PoseidonProject.fireProjectChanged(poseidonProject, null, "LoadingFailed");
                }
                return poseidonProject;
            }

            public void finished() {
                boolean bl;
                Object object;
                if (!ActionSaveProject.this._canceled) {
                    object = (PoseidonProjectMemberManager)JBoogie.getInstance().getProjectMemberManager();
                    ((PoseidonProjectMemberManager)object).cleanUpDeletedMembers();
                    if (file != null && frame != null) {
                        ProjectPanel.getPanelFor((Project)poseidonProject).addToRecentFileList(file);
                    }
                    if (frame != null && progressDialog != null) {
                        PoseidonUIConnector.showStatus("Wrote " + string);
                        progressDialog.hideProgressDialog();
                    }
                } else {
                    ActionSaveProject.this.J.delete();
                    if (frame != null && progressDialog != null) {
                        PoseidonUIConnector.showStatus("Save " + string + " canceled.");
                        progressDialog.hideProgressDialog();
                    }
                }
                if (frame != null) {
                    frame.setCursor(Cursor.getPredefinedCursor(0));
                }
                object = poseidonProject.getUrl();
                URL uRL = Files.toUrl((File)new File(string));
                boolean bl2 = bl = object == null || !((URL)object).equals(uRL);
                if (bl) {
                    try {
                        poseidonProject.setUrl(uRL);
                        if (frame instanceof PoseidonFrame) {
                            ((PoseidonFrame)frame).updateTitle();
                        }
                    }
                    catch (PropertyVetoException propertyVetoException) {
                        I.error((Object)propertyVetoException);
                    }
                }
                ActionSaveProject.this.setReady(true);
                UndoManager undoManager = poseidonProject.getUndoManager();
                undoManager.setSaved();
            }
        };
        this.setReady(false);
        swingWorker.start();
        if (progressDialog != null && frame != null) {
            progressDialog.showProgressDialog(Localizer.localize((ResourceId)MenuResourceBundle.SavingProject) + " " + poseidonProject.getName(), (Component)frame, poseidonProject.getMemberNum() + 2);
        }
        return true;
    }

    public void updateEnabled() {
        Project project = this.getProject();
        if (project == null) {
            this.setEnabled(false);
        } else {
            boolean bl = this.getProject().needsSave();
            this.setEnabled(bl);
        }
    }

    public boolean isReady() {
        return this.ready;
    }

    public synchronized void setReady(boolean bl) {
        this.ready = bl;
    }

    public boolean isCanceled() {
        return this._canceled;
    }
}

