/*
 * Decompiled with CFR 0.152.
 */
package com.gentleware.poseidon.ui;

import com.gentleware.anvil.kernel.LicenseData;
import com.gentleware.anvil.kernel.ProductEditionImpl;
import com.gentleware.jboogie.util.JBoogieUtils;
import com.gentleware.locksmith.client.LicenseChecker;
import com.gentleware.locksmith.client.LicenseKeys;
import com.gentleware.openapi.jboogie.Project;
import com.gentleware.openapi.swingx.Localizer;
import com.gentleware.openapi.swingx.ResourceId;
import com.gentleware.openapi.util.Strings;
import com.gentleware.openapi.util.Utils;
import com.gentleware.poseidon.BuildProperties;
import com.gentleware.poseidon.jboogie.PoseidonApplicationState;
import com.gentleware.poseidon.kernel.PoseidonProject;
import com.gentleware.poseidon.openapi.PoseidonUIConnector;
import com.gentleware.poseidon.ui.ActionSaveProject;
import com.gentleware.poseidon.ui.CoreResourceBundle;
import com.gentleware.poseidon.ui.MenuResourceBundle;
import com.gentleware.poseidon.util.FileFilters;
import com.gentleware.swingx.SuffixFileFilter;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.io.File;
import java.net.URL;
import java.text.MessageFormat;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import org.apache.log4j.Logger;

public class ActionSaveProjectAs
extends ActionSaveProject {
    private static final Logger L = Logger.getLogger((String)"com.gentleware.poseidon.ui.ActionSaveProjectAs");
    private static JFileChooser M;

    public ActionSaveProjectAs(Project project) {
        super(project, MenuResourceBundle.SaveProjectAs);
    }

    private static void C() {
        M = new JFileChooser();
        M.setName("SaveProjectAs");
        SuffixFileFilter suffixFileFilter = FileFilters.getFilter("zuml");
        M.addChoosableFileFilter((FileFilter)suffixFileFilter);
        M.setFileFilter((FileFilter)suffixFileFilter);
        M.removeChoosableFileFilter(M.getAcceptAllFileFilter());
        Dimension dimension = M.getPreferredSize();
        if (dimension.height <= 400) {
            dimension.height += 200;
            M.setPreferredSize(dimension);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        LicenseData licenseData = LicenseKeys.getInstance().getPoseidonLicenseData(BuildProperties.getPoseidonProduct());
        if (LicenseChecker.getInstance().runsAsEvaluation(licenseData) && licenseData.getApplication().getEdition() != ProductEditionImpl.CE && this.getProject().getDiagrams().size() > 8) {
            String string = Localizer.localize((ResourceId)CoreResourceBundle.evaluationLimit);
            Object[] objectArray = new Object[]{BuildProperties.getPoseidonNameShort(), BuildProperties.getEvalLimit()};
            String string2 = MessageFormat.format(string, objectArray);
            String string3 = Localizer.localize((ResourceId)CoreResourceBundle.evalLimitTitle);
            JBoogieUtils.showMessageDialog((Component)PoseidonUIConnector.getApplicationWindow(), (Object)string2, (String)string3, (int)1);
        } else {
            this.trySave(false);
        }
    }

    public boolean trySave(boolean bl) {
        String string;
        Object object;
        PoseidonProject poseidonProject = (PoseidonProject)this.getProject();
        Frame frame = PoseidonUIConnector.getApplicationWindow();
        ActionSaveProjectAs.C();
        try {
            URL uRL = poseidonProject.getUrl();
            if (uRL != null) {
                object = Utils.urlToFile((URL)uRL);
                string = Strings.stripSuffix((String)((File)object).getPath()) + ".zuml";
                if (string.length() > 0 && !string.startsWith("/FILE1/+/")) {
                    M.setSelectedFile(new File(string));
                }
            } else {
                object = PoseidonApplicationState.getLastProjectDirectory();
                M.setSelectedFile(new File((String)object));
            }
        }
        catch (Exception exception) {
            L.error((Object)"[ActionSaveProjectAs:Opening FileChooser]", (Throwable)exception);
        }
        M.setDialogTitle(Localizer.localize((ResourceId)MenuResourceBundle.SaveProject) + ": " + poseidonProject.getName());
        int n2 = M.showSaveDialog(frame);
        boolean bl2 = this._canceled = n2 != 0;
        if (n2 == 0 && (object = M.getSelectedFile()) != null) {
            string = ((File)object).getPath();
            if (!string.endsWith(".zuml")) {
                string = string + ".zuml";
            }
            if (super.trySave(string, false)) {
                String string2 = ((File)object).getParent();
                PoseidonApplicationState.setLastProjectDirectory(string2);
                return true;
            }
        }
        return false;
    }

    public void updateEnabled() {
        this.setEnabled(true);
    }
}

