/*
 * Decompiled with CFR 0.152.
 */
package com.gentleware.poseidon.ui;

import com.gentleware.jboogie.ui.DiagramPanel;
import com.gentleware.openapi.jboogie.GlobalAction;
import com.gentleware.openapi.swingx.ResourceId;
import com.gentleware.openapi.util.CollectionFactory;
import com.gentleware.poseidon.openapi.PoseidonUIConnector;
import com.gentleware.poseidon.ui.MenuResourceBundle;
import java.awt.event.ActionEvent;
import java.util.Iterator;
import java.util.Set;

public class ActionZoom
extends GlobalAction {
    public static final double ZOOM_SCALE_MIN = 0.15;
    public static final double ZOOM_SCALE_MAX = 2.0;
    private static final Set H = CollectionFactory.createWeakHashSet();
    private double G;

    public ActionZoom(int n2, ResourceId resourceId) {
        super(resourceId);
        this.G = (double)n2 / 100.0;
        H.add(this);
    }

    public int getScalePercent() {
        return (int)(this.G * 100.0);
    }

    public void updateEnabled() {
        DiagramPanel diagramPanel = PoseidonUIConnector.getCurrentDiagramPanel();
        if (diagramPanel == null) {
            this.setEnabled(false);
        } else {
            double d2 = diagramPanel.getScale();
            boolean bl = d2 != this.G;
            this.setEnabled(bl);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        DiagramPanel diagramPanel = PoseidonUIConnector.getCurrentDiagramPanel();
        diagramPanel.setScale(this.G);
    }

    public static void updateAllEnabled() {
        Iterator iterator = H.iterator();
        while (iterator.hasNext()) {
            ActionZoom actionZoom = (ActionZoom)((Object)iterator.next());
            if (actionZoom == null) continue;
            actionZoom.updateEnabled();
        }
    }

    public static class ActionZoom150
    extends ActionZoom {
        public ActionZoom150() {
            super(150, MenuResourceBundle.Zoom150);
        }
    }

    public static class ActionZoom125
    extends ActionZoom {
        public ActionZoom125() {
            super(125, MenuResourceBundle.Zoom125);
        }
    }

    public static class ActionZoom100
    extends ActionZoom {
        public ActionZoom100() {
            super(100, MenuResourceBundle.Zoom100);
        }
    }

    public static class ActionZoom75
    extends ActionZoom {
        public ActionZoom75() {
            super(75, MenuResourceBundle.Zoom75);
        }
    }

    public static class ActionZoom50
    extends ActionZoom {
        public ActionZoom50() {
            super(50, MenuResourceBundle.Zoom50);
        }
    }

    public static class ActionZoom25
    extends ActionZoom {
        public ActionZoom25() {
            super(25, MenuResourceBundle.Zoom25);
        }
    }
}

