/*
 * Decompiled with CFR 0.152.
 */
package com.gentleware.poseidon.ui;

import com.gentleware.jboogie.util.JBoogieUtils;
import com.gentleware.openapi.jboogie.Project;
import com.gentleware.openapi.swingx.Localizer;
import com.gentleware.openapi.swingx.ResourceId;
import com.gentleware.poseidon.jboogie.PoseidonApplicationState;
import com.gentleware.poseidon.kernel.PoseidonProject;
import com.gentleware.poseidon.license.A.D;
import com.gentleware.poseidon.openapi.PoseidonUIConnector;
import com.gentleware.poseidon.ui.ActionSaveProject;
import com.gentleware.poseidon.ui.ActionSaveProjectAs;
import com.gentleware.poseidon.ui.MenuResourceBundle;
import com.gentleware.poseidon.ui.PoseidonFrame;
import com.gentleware.poseidon.ui.ProjectPanel;
import com.gentleware.poseidon.util.plugin.PoseidonModuleInstaller;
import java.awt.Component;
import java.awt.Frame;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.beans.VetoableChangeSupport;
import java.lang.reflect.InvocationTargetException;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class ExitHandler {
    private static final Logger C = Logger.getLogger((String)"com.gentleware.poseidon.ui.ExitHandler");
    private static ExitHandler B = new ExitHandler();
    private transient VetoableChangeSupport A = new VetoableChangeSupport(this);
    private volatile int D = 0;
    private volatile int E = 0;

    private ExitHandler() {
    }

    public static ExitHandler getInstance() {
        return B;
    }

    public void requestExit() {
        String string;
        PoseidonProject poseidonProject = PoseidonApplicationState.getInstance().getCurrentProject();
        ProjectPanel projectPanel = ProjectPanel.getPanelFor((Project)poseidonProject);
        Object object = null;
        if (poseidonProject != null && poseidonProject.needsSave()) {
            string = Localizer.localize((ResourceId)MenuResourceBundle.SaveChanges) + poseidonProject.getName() + "?";
            int n2 = JBoogieUtils.showConfirmDialog((Component)PoseidonUIConnector.getApplicationWindow(), (Object)string, (String)string, (int)1);
            if (n2 == 2) {
                return;
            }
            if (n2 == -1) {
                this.A();
                return;
            }
            if (n2 == 1) {
                this.A();
            } else if (n2 == 0) {
                boolean bl = false;
                ActionSaveProject actionSaveProject = new ActionSaveProject((Project)poseidonProject);
                if (actionSaveProject.isEnabled() && poseidonProject.getUrl() != null) {
                    object = actionSaveProject;
                    bl = ((ActionSaveProject)((Object)object)).trySave(true);
                }
                if (!bl) {
                    object = new ActionSaveProjectAs((Project)poseidonProject);
                    bl = ((ActionSaveProject)((Object)object)).trySave(false);
                }
                if (!bl) {
                    return;
                }
                this.A();
            }
        }
        if (object == null) {
            PoseidonModuleInstaller.exit();
            this.updateConfig(poseidonProject, projectPanel);
            if (poseidonProject != null) {
                poseidonProject.dispose();
            }
            PoseidonApplicationState.getInstance().dispose();
            this.exitOnCompleteAcknowledge();
            return;
        }
        string = object;
        Runnable runnable = new Runnable((ActionSaveProject)((Object)string)){
            final /* synthetic */ ActionSaveProject val$saveAction;
            {
                this.val$saveAction = actionSaveProject;
            }

            public void run() {
                try {
                    while (!this.val$saveAction.isReady()) {
                        Thread.sleep(1000L);
                    }
                }
                catch (Exception exception) {
                    C.error((Object)"[ActionExit]", (Throwable)exception);
                }
                ExitHandler.this.exitOnCompleteAcknowledge();
            }
        };
        Thread thread = new Thread(runnable);
        thread.start();
    }

    private void A() {
        PoseidonProject poseidonProject = PoseidonApplicationState.getInstance().getCurrentProject();
        try {
            this.fireVetoableChange("AppClosed", poseidonProject, null);
        }
        catch (PropertyVetoException propertyVetoException) {
            C.error((Object)"firing app closed event failed, but closing application anyway!");
        }
    }

    protected void updateConfig(PoseidonProject poseidonProject, ProjectPanel projectPanel) {
        Frame frame;
        if (projectPanel != null) {
            projectPanel.shutdown();
        }
        if ((frame = PoseidonUIConnector.getApplicationWindow()) != null && frame instanceof PoseidonFrame) {
            ((PoseidonFrame)frame).updateConfig();
        }
    }

    public void addVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        this.A.removeVetoableChangeListener(vetoableChangeListener);
        this.A.addVetoableChangeListener(vetoableChangeListener);
    }

    public void removeVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        this.A.removeVetoableChangeListener(vetoableChangeListener);
    }

    protected void fireVetoableChange(String string, Object object, Object object2) throws PropertyVetoException {
        this.D = this.A.getVetoableChangeListeners().length;
        this.A.fireVetoableChange(string, object, object2);
    }

    public void acknowledgeExit() {
        ++this.E;
    }

    public boolean acknowledgeCompleted() {
        return this.E >= this.D;
    }

    protected void execute() throws InvocationTargetException, InterruptedException {
        SwingUtilities.invokeAndWait(new D());
    }

    public void exitOnCompleteAcknowledge() {
        Thread thread = new Thread(){

            public void run() {
                try {
                    while (!ExitHandler.this.acknowledgeCompleted()) {
                        Thread.sleep(500L);
                    }
                    ExitHandler.this.execute();
                }
                catch (InterruptedException interruptedException) {
                    C.error((Object)"Caught exception while waiting for acknowledged exit!", (Throwable)interruptedException);
                }
                catch (InvocationTargetException invocationTargetException) {
                    C.error((Object)"Caught exception while waiting for acknowledged exit!", (Throwable)invocationTargetException);
                }
                catch (Throwable throwable) {
                    C.error((Object)"Caught exception while waiting for acknowledged exit!", throwable);
                }
                System.exit(0);
            }
        };
        thread.start();
    }
}

