/*
 * Decompiled with CFR 0.152.
 */
package com.gentleware.poseidon.ui;

import com.gentleware.jboogie.kernel.ProjectImpl;
import com.gentleware.jboogie.util.JBoogieUtils;
import com.gentleware.openapi.configuration.Services;
import com.gentleware.openapi.jboogie.Project;
import com.gentleware.openapi.swingx.Localizer;
import com.gentleware.openapi.swingx.ResourceId;
import com.gentleware.openapi.util.IconLoader;
import com.gentleware.poseidon.BuildProperties;
import com.gentleware.poseidon.jboogie.PoseidonApplicationState;
import com.gentleware.poseidon.kernel.PoseidonProject;
import com.gentleware.poseidon.openapi.PoseidonUIConnector;
import com.gentleware.poseidon.ui.CoreResourceBundle;
import com.gentleware.poseidon.ui.I;
import com.gentleware.poseidon.ui.ProjectPanel;
import com.gentleware.poseidon.util.UmlFunctions;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.VetoableChangeListener;
import java.text.MessageFormat;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import org.apache.log4j.Logger;

public class PoseidonFrame
extends JFrame {
    private static final Logger A = Logger.getLogger((String)"com.gentleware.poseidon.ui.PoseidonFrame");
    public static final String APP_NAME = BuildProperties.getPoseidonNameLong() + " " + BuildProperties.getEditionLong();
    public static String _titleAppendix;
    private Font B;
    private ProjectPanel D;
    private VetoableChangeListener C = new VetoableChangeListener(){

        public void vetoableChange(PropertyChangeEvent propertyChangeEvent) {
            A.debug((Object)"[PoseidonFrame] Update Name On Name Change");
            String string = propertyChangeEvent.getPropertyName();
            if ("NameChanged".equals(string)) {
                PoseidonFrame.this.updateTitle();
            }
        }
    };

    public PoseidonFrame(PoseidonProject poseidonProject) {
        super(APP_NAME);
        PoseidonUIConnector.setApplicationWindow(this);
        this.D = PoseidonApplicationState.getInstance().createProjectPanel();
        this.D.setProject((Project)poseidonProject);
        this.A(poseidonProject, this.D);
    }

    public PoseidonFrame(ProjectPanel projectPanel) {
        super(APP_NAME);
        PoseidonUIConnector.setApplicationWindow(this);
        this.D = projectPanel;
        this.A(projectPanel.getOwningProject(), this.D);
    }

    public static void setTitleAppendix(String string) {
        _titleAppendix = string;
        try {
            Frame frame = PoseidonUIConnector.getApplicationWindow();
            if (frame instanceof PoseidonFrame) {
                ((PoseidonFrame)frame).updateTitle();
            }
        }
        catch (Throwable throwable) {
            A.warn((Object)"Ignoring caught exception while updating title. Looks like no frame is there. Ignore exception as changing the title won't work anyway", throwable);
        }
    }

    private void A(PoseidonProject poseidonProject, ProjectPanel projectPanel) {
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)projectPanel, "Center");
        IconLoader iconLoader = IconLoader.getIconLoader();
        ImageIcon imageIcon = iconLoader.get("FrameIcon", this.getClass().getClassLoader());
        if (imageIcon != null) {
            this.setIconImage(imageIcon.getImage());
        }
        this.B = new Font("Dialog", 0, 10);
        this.getContentPane().setFont(this.B);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new _A());
        this.setJMenuBar(poseidonProject.getPanelManager().getUpdatedMenuBar());
        JOptionPane.setRootFrame(this);
        PoseidonApplicationState.getInstance().getCurrentProject().addVetoableChangeListener(this.C);
        PoseidonProject.addProjectListener(new VetoableChangeListener(){

            public void vetoableChange(PropertyChangeEvent propertyChangeEvent) {
                String string = propertyChangeEvent.getPropertyName();
                if ("Loaded".equals(string) || "Created".equals(string)) {
                    A.info((Object)"[PoseidonFrame] Repainting PoseidonFrame ... resetting MenuBar");
                    PoseidonProject poseidonProject = PoseidonApplicationState.getInstance().getCurrentProject();
                    PoseidonFrame.this.setJMenuBar(poseidonProject.getPanelManager().getMenuBar());
                    poseidonProject.addVetoableChangeListener(PoseidonFrame.this.C);
                    PoseidonFrame.this.updateTitle();
                    PoseidonFrame.this.show();
                } else if ("LoadingFailed".equals(string)) {
                    A.info((Object)"show message 'loading failed'");
                    String string2 = Localizer.localize((ResourceId)CoreResourceBundle.LoadingFailedText);
                    ResourceId resourceId = UmlFunctions.getLoadingFailedReasonResourceId();
                    String string3 = "http:www.gentleware.com?id=supportreq";
                    String string4 = MessageFormat.format(string2, "http:www.gentleware.com?id=supportreq");
                    String string5 = Localizer.localize((ResourceId)CoreResourceBundle.LoadingFailedTitle);
                    if (resourceId != null) {
                        String string6 = Localizer.localize((ResourceId)resourceId);
                        string4 = string4 + "\n" + string6;
                    }
                    if (ProjectImpl.isGuiMode()) {
                        JBoogieUtils.showMessageDialog((Component)PoseidonFrame.this, (Object)string4, (String)string5, (int)0);
                    }
                }
            }
        });
    }

    public ProjectPanel getPanel() {
        return this.D;
    }

    public void updateTitle() {
        StringBuffer stringBuffer = new StringBuffer();
        PoseidonProject poseidonProject = PoseidonApplicationState.getInstance().getCurrentProject();
        if (poseidonProject != null) {
            String string = poseidonProject.getName() + " - ";
            stringBuffer.append(string);
        }
        stringBuffer.append(APP_NAME);
        if (_titleAppendix != null) {
            stringBuffer.append(" ");
            stringBuffer.append(_titleAppendix);
        }
        if (BuildProperties.isCe()) {
            stringBuffer.append(" - ");
            stringBuffer.append(Localizer.localize((ResourceId)CoreResourceBundle.NoCommercialUse));
        }
        this.setTitle(new String(stringBuffer));
    }

    public void updateConfig() {
        A.info((Object)("[PoseidonFrame] Saving position X: " + this.getX()));
        A.info((Object)("[PoseidonFrame] Saving position Y: " + this.getY()));
        Services.getInstance().getConfiguration().putInteger("poseidon/screen/left", this.getX());
        Services.getInstance().getConfiguration().putInteger("poseidon/screen/top", this.getY());
        Services.getInstance().getConfiguration().putInteger("poseidon/screen/width", this.getWidth());
        Services.getInstance().getConfiguration().putInteger("poseidon/screen/height", this.getHeight());
    }

    public void showProject() {
        this.updateTitle();
        this.D.selectInitialTarget();
    }

    public VetoableChangeListener getVetoableChangeListener() {
        return this.C;
    }

    class _A
    extends WindowAdapter {
        _A() {
        }

        public void windowClosing(WindowEvent windowEvent) {
            new I().actionPerformed(null);
        }
    }
}

