/*
 * Decompiled with CFR 0.152.
 */
package com.gentleware.poseidon.ui;

import com.gentleware.openapi.swingx.Localizer;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.border.EtchedBorder;
import org.apache.log4j.Logger;

public class StatusBar
extends JPanel
implements Runnable {
    private static final Logger A = Logger.getLogger((String)"com.gentleware.poseidon.ui.StatusBar");
    private static Icon B;
    private static String C;
    protected JLabel _msg = new JLabel();
    protected JProgressBar _progress = new JProgressBar();
    protected JLabel _statusIcon = new JLabel();
    protected String _statusString;
    protected boolean _shouldDisplayStatusIcon;

    public StatusBar(boolean bl) {
        this._shouldDisplayStatusIcon = bl;
        this._progress.setMinimum(0);
        this._progress.setMaximum(100);
        this._progress.setMinimumSize(new Dimension(100, 20));
        this._progress.setSize(new Dimension(100, 20));
        this._msg.setMinimumSize(new Dimension(300, 20));
        this._msg.setSize(new Dimension(300, 20));
        this._msg.setFont(new Font("Dialog", 1, 10));
        this._msg.setForeground(Color.black);
        this.setLayout(new BorderLayout());
        this.setBorder(new EtchedBorder(1));
        if (this._shouldDisplayStatusIcon) {
            this.add((Component)this._msg, "West");
            this.add((Component)this._progress, "Center");
            this.add((Component)this._statusIcon, "East");
            this.A();
        } else {
            this.add((Component)this._msg, "Center");
            this.add((Component)this._progress, "East");
        }
    }

    public void showStatus(String string) {
        this._msg.setText(Localizer.localize((String)"Core", (String)string));
        this.paintImmediately(this.getBounds());
    }

    public void showProgress(int n2) {
        this._progress.setValue(n2);
    }

    public void showStateIcon(Icon icon, String string) {
        if (this._shouldDisplayStatusIcon) {
            this._statusIcon.setIcon(icon);
            this._statusIcon.setToolTipText(string);
            this.paintImmediately(this.getBounds());
        }
    }

    private void A() {
        if (B != null) {
            this.showStateIcon(B, C);
        }
    }

    public void setProgressMaximum(int n2) {
        this._progress.setMaximum(n2);
    }

    public void incProgress(int n2) {
        this._progress.setValue(this._progress.getValue() + n2);
    }

    public synchronized void run() {
        int n2 = this._progress.getMaximum();
        for (int i2 = 0; i2 < n2; ++i2) {
            this._progress.setValue(i2);
            this.repaint();
            try {
                this.wait(10L);
                continue;
            }
            catch (Exception exception) {
                A.debug((Object)exception);
            }
        }
        this.showStatus(this._statusString + "done");
        this.repaint();
        try {
            this.wait(1000L);
        }
        catch (Exception exception) {
            A.debug((Object)exception);
        }
        this._progress.setValue(0);
        this.showStatus("");
        this.repaint();
    }

    public static void setDefaultStatusIcon(Icon icon) {
        B = icon;
    }

    public static void setDefaultStatusIconTooltip(String string) {
        C = string;
    }

    public static Icon getDefaultStatusIcon() {
        return B;
    }

    public static String getDefaultStatusIconTooltip() {
        return C;
    }
}

