/*
 * Decompiled with CFR 0.152.
 */
package com.gentleware.poseidon.util;

import com.gentleware.jboogie.kernel.ProjectImpl;
import com.gentleware.jboogie.util.JBoogieUtils;
import com.gentleware.jboogie.util.LockChecker;
import com.gentleware.jboogie.util.StandaloneLockChecker;
import com.gentleware.openapi.configuration.Services;
import com.gentleware.openapi.jboogie.Project;
import com.gentleware.openapi.swingx.Localizer;
import com.gentleware.openapi.swingx.ResourceId;
import com.gentleware.openapi.swingx.SwingUtil;
import com.gentleware.openapi.swingx.XAbstractAction;
import com.gentleware.openapi.util.BuildPropertiesBasic;
import com.gentleware.openapi.util.CollectionFactory;
import com.gentleware.openapi.util.Strings;
import com.gentleware.openapi.util.Utils;
import com.gentleware.poseidon.BuildProperties;
import com.gentleware.poseidon.PoseidonConfigurationKeys;
import com.gentleware.poseidon.jboogie.PoseidonApplicationState;
import com.gentleware.poseidon.kernel.PoseidonProject;
import com.gentleware.poseidon.merging.ProjectReaderWriter;
import com.gentleware.poseidon.merging.ProjectReaderWriterManager;
import com.gentleware.poseidon.openapi.PoseidonUIConnector;
import com.gentleware.poseidon.ui.ActionSaveProject;
import com.gentleware.poseidon.ui.ActionSaveProjectAs;
import com.gentleware.poseidon.ui.MenuResourceBundle;
import com.gentleware.poseidon.ui.ProjectPanel;
import foxtrot.Task;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.Transferable;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.xml.parsers.SAXParserFactory;
import org.apache.log4j.Logger;

public final class PoseidonUtils {
    private static final Logger C = Logger.getLogger((String)"com.gentleware.poseidon.util.PoseidonUtils");
    static final String[] packageList = new String[]{"com.gentleware.poseidon", "org.netbeans.api.mdr", "org.xml.sax", "org.apache.log4j", "java.lang"};
    public static final String OS_MACOS = "Mac OS";
    public static final String OS_DARWIN = "Darwin";
    private static File B;
    private static String D;
    private static Class class$com$gentleware$poseidon$util$PoseidonUtils;

    private PoseidonUtils() {
    }

    public static boolean checkProjectSaved() {
        String string;
        Object object;
        Frame frame = PoseidonUIConnector.getApplicationWindow();
        PoseidonProject poseidonProject = PoseidonApplicationState.getInstance().getCurrentProject();
        Object object2 = null;
        if (poseidonProject != null && poseidonProject.needsSave()) {
            object = Localizer.localize((ResourceId)MenuResourceBundle.SaveChanges) + poseidonProject.getName() + "?";
            int n2 = JBoogieUtils.showConfirmDialog((Component)frame, (Object)object, (String)(string = Localizer.localize((ResourceId)MenuResourceBundle.SaveChangesTitle)), (int)1);
            if (n2 == 2 || n2 == -1) {
                return false;
            }
            if (n2 == 0) {
                boolean bl;
                if (ProjectImpl.isGuiMode()) {
                    boolean bl2;
                    URL uRL = poseidonProject.getUrl();
                    boolean bl3 = uRL == null;
                    boolean bl4 = bl2 = uRL != null && uRL.toExternalForm().indexOf(".jar!") > 0;
                    if (bl3 || bl2) {
                        object2 = new ActionSaveProjectAs((Project)poseidonProject);
                        bl = ((ActionSaveProject)((Object)object2)).trySave(true);
                        if (((ActionSaveProject)((Object)object2)).isCanceled()) {
                            return false;
                        }
                    } else {
                        object2 = new ActionSaveProject((Project)poseidonProject);
                        bl = ((ActionSaveProject)((Object)object2)).trySave(true);
                        if (((ActionSaveProject)((Object)object2)).isCanceled()) {
                            return false;
                        }
                        if (!bl) {
                            object2 = new ActionSaveProjectAs((Project)poseidonProject);
                            bl = ((ActionSaveProject)((Object)object2)).trySave(false);
                        }
                    }
                } else {
                    object2 = new ActionSaveProject((Project)poseidonProject);
                    bl = ((ActionSaveProject)((Object)object2)).trySave(true);
                    if (((ActionSaveProject)((Object)object2)).isCanceled()) {
                        return false;
                    }
                }
                if (!bl) {
                    return false;
                }
            }
        }
        if (object2 == null) {
            return true;
        }
        object = Boolean.FALSE;
        try {
            string = object2;
            object = (Boolean)SwingUtil.executeBlocking((Task)new Task((ActionSaveProject)((Object)string)){
                final /* synthetic */ ActionSaveProject val$saveActionFinal;
                {
                    this.val$saveActionFinal = actionSaveProject;
                }

                public Object run() throws Exception {
                    while (!this.val$saveActionFinal.isReady()) {
                        try {
                            Thread.sleep(250L);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    return this.val$saveActionFinal.isCanceled() ? Boolean.FALSE : Boolean.TRUE;
                }
            });
        }
        catch (Exception exception) {
            C.error((Object)exception);
        }
        return (Boolean)object;
    }

    public static File getInstallationDirectory() {
        File file;
        if (B != null) {
            return B;
        }
        Class clazz = class$com$gentleware$poseidon$util$PoseidonUtils == null ? (class$com$gentleware$poseidon$util$PoseidonUtils = PoseidonUtils.A("com.gentleware.poseidon.util.PoseidonUtils")) : class$com$gentleware$poseidon$util$PoseidonUtils;
        B = file = Utils.getInstallationDirectory((Class)clazz);
        return file;
    }

    public static boolean isWebStart() {
        File file = PoseidonUtils.getInstallationDirectory();
        File file2 = new File(file, "lib");
        File file3 = new File(file2, "poseidon2.jar");
        boolean bl = !file3.exists();
        return bl;
    }

    public static boolean isNetbeansPlugin() {
        String string = System.getProperty("poseidon-netbeans");
        return string != null && string.length() > 0;
    }

    public static LockChecker createPoseidonDefaultLockChecker() {
        return new StandaloneLockChecker();
    }

    public static Project createEmptyProject(String string) {
        return PoseidonUtils.createEmptyProject(true, string);
    }

    public static Project createEmptyProject(boolean bl, String string) {
        ProjectReaderWriter projectReaderWriter;
        PoseidonApplicationState poseidonApplicationState = PoseidonApplicationState.getInstance();
        PoseidonProject poseidonProject = poseidonApplicationState.getCurrentProject();
        ProjectPanel projectPanel = ProjectPanel.getCurrentPanel();
        if (poseidonProject != null) {
            if (ProjectImpl.isGuiMode()) {
                projectReaderWriter = poseidonProject.createTransferable(null);
                Toolkit.getDefaultToolkit().getSystemClipboard().setContents((Transferable)((Object)projectReaderWriter), (ClipboardOwner)((Object)projectReaderWriter));
            }
            poseidonProject.getTargetManager().setTarget(PoseidonUIConnector.getEmptyTarget());
            poseidonProject.dispose();
            if (projectPanel != null) {
                projectPanel.shutdown();
            }
        }
        if ((poseidonProject = (projectReaderWriter = ProjectReaderWriterManager.getInstance().getProjectReaderWriter(string)).createProject()) != null) {
            Frame frame;
            poseidonProject.initEmptyProject(bl);
            if (projectPanel == null) {
                C.error((Object)"Could not init panel - not registered?");
            } else {
                projectPanel.setProject((Project)poseidonProject);
                projectPanel.selectInitialTarget();
            }
            if (ProjectImpl.isGuiMode() && (frame = PoseidonUIConnector.getApplicationWindow()) != null) {
                frame.validate();
            }
            XAbstractAction.updateAllEnabled();
            return poseidonProject;
        }
        if (ProjectImpl.isGuiMode()) {
            String string2 = Localizer.localize((ResourceId)MenuResourceBundle.NoNewProject) + "!";
            String string3 = Localizer.localize((ResourceId)MenuResourceBundle.NewProjectFailed);
            JBoogieUtils.showMessageDialog((Component)projectPanel, (Object)string2, (String)string3, (int)2);
        }
        XAbstractAction.updateAllEnabled();
        return null;
    }

    public static void deadLockPreventionBegin() {
        ProjectImpl.setImporting((boolean)true);
    }

    public static void deadlockPreventionEnd() {
        ProjectImpl.setImporting((boolean)false);
    }

    public static String getVersionInfo() {
        try {
            Package package_;
            Class.forName("org.netbeans.api.mdr.events.MDRChangeSource");
            Class.forName("org.xml.sax.AttributeList");
            Class.forName("org.apache.log4j.Category");
            StringBuffer stringBuffer = new StringBuffer();
            String string = System.getProperty("javax.xml.parsers.SAXParserFactory");
            SAXParserFactory sAXParserFactory = null;
            if (string != null) {
                stringBuffer.append("SAX Parser Factory " + string + " specified using system property\n");
            }
            try {
                sAXParserFactory = SAXParserFactory.newInstance();
                stringBuffer.append("SAX Parser Factory " + sAXParserFactory.getClass().getName() + " will be used.\n");
            }
            catch (Exception exception) {
                stringBuffer.append("Error determining SAX Parser Factory\n.");
            }
            for (int i2 = 0; i2 < packageList.length; ++i2) {
                PoseidonUtils.getComponentVersionInfo(stringBuffer, packageList[i2]);
            }
            if (sAXParserFactory != null && (package_ = sAXParserFactory.getClass().getPackage()) != null) {
                PoseidonUtils.getComponentVersionInfo(stringBuffer, package_.getName());
            }
            stringBuffer.append("\n \n");
            return stringBuffer.toString();
        }
        catch (Exception exception) {
            return exception.toString();
        }
    }

    public static void getComponentVersionInfo(StringBuffer stringBuffer, String string) {
        stringBuffer.append("Package: ");
        stringBuffer.append(string);
        stringBuffer.append('\n');
        Package package_ = Package.getPackage(string);
        if (package_ == null) {
            stringBuffer.append("-- No Versioning Information --\nMaybe you don't use the jar?\n \n");
            return;
        }
        String string2 = package_.getImplementationTitle();
        if (string2 != null) {
            stringBuffer.append("Component: ");
            stringBuffer.append(string2);
        }
        if ((string2 = package_.getImplementationVendor()) != null) {
            stringBuffer.append(", by: ");
            stringBuffer.append(string2);
        }
        if ((string2 = package_.getImplementationVersion()) != null) {
            stringBuffer.append(", version: ");
            stringBuffer.append(string2);
            stringBuffer.append('\n');
        }
        stringBuffer.append(" \n");
    }

    public static void logVersionInfo() {
        String string = PoseidonUtils.getVersionInfo();
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            C.info((Object)string2);
        }
    }

    public static List getKeyFilenames(File file) {
        List list = CollectionFactory.createArrayList();
        if (file.isDirectory()) {
            File[] fileArray = file.listFiles();
            for (int i2 = 0; i2 < fileArray.length; ++i2) {
                if (!fileArray[i2].isFile() || !fileArray[i2].getName().endsWith(".key")) continue;
                list.add(fileArray[i2].getPath());
            }
        }
        return list;
    }

    public static void setOsSpecifics() {
        Properties properties = System.getProperties();
        if (Utils.isMacOs()) {
            properties.put("com.apple.macos.useScreenMenuBar", "true");
            properties.put("com.apple.macos.smallTabs", "true");
            properties.put("com.apple.mrj.application.apple.menu.about.name", "Poseidon");
            System.setProperties(properties);
        }
    }

    public static String getConfigDir() {
        if (D == null) {
            D = Utils.getConfigDir((String)BuildProperties.getEditionShort());
        }
        return D;
    }

    public static String getVersionSpecificConfigDir() {
        String string = PoseidonUtils.getConfigDir();
        int n2 = BuildPropertiesBasic.getMajorVersionNumber();
        int n3 = BuildPropertiesBasic.getMinorVersionNumber();
        String string2 = string + File.separatorChar + n2 + '.' + n3;
        return string2;
    }

    public static String getTempDir() {
        String string = Services.getInstance().getConfiguration().getString(PoseidonConfigurationKeys.KEY_TEMP_DIR, System.getProperty("poseidon.temp.dir"));
        if (string == null || string.length() == 0) {
            string = Utils.isWindowsOs() ? "C:\\windows\\temp" : (Utils.isMacOs() || Utils.isLinuxOs() ? "/tmp" : "/tmp");
        }
        return string;
    }

    public static boolean isIdenticalClass(Class clazz, Class clazz2) {
        if (clazz2 == clazz) {
            return true;
        }
        boolean bl = false;
        if (clazz2.isInterface()) {
            if (!clazz2.isAssignableFrom(clazz)) {
                return false;
            }
            Class<?>[] classArray = clazz.getInterfaces();
            for (int i2 = 0; i2 < classArray.length; ++i2) {
                if (classArray[i2] != clazz2) continue;
                bl = true;
                break;
            }
            return bl;
        }
        if (!clazz2.isAssignableFrom(clazz)) {
            return false;
        }
        Class<?>[] classArray = clazz.getClasses();
        for (int i3 = 0; i3 < classArray.length; ++i3) {
            if (classArray[i3] != clazz2) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public static void compareXmiByLine(String string, String string2) throws Exception {
        StringReader stringReader = new StringReader(string);
        StringReader stringReader2 = new StringReader(string2);
        PoseidonUtils.A(stringReader, stringReader2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void compareXmiFilesByLine(String string, String string2) throws Exception {
        BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
        BufferedReader bufferedReader2 = new BufferedReader(new FileReader(string2));
        try {
            PoseidonUtils.A(bufferedReader, bufferedReader2);
        }
        finally {
            bufferedReader.close();
            bufferedReader2.close();
        }
    }

    private static void A(Reader reader, Reader reader2) throws IOException {
        String string;
        String string2;
        LineNumberReader lineNumberReader = new LineNumberReader(reader);
        LineNumberReader lineNumberReader2 = new LineNumberReader(reader2);
        while (!"<XMI.content>".equals(string2 = lineNumberReader.readLine().trim())) {
        }
        while (!"<XMI.content>".equals(string = lineNumberReader2.readLine().trim())) {
        }
        do {
            if (Strings.equals((String)(string2 = lineNumberReader.readLine()), (String)(string = lineNumberReader2.readLine()))) continue;
            String string3 = "Files not equal in line " + lineNumberReader.getLineNumber() + ": " + string2;
            throw new IllegalStateException(string3);
        } while (string2 != null);
    }

    public static File getUserModuleFolder() {
        String string = PoseidonUtils.getVersionSpecificConfigDir();
        File file = new File(string);
        return file;
    }

    public static File getInstalledModuleFile() {
        File file = new File(PoseidonUtils.getVersionSpecificConfigDir(), "installedModules.xml");
        return file;
    }

    private static Class A(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }
}

