/*
 * Decompiled with CFR 0.152.
 */
package com.gentleware.poseidon.xml.argo;

import com.gentleware.poseidon.kernel.PoseidonProject;
import com.gentleware.poseidon.kernel.settings.CustomJavaImportSettings;
import com.gentleware.poseidon.kernel.settings.CustomJavaRoundtripSettings;
import com.gentleware.poseidon.kernel.settings.CustomMDLImportSettings;
import com.gentleware.poseidon.xml.E;
import com.gentleware.poseidon.xml.F;
import com.gentleware.poseidon.xml.argo.A;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.apache.log4j.Logger;
import org.xml.sax.SAXException;

public class ArgoParser
extends E {
    private static final Logger K = Logger.getLogger((String)"com.gentleware.poseidon.xml.argo.ArgoParser");
    public static ArgoParser SINGLETON = new ArgoParser();
    private A I = new A();
    private boolean J = true;
    private URL L;
    private PoseidonProject M;

    protected ArgoParser() {
    }

    public synchronized void readArgoStorable(URL uRL, PoseidonProject poseidonProject) {
        this.readArgoStorable(uRL, true, poseidonProject);
    }

    public synchronized void readArgoStorable(URL uRL, boolean bl, PoseidonProject poseidonProject) {
        this.L = uRL;
        try {
            this.readProject(uRL.openStream(), bl, poseidonProject);
        }
        catch (IOException iOException) {
            K.error((Object)("Couldn't open InputStream in ArgoParser.load(" + uRL + ") " + iOException), (Throwable)iOException);
        }
    }

    public void setURL(URL uRL) {
        this.L = uRL;
    }

    public synchronized void readProject(InputStream inputStream, boolean bl, PoseidonProject poseidonProject) {
        this.readIntoProject(poseidonProject, inputStream, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void readIntoProject(PoseidonProject poseidonProject, InputStream inputStream, boolean bl) {
        this.J = bl;
        if (this.L == null && this.J) {
            K.error((Object)"URL not set! Won't be able to add members! Aborting...");
            return;
        }
        try {
            K.debug((Object)"=======================================");
            K.debug((Object)("== READING PROJECT " + this.L));
            poseidonProject.setVersion("");
            if (poseidonProject != null) {
                this.M = poseidonProject;
            }
            this.parse(inputStream);
        }
        catch (SAXException sAXException) {
            K.error((Object)"Exception reading project================");
            Exception exception = sAXException.getException();
            if (exception == null) {
                K.error((Object)"catching exception while reading project", (Throwable)sAXException);
            } else {
                K.error((Object)"catching exception while reading project", (Throwable)exception);
            }
        }
        catch (Exception exception) {
            K.error((Object)"Exception reading project================\n", (Throwable)exception);
        }
        finally {
            this.M = null;
        }
    }

    public void handleStartElement(F f2) {
        K.debug((Object)("ArgoParser handleStartTag:" + f2.D()));
        try {
            switch (this.I.A(f2.D(), true)) {
                case 1: {
                    this.handleArgo(f2);
                    break;
                }
                case 8: {
                    this.handleDocumentation(f2);
                    break;
                }
                default: {
                    K.debug((Object)("unknown tag:" + f2.D()));
                    break;
                }
            }
        }
        catch (Exception exception) {
            K.error((Object)"catching exception while handling start element", (Throwable)exception);
        }
    }

    public void handleEndElement(F f2) {
        String string = f2.D();
        if (_debug) {
            K.info((Object)("NOTE: ArgoParser handleEndTag:" + string + "."));
        }
        try {
            int n2 = this.I.A(string, false);
            switch (n2) {
                case 2: {
                    this.handleAuthorname(f2);
                    break;
                }
                case 4: {
                    this.handleDescription(f2);
                    break;
                }
                case 5: {
                    this.handleSearchpath(f2);
                    break;
                }
                case 6: {
                    this.handleMember(f2);
                    break;
                }
                case 7: {
                    this.handleHistoryfile(f2);
                    break;
                }
                case 3: {
                    this.handleCreatedWith(f2);
                    break;
                }
                case 12: {
                    this.handleLastModified(f2);
                    break;
                }
                case 13: {
                    this.handleClasspath(f2);
                    break;
                }
                case 14: {
                    this.handleSourcepath(f2);
                    break;
                }
                case 15: {
                    this.handleCustomSourcepath(f2);
                    break;
                }
                case 22: {
                    this.handleCodeGenerationTreeSelection(f2);
                    break;
                }
                case 19: {
                    this.handleCustomJavaImportSettings(f2);
                    break;
                }
                case 21: {
                    this.handleCustomJavaRoundtripSettings(f2);
                    break;
                }
                case 23: {
                    this.handleRootSourcepathMap(f2);
                    break;
                }
                case 20: {
                    this.handleCustomMDLImportSettings(f2);
                    break;
                }
                case 16: {
                    this.handleProfile(f2);
                    break;
                }
                case 17: {
                    this.handleUniqueId(f2);
                    break;
                }
                default: {
                    if (_debug) {
                        K.debug((Object)("unknown end tag:" + string));
                    }
                    break;
                }
            }
        }
        catch (Exception exception) {
            K.error((Object)"catching exception while handling end element", (Throwable)exception);
        }
    }

    protected void handleArgo(F f2) {
    }

    protected void handleDocumentation(F f2) {
    }

    protected void handleAuthorname(F f2) {
        String string = f2.A().trim();
        this.M.setAuthorname(string);
    }

    protected void handleCreatedWith(F f2) {
        String string = f2.A().trim();
        this.M.setVersion(string);
    }

    protected void handleLastModified(F f2) {
        String string = f2.A().trim();
        if ("1.60_01".equals(string)) {
            string = "1.6.0-01";
        }
        this.M.setLastModified(string);
    }

    protected void handleClasspath(F f2) {
        String string = f2.A().trim();
        this.M.setClasspath(string);
    }

    protected void handleSourcepath(F f2) {
        String string = f2.A().trim();
        this.M.setSourcepath(string);
    }

    protected void handleCustomSourcepath(F f2) {
        String string = f2.D("name").trim();
        String string2 = f2.D("location").trim();
        K.debug((Object)("[ArgoParser] handleMember: name = " + string + " / type = " + string2));
        this.M.addCustomSourcepath(string, string2);
    }

    protected void handleCodeGenerationTreeSelection(F f2) {
        String string = f2.D("name").trim();
        String string2 = f2.D("selectionString").trim();
        this.M.setSelectionString(string, string2);
    }

    protected void handleCustomJavaImportSettings(F f2) {
        String string = f2.D("importAsAttributes").trim();
        String string2 = f2.D("importAsDatatypes").trim();
        String string3 = f2.D("importAsAttributesDescription");
        if (string3 != null) {
            string3 = string3.trim();
        }
        K.debug((Object)("[ArgoParser] handleMember: importAsAttributes = " + string + " / importAsDatatypes = " + string2 + " / importAsAttributesDescription = " + string3));
        CustomJavaImportSettings customJavaImportSettings = new CustomJavaImportSettings(this.M, string, string2, string3);
        this.M.setCustomJavaImportSettings(customJavaImportSettings);
    }

    protected void handleCustomJavaRoundtripSettings(F f2) {
        String string = f2.D("sourcepathString");
        String string2 = f2.D("timeInterval");
        String string3 = f2.D("roundtripIsUndoable");
        String string4 = f2.D("roundtripEnabled");
        String string5 = f2.D("autoSynchEnabled");
        String string6 = f2.D("showSettingsInformationDialog");
        String string7 = f2.D("projectRoot");
        K.debug((Object)("[ArgoParser] handleMember: sourcepathString = " + string + " / timeInterval = " + string2 + " / roundtripIsUndoable = " + string3 + " / roundtripEnabled = " + string4 + " / autoSynchEnabled = " + string5 + " / showSettingsInformationDialog = " + string6 + " / projectRoot = " + string7));
        CustomJavaRoundtripSettings customJavaRoundtripSettings = new CustomJavaRoundtripSettings(this.M, string2, string3, string4, string5, string6, string7);
        this.M.setCustomJavaRoundtripSettings(customJavaRoundtripSettings);
    }

    protected void handleRootSourcepathMap(F f2) {
        String string = f2.D("key").trim();
        String string2 = f2.D("path").trim();
        K.debug((Object)("[ArgoParser] handleMember: key = " + string + " / path = " + string2));
        CustomJavaRoundtripSettings customJavaRoundtripSettings = this.M.getCustomJavaRoundtripSettings();
        customJavaRoundtripSettings.addLogical2RelativeSourceRootPair(string, string2);
    }

    protected void handleCustomMDLImportSettings(F f2) {
        String string = f2.D("showClassifierPackages").trim();
        String string2 = f2.D("createDiagrams").trim();
        String string3 = f2.D("generateRootViewNodes").trim();
        String string4 = f2.D("scalingFactor").trim();
        K.debug((Object)("[ArgoParser] handleMember: showClassifierPackages = " + string + " / createDiagrams = " + string2 + " / generateRootViewNodes = " + string3 + " / scalingFactor = " + string4));
        CustomMDLImportSettings customMDLImportSettings = new CustomMDLImportSettings(this.M, string, string2, string3, string4);
        this.M.setCustomMDLImportSettings(customMDLImportSettings);
    }

    protected void handleDescription(F f2) {
        String string = f2.A().trim();
        this.M.setDescription(string);
    }

    protected void handleSearchpath(F f2) {
        String string = f2.D("href").trim();
    }

    protected void handleMember(F f2) {
        if (this.J) {
            String string = f2.D("name").trim();
            String string2 = f2.D("type").trim();
            K.debug((Object)("[ArgoParser] handleMember: name = " + string + " / type = " + string2));
            this.M.addMember(string, string2);
        }
    }

    protected void handleProfile(F f2) {
        String string = f2.D("name");
        this.M.addProjectProfile(string);
    }

    protected void handleHistoryfile(F f2) {
    }

    protected void handleUniqueId(F f2) {
    }
}

