/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.mdr.handlers;

import gnu.trove.THashMap;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import javax.jmi.reflect.RefAssociationLink;
import javax.jmi.reflect.RefObject;
import org.netbeans.mdr.storagemodel.AssociationLink;
import org.netbeans.mdr.storagemodel.StorableObject;

class AssociationLinkWrapper
implements RefAssociationLink {
    private static final IdentityCache identityCache = new IdentityCache();
    private final AssociationLink innerLink;

    private AssociationLinkWrapper(AssociationLink innerLink) {
        this.innerLink = innerLink;
    }

    AssociationLink getInnerLink() {
        return this.innerLink;
    }

    public RefObject refFirstEnd() {
        StorableObject fe = this.innerLink.getFirstEnd();
        return (RefObject)fe.getMdrStorage().getRepository().getHandler(fe);
    }

    public RefObject refSecondEnd() {
        StorableObject se = this.innerLink.getSecondEnd();
        return (RefObject)se.getMdrStorage().getRepository().getHandler(se);
    }

    public boolean equals(Object other) {
        if (other instanceof AssociationLinkWrapper) {
            return this == other;
        }
        return other instanceof RefAssociationLink && ((RefAssociationLink)other).refFirstEnd().equals(this.refFirstEnd()) && ((RefAssociationLink)other).refSecondEnd().equals(this.refSecondEnd());
    }

    public int hashCode() {
        return (this.innerLink.getFirstEnd().getMofId().toString() + this.innerLink.getSecondEnd().getMofId().toString()).hashCode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static RefAssociationLink wrapLink(AssociationLink innerLink) {
        if (innerLink == null) {
            return null;
        }
        String linkID = innerLink.getFirstEnd().getMofId().toString() + ':' + innerLink.getSecondEnd().getMofId().toString();
        IdentityCache identityCache = AssociationLinkWrapper.identityCache;
        synchronized (identityCache) {
            RefAssociationLink result = (RefAssociationLink)AssociationLinkWrapper.identityCache.get(linkID);
            if (result == null) {
                result = new AssociationLinkWrapper(innerLink);
                AssociationLinkWrapper.identityCache.put(linkID, result);
            }
            return result;
        }
    }

    private static class IdentityCache
    extends THashMap {
        private final ReferenceQueue queue = new ReferenceQueue();

        private IdentityCache() {
        }

        private void cleanUp() {
            LinkReference reference;
            while ((reference = (LinkReference)this.queue.poll()) != null) {
                this.remove(reference.getProxyMofId());
            }
        }

        public Object put(Object key, Object value) {
            this.cleanUp();
            Object result = super.put(key, (Object)new LinkReference((String)key, (RefAssociationLink)value));
            if (result != null) {
                return ((LinkReference)result).get();
            }
            return result;
        }

        public Object get(Object key) {
            this.cleanUp();
            Object result = super.get(key);
            if (result != null) {
                return ((LinkReference)result).get();
            }
            return result;
        }

        private class LinkReference
        extends WeakReference {
            private String mofId;

            public LinkReference(String key, RefAssociationLink link) {
                super(link, IdentityCache.this.queue);
                this.mofId = key;
            }

            public String getProxyMofId() {
                return this.mofId;
            }
        }
    }
}

