/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.mdr.handlers;

import java.io.File;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import javax.jmi.reflect.InvalidObjectException;
import javax.jmi.reflect.RefBaseObject;
import javax.jmi.reflect.RefObject;
import javax.jmi.reflect.RefPackage;
import org.netbeans.api.mdr.MDRObject;
import org.netbeans.api.mdr.MDRepository;
import org.netbeans.mdr.NBMDRepositoryImpl;
import org.netbeans.mdr.handlers.ClassLoaderProvider;
import org.netbeans.mdr.handlers.MDRClassLoader;
import org.netbeans.mdr.handlers.gen.HandlerGenerator;
import org.netbeans.mdr.persistence.MOFID;
import org.netbeans.mdr.persistence.StorageBadRequestException;
import org.netbeans.mdr.persistence.StorageException;
import org.netbeans.mdr.storagemodel.MdrStorage;
import org.netbeans.mdr.storagemodel.StorableBaseObject;
import org.netbeans.mdr.storagemodel.StorableObject;
import org.netbeans.mdr.storagemodel.StorablePackage;
import org.netbeans.mdr.storagemodel.Transient;
import org.netbeans.mdr.util.AbstractCollectionFactory;
import org.netbeans.mdr.util.ClassUtils;
import org.netbeans.mdr.util.DebugException;
import org.netbeans.mdr.util.ImplClass;
import org.netbeans.mdr.util.Logger;

public abstract class BaseObjectHandler
extends ImplClass
implements MDRObject {
    private static MDRClassLoader defaultLoader = null;
    private static ClassLoaderProvider provider = null;
    private MOFID mofId;
    private final MdrStorage mdrStorage;
    private StorableBaseObject storable;

    public static synchronized void setClassLoaderProvider(ClassLoaderProvider provider) {
        BaseObjectHandler.provider = provider;
    }

    public static synchronized MDRClassLoader getDefaultClassLoader() {
        if (defaultLoader == null) {
            defaultLoader = new MDRClassLoader(provider);
        }
        return defaultLoader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Class getHandlerClass(Class ifc, StorableBaseObject s) throws IllegalArgumentException {
        MDRClassLoader loader = BaseObjectHandler.getDefaultClassLoader();
        BaseObjectHandler.check(loader, ifc);
        String className = BaseObjectHandler.getName(ifc);
        Map cache = BaseObjectHandler.getLoaderCache(loader);
        Class result = ImplClass.getFromCache(cache, ifc, className);
        try {
            if (result == null) {
                result = ClassGenerator.generateHandler(className, loader, ifc, s);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Logger.getDefault().notify(1, (Throwable)e);
        }
        finally {
            BaseObjectHandler.releaseCache(cache, result, className);
        }
        return result;
    }

    public static Class resolveClass(StorableBaseObject s) {
        try {
            StorableObject metaObject = s.getMetaObject();
            return BaseObjectHandler.getDefaultClassLoader().resolveInterface(metaObject, !(s instanceof StorableObject));
        }
        catch (StorageException e) {
            throw (DebugException)Logger.getDefault().annotate((Throwable)new DebugException(e), (Throwable)e);
        }
    }

    public static Class resolveInterface(String ifcName) throws ClassNotFoundException {
        try {
            return Class.forName(ifcName, true, BaseObjectHandler.getDefaultClassLoader());
        }
        catch (RuntimeException e) {
            Logger.getDefault().annotate((Throwable)e, "ClassLoader: " + BaseObjectHandler.getDefaultClassLoader());
            Logger.getDefault().annotate((Throwable)e, "ClassName: " + ifcName);
            throw e;
        }
        catch (Error e) {
            Logger.getDefault().annotate((Throwable)e, "ClassLoader: " + BaseObjectHandler.getDefaultClassLoader());
            Logger.getDefault().annotate((Throwable)e, "ClassName: " + ifcName);
            throw e;
        }
    }

    public static Class resolveImplementation(String implName) throws ClassNotFoundException {
        try {
            return Class.forName(implName, true, BaseObjectHandler.getDefaultClassLoader());
        }
        catch (ClassNotFoundException e) {
            throw e;
        }
        catch (Error e) {
            Logger.getDefault().annotate((Throwable)e, "ClassLoader: " + BaseObjectHandler.getDefaultClassLoader());
            Logger.getDefault().annotate((Throwable)e, "ClassName: " + implName);
            throw e;
        }
        catch (RuntimeException e) {
            Logger.getDefault().annotate((Throwable)e, "ClassLoader: " + BaseObjectHandler.getDefaultClassLoader());
            Logger.getDefault().annotate((Throwable)e, "ClassName: " + implName);
            throw e;
        }
    }

    protected BaseObjectHandler(StorableBaseObject storable) {
        this._setDelegate(storable);
        this.mdrStorage = storable.getMdrStorage();
    }

    protected final void _lock() {
        this._lock(false);
    }

    protected final void _lock(boolean write) {
        this.mdrStorage.getRepositoryMutex().enter(write);
    }

    protected final void _unlock() {
        this.mdrStorage.getRepositoryMutex().leave();
    }

    protected final void _unlock(boolean fail) {
        this.mdrStorage.getRepositoryMutex().leave(fail);
    }

    public final MDRepository repository() {
        return this._getRepository();
    }

    public final boolean equals(Object obj) {
        if (obj instanceof BaseObjectHandler) {
            return this == obj;
        }
        return obj instanceof RefBaseObject && ((RefBaseObject)obj).refMofId().equals(this.refMofId());
    }

    public String toString() {
        String outP;
        String metaId;
        String className = this.getClass().getName();
        className = className.substring(className.lastIndexOf(".") + 1);
        try {
            metaId = this._getDelegate().getMetaObject().getMofId().toString();
        }
        catch (Exception e) {
            metaId = "(not available)";
        }
        try {
            outP = this._getDelegate().getOutermostPackage().getMofId().toString();
        }
        catch (Exception e) {
            outP = "(not available)";
        }
        return className + "  ID: " + this.refMofId() + "  MID: " + metaId + "  OPCKG: " + outP;
    }

    public final int hashCode() {
        return this.mofId.hashCode();
    }

    public final RefObject refMetaObject() {
        try {
            return (RefObject)this._getRepository().getHandler(this._getDelegate().getMetaObject());
        }
        catch (StorageException e) {
            throw (DebugException)Logger.getDefault().annotate((Throwable)new DebugException(e), (Throwable)e);
        }
    }

    public final RefPackage refImmediatePackage() {
        try {
            return (RefPackage)this._getRepository().getHandler(this._getDelegate().getImmediatePackage());
        }
        catch (StorageException e) {
            throw (DebugException)Logger.getDefault().annotate((Throwable)new DebugException(e), (Throwable)e);
        }
    }

    public final RefPackage refOutermostPackage() {
        try {
            StorablePackage pkg = this._getDelegate().getOutermostPackage();
            if (pkg.getMofId().equals(this._getDelegate().getMofId())) {
                return (RefPackage)this;
            }
            return (RefPackage)this._getRepository().getHandler(pkg);
        }
        catch (StorageException e) {
            throw (DebugException)Logger.getDefault().annotate((Throwable)new DebugException(e), (Throwable)e);
        }
    }

    public final String refMofId() {
        return this.mofId.toString();
    }

    public final Collection refVerifyConstraints(boolean deepVerify) {
        if (deepVerify) {
            return this._recursiveVerify(AbstractCollectionFactory.getCollectionFactory().createArrayList(), AbstractCollectionFactory.getCollectionFactory().createHashSet());
        }
        return this._verify(AbstractCollectionFactory.getCollectionFactory().createArrayList());
    }

    public final StorableBaseObject _getDelegate() {
        try {
            StorableBaseObject result = this.storable != null ? this.storable : this.mdrStorage.getObject(this.mofId);
            if (result == null) {
                throw new InvalidObjectException(null, "Object with MOFID " + this.mofId + " no longer exists.");
            }
            return result;
        }
        catch (StorageBadRequestException e) {
            throw new InvalidObjectException(null, "Object with MOFID " + this.mofId + " no longer exists.");
        }
        catch (StorageException e) {
            throw new DebugException(e.toString());
        }
    }

    protected final void _setDelegate(StorableBaseObject storable) {
        boolean register = false;
        MOFID newMofId = storable.getMofId();
        if (this.mofId != null && !this.mofId.equals(newMofId)) {
            this._getRepository().removeHandler(this.mofId.toString());
            register = true;
        }
        this.mofId = newMofId;
        this.storable = storable instanceof StorableObject && storable instanceof Transient ? storable : null;
        if (register) {
            this._getRepository().addHandler(this);
        }
    }

    protected final MdrStorage _getMdrStorage() {
        return this.mdrStorage;
    }

    protected final NBMDRepositoryImpl _getRepository() {
        return this.mdrStorage.getRepository();
    }

    protected abstract Collection _recursiveVerify(Collection var1, Set var2);

    protected abstract Collection _verify(Collection var1);

    private static interface ClassCachingStrategy {
        public Class getClassHandler(String var1, MDRClassLoader var2, Class var3, StorableBaseObject var4) throws Exception;
    }

    private static class ClassGenerator {
        private static ClassCachingStrategy cachingStrategy;

        private ClassGenerator() {
        }

        private static Class getDiscCachedClass(String className, MDRClassLoader loader, Class ifc, StorableBaseObject s) throws Exception {
            File file = new File(ClassUtils.getClassFilePath(className));
            if (file.exists()) {
                return loader.defineClass(className, ClassUtils.loadHandler(file));
            }
            return ClassGenerator.generateClassHandler(className, ifc, s, loader, true);
        }

        private static Class getMemoryCachedClass(MDRClassLoader loader, Class ifc, String className, StorableBaseObject s) {
            return ClassGenerator.generateClassHandler(className, ifc, s, loader, false);
        }

        private static Class generateClassHandler(String className, Class ifc, StorableBaseObject s, MDRClassLoader loader, boolean store) {
            byte[] handlerClassFile = HandlerGenerator.generateHandler(className, ifc, s);
            if (store) {
                ClassUtils.saveClass(handlerClassFile, className);
            }
            Class result = loader.defineClass(className, handlerClassFile);
            return result;
        }

        public static Class generateHandler(String className, MDRClassLoader loader, Class ifc, StorableBaseObject s) throws Exception {
            return cachingStrategy.getClassHandler(className, loader, ifc, s);
        }

        static /* synthetic */ Class access$000(String x0, MDRClassLoader x1, Class x2, StorableBaseObject x3) throws Exception {
            return ClassGenerator.getDiscCachedClass(x0, x1, x2, x3);
        }

        static /* synthetic */ Class access$100(MDRClassLoader x0, Class x1, String x2, StorableBaseObject x3) {
            return ClassGenerator.getMemoryCachedClass(x0, x1, x2, x3);
        }

        static {
            if (ClassUtils.isSaveByteCode()) {
                if (!ClassUtils.isCachedClassPattern()) {
                    System.out.println("Using cached class from directory:" + ClassUtils.getBaseClassDir());
                    cachingStrategy = new ClassCachingStrategy(){

                        public Class getClassHandler(String className, MDRClassLoader loader, Class ifc, StorableBaseObject s) throws Exception {
                            return ClassGenerator.access$000(className, loader, ifc, s);
                        }
                    };
                } else {
                    System.out.print("Using cached class from directory:" + ClassUtils.getBaseClassDir());
                    System.out.println(" for class names:" + ClassUtils.getCachedclasspattern());
                    cachingStrategy = new ClassCachingStrategy(){

                        public Class getClassHandler(String className, MDRClassLoader loader, Class ifc, StorableBaseObject s) throws Exception {
                            Class result = ClassUtils.isStoredClass(className) ? ClassGenerator.access$000(className, loader, ifc, s) : ClassGenerator.access$100(loader, ifc, className, s);
                            return result;
                        }
                    };
                }
            } else {
                System.out.println("Using memory caching");
                cachingStrategy = new ClassCachingStrategy(){

                    public Class getClassHandler(String className, MDRClassLoader loader, Class ifc, StorableBaseObject s) {
                        return ClassGenerator.access$100(loader, ifc, className, s);
                    }
                };
            }
        }
    }
}

