/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.mdr.handlers;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;
import javax.jmi.reflect.RefBaseObject;
import org.netbeans.mdr.handlers.AssociationLinkWrapper;
import org.netbeans.mdr.handlers.BaseObjectHandler;
import org.netbeans.mdr.handlers.CollectionUnwrapper;
import org.netbeans.mdr.storagemodel.AssociationLink;
import org.netbeans.mdr.storagemodel.MdrStorage;
import org.netbeans.mdr.storagemodel.StorableBaseObject;
import org.netbeans.mdr.util.DebugException;

public class IndexSetWrapper
implements Collection {
    protected final Collection inner;
    protected final MdrStorage storage;

    public IndexSetWrapper(MdrStorage mdrStorage, Collection inner) {
        this.inner = inner;
        this.storage = mdrStorage;
    }

    protected void lock(boolean writeAccess) {
        this.storage.getRepositoryMutex().enter(writeAccess);
    }

    protected void unlock() {
        this.storage.getRepositoryMutex().leave();
    }

    protected void unlock(boolean fail) {
        this.storage.getRepositoryMutex().leave(fail);
    }

    protected static Object wrap(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof StorableBaseObject) {
            return ((StorableBaseObject)obj).getMdrStorage().getRepository().getHandler((StorableBaseObject)obj);
        }
        if (obj instanceof AssociationLink) {
            return AssociationLinkWrapper.wrapLink((AssociationLink)obj);
        }
        throw new DebugException("Invalid object in collection: " + obj.getClass().getName());
    }

    protected static Object unwrap(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof RefBaseObject) {
            return ((BaseObjectHandler)obj)._getDelegate().getMofId();
        }
        if (obj instanceof AssociationLinkWrapper) {
            return ((AssociationLinkWrapper)obj).getInnerLink();
        }
        return obj;
    }

    protected static Object[] wrapArray(Object[] array) {
        for (int i = 0; i < array.length; ++i) {
            array[i] = IndexSetWrapper.wrap(array[i]);
        }
        return array;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(Object obj) {
        try {
            this.lock(false);
            boolean bl = this.inner.contains(IndexSetWrapper.unwrap(obj));
            return bl;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator iterator() {
        try {
            this.lock(false);
            IndexIteratorWrapper indexIteratorWrapper = new IndexIteratorWrapper(this.inner.iterator());
            return indexIteratorWrapper;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        try {
            this.lock(false);
            int n = this.inner.size();
            return n;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() {
        try {
            this.lock(false);
            boolean bl = this.inner.isEmpty();
            return bl;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsAll(Collection collection) {
        try {
            this.lock(false);
            boolean bl = this.inner.containsAll(new CollectionUnwrapper(collection));
            return bl;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] toArray(Object[] obj) {
        try {
            this.lock(false);
            Object[] value = IndexSetWrapper.wrapArray(this.inner.toArray());
            Object[] result = obj;
            if (value.length > result.length) {
                if (value.getClass() == result.getClass()) {
                    Object[] objectArray = value;
                    return objectArray;
                }
                result = (Object[])Array.newInstance(obj.getClass().getComponentType(), value.length);
            } else if (value.length < result.length) {
                result[value.length] = null;
            }
            System.arraycopy(value, 0, result, 0, value.length);
            Object[] objectArray = result;
            return objectArray;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Collection)) {
            return false;
        }
        try {
            this.lock(false);
            Iterator it1 = this.iterator();
            Iterator it2 = ((Collection)object).iterator();
            while (it1.hasNext() && it2.hasNext()) {
                Object o1 = it1.next();
                Object o2 = it2.next();
                if (o1 != null ? o1.equals(o2) : o2 == null) continue;
                boolean bl = false;
                return bl;
            }
            boolean bl = !it1.hasNext() && !it2.hasNext();
            return bl;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int hashCode() {
        this.lock(false);
        try {
            int hashCode = 1;
            Iterator it = this.iterator();
            while (it.hasNext()) {
                Object obj = it.next();
                hashCode = 31 * hashCode + (obj == null ? 0 : obj.hashCode());
            }
            int n = hashCode;
            return n;
        }
        finally {
            this.unlock();
        }
    }

    public Object[] toArray() {
        return this.toArray(new Object[this.size()]);
    }

    public void clear() {
        throw new UnsupportedOperationException();
    }

    public boolean addAll(Collection collection) {
        throw new UnsupportedOperationException();
    }

    public boolean remove(Object obj) {
        throw new UnsupportedOperationException();
    }

    public boolean add(Object obj) {
        throw new UnsupportedOperationException();
    }

    public boolean retainAll(Collection collection) {
        throw new UnsupportedOperationException();
    }

    public boolean removeAll(Collection collection) {
        throw new UnsupportedOperationException();
    }

    protected class IndexIteratorWrapper
    implements Iterator {
        protected Iterator innerIterator;

        public IndexIteratorWrapper(Iterator innerIterator) {
            this.innerIterator = innerIterator;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean hasNext() {
            try {
                IndexSetWrapper.this.lock(false);
                boolean bl = this.innerIterator.hasNext();
                return bl;
            }
            finally {
                IndexSetWrapper.this.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object next() {
            try {
                IndexSetWrapper.this.lock(false);
                Object object = IndexSetWrapper.wrap(this.innerIterator.next());
                return object;
            }
            finally {
                IndexSetWrapper.this.unlock();
            }
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

