/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.mdr.handlers;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.security.AllPermission;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.ProtectionDomain;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.netbeans.api.mdr.JMIStreamFactory;
import org.netbeans.lib.jmi.mapping.ClassFileMapper;
import org.netbeans.mdr.handlers.ClassLoaderProvider;
import org.netbeans.mdr.handlers.gen.TagSupport;
import org.netbeans.mdr.persistence.Storage;
import org.netbeans.mdr.storagemodel.StorableObject;
import org.netbeans.mdr.util.AbstractCollectionFactory;
import org.netbeans.mdr.util.DebugException;
import org.netbeans.mdr.util.Logger;

class MDRClassLoader
extends ClassLoader {
    private static final ProtectionDomain pd;
    private static final Map suffixes;
    private final JMIStreamFactory streamFactory = new StreamFactory();
    private final ClassLoaderProvider provider;
    private Delegator parent;
    private final Map packages = AbstractCollectionFactory.getCollectionFactory().createHashMap();
    private final Map proxyClasses = AbstractCollectionFactory.getCollectionFactory().createHashMap();
    private final Map instanceClasses = AbstractCollectionFactory.getCollectionFactory().createHashMap();
    static /* synthetic */ Class class$org$netbeans$mdr$handlers$MDRClassLoader$Delegator;

    MDRClassLoader(ClassLoaderProvider provider) {
        this.provider = provider;
    }

    private Delegator getDelegator() {
        if (this.parent == null) {
            this.parent = new Delegator(this.provider);
        }
        this.parent = this.parent.getDelegator();
        return this.parent;
    }

    protected Class defineClass(String className, byte[] classFile) {
        Class<?> result;
        if (this.provider == null || (result = this.provider.defineClass(className, classFile)) == null) {
            int i = className.lastIndexOf(46);
            String pkgName = className.substring(0, i);
            Package pkg = this.getPackage(pkgName);
            if (pkg == null) {
                this.definePackage(pkgName, null, null, null, null, null, null, null);
            }
            result = this.defineClass(className, classFile, 0, classFile.length, pd);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Class resolveInterface(StorableObject s, boolean proxy) {
        String key = s.getMofId().toString();
        Map classes = proxy ? this.proxyClasses : this.instanceClasses;
        Class<?> result = null;
        Storage storage = s.getMdrStorage().getStorageByMofId(s.getMofId());
        synchronized (storage) {
            result = (Class<?>)classes.get(key);
            if (result == null) {
                try {
                    String metaName = (String)s.getMetaObject().getAttribute("name");
                    String suffix = proxy ? (String)suffixes.get(metaName) : "";
                    String ifcName = TagSupport.getTypeFullName(s) + suffix;
                    try {
                        result = this.loadClass(ifcName);
                    }
                    catch (ClassNotFoundException e) {
                        Logger.getDefault().log(16, "Metamodel specific JMI class " + ifcName + " not found. Using bytecode generation to create it.");
                        new ClassFileMapper(this.streamFactory).visitRefBaseObject(s.getMdrStorage().getRepository().getHandler(s.getOutermostPackage()));
                        result = this.loadClass(ifcName);
                    }
                    classes.put(key, result);
                }
                catch (Exception e) {
                    throw (DebugException)Logger.getDefault().annotate((Throwable)new DebugException(e), (Throwable)e);
                }
            }
        }
        return result;
    }

    protected Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> c = this.findLoadedClass(name);
        if (c == null) {
            try {
                c = this.getDelegator().accessibleLoadClass(name, false);
            }
            catch (ClassNotFoundException e) {
                c = this.findClass(name);
            }
        }
        if (resolve) {
            this.resolveClass(c);
        }
        return c;
    }

    public URL getResource(String name) {
        URL url = this.getDelegator().getResource(name);
        if (url == null) {
            url = this.findResource(name);
        }
        return url;
    }

    protected Enumeration findResources(String name) throws IOException {
        return this.getDelegator().getResources(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Package getPackage(String name) {
        Map map = this.packages;
        synchronized (map) {
            Package pkg = (Package)this.packages.get(name);
            if (pkg == null && (pkg = this.getDelegator().accessibleGetPackage(name)) != null) {
                this.packages.put(name, pkg);
            }
            return pkg;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Package[] getPackages() {
        Map map;
        Map map2 = this.packages;
        synchronized (map2) {
            map = AbstractCollectionFactory.getCollectionFactory().createHashMap(this.packages);
        }
        Package[] pkgs = this.getDelegator().accessibleGetPackages();
        if (pkgs != null) {
            for (int i = 0; i < pkgs.length; ++i) {
                String pkgName = pkgs[i].getName();
                if (map.get(pkgName) != null) continue;
                map.put(pkgName, pkgs[i]);
            }
        }
        return map.values().toArray(new Package[map.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Package definePackage(String name, String specTitle, String specVersion, String specVendor, String implTitle, String implVersion, String implVendor, URL sealBase) throws IllegalArgumentException {
        Map map = this.packages;
        synchronized (map) {
            Package pkg = this.getPackage(name);
            if (pkg != null) {
                throw new IllegalArgumentException(name);
            }
            pkg = super.definePackage(name, specTitle, specVersion, specVendor, implTitle, implVersion, implVendor, sealBase);
            this.packages.put(name, pkg);
            return pkg;
        }
    }

    static {
        Permissions pc = new Permissions();
        ((PermissionCollection)pc).add(new AllPermission());
        pd = new ProtectionDomain(null, pc);
        suffixes = AbstractCollectionFactory.getCollectionFactory().createHashMap(3, 1.0f);
        suffixes.put("Class", "Class");
        suffixes.put("Package", "Package");
        suffixes.put("Association", "");
    }

    private final class StreamFactory
    extends JMIStreamFactory {
        private StreamFactory() {
        }

        public OutputStream createStream(List pkg, String className, String extension) throws IOException {
            if (!"class".equals(extension)) {
                throw new IllegalArgumentException("ERROR: Wrong extension of the generated data: " + extension + ". Only bytecode data (i.e. extension \"class\" is accepted.");
            }
            return new ClassOutputStream(pkg, className);
        }
    }

    private static final class Delegator
    extends ClassLoader {
        private final ClassLoaderProvider provider;
        private final ClassLoader parent;

        Delegator(ClassLoaderProvider provider) {
            super(provider == null ? (class$org$netbeans$mdr$handlers$MDRClassLoader$Delegator == null ? (class$org$netbeans$mdr$handlers$MDRClassLoader$Delegator = MDRClassLoader.class$("org.netbeans.mdr.handlers.MDRClassLoader$Delegator")) : class$org$netbeans$mdr$handlers$MDRClassLoader$Delegator).getClassLoader() : provider.getClassLoader());
            this.parent = provider == null ? (class$org$netbeans$mdr$handlers$MDRClassLoader$Delegator == null ? (class$org$netbeans$mdr$handlers$MDRClassLoader$Delegator = MDRClassLoader.class$("org.netbeans.mdr.handlers.MDRClassLoader$Delegator")) : class$org$netbeans$mdr$handlers$MDRClassLoader$Delegator).getClassLoader() : provider.getClassLoader();
            this.provider = provider;
        }

        Delegator getDelegator() {
            return this.provider == null || this.provider.getClassLoader() == this.parent ? this : new Delegator(this.provider);
        }

        Class accessibleLoadClass(String name, boolean param) throws ClassNotFoundException {
            return this.loadClass(name, param);
        }

        Package accessibleGetPackage(String name) {
            return this.getPackage(name);
        }

        Package[] accessibleGetPackages() {
            return this.getPackages();
        }
    }

    private final class ClassOutputStream
    extends ByteArrayOutputStream {
        private final String className;

        ClassOutputStream(List pkg, String className) {
            StringBuffer temp = new StringBuffer(32);
            Iterator it = pkg.iterator();
            while (it.hasNext()) {
                temp.append(it.next() + ".");
            }
            temp.append(className);
            this.className = temp.toString();
        }

        public void close() throws IOException {
            try {
                MDRClassLoader.this.loadClass(this.className);
            }
            catch (ClassNotFoundException e) {
                Logger.getDefault().log("Generating bytecode for JMI class: " + this.className);
                MDRClassLoader.this.defineClass(this.className, this.toByteArray());
            }
            super.close();
        }
    }
}

