/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.mdr.persistence.btreeimpl.btreeindex;

import org.netbeans.mdr.persistence.StorageException;
import org.netbeans.mdr.persistence.btreeimpl.btreeindex.Btree;
import org.netbeans.mdr.persistence.btreeimpl.btreeindex.BtreePage;
import org.netbeans.mdr.persistence.btreeimpl.btreeindex.SearchResult;

public class FixedKeyPage
extends BtreePage {
    int keyLength;

    public void init(Btree btree, byte[] pageId, byte[] pageBuffer, boolean isNew) throws StorageException {
        super.init(btree, pageId, pageBuffer, isNew);
        this.keyLength = btree.keyInfo.getLength();
    }

    int numEntries() {
        return (this.freeStart - this.headerLength) / (this.keyLength + this.dataLength);
    }

    int keyOffset(int entryNum) {
        return this.headerLength + entryNum * (this.keyLength + this.dataLength);
    }

    int keyLength(int entryNum) {
        return this.keyLength;
    }

    byte[] getData(int entryNum) {
        byte[] data = new byte[this.dataLength];
        System.arraycopy(this.pageBuffer, this.keyOffset(entryNum) + this.keyLength, data, 0, this.dataLength);
        return data;
    }

    byte[] getKey(int entryNum) {
        byte[] key = new byte[this.keyLength];
        System.arraycopy(this.pageBuffer, this.keyOffset(entryNum), key, 0, this.keyLength);
        return key;
    }

    BtreePage.BtreeEntry insert(BtreePage.BtreeEntry entry, int entryNum, SearchResult resultPosition) throws StorageException {
        this.pageSource.dirtyPage(this);
        if (this.btree.pageSize - this.freeStart >= entry.length()) {
            this.insertHere(entry, entryNum, resultPosition);
            return null;
        }
        return this.split(entry, entryNum, resultPosition);
    }

    BtreePage.BtreeEntry replace(BtreePage.BtreeEntry entry, int entryNum, SearchResult resultPosition) throws StorageException {
        this.pageSource.dirtyPage(this);
        int offset = this.keyOffset(entryNum) + this.keyLength;
        System.arraycopy(entry.data, 0, this.pageBuffer, offset, entry.data.length);
        if (resultPosition != null) {
            resultPosition.matched = true;
            resultPosition.skipCount = 0;
            resultPosition.page = this;
            resultPosition.entryNum = entryNum;
        }
        return null;
    }

    private void insertHere(BtreePage.BtreeEntry entry, int entryNum, SearchResult resultPosition) {
        int offset = this.keyOffset(entryNum);
        if (offset != this.freeStart) {
            System.arraycopy(this.pageBuffer, offset, this.pageBuffer, offset + entry.length(), this.freeStart - offset);
        }
        System.arraycopy(entry.key, 0, this.pageBuffer, offset, this.keyLength);
        System.arraycopy(entry.data, 0, this.pageBuffer, offset + this.keyLength, this.dataLength);
        this.freeStart += this.keyLength + this.dataLength;
        if (resultPosition != null) {
            resultPosition.entryNum = entryNum;
            resultPosition.matched = true;
            resultPosition.page = this;
            resultPosition.skipCount = 0;
        }
    }

    void delete(int firstEntry, int lastEntry) throws StorageException {
        this.pageSource.dirtyPage(this);
        int startOffset = this.keyOffset(firstEntry);
        int endOffset = this.keyOffset(lastEntry + 1);
        if (this.freeStart != endOffset) {
            System.arraycopy(this.pageBuffer, endOffset, this.pageBuffer, startOffset, this.freeStart - endOffset);
        }
        this.freeStart -= endOffset - startOffset;
    }

    byte[] splitEntries(BtreePage left, BtreePage right, BtreePage.BtreeEntry entry, int entryNum, SearchResult resultPosition) {
        int offset = this.keyOffset(entryNum);
        int entryLength = this.keyLength + this.dataLength;
        int half = this.numEntries() >> 1;
        int midpoint = this.headerLength + half * entryLength;
        boolean insertLeft = offset < midpoint;
        int copyLength = insertLeft ? this.freeStart - midpoint : offset - midpoint;
        if (resultPosition != null) {
            resultPosition.matched = true;
            resultPosition.skipCount = 0;
            if (insertLeft) {
                resultPosition.page = left;
                resultPosition.entryNum = entryNum;
            } else {
                resultPosition.page = right;
                resultPosition.entryNum = entryNum - half;
            }
        }
        if (copyLength > 0) {
            System.arraycopy(this.pageBuffer, midpoint, right.pageBuffer, right.freeStart, copyLength);
            right.freeStart += copyLength;
        }
        if (!insertLeft) {
            System.arraycopy(entry.key, 0, right.pageBuffer, right.freeStart, this.keyLength);
            right.freeStart += this.keyLength;
            System.arraycopy(entry.data, 0, right.pageBuffer, right.freeStart, this.dataLength);
            right.freeStart += this.dataLength;
            if (this.freeStart != offset) {
                System.arraycopy(this.pageBuffer, offset, right.pageBuffer, right.freeStart, this.freeStart - offset);
                right.freeStart += this.freeStart - offset;
            }
        }
        if (left != this && (copyLength = insertLeft ? offset - this.headerLength : midpoint - this.headerLength) > 0) {
            System.arraycopy(this.pageBuffer, this.headerLength, left.pageBuffer, left.freeStart, copyLength);
        }
        if (insertLeft) {
            if (midpoint != offset) {
                System.arraycopy(this.pageBuffer, offset, left.pageBuffer, offset + entryLength, midpoint - offset);
            }
            System.arraycopy(entry.key, 0, left.pageBuffer, offset, this.keyLength);
            System.arraycopy(entry.data, 0, left.pageBuffer, offset + this.keyLength, this.dataLength);
            left.freeStart = midpoint + entryLength;
        } else {
            left.freeStart = midpoint;
        }
        if (left != this) {
            this.freeStart = this.headerLength;
        }
        byte[] rightKey = new byte[this.keyLength];
        System.arraycopy(right.pageBuffer, this.headerLength, rightKey, 0, this.keyLength);
        return rightKey;
    }
}

