/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.mdr.persistence.btreeimpl.btreeindex;

import org.netbeans.mdr.persistence.StorageBadRequestException;
import org.netbeans.mdr.persistence.StorageException;
import org.netbeans.mdr.persistence.btreeimpl.btreeindex.Btree;
import org.netbeans.mdr.persistence.btreeimpl.btreeindex.BtreePage;
import org.netbeans.mdr.persistence.btreeimpl.btreeindex.SearchResult;
import org.netbeans.mdr.persistence.btreeimpl.btreestorage.Converter;

public class VarRecordPage
extends BtreePage {
    private int[] offsets;
    private int[] keyLengths;
    private int nextOffset;
    private static final int SIZE_OF_OFFSET = 4;

    public void init(Btree btree, byte[] pageId, byte[] pageBuffer, boolean isNew) throws StorageException {
        if (this.initialized) {
            return;
        }
        super.init(btree, pageId, pageBuffer, isNew);
        if (this.offsets == null) {
            int maxOffsets = (btree.pageSize - this.headerLength) / 4;
            this.offsets = new int[maxOffsets];
            this.keyLengths = new int[maxOffsets];
        }
        this.initOffsets(isNew);
    }

    private void initOffsets(boolean isNew) {
        int pageOffset = this.headerLength;
        if (isNew) {
            this.nextOffset = 0;
        } else {
            this.nextOffset = (this.freeStart - this.headerLength) / 4;
            for (int i = 0; i < this.nextOffset; ++i) {
                this.offsets[i] = Converter.readShort(this.pageBuffer, pageOffset);
                this.keyLengths[i] = Converter.readShort(this.pageBuffer, pageOffset + 2);
                pageOffset += 4;
            }
        }
        this.offsets[this.nextOffset] = this.btree.pageSize;
    }

    public void store() {
        int pageOffset = this.headerLength;
        super.store();
        if (this.nextOffset > 0) {
            for (int i = 0; i < this.nextOffset; ++i) {
                Converter.writeShort(this.pageBuffer, pageOffset, (short)this.offsets[i]);
                Converter.writeShort(this.pageBuffer, pageOffset + 2, (short)this.keyLengths[i]);
                pageOffset += 4;
            }
        }
    }

    int numEntries() {
        return this.nextOffset;
    }

    int keyOffset(int entryNum) {
        return this.offsets[entryNum];
    }

    int keyLength(int entryNum) {
        if (entryNum != this.nextOffset) {
            return this.keyLengths[entryNum];
        }
        return 0;
    }

    int dataLength(int entryNum) {
        if (entryNum != this.nextOffset) {
            return this.offsets[entryNum + 1] - this.offsets[entryNum] - this.keyLengths[entryNum];
        }
        return 0;
    }

    byte[] getData(int entryNum) {
        int length = this.dataLength(entryNum);
        byte[] data = new byte[length];
        System.arraycopy(this.pageBuffer, this.offsets[entryNum + 1] - length, data, 0, length);
        return data;
    }

    byte[] getKey(int entryNum) {
        byte[] key = new byte[this.keyLengths[entryNum]];
        System.arraycopy(this.pageBuffer, this.offsets[entryNum], key, 0, key.length);
        return key;
    }

    BtreePage.BtreeEntry replace(BtreePage.BtreeEntry entry, int entryNum, SearchResult resultPosition) throws StorageException {
        this.delete(entryNum, entryNum);
        return this.insert(entry, entryNum, resultPosition);
    }

    BtreePage.BtreeEntry insert(BtreePage.BtreeEntry entry, int entryNum, SearchResult resultPosition) throws StorageException {
        int entryLength = entry.length();
        this.pageSource.dirtyPage(this);
        if (!this.haveSpaceForInsert(entry)) {
            return this.split(entry, entryNum, resultPosition);
        }
        int entriesStart = this.offsets[0];
        int entriesSplit = this.offsets[entryNum];
        this.shiftOffsets(this, entryNum, entryLength);
        if (entryNum != 0) {
            System.arraycopy(this.pageBuffer, entriesStart, this.pageBuffer, entriesStart - entryLength, entriesSplit - entriesStart);
        }
        System.arraycopy(entry.key, 0, this.pageBuffer, this.offsets[entryNum], entry.key.length);
        System.arraycopy(entry.data, 0, this.pageBuffer, this.offsets[entryNum] + entry.key.length, entry.data.length);
        this.keyLengths[entryNum] = entry.key.length;
        this.freeStart += 4;
        if (resultPosition != null) {
            resultPosition.entryNum = entryNum;
            resultPosition.matched = true;
            resultPosition.page = this;
            resultPosition.skipCount = 0;
        }
        return null;
    }

    void delete(int first, int last) throws StorageException {
        int i;
        this.pageSource.dirtyPage(this);
        int startOffset = this.offsets[first];
        int endOffset = this.offsets[last + 1];
        int bytesDeleted = endOffset - startOffset;
        int numDeleted = last - first + 1;
        if (first != 0) {
            System.arraycopy(this.pageBuffer, this.offsets[0], this.pageBuffer, this.offsets[0] + bytesDeleted, startOffset - this.offsets[0]);
        }
        for (i = last + 1; i <= this.nextOffset; ++i) {
            this.offsets[i - numDeleted] = this.offsets[i];
            this.keyLengths[i - numDeleted] = this.keyLengths[i];
        }
        this.nextOffset -= numDeleted;
        this.freeStart -= numDeleted * 4;
        if (first != 0) {
            i = 0;
            while (i < first) {
                int n = i++;
                this.offsets[n] = this.offsets[n] + bytesDeleted;
            }
        }
    }

    byte[] splitEntries(BtreePage leftBP, BtreePage rightBP, BtreePage.BtreeEntry entry, int newEntryNum, SearchResult resultPosition) throws StorageException {
        boolean insertLeft;
        int spaceNeeded;
        int splitEntryNum;
        VarRecordPage left = (VarRecordPage)leftBP;
        VarRecordPage right = (VarRecordPage)rightBP;
        int pageSize = this.btree.pageSize;
        int spaceAvailable = pageSize - this.headerLength;
        if (entry.length() > spaceAvailable) {
            throw new StorageBadRequestException("Entry too big to fit in a VarRecordPage, size: " + entry.length());
        }
        int halfBytes = spaceAvailable - this.nextOffset * 4 >> 1;
        for (splitEntryNum = 0; this.offsets[splitEntryNum] < halfBytes && splitEntryNum < this.nextOffset; ++splitEntryNum) {
        }
        if (newEntryNum < splitEntryNum) {
            do {
                if ((spaceNeeded = splitEntryNum * 4 + this.offsets[splitEntryNum] - this.offsets[0] + entry.length() + 4) <= spaceAvailable) continue;
                --splitEntryNum;
            } while (spaceNeeded > spaceAvailable && newEntryNum < splitEntryNum);
        }
        boolean bl = insertLeft = newEntryNum < splitEntryNum;
        if (resultPosition != null) {
            resultPosition.matched = true;
            resultPosition.skipCount = 0;
            if (insertLeft) {
                resultPosition.page = left;
                resultPosition.entryNum = newEntryNum;
            } else {
                resultPosition.page = right;
                resultPosition.entryNum = newEntryNum - splitEntryNum;
            }
        }
        if (!insertLeft) {
            spaceNeeded = splitEntryNum * 4 + pageSize - this.offsets[splitEntryNum] + entry.length() + 4;
        }
        int from = splitEntryNum;
        int to = 0;
        while (from < this.nextOffset) {
            right.offsets[to] = this.offsets[from];
            right.keyLengths[to] = this.keyLengths[from];
            ++from;
            ++to;
        }
        right.nextOffset = this.nextOffset - splitEntryNum;
        right.offsets[right.nextOffset] = this.btree.pageSize;
        right.freeStart = this.headerLength + right.nextOffset * 4;
        if (insertLeft) {
            System.arraycopy(this.pageBuffer, this.offsets[splitEntryNum], right.pageBuffer, this.offsets[splitEntryNum], pageSize - this.offsets[splitEntryNum]);
        } else {
            int rightNewEntryNum = newEntryNum - splitEntryNum;
            this.shiftOffsets(right, rightNewEntryNum, entry.length());
            right.keyLengths[rightNewEntryNum] = entry.key.length;
            right.freeStart += 4;
            if (newEntryNum != splitEntryNum) {
                System.arraycopy(this.pageBuffer, this.offsets[splitEntryNum], right.pageBuffer, right.offsets[0], this.offsets[newEntryNum] - this.offsets[splitEntryNum]);
            }
            System.arraycopy(entry.key, 0, right.pageBuffer, right.offsets[rightNewEntryNum], entry.key.length);
            System.arraycopy(entry.data, 0, right.pageBuffer, right.offsets[rightNewEntryNum] + entry.key.length, entry.data.length);
            if (newEntryNum != this.nextOffset) {
                System.arraycopy(this.pageBuffer, this.offsets[newEntryNum], right.pageBuffer, right.offsets[rightNewEntryNum + 1], pageSize - this.offsets[newEntryNum]);
            }
        }
        int bytesRemoved = pageSize - this.offsets[splitEntryNum];
        int splitPoint = this.offsets[splitEntryNum];
        int entriesStart = this.offsets[0];
        int insertPoint = this.offsets[newEntryNum];
        for (int i = 0; i < splitEntryNum; ++i) {
            left.offsets[i] = this.offsets[i] + bytesRemoved;
            left.keyLengths[i] = this.keyLengths[i];
        }
        left.nextOffset = splitEntryNum;
        left.offsets[left.nextOffset] = pageSize;
        left.freeStart = this.headerLength + left.nextOffset * 4;
        if (!insertLeft) {
            System.arraycopy(this.pageBuffer, entriesStart, left.pageBuffer, left.offsets[0], splitPoint - entriesStart);
        } else {
            this.shiftOffsets(left, newEntryNum, entry.length());
            left.keyLengths[newEntryNum] = entry.key.length;
            left.freeStart += 4;
            if (insertPoint != splitPoint) {
                System.arraycopy(this.pageBuffer, insertPoint, left.pageBuffer, left.offsets[newEntryNum + 1], splitPoint - insertPoint);
            }
            if (insertPoint != entriesStart) {
                System.arraycopy(this.pageBuffer, entriesStart, left.pageBuffer, left.offsets[0], insertPoint - entriesStart);
            }
            System.arraycopy(entry.key, 0, left.pageBuffer, left.offsets[newEntryNum], entry.key.length);
            System.arraycopy(entry.data, 0, left.pageBuffer, left.offsets[newEntryNum] + entry.key.length, entry.data.length);
        }
        if (left != this) {
            this.nextOffset = 0;
            this.freeStart = this.headerLength;
            this.offsets[0] = pageSize;
        }
        int rightKeyLength = right.keyLength(0);
        byte[] rightKey = new byte[rightKeyLength];
        System.arraycopy(right.pageBuffer, right.offsets[0], rightKey, 0, rightKeyLength);
        return rightKey;
    }

    private void shiftOffsets(VarRecordPage page, int entryNum, int entryLength) {
        int i;
        if (entryNum != page.nextOffset) {
            for (i = page.nextOffset; i > entryNum; --i) {
                page.offsets[i] = page.offsets[i - 1];
                page.keyLengths[i] = page.keyLengths[i - 1];
            }
        }
        ++page.nextOffset;
        page.offsets[page.nextOffset] = this.btree.pageSize;
        i = entryNum;
        while (i >= 0) {
            int n = i--;
            page.offsets[n] = page.offsets[n] - entryLength;
        }
    }

    boolean haveSpaceForInsert(BtreePage.BtreeEntry entry) {
        int freeSpace = this.offsets[0] - this.freeStart;
        return entry.length() + 4 <= freeSpace;
    }
}

