/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.mdr.persistence.btreeimpl.btreestorage;

import java.text.MessageFormat;
import java.util.Iterator;
import java.util.Map;
import org.netbeans.mdr.persistence.Storage;
import org.netbeans.mdr.persistence.StorageBadRequestException;
import org.netbeans.mdr.persistence.StorageException;
import org.netbeans.mdr.persistence.btreeimpl.btreeindex.BigKeyPage;
import org.netbeans.mdr.persistence.btreeimpl.btreeindex.Btree;
import org.netbeans.mdr.persistence.btreeimpl.btreeindex.BtreePage;
import org.netbeans.mdr.persistence.btreeimpl.btreeindex.BtreePageSource;
import org.netbeans.mdr.persistence.btreeimpl.btreeindex.EntryTypeInfo;
import org.netbeans.mdr.persistence.btreeimpl.btreeindex.IntInfo;
import org.netbeans.mdr.persistence.btreeimpl.btreeindex.MofidGenerator;
import org.netbeans.mdr.persistence.btreeimpl.btreestorage.BtreeStorage;
import org.netbeans.mdr.persistence.btreeimpl.btreestorage.CachedPage;
import org.netbeans.mdr.persistence.btreeimpl.btreestorage.Converter;
import org.netbeans.mdr.persistence.btreeimpl.btreestorage.FileCache;
import org.netbeans.mdr.persistence.btreeimpl.btreestorage.IntrusiveList;
import org.netbeans.mdr.util.AbstractCollectionFactory;

public class BtreeFileSource
implements BtreePageSource,
FileCache.NotifyOnCommit {
    static final int MAGIC = 123456789;
    static final int VERSION = 1;
    static final int NO_PAGEID = -1;
    static final int NEXTFREE_OFFSET = 72;
    static final int CACHE_SIZE = 5;
    private FileCache fileCache;
    private int fileId;
    private int pageSize;
    private EntryTypeInfo pageIdInfo;
    private byte[] noPageId;
    private boolean metaChanged;
    private int nextFree;
    private BtreeStorage storage;
    private Map btreeCache;
    private IntrusiveList lruList;
    private MofidGenerator gen;

    public BtreeFileSource(int fileId, FileCache fileCache, int pageSize, boolean isNew, MofidGenerator mGen, BtreeStorage storage) throws StorageException {
        this.fileId = fileId;
        this.fileCache = fileCache;
        this.pageSize = pageSize;
        this.storage = storage;
        this.gen = mGen;
        this.pageIdInfo = EntryTypeInfo.getEntryTypeInfo(Storage.EntryType.INT, null);
        this.noPageId = this.pageIdInfo.toBuffer(new Integer(-1));
        this.btreeCache = AbstractCollectionFactory.getCollectionFactory().createHashMap(10);
        this.lruList = new IntrusiveList();
        this.metaChanged = false;
        CachedPage metaFCP = fileCache.getPage(fileId, 0);
        byte[] metadata = metaFCP.contents;
        int offset = 64;
        if (isNew) {
            offset = Converter.writeInt(metadata, offset, 123456789);
            offset = Converter.writeInt(metadata, offset, 1);
            this.nextFree = 1;
            offset = Converter.writeInt(metadata, offset, this.nextFree);
            fileCache.setWritable(metaFCP);
        } else {
            int magic = Converter.readInt(metadata, offset);
            int version = Converter.readInt(metadata, offset += 4);
            this.nextFree = Converter.readInt(metadata, offset += 4);
            if (magic != 123456789) {
                throw new StorageBadRequestException(MessageFormat.format("Index file has bad magic number ", new Integer(magic)));
            }
            if (version != 1) {
                throw new StorageBadRequestException(MessageFormat.format("Index file has incorrect version number. {0} expected, {1} found", new Integer(1), new Integer(version)));
            }
        }
        fileCache.unpin(metaFCP);
        fileCache.addNotifier(this);
    }

    public EntryTypeInfo getPageIdInfo() {
        return new IntInfo();
    }

    public void setNoPage(byte[] pageId) {
        System.arraycopy(this.noPageId, 0, pageId, 0, pageId.length);
    }

    public boolean isNoPage(byte[] pageId) {
        for (int i = 0; i < pageId.length; ++i) {
            if (pageId[i] == this.noPageId[i]) continue;
            return false;
        }
        return true;
    }

    public synchronized void prepareToCommit() throws StorageException {
        Iterator entries = this.btreeCache.values().iterator();
        while (entries.hasNext()) {
            CacheEntry entry = (CacheEntry)entries.next();
            if (!entry.needsStore) continue;
            entry.page.store();
        }
        if (this.metaChanged) {
            CachedPage metaFCP = this.fileCache.getPage(this.fileId, 0);
            this.fileCache.setWritable(metaFCP);
            Converter.writeInt(metaFCP.contents, 72, this.nextFree);
            this.fileCache.unpin(metaFCP);
        }
        this.metaChanged = false;
    }

    public BtreePage getRootPage(Btree btree) throws StorageException {
        if (this.nextFree > 1) {
            return this.getPage(this.pageIdInfo.toBuffer(new Integer(1)), btree);
        }
        return this.newPage(btree);
    }

    public synchronized BtreePage getPage(byte[] pageId, Btree btree) throws StorageException {
        Integer pageNum = (Integer)this.pageIdInfo.fromBuffer(pageId);
        CacheEntry entry = (CacheEntry)this.btreeCache.get(pageNum);
        if (entry == null) {
            entry = this.addToBtreeCache(pageId, pageNum, false, btree);
        } else if (entry.pinned == 0) {
            this.lruList.remove(entry);
        }
        ++entry.pinned;
        return entry.page;
    }

    private CacheEntry addToBtreeCache(byte[] pageId, Integer pageNum, boolean isNew, Btree btree) throws StorageException {
        CacheEntry entry = this.getCacheEntry();
        entry.fcp = this.fileCache.getPage(this.fileId, pageNum);
        if (entry.page == null) {
            entry.page = btree.pageFactory();
        } else {
            entry.page.uninit();
        }
        entry.page.init(btree, pageId, entry.fcp.contents, isNew);
        this.btreeCache.put(pageNum, entry);
        return entry;
    }

    private CacheEntry getCacheEntry() throws StorageException {
        CacheEntry entry = null;
        if (this.btreeCache.size() >= 5) {
            entry = (CacheEntry)this.lruList.removeFirst();
        }
        if (entry != null) {
            Integer pageNum = (Integer)this.pageIdInfo.fromBuffer(entry.page.pageId);
            this.btreeCache.remove(pageNum);
            if (entry.needsStore) {
                entry.page.store();
                entry.needsStore = false;
            }
            this.fileCache.unpin(entry.fcp);
        } else {
            entry = new CacheEntry();
        }
        return entry;
    }

    public synchronized BtreePage newPage(Btree btree) throws StorageException {
        Integer pageNum = new Integer(this.nextFree);
        ++this.nextFree;
        this.metaChanged = true;
        byte[] pageId = this.pageIdInfo.toBuffer(pageNum);
        CacheEntry entry = this.addToBtreeCache(pageId, pageNum, true, btree);
        ++entry.pinned;
        this.dirtyPage(entry.page);
        return entry.page;
    }

    public synchronized BigKeyPage newBigKeyPage(Btree btree) throws StorageException {
        Integer pageNum = new Integer(this.nextFree);
        ++this.nextFree;
        this.metaChanged = true;
        byte[] pageId = this.pageIdInfo.toBuffer(pageNum);
        CacheEntry entry = new CacheEntry();
        entry.fcp = this.fileCache.getPage(this.fileId, pageNum);
        entry.page = new BigKeyPage();
        entry.page.init(btree, pageId, entry.fcp.contents, true);
        this.btreeCache.put(pageNum, entry);
        ++entry.pinned;
        this.dirtyPage(entry.page);
        return (BigKeyPage)entry.page;
    }

    public synchronized void unpinPage(BtreePage page) {
        CacheEntry entry = (CacheEntry)this.btreeCache.get(this.pageIdInfo.fromBuffer(page.pageId));
        if (--entry.pinned == 0) {
            this.lruList.addLast(entry);
        }
    }

    public synchronized void unpinPage(BigKeyPage page) throws StorageException {
        CacheEntry entry = (CacheEntry)this.btreeCache.get(this.pageIdInfo.fromBuffer(page.pageId));
        if (--entry.pinned == 0) {
            Integer pageNum = (Integer)this.pageIdInfo.fromBuffer(entry.page.pageId);
            this.btreeCache.remove(pageNum);
            if (entry.needsStore) {
                entry.page.store();
                entry.needsStore = false;
            }
            this.fileCache.unpin(entry.fcp);
        }
    }

    public synchronized void dirtyPage(BtreePage page) throws StorageException {
        CacheEntry entry = (CacheEntry)this.btreeCache.get(this.pageIdInfo.fromBuffer(page.pageId));
        entry.needsStore = true;
        this.fileCache.setWritable(entry.fcp);
    }

    public int getPageIdLength() {
        return this.pageIdInfo.getLength();
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public long getNextMofid() {
        if (this.gen != null) {
            return this.gen.getNextMofid();
        }
        throw new RuntimeException("Not implemented");
    }

    public String getMofidPrefix() {
        if (this.gen != null) {
            return this.gen.getMofidPrefix();
        }
        throw new RuntimeException("Not implemented");
    }

    public BtreeStorage getStorage() {
        return this.storage;
    }

    private static class CacheEntry
    extends IntrusiveList.Member {
        BtreePage page;
        CachedPage fcp;
        int pinned;
        boolean needsStore;

        private CacheEntry() {
        }
    }
}

