/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.mdr.persistence.memoryimpl;

import java.util.Collection;
import java.util.List;
import org.netbeans.mdr.persistence.MultivaluedOrderedIndex;
import org.netbeans.mdr.persistence.SinglevaluedIndex;
import org.netbeans.mdr.persistence.Storage;
import org.netbeans.mdr.persistence.StorageBadRequestException;
import org.netbeans.mdr.persistence.StorageException;
import org.netbeans.mdr.persistence.Streamable;
import org.netbeans.mdr.persistence.memoryimpl.IndexStorageCreator;
import org.netbeans.mdr.persistence.memoryimpl.MultivaluedIndexImpl;
import org.netbeans.mdr.util.AbstractCollectionFactory;

public class MultivaluedOrderedIndexImpl
extends MultivaluedIndexImpl
implements MultivaluedOrderedIndex,
Streamable {
    public MultivaluedOrderedIndexImpl(String name, Storage storage, Storage.EntryType keyType, Storage.EntryType valueType, boolean unique, IndexStorageCreator indexStorageCreator) {
        super(name, storage, keyType, valueType, unique, indexStorageCreator);
    }

    public MultivaluedOrderedIndexImpl() {
    }

    public synchronized List getItemsOrdered(Object key) throws StorageException {
        return (List)this.getItems(key);
    }

    public synchronized Collection getObjectsOrdered(Object key, SinglevaluedIndex repos) throws StorageException {
        return (List)this.getObjects(key, repos);
    }

    public synchronized boolean remove(Object key, int index) throws StorageException {
        Object orig;
        List vals = (List)this.entries.get(key);
        if (vals != null && (orig = vals.remove(index)) != null) {
            this.transLog.logRemove(key, orig, index);
            return true;
        }
        return false;
    }

    public synchronized void add(Object key, int index, Object value) throws StorageException {
        List vals = (List)this.entries.get(key);
        if (vals == null) {
            vals = AbstractCollectionFactory.getCollectionFactory().createArrayList();
            this.entries.put(key, vals);
        } else if (this.unique && vals.contains(value)) {
            throw MultivaluedIndexImpl.createValueAlreadyContainedExc(key, value);
        }
        vals.add(index, value);
        this.transLog.logAdd(key, value, index);
    }

    public synchronized void replace(Object key, int index, Object element) throws StorageException {
        List vals = (List)this.entries.get(key);
        try {
            if (vals != null) {
                if (this.unique && !MultivaluedOrderedIndexImpl.isUniqueValue(vals, element, index)) {
                    throw MultivaluedIndexImpl.createValueAlreadyContainedExc(key, element);
                }
                Object orig = vals.set(index, element);
                if (orig != null) {
                    this.transLog.logReplace(key, orig, index);
                    return;
                }
            }
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
        throw new StorageBadRequestException("Index out of range: " + index + " for key: " + key);
    }
}

