/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.mdr.storagemodel;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.netbeans.mdr.persistence.Index;
import org.netbeans.mdr.persistence.MOFID;
import org.netbeans.mdr.persistence.MultivaluedIndex;
import org.netbeans.mdr.persistence.MultivaluedOrderedIndex;
import org.netbeans.mdr.persistence.SinglevaluedIndex;
import org.netbeans.mdr.persistence.StorageBadRequestException;
import org.netbeans.mdr.persistence.StorageException;
import org.netbeans.mdr.storagemodel.AssocEndIndexSet;
import org.netbeans.mdr.storagemodel.StorableAssociation;
import org.netbeans.mdr.storagemodel.StorableBaseObject;
import org.netbeans.mdr.storagemodel.StorableObject;
import org.netbeans.mdr.util.DebugException;
import org.netbeans.mdr.util.Logger;

public class AssocEndIndexUList
extends AssocEndIndexSet
implements List {
    private final MultivaluedOrderedIndex orderedIndex;

    protected AssocEndIndexUList(StorableAssociation storable, MOFID metaMofId, MOFID metaMofIdOther, MultivaluedOrderedIndex index, Object indexKey, Index secondIndex, Class type, int max, boolean mutable, boolean isAggregate, boolean isAggregateOther, boolean isIndexed, boolean isIndexedOther) {
        super(storable, metaMofId, metaMofIdOther, index, indexKey, secondIndex, type, max, mutable, isAggregate, isAggregateOther, isIndexed, isIndexedOther);
        this.orderedIndex = index;
    }

    protected List getItemsList() {
        try {
            return this.orderedIndex.getItemsOrdered(this.indexKey);
        }
        catch (StorageException e) {
            throw (DebugException)Logger.getDefault().annotate((Throwable)new DebugException(e), (Throwable)e);
        }
    }

    protected List getObjectsList() {
        try {
            return (List)this.storage.getObjectsFromIndex(this.index, this.indexKey);
        }
        catch (StorageException e) {
            throw (DebugException)Logger.getDefault().annotate((Throwable)new DebugException(e), (Throwable)e);
        }
    }

    public Object get(int param) {
        return this.getObjectsList().get(param);
    }

    public ListIterator listIterator() {
        return new IndexListIterator(this.getObjectsList().listIterator());
    }

    public ListIterator listIterator(int param) {
        return new IndexListIterator(this.getObjectsList().listIterator(param));
    }

    public int indexOf(Object obj) {
        return this.getItemsList().indexOf(obj);
    }

    public int lastIndexOf(Object obj) {
        return this.getItemsList().lastIndexOf(obj);
    }

    public List subList(int param, int param1) {
        throw new UnsupportedOperationException();
    }

    public Object set(int index, Object object) {
        try {
            List items = (List)this.getItems();
            if (items == null) {
                throw new DebugException("Object does not exist.");
            }
            Object oldValue = items.get(index);
            if (this.isAggregate) {
                this.keyObject.clearComposite();
                this.keyObject.setComposite((MOFID)object, (MOFID)object, this.metaMofId);
            } else if (this.isAggregateOther) {
                ((StorableObject)this.storage.getObject((MOFID)oldValue)).clearComposite();
                ((StorableObject)this.storage.getObject((MOFID)object)).setComposite(this.keyObject, (MOFID)object, this.metaMofId);
            }
            if (this.isIndexed) {
                this.keyObject.removeFromIndex(this.metaMofId);
            }
            if (this.isIndexedOther) {
                ((StorableObject)this.storage.getObject((MOFID)oldValue)).removeFromIndex(this.metaMofIdOther);
                ((StorableObject)this.storage.getObject((MOFID)object)).removeFromIndex(this.metaMofIdOther);
            }
            this.orderedIndex.replace(this.indexKey, index, object);
            if (this.secondIndex instanceof SinglevaluedIndex) {
                this.secondIndex.remove(oldValue);
            } else {
                ((MultivaluedIndex)this.secondIndex).remove(oldValue, this.indexKey);
            }
            this.secondIndex.add(object, this.indexKey);
            if (this.isIndexed) {
                this.keyObject.addToIndex(this.metaMofId);
            }
            if (this.isIndexedOther) {
                ((StorableObject)this.storage.getObject((MOFID)oldValue)).addToIndex(this.metaMofIdOther);
                ((StorableObject)this.storage.getObject((MOFID)object)).addToIndex(this.metaMofIdOther);
            }
            return this.storage.getObject((MOFID)oldValue);
        }
        catch (StorageException e) {
            throw (DebugException)Logger.getDefault().annotate((Throwable)new DebugException(e), (Throwable)e);
        }
    }

    public void add(int index, Object element) {
        try {
            this.checkMaxSize(1);
            StorableObject so = null;
            if (this.isAggregate) {
                this.keyObject.setComposite((MOFID)element, (MOFID)element, this.metaMofId);
            } else if (this.isAggregateOther) {
                if (so == null) {
                    so = (StorableObject)this.storage.getObject((MOFID)element);
                }
                so.setComposite(this.keyObject, (MOFID)element, this.metaMofId);
            }
            if (this.isIndexed) {
                this.keyObject.removeFromIndex(this.metaMofId);
            }
            if (this.isIndexedOther) {
                if (so == null) {
                    so = (StorableObject)this.storage.getObject((MOFID)element);
                }
                so.removeFromIndex(this.metaMofIdOther);
            }
            try {
                this.orderedIndex.add(this.indexKey, index, element);
            }
            catch (StorageBadRequestException e) {
                throw new IndexOutOfBoundsException();
            }
            this.secondIndex.add(element, this.indexKey);
            if (this.isIndexed) {
                this.keyObject.addToIndex(this.metaMofId);
            }
            if (this.isIndexedOther) {
                so.addToIndex(this.metaMofIdOther);
            }
        }
        catch (StorageException e) {
            throw (DebugException)Logger.getDefault().annotate((Throwable)new DebugException(e), (Throwable)e);
        }
    }

    public Object remove(int index) {
        try {
            Object oldValue = this.getItemsList().get(index);
            StorableObject so = null;
            if (this.isAggregate) {
                this.keyObject.clearComposite();
            } else if (this.isAggregateOther) {
                if (so == null) {
                    so = (StorableObject)this.storage.getObject((MOFID)oldValue);
                }
                so.clearComposite();
            }
            if (this.isIndexed) {
                this.keyObject.removeFromIndex(this.metaMofId);
            }
            if (this.isIndexedOther) {
                if (so == null) {
                    so = (StorableObject)this.storage.getObject((MOFID)oldValue);
                }
                so.removeFromIndex(this.metaMofIdOther);
            }
            this.orderedIndex.remove(this.indexKey, index);
            if (this.secondIndex instanceof SinglevaluedIndex) {
                this.secondIndex.remove(oldValue);
            } else {
                ((MultivaluedIndex)this.secondIndex).remove(oldValue, this.indexKey);
            }
            if (this.isIndexed) {
                this.keyObject.addToIndex(this.metaMofId);
            }
            if (this.isIndexedOther) {
                so.addToIndex(this.metaMofIdOther);
            }
            return this.storage.getObject((MOFID)oldValue);
        }
        catch (StorageException e) {
            throw new DebugException(e);
        }
    }

    public boolean addAll(int param, Collection collection) {
        throw new DebugException(new UnsupportedOperationException());
    }

    protected class IndexListIterator
    extends AssocEndIndexSet.IndexIterator
    implements ListIterator {
        private final ListIterator listIterator;

        protected IndexListIterator(ListIterator innerIterator) {
            super((Iterator)innerIterator);
            this.listIterator = innerIterator;
        }

        public void add(Object obj) {
            this.listIterator.add(obj);
            try {
                if (AssocEndIndexUList.this.isAggregate) {
                    AssocEndIndexUList.this.keyObject.setComposite((MOFID)obj, (MOFID)obj, AssocEndIndexUList.this.metaMofId);
                } else if (AssocEndIndexUList.this.isAggregateOther) {
                    ((StorableObject)AssocEndIndexUList.this.storage.getObject((MOFID)obj)).setComposite(AssocEndIndexUList.this.keyObject, (MOFID)obj, AssocEndIndexUList.this.metaMofId);
                }
                if (AssocEndIndexUList.this.isIndexed) {
                    AssocEndIndexUList.this.keyObject.removeFromIndex(AssocEndIndexUList.this.metaMofId);
                }
                if (AssocEndIndexUList.this.isIndexedOther) {
                    ((StorableObject)AssocEndIndexUList.this.storage.getObject((MOFID)obj)).removeFromIndex(AssocEndIndexUList.this.metaMofIdOther);
                }
                AssocEndIndexUList.this.secondIndex.add(obj, AssocEndIndexUList.this.indexKey);
                if (AssocEndIndexUList.this.isIndexed) {
                    AssocEndIndexUList.this.keyObject.addToIndex(AssocEndIndexUList.this.metaMofId);
                }
                if (AssocEndIndexUList.this.isIndexedOther) {
                    ((StorableObject)AssocEndIndexUList.this.storage.getObject((MOFID)obj)).addToIndex(AssocEndIndexUList.this.metaMofIdOther);
                }
            }
            catch (StorageException e) {
                throw (DebugException)Logger.getDefault().annotate((Throwable)new DebugException(e), (Throwable)e);
            }
        }

        public boolean hasPrevious() {
            return this.listIterator.hasPrevious();
        }

        public int nextIndex() {
            return this.listIterator.nextIndex();
        }

        public Object previous() {
            this.lastRead = this.listIterator.previous();
            return this.lastRead;
        }

        public int previousIndex() {
            return this.listIterator.previousIndex();
        }

        public void set(Object obj) {
            MOFID key = ((StorableBaseObject)this.lastRead).getMofId();
            this.listIterator.set(obj);
            try {
                if (AssocEndIndexUList.this.isAggregate) {
                    AssocEndIndexUList.this.keyObject.clearComposite();
                    AssocEndIndexUList.this.keyObject.setComposite((MOFID)obj, (MOFID)obj, AssocEndIndexUList.this.metaMofId);
                } else if (AssocEndIndexUList.this.isAggregateOther) {
                    ((StorableObject)this.lastRead).clearComposite();
                    ((StorableObject)this.lastRead).setComposite(AssocEndIndexUList.this.keyObject, key, AssocEndIndexUList.this.metaMofId);
                }
                if (AssocEndIndexUList.this.isIndexed) {
                    AssocEndIndexUList.this.keyObject.removeFromIndex(AssocEndIndexUList.this.metaMofId);
                }
                if (AssocEndIndexUList.this.isIndexedOther) {
                    ((StorableObject)this.lastRead).removeFromIndex(AssocEndIndexUList.this.metaMofIdOther);
                    ((StorableObject)AssocEndIndexUList.this.storage.getObject((MOFID)obj)).removeFromIndex(AssocEndIndexUList.this.metaMofIdOther);
                }
                if (AssocEndIndexUList.this.secondIndex instanceof MultivaluedIndex) {
                    ((MultivaluedIndex)AssocEndIndexUList.this.secondIndex).remove(key, AssocEndIndexUList.this.indexKey);
                } else {
                    AssocEndIndexUList.this.secondIndex.remove(key);
                }
                AssocEndIndexUList.this.secondIndex.add(obj, AssocEndIndexUList.this.indexKey);
                if (AssocEndIndexUList.this.isIndexed) {
                    AssocEndIndexUList.this.keyObject.addToIndex(AssocEndIndexUList.this.metaMofId);
                }
                if (AssocEndIndexUList.this.isIndexedOther) {
                    ((StorableObject)this.lastRead).addToIndex(AssocEndIndexUList.this.metaMofIdOther);
                    ((StorableObject)AssocEndIndexUList.this.storage.getObject((MOFID)obj)).addToIndex(AssocEndIndexUList.this.metaMofIdOther);
                }
            }
            catch (StorageException e) {
                throw (DebugException)Logger.getDefault().annotate((Throwable)new DebugException(e), (Throwable)e);
            }
        }
    }
}

