/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.mdr.storagemodel;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jmi.model.AssociationEnd;
import javax.jmi.model.Attribute;
import javax.jmi.model.ModelElement;
import javax.jmi.model.Tag;
import javax.jmi.reflect.RefObject;
import org.netbeans.mdr.handlers.BaseObjectHandler;
import org.netbeans.mdr.handlers.ClassProxyHandler;
import org.netbeans.mdr.handlers.InstanceHandler;
import org.netbeans.mdr.handlers.gen.TagSupport;
import org.netbeans.mdr.persistence.MOFID;
import org.netbeans.mdr.persistence.MultivaluedIndex;
import org.netbeans.mdr.persistence.StorageException;
import org.netbeans.mdr.storagemodel.CompositeCollection;
import org.netbeans.mdr.storagemodel.DatatypeDescriptor;
import org.netbeans.mdr.storagemodel.IndexImmutSet;
import org.netbeans.mdr.storagemodel.MdrStorage;
import org.netbeans.mdr.storagemodel.StorableAssociation;
import org.netbeans.mdr.storagemodel.StorableBaseObject;
import org.netbeans.mdr.storagemodel.StorableFeatured;
import org.netbeans.mdr.storagemodel.StorableObject;
import org.netbeans.mdr.util.AbstractCollectionFactory;
import org.netbeans.mdr.util.DebugException;
import org.netbeans.mdr.util.IOUtils;
import org.netbeans.mdr.util.Logger;

public class StorableClass
extends StorableFeatured {
    private AttributeDescriptor[] attrDescs;
    private Map clAttrDescs = AbstractCollectionFactory.getCollectionFactory().createHashMap();
    private Map clAttrValues = AbstractCollectionFactory.getCollectionFactory().createHashMap();
    private Map datatypes;
    private List superclasses;
    private List subclasses;
    private Map references;
    private Collection associationEnds;
    private boolean classDerived;
    private boolean instanceDerived;
    private String classSuperclass = null;
    private String instanceSuperclass = null;
    private boolean singletonClass;
    private boolean abstractClass;
    private IndexDescriptor[] indexDescs;
    private final Map refCache = AbstractCollectionFactory.getCollectionFactory().createHashMap();
    private List attributes;
    private AttributeDescriptor[] attributeDescs;
    private List indexDescriptors;
    private Map indexMap;
    private Map indexesByName;

    protected void replaceValues(Map table) {
        this.objectWillChange();
        super.replaceValues(table);
        for (int i = 0; i < this.attrDescs.length; ++i) {
            this.attrDescs[i].replaceValues(table);
        }
        Iterator it = this.clAttrDescs.values().iterator();
        while (it.hasNext()) {
            ((AttributeDescriptor)it.next()).replaceValues(table);
        }
        it = this.references.values().iterator();
        while (it.hasNext()) {
            ((ReferenceDescriptor)it.next()).replaceValues(table);
        }
        this.objectChanged();
    }

    public StorableClass() {
    }

    public StorableClass(MdrStorage mdrStorage, MOFID packageId, MOFID metaId, List attrDescs, List clAttrDescs, Map datatypes, boolean classDerived, boolean instanceDerived, boolean isSingleton, boolean isAbstract) throws StorageException {
        super(mdrStorage, packageId, metaId);
        this.attrDescs = attrDescs.toArray(new AttributeDescriptor[attrDescs.size()]);
        Iterator it = clAttrDescs.iterator();
        while (it.hasNext()) {
            AttributeDescriptor desc = (AttributeDescriptor)it.next();
            this.clAttrDescs.put(desc.getName(), desc);
            this.clAttrValues.put(desc.getName(), this.getInitialValue(desc, null));
        }
        this.datatypes = datatypes;
        this.subclasses = AbstractCollectionFactory.getCollectionFactory().createArrayList();
        this.superclasses = AbstractCollectionFactory.getCollectionFactory().createArrayList();
        this.references = AbstractCollectionFactory.getCollectionFactory().createHashMap();
        this.associationEnds = AbstractCollectionFactory.getCollectionFactory().createArrayList();
        this.classDerived = classDerived;
        this.instanceDerived = instanceDerived;
        this.singletonClass = isSingleton;
        this.abstractClass = isAbstract;
        this.getMdrStorage().addObject(this);
        this.initFinished = true;
    }

    public void buildAdditionalIndexes(List indexTags, Map associationProxies) throws StorageException {
        this.objectWillChange();
        this.indexDescs = new IndexDescriptor[indexTags.size()];
        Iterator iter = indexTags.iterator();
        int y = 0;
        while (iter.hasNext()) {
            IndexDescriptor indexDesc;
            Tag tag = (Tag)iter.next();
            List values = tag.getValues();
            if (values == null || values.size() == 0) {
                throw new DebugException("Cannot create unnamed additional index.");
            }
            String indexName = (String)values.get(0);
            List elements = AbstractCollectionFactory.getCollectionFactory().createArrayList(tag.getElements());
            Iterator elementsIter = elements.iterator();
            List collectedFields = AbstractCollectionFactory.getCollectionFactory().createArrayList(elements.size());
            while (elementsIter.hasNext()) {
                ModelElement elem = (ModelElement)elementsIter.next();
                if (((InstanceHandler)elem)._getDelegate().getMofId().equals(this.getMetaObjectId())) continue;
                if (elem instanceof Attribute) {
                    collectedFields.add(new IndexDescriptor.Attrib(((InstanceHandler)elem)._getDelegate().getMofId(), elem.getName(), ((Attribute)elem).getMultiplicity().isOrdered()));
                    continue;
                }
                if (elem instanceof AssociationEnd) {
                    MOFID assocId = (MOFID)associationProxies.get(((InstanceHandler)elem.getContainer())._getDelegate().getMofId());
                    collectedFields.add(new IndexDescriptor.AssocEnd(((InstanceHandler)elem)._getDelegate().getMofId(), elem.getName(), ((AssociationEnd)elem).getMultiplicity().isOrdered(), assocId));
                    continue;
                }
                throw new DebugException("Cannot create additional index " + indexName + ", element " + elem.getName() + " is not an attribute or an association end.");
            }
            this.indexDescs[y] = indexDesc = new IndexDescriptor(indexName, collectedFields.toArray(new IndexDescriptor.Field[0]));
            this.getMdrStorage().createAdditionalIndex(this.getOutermostPackageId(), indexName, this.getMofId());
            ++y;
        }
        this.objectChanged();
    }

    private void buildIndexMap() throws StorageException {
        this.indexMap = AbstractCollectionFactory.getCollectionFactory().createHashMap();
        this.indexesByName = AbstractCollectionFactory.getCollectionFactory().createHashMap();
        Iterator iter = this.indexDescriptors.iterator();
        while (iter.hasNext()) {
            IndexDescriptor desc = (IndexDescriptor)iter.next();
            this.indexesByName.put(desc.getName(), desc);
            IndexDescriptor.Field[] fields = desc.getFields();
            for (int x = 0; x < fields.length; ++x) {
                MOFID id;
                if (fields[x] instanceof IndexDescriptor.Attrib) {
                    id = ((IndexDescriptor.Attrib)fields[x]).getId();
                    String name = ((IndexDescriptor.Attrib)fields[x]).getName();
                    this.attributeDescs[this.getAttrIndex(name)].setIndexed(true);
                } else {
                    id = ((IndexDescriptor.AssocEnd)fields[x]).getId();
                }
                LinkedList<IndexDescriptor> list = (LinkedList<IndexDescriptor>)this.indexMap.get(id);
                if (list == null) {
                    list = new LinkedList<IndexDescriptor>();
                    this.indexMap.put(id, list);
                }
                list.add(desc);
            }
        }
    }

    List getIndexes(MOFID mofId) throws StorageException {
        this.checkAttributes();
        return (List)this.indexMap.get(mofId);
    }

    public IndexDescriptor getAdditionalIndex(String indexName) throws StorageException {
        this.checkAttributes();
        return (IndexDescriptor)this.indexesByName.get(indexName);
    }

    public DatatypeDescriptor getDatatypeDesc(String name) {
        return (DatatypeDescriptor)this.datatypes.get(name);
    }

    public Collection allObjects(boolean subclasses) throws StorageException {
        if (subclasses) {
            CompositeCollection result = new CompositeCollection();
            this.collectObjects(result, AbstractCollectionFactory.getCollectionFactory().createHashSet());
            return result;
        }
        MdrStorage storage = this.getMdrStorage();
        MOFID mofId = this.getMofId();
        return new IndexImmutSet(storage, storage.getInstancesIndex(mofId), mofId);
    }

    private void collectObjects(CompositeCollection result, Set visited) throws StorageException {
        if (visited.add(this.getMofId())) {
            result.addCollection(this.allObjects(false));
            Iterator it = this.subclasses.iterator();
            while (it.hasNext()) {
                ((StorableClass)this.getMdrStorage().getObject((MOFID)it.next())).collectObjects(result, visited);
            }
        }
    }

    public void addAssociationEnd(MOFID mofId, String endName, boolean aggregate) {
        this.objectWillChange();
        this.associationEnds.add(new AssocEndDescriptor(mofId, endName, aggregate));
        this.objectChanged();
    }

    public void addSubclass(MOFID mofId) {
        this.objectWillChange();
        this.subclasses.add(mofId);
        this.objectChanged();
    }

    public void addSuperclass(MOFID mofId) {
        if (this.attributes != null) {
            throw new DebugException("bad thing in: " + this.getMofId());
        }
        this.objectWillChange();
        this.superclasses.add(mofId);
        this.objectChanged();
    }

    public void addReferenceDescriptor(MOFID mofId, String name, MOFID assocProxyId, String endName) {
        this.objectWillChange();
        this.references.put(name, new ReferenceDescriptor(mofId, assocProxyId, endName));
        this.objectChanged();
    }

    public void verify(Collection violations) {
    }

    public Object getAttribute(String name) throws StorageException {
        StorableClass cls = this.getClsForAttr(name);
        if (cls == null) {
            throw new DebugException("Classifier-level attribute '" + name + "' not found.");
        }
        return cls.clAttrValues.get(name);
    }

    public void setAttribute(String name, Object value) throws StorageException {
        StorableClass cls = this.getClsForAttr(name);
        if (cls == null) {
            throw new DebugException("Classifier-level attribute '" + name + "' not found.");
        }
        cls.objectWillChange();
        AttributeDescriptor attribute = (AttributeDescriptor)cls.clAttrDescs.get(name);
        Object oldValue = cls.clAttrValues.put(name, value);
        if (!attribute.isMultivalued() && value instanceof RefObject) {
            StorableObject storableObj = (StorableObject)((BaseObjectHandler)value)._getDelegate();
            storableObj.setComposite(this.getMofId(), storableObj.getMofId(), attribute.getMofId());
            if (oldValue != null) {
                storableObj = (StorableObject)((BaseObjectHandler)oldValue)._getDelegate();
                storableObj.clearComposite();
            }
        }
        cls.objectChanged();
    }

    private StorableClass getClsForAttr(String name) throws StorageException {
        if (this.clAttrDescs.get(name) == null) {
            StorableClass result = null;
            Iterator it = this.superclasses.iterator();
            while (it.hasNext() && result == null) {
                result = ((StorableClass)this.getMdrStorage().getObject((MOFID)it.next())).getClsForAttr(name);
            }
            return result;
        }
        return this;
    }

    public StorableClass getClassProxy() throws StorageException {
        return this;
    }

    public final int getAttrIndex(String attributeName) throws StorageException {
        this.checkAttributes();
        int result = this.attributes.indexOf(attributeName);
        if (result < 0) {
            Logger.getDefault().log("attribute not found: " + attributeName);
            Logger.getDefault().log("collected attributes of " + this.getMofId() + ':');
            Iterator it = this.attributes.iterator();
            while (it.hasNext()) {
                Logger.getDefault().log("\t" + it.next());
            }
            Logger.getDefault().log("registered superclasses:");
            it = this.superclasses.iterator();
            while (it.hasNext()) {
                Logger.getDefault().log("\t" + it.next());
            }
            Logger.getDefault().log("registered subclasses:");
            it = this.subclasses.iterator();
            while (it.hasNext()) {
                Logger.getDefault().log("\t" + it.next());
            }
            throw new DebugException();
        }
        return result;
    }

    public final int getAttrCount() throws StorageException {
        this.checkAttributes();
        return this.attributeDescs.length;
    }

    public final AttributeDescriptor getAttrDesc(int attrIndex) throws StorageException {
        this.checkAttributes();
        return this.attributeDescs[attrIndex];
    }

    public final AttributeDescriptor getAttrDesc(String attrName) throws StorageException {
        try {
            int index = this.getAttrIndex(attrName);
            return this.getAttrDesc(index);
        }
        catch (DebugException e) {
            StorableClass cls = this.getClsForAttr(attrName);
            if (cls == null) {
                throw new DebugException("Attribute '" + attrName + "' not found.");
            }
            return (AttributeDescriptor)cls.clAttrDescs.get(attrName);
        }
    }

    public ReferenceDescriptor getReferenceDescriptor(String referenceName) throws StorageException {
        ReferenceDescriptor result = (ReferenceDescriptor)this.refCache.get(referenceName);
        if (result == null) {
            result = (ReferenceDescriptor)this.references.get(referenceName);
            if (result == null) {
                for (int i = 0; i < this.superclasses.size() && (result = ((StorableClass)this.getMdrStorage().getObject((MOFID)this.superclasses.get(i))).getReferenceDescriptor(referenceName)) == null; ++i) {
                }
            }
            if (result != null) {
                this.refCache.put(referenceName, result);
            }
        }
        return result;
    }

    public Collection getAllReferenceDescriptors() throws StorageException {
        return this.collectReferences(AbstractCollectionFactory.getCollectionFactory().createArrayList(), AbstractCollectionFactory.getCollectionFactory().createHashSet());
    }

    private Collection collectReferences(Collection descs, Set visited) throws StorageException {
        descs.addAll(this.references.values());
        visited.add(this.getMofId());
        Iterator it = this.superclasses.iterator();
        while (it.hasNext()) {
            MOFID mofId = (MOFID)it.next();
            if (visited.contains(mofId)) continue;
            ((StorableClass)this.getMdrStorage().getObject(mofId)).collectReferences(descs, visited);
        }
        return descs;
    }

    private synchronized void checkAttributes() throws StorageException {
        if (this.attributes == null) {
            this.attributes = AbstractCollectionFactory.getCollectionFactory().createArrayList();
            List attribDescs = AbstractCollectionFactory.getCollectionFactory().createArrayList();
            this.indexDescriptors = AbstractCollectionFactory.getCollectionFactory().createArrayList();
            this.collectAttributes(this.attributes, attribDescs, this.indexDescriptors, AbstractCollectionFactory.getCollectionFactory().createHashSet());
            this.attributeDescs = attribDescs.toArray(new AttributeDescriptor[attribDescs.size()]);
            this.buildIndexMap();
        }
    }

    void collectAssociationEnds(Collection result, Set visited) throws StorageException {
        Iterator it = this.superclasses.iterator();
        while (it.hasNext()) {
            MOFID mofId = (MOFID)it.next();
            if (visited.contains(mofId)) continue;
            ((StorableClass)this.getMdrStorage().getObject(mofId)).collectAssociationEnds(result, visited);
        }
        result.addAll(this.associationEnds);
        visited.add(this.getMofId());
    }

    private void collectAttributes(List attrs, List descs, List indexes, Set visited) throws StorageException {
        int i;
        Iterator it = this.superclasses.iterator();
        while (it.hasNext()) {
            MOFID mofId = (MOFID)it.next();
            if (visited.contains(mofId)) continue;
            ((StorableClass)this.getMdrStorage().getObject(mofId)).collectAttributes(attrs, descs, indexes, visited);
        }
        for (i = 0; i < this.attrDescs.length; ++i) {
            attrs.add(this.attrDescs[i].getName());
            descs.add(this.attrDescs[i]);
        }
        if (this.indexDescs != null) {
            for (i = 0; i < this.indexDescs.length; ++i) {
                indexes.add(this.indexDescs[i]);
            }
        }
        visited.add(this.getMofId());
    }

    public Class getClassSuperclass() throws StorageException, ClassNotFoundException {
        return StorableClass.resolveClass(this.classSuperclass);
    }

    public Class getClassCustomImpl() {
        try {
            return this.getClassSuperclass();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public Class getInstanceSuperclass() throws StorageException, ClassNotFoundException {
        return StorableClass.resolveClass(this.instanceSuperclass);
    }

    public Class getInstanceCustomImpl() {
        try {
            Class sup = this.getInstanceSuperclass();
            return sup == InstanceHandler.class ? null : sup;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public boolean isAbstract() {
        return this.abstractClass;
    }

    public boolean isSingleton() {
        return this.singletonClass;
    }

    public boolean isTransient() {
        return false;
    }

    public Class initClassSuperclass(Class[] iface) throws StorageException, ClassNotFoundException {
        Class result = null;
        if (this.classSuperclass == null) {
            try {
                result = StorableClass.resolveClass(this, 2);
            }
            catch (ClassNotFoundException e) {
                result = ClassProxyHandler.class;
            }
            this.objectWillChange();
            this.classSuperclass = result.getName();
            this.objectChanged();
        }
        return result;
    }

    private static Class resolveClass(StorableClass cls, int type) throws ClassNotFoundException, StorageException {
        return StorableClass.resolveClass(TagSupport.getImplFullName(cls.getMetaObject(), type));
    }

    private static Class resolveClass(String className) throws ClassNotFoundException {
        return BaseObjectHandler.resolveImplementation(className);
    }

    private static Class resolveInterface(StorableClass cls, int type) throws ClassNotFoundException, StorageException {
        return BaseObjectHandler.resolveInterface(TagSupport.getTypeFullName(cls.getMetaObject(), type));
    }

    public Class initInstanceSuperclass(Class[] iface) throws StorageException, ClassNotFoundException {
        Class result;
        block5: {
            result = null;
            try {
                result = StorableClass.resolveClass(this, 1);
                iface[0] = StorableClass.resolveInterface(this, 1);
            }
            catch (ClassNotFoundException e) {
                Class[] currentIface = new Class[1];
                Iterator it = this.superclasses.iterator();
                while (it.hasNext()) {
                    Class current = ((StorableClass)this.getMdrStorage().getObject((MOFID)it.next())).initInstanceSuperclass(currentIface);
                    if (result == null || iface[0] == null || iface[0].isAssignableFrom(currentIface[0])) {
                        result = current;
                        iface[0] = currentIface[0];
                        continue;
                    }
                    if (currentIface[0].isAssignableFrom(iface[0])) continue;
                    throw e;
                }
                if (result != null) break block5;
                result = InstanceHandler.class;
                Class clazz = iface[0] = RefObject.class;
            }
        }
        if (this.instanceSuperclass == null) {
            this.objectWillChange();
            this.instanceSuperclass = result.getName();
            this.objectChanged();
        }
        return result;
    }

    protected void deleteRecursive() throws StorageException {
        MOFID thisMofId = this.getMofId();
        MdrStorage storage = this.getMdrStorage();
        MultivaluedIndex instancesIndex = storage.getInstancesIndex(thisMofId);
        Collection instances = instancesIndex.getItems(thisMofId);
        if (instances != null) {
            Iterator it = instances.iterator();
            while (it.hasNext()) {
                MOFID instanceMofId = (MOFID)it.next();
                storage.removeObject(instanceMofId);
                it.remove();
            }
        }
        super.deleteRecursive();
    }

    public List getIndexDescriptors() throws StorageException {
        this.checkAttributes();
        return this.indexDescriptors;
    }

    public void write(OutputStream outputStream) {
        super.write(outputStream);
        try {
            IOUtils.write(outputStream, this.meta, this);
            IOUtils.write(outputStream, this.immediatePackage, this);
            if (this.attrDescs == null) {
                IOUtils.writeInt(outputStream, 0);
            } else {
                IOUtils.writeInt(outputStream, this.attrDescs.length + 1);
                for (int i = 0; i < this.attrDescs.length; ++i) {
                    this.attrDescs[i].write(outputStream);
                }
            }
            IOUtils.writeInt(outputStream, this.datatypes.size());
            Iterator<Object> it = this.datatypes.keySet().iterator();
            while (it.hasNext()) {
                String name = (String)it.next();
                IOUtils.writeString(outputStream, name);
                ((DatatypeDescriptor)this.datatypes.get(name)).write(outputStream);
            }
            IOUtils.write(outputStream, this.subclasses, this);
            IOUtils.write(outputStream, this.superclasses, this);
            IOUtils.write(outputStream, this.references, this);
            IOUtils.writeInt(outputStream, this.associationEnds.size());
            it = this.associationEnds.iterator();
            while (it.hasNext()) {
                AssocEndDescriptor item = (AssocEndDescriptor)it.next();
                IOUtils.writeMOFID(outputStream, item.mofId, this.getMdrStorage(), this.getMofId());
                IOUtils.writeString(outputStream, item.endName);
                IOUtils.writeBoolean(outputStream, item.isAggregate);
            }
            IOUtils.writeBoolean(outputStream, this.classDerived);
            IOUtils.writeBoolean(outputStream, this.instanceDerived);
            IOUtils.writeBoolean(outputStream, this.singletonClass);
            IOUtils.writeBoolean(outputStream, this.abstractClass);
            IOUtils.writeString(outputStream, this.classSuperclass);
            IOUtils.writeString(outputStream, this.instanceSuperclass);
            if (this.indexDescs == null) {
                IOUtils.writeInt(outputStream, 0);
            } else {
                IOUtils.writeInt(outputStream, this.indexDescs.length);
                for (int i = 0; i < this.indexDescs.length; ++i) {
                    this.indexDescs[i].write(outputStream, this);
                }
            }
            IOUtils.writeInt(outputStream, this.clAttrDescs.size());
            Iterator it2 = this.clAttrDescs.values().iterator();
            while (it2.hasNext()) {
                AttributeDescriptor desc = (AttributeDescriptor)it2.next();
                desc.write(outputStream);
                IOUtils.write(outputStream, this.clAttrValues.get(desc.getName()), this);
            }
        }
        catch (IOException e) {
            Logger.getDefault().notify(1, (Throwable)e);
        }
    }

    public void read(InputStream inputStream) {
        super.read(inputStream);
        try {
            int i;
            this.meta = (MOFID)IOUtils.read(inputStream, this);
            this.immediatePackage = (MOFID)IOUtils.read(inputStream, this);
            int objCount = IOUtils.readInt(inputStream);
            if (objCount != 0) {
                int arrayLength = objCount - 1;
                this.attrDescs = new AttributeDescriptor[arrayLength];
                for (int i2 = 0; i2 < arrayLength; ++i2) {
                    this.attrDescs[i2] = AttributeDescriptor.readResolve(inputStream, this);
                }
            }
            objCount = IOUtils.readInt(inputStream);
            this.datatypes = AbstractCollectionFactory.getCollectionFactory().createHashMap(objCount, 1.0f);
            for (i = 0; i < objCount; ++i) {
                String name = IOUtils.readString(inputStream);
                this.datatypes.put(name, DatatypeDescriptor.readResolve(inputStream, this));
            }
            this.subclasses = (List)IOUtils.read(inputStream, this);
            this.superclasses = (List)IOUtils.read(inputStream, this);
            this.references = (Map)IOUtils.read(inputStream, this);
            objCount = IOUtils.readInt(inputStream);
            this.associationEnds = AbstractCollectionFactory.getCollectionFactory().createArrayList(objCount);
            for (i = 0; i < objCount; ++i) {
                this.associationEnds.add(new AssocEndDescriptor(IOUtils.readMOFID(inputStream, this.getMdrStorage(), this.getMofId()), IOUtils.readString(inputStream), IOUtils.readBoolean(inputStream)));
            }
            this.classDerived = IOUtils.readBoolean(inputStream);
            this.instanceDerived = IOUtils.readBoolean(inputStream);
            this.singletonClass = IOUtils.readBoolean(inputStream);
            this.abstractClass = IOUtils.readBoolean(inputStream);
            this.classSuperclass = IOUtils.readString(inputStream);
            this.instanceSuperclass = IOUtils.readString(inputStream);
            objCount = IOUtils.readInt(inputStream);
            if (objCount != 0) {
                this.indexDescs = new IndexDescriptor[objCount];
                for (i = 0; i < objCount; ++i) {
                    this.indexDescs[i] = IndexDescriptor.readResolve(inputStream, this);
                }
            }
            objCount = IOUtils.readInt(inputStream);
            for (i = 0; i < objCount; ++i) {
                AttributeDescriptor desc = AttributeDescriptor.readResolve(inputStream, this);
                this.clAttrDescs.put(desc.getName(), desc);
                this.clAttrValues.put(desc.getName(), IOUtils.read(inputStream, this, desc.getType().getName()));
            }
        }
        catch (IOException e) {
            throw (DebugException)Logger.getDefault().annotate((Throwable)new DebugException(e), (Throwable)e);
        }
    }

    public static final class IndexDescriptor {
        private static final int ATTRIB_ID = 0;
        private static final int ASSOC_END_ID = 1;
        private final String indexName;
        private final Field[] fields;

        public IndexDescriptor(String name, Field[] fields) {
            this.indexName = name;
            this.fields = fields;
        }

        public String getName() {
            return this.indexName;
        }

        public Field[] getFields() {
            return this.fields;
        }

        void write(OutputStream stream, StorableBaseObject storable) throws IOException {
            IOUtils.writeString(stream, this.indexName);
            IOUtils.writeInt(stream, this.fields.length);
            for (int i = 0; i < this.fields.length; ++i) {
                if (this.fields[i] instanceof Attrib) {
                    IOUtils.writeInt(stream, 0);
                } else {
                    IOUtils.writeInt(stream, 1);
                }
                this.fields[i].write(stream, storable);
            }
        }

        static IndexDescriptor readResolve(InputStream stream, StorableBaseObject storable) throws IOException {
            String indexName = IOUtils.readString(stream);
            int fieldsCount = IOUtils.readInt(stream);
            Field[] fields = new Field[fieldsCount];
            for (int i = 0; i < fieldsCount; ++i) {
                int id = IOUtils.readInt(stream);
                switch (id) {
                    case 0: {
                        fields[i] = new Attrib(null, null, false);
                        break;
                    }
                    case 1: {
                        fields[i] = new AssocEnd(null, null, false, null);
                    }
                }
                fields[i].read(stream, storable);
            }
            return new IndexDescriptor(indexName, fields);
        }

        public static final class AssocEnd
        extends Field {
            private MOFID assocId;

            public AssocEnd(MOFID id, String name, boolean ordered, MOFID assocId) {
                super(id, name, ordered);
                this.assocId = assocId;
            }

            public MOFID getAssociation() {
                return this.assocId;
            }

            public void write(OutputStream stream, StorableBaseObject storable) throws IOException {
                super.write(stream, storable);
                IOUtils.write(stream, this.assocId, storable);
            }

            public void read(InputStream stream, StorableBaseObject storable) throws IOException {
                super.read(stream, storable);
                this.assocId = (MOFID)IOUtils.read(stream, storable);
            }
        }

        public static final class Attrib
        extends Field {
            public Attrib(MOFID id, String name, boolean ordered) {
                super(id, name, ordered);
            }
        }

        public static abstract class Field {
            protected MOFID id;
            protected String name;
            protected boolean isOrdered;

            public Field(MOFID id, String name, boolean ordered) {
                this.id = id;
                this.name = name;
                this.isOrdered = ordered;
            }

            public MOFID getId() {
                return this.id;
            }

            public String getName() {
                return this.name;
            }

            public boolean isOrdered() {
                return this.isOrdered;
            }

            public void write(OutputStream stream, StorableBaseObject storable) throws IOException {
                IOUtils.writeMOFID(stream, this.id, storable.getMdrStorage(), storable.getMofId());
                IOUtils.writeString(stream, this.name);
                IOUtils.writeBoolean(stream, this.isOrdered);
            }

            public void read(InputStream stream, StorableBaseObject storable) throws IOException {
                this.id = IOUtils.readMOFID(stream, storable.getMdrStorage(), storable.getMofId());
                this.name = IOUtils.readString(stream);
                this.isOrdered = IOUtils.readBoolean(stream);
            }
        }
    }

    static final class AssocEndDescriptor {
        final MOFID mofId;
        final String endName;
        final boolean isAggregate;

        AssocEndDescriptor(MOFID mofId, String endName, boolean aggregate) {
            this.mofId = mofId;
            this.endName = endName;
            this.isAggregate = aggregate;
        }
    }

    public static final class AttributeDescriptor {
        private final int typeIndex;
        private final int maxSize;
        private final int minSize;
        private final boolean unique;
        private final boolean ordered;
        private final boolean changeable;
        private MOFID mofId;
        private final String name;
        private final transient MdrStorage mdrStorage;
        private transient boolean indexed = false;
        private transient Class type = null;
        private transient String storageId = null;

        public AttributeDescriptor(MdrStorage storage, MOFID mofId, String name, Class type, int minSize, int maxSize, boolean isUnique, boolean isOrdered, boolean isChangeable, String storageId) {
            this(storage, mofId, name, storage.storageValues(storageId).store(type.getName()), minSize, maxSize, isUnique, isOrdered, isChangeable, storageId);
            this.type = type;
        }

        public AttributeDescriptor(MdrStorage storage, MOFID mofId, String name, int typeIndex, int minSize, int maxSize, boolean isUnique, boolean isOrdered, boolean isChangeable, String storageId) {
            this.mdrStorage = storage;
            this.typeIndex = typeIndex;
            this.minSize = minSize;
            this.maxSize = maxSize;
            this.unique = isUnique;
            this.ordered = isOrdered;
            this.changeable = isChangeable;
            this.mofId = mofId;
            this.name = name;
            this.storageId = storageId;
        }

        void replaceValues(Map table) {
            if (this.mofId != null) {
                this.mofId = (MOFID)table.get(this.mofId);
            }
        }

        public Class getType() {
            if (this.type == null) {
                try {
                    this.type = BaseObjectHandler.resolveInterface((String)this.mdrStorage.storageValues(this.storageId).resolve(this.typeIndex));
                }
                catch (ClassNotFoundException e) {
                    throw new DebugException(e);
                }
            }
            return this.type;
        }

        public int getTypeIndex() {
            return this.typeIndex;
        }

        public int getMinSize() {
            return this.minSize;
        }

        public int getMaxSize() {
            return this.maxSize;
        }

        public boolean isMultivalued() {
            return this.maxSize > 1 || this.maxSize == -1;
        }

        public boolean isUnique() {
            return this.unique;
        }

        public boolean isOrdered() {
            return this.ordered;
        }

        public boolean isChangeable() {
            return this.changeable;
        }

        public MOFID getMofId() {
            return this.mofId;
        }

        public String getName() {
            return this.name;
        }

        public void setIndexed(boolean indexed) {
            this.indexed = indexed;
        }

        public boolean isIndexed() {
            return this.indexed;
        }

        static AttributeDescriptor readResolve(InputStream stream, StorableClass storable) throws IOException {
            return new AttributeDescriptor(storable.getMdrStorage(), IOUtils.readMOFID(stream, storable.getMdrStorage(), storable.getMofId()), IOUtils.readString(stream), IOUtils.readInt(stream), IOUtils.readInt(stream), IOUtils.readInt(stream), IOUtils.readBoolean(stream), IOUtils.readBoolean(stream), IOUtils.readBoolean(stream), MdrStorage.getStorageIdFromMofId(storable.getMofId()));
        }

        void write(OutputStream outputStream) throws IOException {
            IOUtils.writeMOFID(outputStream, this.mofId, this.mdrStorage.getStorageById(this.storageId));
            IOUtils.writeString(outputStream, this.name);
            IOUtils.writeInt(outputStream, this.typeIndex);
            IOUtils.writeInt(outputStream, this.minSize);
            IOUtils.writeInt(outputStream, this.maxSize);
            IOUtils.writeBoolean(outputStream, this.unique);
            IOUtils.writeBoolean(outputStream, this.ordered);
            IOUtils.writeBoolean(outputStream, this.changeable);
        }
    }

    public final class ReferenceDescriptor {
        private MOFID mofId;
        private final MOFID proxyId;
        private final String endName;
        private StorableAssociation proxy = null;

        void replaceValues(Map table) {
            if (this.mofId != null) {
                this.mofId = (MOFID)table.get(this.mofId);
            }
        }

        public ReferenceDescriptor(MOFID mofId, MOFID proxyId, String endName) {
            this.mofId = mofId;
            this.proxyId = proxyId;
            this.endName = endName;
        }

        public MOFID getMofId() {
            return this.mofId;
        }

        public MOFID getAssociationId() {
            return this.proxyId;
        }

        public String getEndName() {
            return this.endName;
        }

        public synchronized StorableAssociation getAssociation() {
            if (this.proxy == null) {
                try {
                    this.proxy = (StorableAssociation)StorableClass.this.getMdrStorage().getObject(this.proxyId);
                }
                catch (StorageException e) {
                    throw (DebugException)Logger.getDefault().annotate((Throwable)new DebugException(e), (Throwable)e);
                }
            }
            return this.proxy;
        }

        public boolean isFirstEnd() {
            return this.getAssociation().getEnd2Name().equals(this.endName);
        }
    }
}

