/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.mdr.storagemodel;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.netbeans.mdr.persistence.MOFID;
import org.netbeans.mdr.persistence.StorageException;
import org.netbeans.mdr.storagemodel.MdrStorage;
import org.netbeans.mdr.storagemodel.StorableObject;
import org.netbeans.mdr.storagemodel.Transient;
import org.netbeans.mdr.util.AbstractCollectionFactory;
import org.netbeans.mdr.util.DebugException;
import org.netbeans.mdr.util.Logger;

public class TransientStorableObject
extends StorableObject
implements Transient {
    private List referentQueue;
    private Map attrTxLog = AbstractCollectionFactory.getCollectionFactory().createHashMap();

    public TransientStorableObject() {
    }

    public TransientStorableObject(MdrStorage mdrStorage, MOFID immediatePackage, MOFID meta, MOFID classProxy) throws StorageException {
        this(mdrStorage, immediatePackage, meta, classProxy, null);
    }

    public TransientStorableObject(MdrStorage mdrStorage, MOFID immediatePackage, MOFID meta, MOFID classProxy, Object[] params) throws StorageException {
        super(mdrStorage, immediatePackage, meta, classProxy, params, "GC");
    }

    public void delete() throws StorageException {
        this.deleteRecursive();
    }

    public void write(OutputStream outputStream) {
        throw new DebugException("Trying to write tranient object");
    }

    public void read(InputStream inputStream) {
        throw new DebugException("Trying to read transient object");
    }

    public void addReferent(TransientStorableObject referent) {
        if (this.referentQueue == null) {
            this.referentQueue = AbstractCollectionFactory.getCollectionFactory().createArrayList();
        }
        this.referentQueue.add(referent);
    }

    public void removeReferent(TransientStorableObject referent) {
        if (this.referentQueue == null) {
            return;
        }
        this.referentQueue.remove(referent);
    }

    public void setAttribute(int index, Object value) throws StorageException {
        this.check();
        Object oldValue = this.values[index];
        super.setAttribute(index, value);
        Integer key = new Integer(index);
        if (!this.attrTxLog.containsKey(key)) {
            this.attrTxLog.put(key, oldValue);
        }
    }

    public void commit() {
        this.attrTxLog.clear();
    }

    public void rollBack() {
        Iterator it = this.attrTxLog.keySet().iterator();
        while (it.hasNext()) {
            Integer key = (Integer)it.next();
            Object value = this.attrTxLog.get(key);
            it.remove();
            try {
                super.setAttribute(key, value);
            }
            catch (StorageException se) {
                Logger.getDefault().notify(1, (Throwable)se);
            }
        }
    }

    protected void deleteRecursive() throws StorageException {
        this.getMdrStorage().removeInstance(this);
    }

    protected void modifyIndex(int attrIdx, Object oldValue, Object newValue) throws StorageException {
    }

    void addToIndex(String proxyId, String endId) throws StorageException {
    }

    void removeFromIndex(String proxyId, String endId) throws StorageException {
    }
}

