/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.mdr.storagemodel.transientimpl;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.netbeans.mdr.persistence.MOFID;
import org.netbeans.mdr.persistence.Storage;
import org.netbeans.mdr.persistence.StorageBadRequestException;
import org.netbeans.mdr.persistence.StorageException;
import org.netbeans.mdr.storagemodel.MdrStorage;
import org.netbeans.mdr.storagemodel.TransientStorableObject;
import org.netbeans.mdr.storagemodel.transientimpl.CompensatingTransaction;
import org.netbeans.mdr.storagemodel.transientimpl.TransactionalIndex;
import org.netbeans.mdr.util.DebugException;

public abstract class TransientIndex
extends TransactionalIndex {
    private String name;
    private Storage.EntryType keyType;
    private Storage.EntryType valueType;
    protected MdrStorage storage;
    protected Map map;
    protected ReferenceQueue refQueue = new ReferenceQueue();

    public TransientIndex(MdrStorage storage, String name, Storage.EntryType keyType, Storage.EntryType valueType) {
        this.storage = storage;
        this.name = name;
        this.keyType = keyType;
        this.valueType = valueType;
    }

    public abstract void add(Object var1, Object var2) throws StorageException;

    public Storage.EntryType getKeyType() throws StorageException {
        return this.keyType;
    }

    public String getName() throws StorageException {
        return this.name;
    }

    public Storage.EntryType getValueType() throws StorageException {
        return this.valueType;
    }

    public boolean remove(Object key) throws StorageException {
        this.expungeStaleEntries();
        Object value = this.map.remove(key);
        this.handleRemove(key, value);
        return value != null;
    }

    public abstract Set keySet() throws StorageException;

    protected abstract void expungeStaleEntries();

    protected abstract void handleRemove(Object var1, Object var2) throws StorageException;

    protected void handleAdd(Object key, Object value) {
        this.txlog.push(new CompensatingTransaction.AddCTx(key, value));
    }

    protected abstract class EntryKeySet
    implements Set {
        protected EntryKeySet() {
        }

        public boolean add(Object o) {
            throw new UnsupportedOperationException();
        }

        public boolean addAll(Collection c) {
            throw new UnsupportedOperationException();
        }

        public void clear() {
            Iterator it = TransientIndex.this.map.keySet().iterator();
            while (it.hasNext()) {
                Object keyMofId = it.next();
                Object values = TransientIndex.this.map.get(keyMofId);
                it.remove();
                try {
                    TransientIndex.this.handleRemove(keyMofId, values);
                }
                catch (StorageException se) {
                    throw new DebugException(se.toString());
                }
            }
        }

        public boolean contains(Object o) {
            TransientIndex.this.expungeStaleEntries();
            Entry e = (Entry)TransientIndex.this.map.get(o);
            return e != null && e.isValid();
        }

        public boolean containsAll(Collection c) {
            boolean result = true;
            Iterator it = c.iterator();
            while (it.hasNext()) {
                result &= this.contains(it.next());
            }
            return result;
        }

        public boolean isEmpty() {
            TransientIndex.this.expungeStaleEntries();
            return TransientIndex.this.map.size() == 0;
        }

        public boolean remove(Object o) {
            try {
                Object values = TransientIndex.this.map.get(o);
                TransientIndex.this.remove(o);
                TransientIndex.this.handleRemove(o, values);
                return values != null;
            }
            catch (StorageException se) {
                return false;
            }
        }

        public boolean removeAll(Collection c) {
            boolean result = false;
            Iterator it = c.iterator();
            while (it.hasNext()) {
                result |= this.remove(it.next());
            }
            return result;
        }

        public boolean retainAll(Collection c) {
            TransientIndex.this.expungeStaleEntries();
            boolean result = false;
            Iterator it = TransientIndex.this.map.keySet().iterator();
            while (it.hasNext()) {
                Object key = it.next();
                if (c.contains(key)) continue;
                Object values = TransientIndex.this.map.get(key);
                it.remove();
                try {
                    TransientIndex.this.handleRemove(key, values);
                }
                catch (StorageException se) {
                    throw new DebugException(se.toString());
                }
                result = true;
            }
            return result;
        }

        public int size() {
            TransientIndex.this.expungeStaleEntries();
            return TransientIndex.this.map.size();
        }

        public Object[] toArray() {
            return this.collectKeys().toArray();
        }

        public Object[] toArray(Object[] a) {
            return this.collectKeys().toArray(a);
        }

        public abstract Iterator iterator();

        protected abstract List collectKeys();
    }

    protected class Entry {
        private Object key;
        private Object value;

        public Entry(Object firstEnd, Object secondEnd) throws StorageException {
            TransientStorableObject firstEndObj = null;
            if (MdrStorage.isTransientMofId((MOFID)firstEnd)) {
                firstEndObj = (TransientStorableObject)TransientIndex.this.storage.getObject((MOFID)firstEnd);
                if (firstEndObj == null) {
                    throw new StorageBadRequestException();
                }
                this.key = new KeyedReference(firstEndObj, TransientIndex.this.refQueue, (MOFID)firstEnd);
            } else {
                this.key = firstEnd;
            }
            if (MdrStorage.isTransientMofId((MOFID)secondEnd)) {
                TransientStorableObject secondEndObj = (TransientStorableObject)TransientIndex.this.storage.getObject((MOFID)secondEnd);
                if (secondEndObj == null) {
                    throw new StorageBadRequestException();
                }
                this.value = new KeyedReference(secondEndObj, TransientIndex.this.refQueue, (MOFID)firstEnd);
                if (firstEndObj != null) {
                    firstEndObj.addReferent(secondEndObj);
                }
            } else {
                this.value = secondEnd;
            }
        }

        public void dispose() {
            if (this.key instanceof Reference && this.value instanceof Reference) {
                TransientStorableObject ktso = (TransientStorableObject)((Reference)this.key).get();
                TransientStorableObject vtso = (TransientStorableObject)((Reference)this.value).get();
                if (ktso != null) {
                    ktso.removeReferent(vtso);
                }
            }
        }

        public boolean isValid() {
            if (this.key instanceof Reference && ((Reference)this.key).get() == null) {
                return false;
            }
            if (this.value instanceof Reference) {
                return ((Reference)this.value).get() != null;
            }
            return true;
        }

        public MOFID getValue() {
            if (this.value instanceof Reference) {
                TransientStorableObject result = (TransientStorableObject)((Reference)this.value).get();
                if (result != null) {
                    return result.getMofId();
                }
                return null;
            }
            return (MOFID)this.value;
        }

        public MOFID getKey() {
            if (this.key instanceof Reference) {
                TransientStorableObject tso = (TransientStorableObject)((Reference)this.key).get();
                if (tso == null) {
                    return null;
                }
                return tso.getMofId();
            }
            return (MOFID)this.key;
        }

        public int hashCode() {
            return this.getKey().hashCode();
        }

        public boolean equals(Object other) {
            if (!(other instanceof Entry)) {
                return false;
            }
            Entry e = (Entry)other;
            return this.getValue().equals(e.getValue()) && this.getKey().equals(e.getKey());
        }
    }

    protected static class KeyedReference
    extends WeakReference {
        private MOFID key;

        public KeyedReference(Object referent, ReferenceQueue queue, MOFID key) {
            super(referent, queue);
            this.key = key;
        }

        public MOFID getLookupKey() {
            return this.key;
        }
    }
}

