/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.mdr.util;

import org.netbeans.mdr.util.CollectionFactory;
import org.netbeans.mdr.util.CollectionFactoryJavaOriginal;
import org.netbeans.mdr.util.Logger;

public abstract class AbstractCollectionFactory {
    private static CollectionFactory _collectionFactoryInstance;

    private AbstractCollectionFactory() {
    }

    public static CollectionFactory getCollectionFactory() {
        if (_collectionFactoryInstance == null) {
            _collectionFactoryInstance = AbstractCollectionFactory.createCollectionFactory();
        }
        return _collectionFactoryInstance;
    }

    private static CollectionFactory createCollectionFactory() {
        CollectionFactory collectionFactory = null;
        try {
            String collectionFactoryClassName = System.getProperty("collection.factoryclass.name");
            Class<?> collectionFactoryClass = collectionFactoryClassName != null ? Class.forName(collectionFactoryClassName) : Class.forName(CollectionFactoryJavaOriginal.class.getName());
            collectionFactory = (CollectionFactory)collectionFactoryClass.newInstance();
            System.out.println("Logger Class : " + collectionFactory.getClass());
        }
        catch (ClassNotFoundException e) {
            System.out.println("Collection Factory creation failed reason: " + e.getMessage());
            Logger.getDefault().log(e.getMessage());
            try {
                Class<?> collectionFactoryClass = Class.forName(CollectionFactoryJavaOriginal.class.getName());
                collectionFactory = (CollectionFactory)collectionFactoryClass.newInstance();
                System.out.println("Default Logger Class : " + collectionFactory.getClass());
            }
            catch (Exception ex) {
                Logger.getDefault().log(ex.getMessage());
            }
        }
        catch (IllegalAccessException e) {
            System.out.println("Collection Factory creation failed reason: " + e.getMessage());
            Logger.getDefault().log(e.getMessage());
        }
        catch (InstantiationException e) {
            System.out.println("Collection Factory creation failed reason: " + e.getMessage());
            Logger.getDefault().log(e.getMessage());
        }
        return collectionFactory;
    }
}

