/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.mdr.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.List;
import org.netbeans.mdr.util.Logger;

public class XmlUtils {
    static byte[] buf = new byte[4096];

    public static String readTagStart(InputStream is) throws IOException {
        int c;
        while (is.read() != 60) {
        }
        int i = 0;
        while ((c = is.read()) != 62) {
            XmlUtils.buf[i++] = (byte)c;
        }
        String result = new String(buf, 0, i);
        return result;
    }

    public static String readValue(InputStream is) throws IOException {
        int c;
        int i = 0;
        while ((c = is.read()) != 60) {
            XmlUtils.buf[i++] = (byte)c;
        }
        return XmlUtils.decode(new String(buf, 0, i));
    }

    public static String readComplexValue(InputStream is) throws IOException {
        String start = XmlUtils.readTagStart(is);
        int i = 0;
        int left = 0;
        while (true) {
            int c;
            if ((c = is.read()) != 62) {
                if (c == 60) {
                    left = i;
                }
                XmlUtils.buf[i++] = (byte)c;
                continue;
            }
            try {
                if (start.equals(new String(buf, left + 2, i - left - 2))) {
                    break;
                }
            }
            catch (StringIndexOutOfBoundsException e) {
                Logger.getDefault().annotate((Throwable)e, Integer.toString(left + 2));
                Logger.getDefault().annotate((Throwable)e, Integer.toString(i - left - 2));
                Logger.getDefault().annotate((Throwable)e, new String(buf, 0, i));
                throw e;
            }
            XmlUtils.buf[i++] = 62;
        }
        String value = new String(buf, 0, left).intern();
        return value;
    }

    public static void skipTagEnd(InputStream is) throws IOException {
        while (is.read() != 62) {
        }
    }

    public static String readTextTag(InputStream is) throws IOException {
        XmlUtils.readTagStart(is);
        String value = XmlUtils.readValue(is);
        XmlUtils.skipTagEnd(is);
        return value;
    }

    public static String encode(String str) {
        int strLength = str.length();
        StringBuffer sb = new StringBuffer(str.length());
        for (int i = 0; i < str.length(); ++i) {
            String c = str.substring(i, i + 1);
            if (c.equals("&")) {
                sb.append("&amp;");
                continue;
            }
            if (c.equals("<")) {
                sb.append("&lt;");
                continue;
            }
            if (c.equals(">")) {
                sb.append("&gt;");
                continue;
            }
            if (c.equals("\"")) {
                sb.append("&quot;");
                continue;
            }
            if (c.equals("'")) {
                sb.append("&apos;");
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static String decode(String str) {
        StringBuffer sb = new StringBuffer(str.length());
        int i = 0;
        int j = -1;
        while ((i = str.indexOf("&", j)) >= 0) {
            sb.append(str.substring(j + 1, i));
            j = str.indexOf(";", i + 1);
            if (j > i + 1) {
                String c = str.substring(i + 1, j);
                if (c.equals("amp")) {
                    sb.append("&");
                    continue;
                }
                if (c.equals("lt")) {
                    sb.append("<");
                    continue;
                }
                if (c.equals("gt")) {
                    sb.append(">");
                    continue;
                }
                if (c.equals("quot")) {
                    sb.append("\"");
                    continue;
                }
                if (c.equals("apos")) {
                    sb.append("'");
                    continue;
                }
                Logger.getDefault().log(16, "Error! Cannot substitute character: " + c);
                return "";
            }
            Logger.getDefault().log(16, "Error! End of substitution not found.");
            return "";
        }
        sb.append(str.substring(j + 1));
        return sb.toString();
    }

    public static String encodeString(String text) {
        return "<textValue>" + XmlUtils.encode(text) + "</textValue>";
    }

    public static String decodeString(InputStream inputStream) throws IOException {
        return XmlUtils.readTextTag(inputStream);
    }

    public static String encodeList(List list) {
        StringBuffer buf = new StringBuffer(100);
        buf.append("<list>");
        Iterator it = list.iterator();
        while (it.hasNext()) {
            buf.append(XmlUtils.encodeString((String)it.next()));
        }
        buf.append("</list>");
        return buf.toString();
    }

    public static void decodeList(InputStream inputStream, List list) throws IOException {
        String str;
        XmlUtils.readTagStart(inputStream);
        while (!(str = XmlUtils.readTagStart(inputStream)).equals("/list")) {
            list.add(XmlUtils.readValue(inputStream));
            XmlUtils.skipTagEnd(inputStream);
        }
    }
}

