/*
 * Decompiled with CFR 0.152.
 */
package com.gentleware.poseidon.uml.generator;

import com.gentleware.openapi.configuration.Services;
import com.gentleware.openapi.util.CollectionFactory;
import com.gentleware.poseidon.generator.ElementPreparator;
import com.gentleware.poseidon.generator.PreparationException;
import com.gentleware.poseidon.generator.PreparedElement;
import com.gentleware.poseidon.jboogie.PoseidonApplicationState;
import com.gentleware.poseidon.model_management.DocumentationManager;
import com.gentleware.poseidon.uml.UmlProject;
import com.gentleware.poseidon.uml.model_management.Uml1SmAccessory;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import javax.jmi.reflect.RefObject;
import org.apache.log4j.Logger;
import org.omg.uml.foundation.core.AssociationEnd;
import org.omg.uml.foundation.core.Attribute;
import org.omg.uml.foundation.core.Classifier;
import org.omg.uml.foundation.core.Comment;
import org.omg.uml.foundation.core.ModelElement;
import org.omg.uml.foundation.core.Namespace;
import org.omg.uml.foundation.core.Operation;
import org.omg.uml.foundation.core.Parameter;
import org.omg.uml.modelmanagement.Model;
import org.omg.uml2.activities2.ActivityEdge;
import org.omg.uml2.activities2.ActivityNode;
import org.omg.uml2.core2.NamedElement;

public class PreparedModelElement
extends PreparedElement {
    private static final Logger D = Logger.getLogger("com.gentleware.poseidon.uml.generator.PreparedModelElement");
    public static final String KEY_TYPE_UNORDERED_MULTI = Services.getInstance().getConfiguration().makeKey("codeGen", "java", "unorderedMultiplicity");
    public static final String KEY_TYPE_ORDERED_MULTI = Services.getInstance().getConfiguration().makeKey("codeGen", "java", "orderedMultiplicity");
    public static final String KEY_TYPE_SORTED_MULTI = Services.getInstance().getConfiguration().makeKey("codeGen", "java", "sortedMultiplicity");
    protected static final String DOCUMENTATION_TAG_NAME = "documentation";

    public UmlProject getProject() {
        return (UmlProject)PoseidonApplicationState.getInstance().getCurrentProject();
    }

    public String getDocs() {
        UmlProject umlProject = this.getProject();
        DocumentationManager documentationManager = umlProject.getDocumentationManager();
        Object object = this.getElement();
        return documentationManager.getDocAndNotes(object);
    }

    public String getParsedDocs() {
        return this.getProject().getDocumentationManager().getHTMLDocs(this.getElement(), null);
    }

    public String getPlainDocs() {
        String string = this.getProject().getUml1SmAccessory().getTaggedValue((ModelElement)this.getElement(), DOCUMENTATION_TAG_NAME);
        if (string != null && !"".equals(string)) {
            D.debug("getPlainDocs: docTaggedVal=" + string);
            return string;
        }
        return "";
    }

    public PreparedElement getPreparedParent() {
        NamedElement namedElement;
        RefObject refObject = (RefObject)this.getElement();
        if (!(refObject instanceof ModelElement) || refObject instanceof Model) {
            return null;
        }
        Object object = refObject.refImmediateComposite();
        if (refObject instanceof Parameter) {
            namedElement = (Parameter)refObject;
            object = namedElement.getBehavioralFeature();
        }
        if (object == null && refObject instanceof ActivityNode && (object = Uml1SmAccessory.getStructuredActivityNode((ActivityNode)(namedElement = (ActivityNode)refObject))) == null) {
            object = Uml1SmAccessory.getActivityForActivityNode((ActivityNode)namedElement);
        }
        if (object == null && refObject instanceof ActivityEdge) {
            object = ((ActivityEdge)refObject).getInStructuredNode();
        }
        if (object == null) {
            object = this.getProject().getUml1SmAccessory().getNamespace((ModelElement)refObject);
        }
        namedElement = this.getPreparator();
        if (object != null && namedElement != null) {
            return namedElement.getOrCreatePreparedElement(object);
        }
        return null;
    }

    public String getPath(boolean bl, boolean bl2, String string) {
        List list = this.getNamespaceList(bl, bl2);
        String string2 = "";
        int n2 = list.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            String string3 = PreparedElement.replaceIllegalChars((String)((String)list.get(i2)));
            string2 = string2 + string3 + string;
        }
        return string2;
    }

    public String getPathAsString(boolean bl, boolean bl2) {
        List list = this.getNamespaceList(bl, bl2);
        String string = "";
        int n2 = list.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            String string2 = PreparedElement.replaceIllegalChars((String)((String)list.get(i2)));
            string = i2 < n2 - 1 ? string + string2 + "_" : string + string2;
        }
        return string;
    }

    public String getNameOfElementAsString(Object object) {
        return this.getNameOfElementAsString(object, false);
    }

    protected String getNameOfElementAsString(Object object, boolean bl) {
        if (!(object instanceof ModelElement)) {
            return "";
        }
        ModelElement modelElement = (ModelElement)object;
        if (modelElement.getName() != null) {
            StringBuffer stringBuffer = new StringBuffer(modelElement.getName());
            if (modelElement instanceof Classifier) {
                String string;
                Uml1SmAccessory uml1SmAccessory = this.getProject().getUml1SmAccessory();
                Namespace namespace = uml1SmAccessory.getNamespace(modelElement);
                while (namespace instanceof Classifier) {
                    stringBuffer.insert(0, namespace.getName() + ".");
                    namespace = this.getProject().getUml1SmAccessory().getNamespace(namespace);
                }
                if (bl && !"".equals(string = uml1SmAccessory.generateJavaPackageName(modelElement)) && !"java.lang".equals(string)) {
                    stringBuffer.insert(0, string + ".");
                }
            }
            return this.getNameAsStringOverriden(stringBuffer.toString());
        }
        return "";
    }

    public String check() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.checkName());
        stringBuffer.append(this.checkVisibility());
        return stringBuffer.toString();
    }

    protected String checkName() {
        String string = "";
        Object object = this.getElement();
        if (!(object instanceof ModelElement)) {
            return string;
        }
        ModelElement modelElement = (ModelElement)object;
        String string2 = modelElement.getName();
        if (string2 == null || "".equals(string2)) {
            string = "Illegal name (empty) of model element " + modelElement + "\n";
        } else if (string2.indexOf(92) > 0 || string2.indexOf(47) > 0) {
            string = string + "Element name contains file separator characters [e.g. /, \\]: " + string2 + "\n";
        } else {
            String string3 = this.getNameAsString();
            if (!string3.endsWith(string2)) {
                string = string + "  Element '" + string2 + "' contains illegal characters, it will be generated as '" + string3 + "'.\n    Generating this element and re-importing it may lead to duplicates.\n";
            }
        }
        return string;
    }

    public String getVisibilityAsString() {
        Object object = this.getElement();
        if (!(object instanceof ModelElement)) {
            return "";
        }
        ModelElement modelElement = (ModelElement)object;
        if (modelElement.getVisibility() != null && modelElement.getVisibility().toString() != null) {
            String string = modelElement.getVisibility().toString();
            if ("vk_package".equals(string)) {
                return "";
            }
            if (string.startsWith("vk_")) {
                string = string.substring(3);
            }
            return string + " ";
        }
        return "";
    }

    public List getNamespaceList(boolean bl, boolean bl2) {
        if (!(this.getElement() instanceof ModelElement)) {
            return CollectionFactory.createArrayList();
        }
        List list = this.getParentNamespaces((ModelElement)this.getElement());
        List list2 = CollectionFactory.createArrayList();
        int n2 = bl ? list.size() - 1 : list.size() - 2;
        for (int i2 = n2; i2 >= 0; --i2) {
            String string = this.getNameAsStringOverriden(((Namespace)list.get(i2)).getName());
            list2.addAll(this.parseNamespace(string));
        }
        if (bl2) {
            list2.addAll(this.parseNamespace(this.getNameAsString("", "")));
        }
        return list2;
    }

    protected String getNameAsStringOverriden(String string) {
        return PreparedModelElement.getNameAsString((String)string);
    }

    public String getRelativePathToModel(boolean bl, boolean bl2, String string) {
        List list = this.getNamespaceList(bl, bl2);
        StringBuffer stringBuffer = new StringBuffer("");
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            stringBuffer.append("..");
            stringBuffer.append(string);
            iterator.next();
        }
        if (stringBuffer.length() == 0) {
            stringBuffer.append(".");
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    public int getNamespaceHierarchyPosition() {
        List list = this.getNamespaceList(false, false);
        int n2 = list.size();
        return n2;
    }

    public String checkVisibility() {
        return "";
    }

    public String getNamespaceListAsString(boolean bl, boolean bl2, String string) {
        List list = this.getNamespaceList(bl, bl2);
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            stringBuffer.append((String)iterator.next());
            if (!iterator.hasNext()) continue;
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    public String getTaggedValue(String string) {
        Object object = this.getElement();
        if (!(object instanceof ModelElement)) {
            return null;
        }
        return this.getProject().getUml1SmAccessory().getTaggedValue((ModelElement)object, string);
    }

    public List parseNamespace(String string) {
        String string2 = ".";
        List list = CollectionFactory.createArrayList();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        if (stringTokenizer.hasMoreElements()) {
            while (stringTokenizer.hasMoreElements()) {
                String string3 = this.getNameAsStringOverriden(stringTokenizer.nextToken());
                list.add(string3);
            }
        } else {
            list.add(string);
        }
        return list;
    }

    public List getParentNamespaces(ModelElement modelElement) {
        Uml1SmAccessory uml1SmAccessory = this.getProject().getUml1SmAccessory();
        List list = uml1SmAccessory.getNamespaces(modelElement);
        return list;
    }

    public void init(Object object, ElementPreparator elementPreparator) throws PreparationException {
        this.setElement(object);
        this.setPreparator(elementPreparator);
    }

    public static String addLinePrefix(String string, String string2) {
        if (string2 == null) {
            throw new NullPointerException("Cannot use null as prefix in addLinePrefix.");
        }
        StringBuffer stringBuffer = new StringBuffer(string);
        if (stringBuffer.length() > 0) {
            stringBuffer.insert(0, string2);
        }
        for (int i2 = stringBuffer.length() - 2; i2 > 0; --i2) {
            if (stringBuffer.charAt(i2) != '\n') continue;
            stringBuffer.insert(i2 + 1, string2);
        }
        return stringBuffer.toString();
    }

    public final boolean isOperation() {
        return this.getElement() instanceof Operation;
    }

    public final boolean isAttribute() {
        return this.getElement() instanceof Attribute;
    }

    public final boolean isAssociationEnd() {
        return this.getElement() instanceof AssociationEnd;
    }

    public final boolean isClassifier() {
        return this.getElement() instanceof Classifier;
    }

    public final boolean isComment() {
        return this.getElement() instanceof Comment;
    }
}

