/*
 * Decompiled with CFR 0.152.
 */
package com.gentleware.poseidon.uml.generator.util;

import com.gentleware.openapi.configuration.Configuration;
import com.gentleware.openapi.configuration.Services;
import com.gentleware.openapi.util.Strings;
import com.gentleware.poseidon.generator.PreparedElement;
import com.gentleware.poseidon.generator.ui.DialogController;
import com.gentleware.poseidon.jboogie.PoseidonApplicationState;
import com.gentleware.poseidon.uml.UmlProject;
import com.gentleware.poseidon.uml.generator.PreparedModelElement;
import com.gentleware.poseidon.uml.generator.util.JavaDocHelper;
import com.gentleware.poseidon.uml.model_management.Uml1SmAccessory;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.jmi.reflect.RefObject;
import org.apache.log4j.Logger;
import org.omg.uml.foundation.core.Attribute;
import org.omg.uml.foundation.core.Classifier;
import org.omg.uml.foundation.core.DataType;
import org.omg.uml.foundation.core.Namespace;
import org.omg.uml.foundation.core.Parameter;
import org.omg.uml.modelmanagement.Model;

public class HTMLHelper {
    private static final Logger C = Logger.getLogger("com.gentleware.poseidon.uml.generator.util.HTMLHelper");
    private static String B = "java/";
    private static HTMLHelper A = new HTMLHelper();

    protected HTMLHelper() {
    }

    public static HTMLHelper getInstance() {
        return A;
    }

    public String getTagIndentationString(String string, int n2, int n3) {
        int n4 = n3 - n2;
        if (n4 == 0) {
            return "";
        }
        String string2 = "<" + (n4 > 0 ? "" : "/") + string + ">";
        n4 = Math.abs(n4);
        StringBuffer stringBuffer = new StringBuffer();
        for (int i2 = 0; i2 < n4; ++i2) {
            stringBuffer.append(string2);
        }
        return stringBuffer.toString();
    }

    public static void main(String[] stringArray) {
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            String string = stringArray[i2];
            HTMLHelper hTMLHelper = new HTMLHelper();
            System.out.println("Original: " + string);
        }
    }

    public String getSpaces(int n2) {
        return Strings.repeat((String)"&nbsp;", (int)n2);
    }

    public void reverseList(List list) {
        Collections.reverse(list);
    }

    public String getExternLinkBase() {
        Configuration configuration = Services.getInstance().getConfiguration();
        return configuration.getString(DialogController.EXTERNAL_LINK_BASE);
    }

    public String getExternalLinkForType(PreparedModelElement preparedModelElement) {
        return this.getExternLinkBase() + "/" + this.getLinkForType(preparedModelElement);
    }

    public String getLinkForType(PreparedModelElement preparedModelElement) {
        String string = "";
        try {
            if (preparedModelElement != null) {
                Classifier classifier;
                RefObject refObject = (RefObject)preparedModelElement.getElement();
                if (refObject instanceof Attribute) {
                    Attribute attribute = (Attribute)refObject;
                    classifier = attribute.getType();
                } else if (refObject instanceof Parameter) {
                    Parameter parameter = (Parameter)refObject;
                    classifier = parameter.getType();
                } else {
                    C.error("IllegalArgument: expected Attribute or Parameter, get " + refObject);
                    return "";
                }
                if (!(classifier instanceof DataType)) {
                    string = this.A(classifier);
                }
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            illegalArgumentException.printStackTrace();
        }
        return string;
    }

    public boolean hasExternalLink(PreparedModelElement preparedModelElement) {
        String string = this.getLinkForType(preparedModelElement);
        boolean bl = !"".equals(string) && this.A(string) && this.A();
        return bl;
    }

    private boolean A(String string) {
        return string.indexOf(B) > -1;
    }

    private boolean A() {
        Configuration configuration = Services.getInstance().getConfiguration();
        return configuration.getBoolean(DialogController.GENERATE_EXTERNAL_LINKS, true);
    }

    private String A(Classifier classifier) {
        if (classifier == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        UmlProject umlProject = (UmlProject)PoseidonApplicationState.getInstance().getCurrentProject();
        Uml1SmAccessory uml1SmAccessory = umlProject.getUml1SmAccessory();
        List list = uml1SmAccessory.getNamespaces(classifier);
        String string = "";
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Namespace namespace = (Namespace)iterator.next();
            if (namespace instanceof Model) continue;
            stringBuffer.insert(0, string);
            stringBuffer.insert(0, namespace.getName());
            string = "/";
        }
        stringBuffer.append(string);
        stringBuffer.append(classifier.getName());
        stringBuffer.append(".html");
        return stringBuffer.toString();
    }

    public JavaDocHelper getJavaDocHelper(PreparedElement preparedElement) {
        if (preparedElement instanceof PreparedModelElement) {
            PreparedModelElement preparedModelElement = (PreparedModelElement)preparedElement;
            JavaDocHelper javaDocHelper = new JavaDocHelper(preparedModelElement);
            return javaDocHelper;
        }
        C.error("[HTMLHelper]: No JavaDocHelper created, because no ModelElement can be assigned");
        throw new NullPointerException(preparedElement.toString() + " contains no ModelElement");
    }
}

