/*
 * Decompiled with CFR 0.152.
 */
package com.gentleware.poseidon.uml.merging;

import com.gentleware.jboogie.command_framework.UndoManager;
import com.gentleware.jboogie.kernel.IdFactory;
import com.gentleware.jboogie.kernel.JBoogie;
import com.gentleware.jboogie.kernel.JmiCommandFactoryImpl;
import com.gentleware.jboogie.kernel.NameGenerator;
import com.gentleware.jboogie.kernel.ProjectMember;
import com.gentleware.jboogie.kernel.ProjectMemberManager;
import com.gentleware.jboogie.kernel.ProjectMemberReaderWriter;
import com.gentleware.jboogie.model_management.XmiIdHandler;
import com.gentleware.jboogie.util.JBoogieUtils;
import com.gentleware.jboogie.util.SubInputStream;
import com.gentleware.mdr.MdrFacade;
import com.gentleware.mdr.RepositoryHelper;
import com.gentleware.openapi.configuration.ConfigurationException;
import com.gentleware.openapi.configuration.ConfigurationReader;
import com.gentleware.openapi.jboogie.DiCommandFactory;
import com.gentleware.openapi.jboogie.JmiCommandFactory;
import com.gentleware.openapi.jboogie.Project;
import com.gentleware.openapi.swingx.Localizer;
import com.gentleware.openapi.swingx.ResourceId;
import com.gentleware.openapi.util.Files;
import com.gentleware.openapi.util.ProductVersion;
import com.gentleware.openapi.util.Utils;
import com.gentleware.poseidon.ProjectConverter;
import com.gentleware.poseidon.configuration.ProjectConfigurationReader;
import com.gentleware.poseidon.jboogie.PoseidonApplicationState;
import com.gentleware.poseidon.kernel.PoseidonProject;
import com.gentleware.poseidon.kernel.ProjectMemberReaderWriterDefault;
import com.gentleware.poseidon.merging.BadXmiException;
import com.gentleware.poseidon.merging.LoadException;
import com.gentleware.poseidon.merging.ProjectReaderWriter;
import com.gentleware.poseidon.openapi.PoseidonUIConnector;
import com.gentleware.poseidon.openapi.uml.Uml1SmCommandFactory;
import com.gentleware.poseidon.ui.MenuResourceBundle;
import com.gentleware.poseidon.uml.Uml1SmCommandFactoryImpl;
import com.gentleware.poseidon.uml.UmlNameGenerator;
import com.gentleware.poseidon.uml.UmlProject;
import com.gentleware.poseidon.uml.model_conversion.ProjectConverterImpl;
import com.gentleware.poseidon.uml.model_management.Uml1SmFactory;
import com.gentleware.poseidon.uml.xml.B;
import com.gentleware.poseidon.uml.xml.D;
import com.gentleware.poseidon.uml.xml.XmiLoader;
import com.gentleware.poseidon.xml.argo.ArgoParser;
import com.gentleware.swingx.ProgressDialog;
import gnu.trove.TObjectIntHashMap;
import java.beans.PropertyVetoException;
import java.io.BufferedInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.jmi.reflect.RefObject;
import javax.jmi.reflect.RefPackage;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.log4j.Logger;
import org.dom4j.DocumentException;
import org.netbeans.api.xmi.XMIReader;
import org.netbeans.api.xmi.XMIReferenceProvider;
import org.omg.uml.modelmanagement.Model;
import org.omg.uml.modelmanagement.ModelClass;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.ParserAdapter;

public class Poseidon2UmlProjectReaderWriter
extends ProjectMemberReaderWriter
implements ProjectReaderWriter {
    private static final Logger D = Logger.getLogger("com.gentleware.poseidon.uml.merging.Poseidon2UmlProjectReaderWriter");
    private IdFactory E;
    private Uml1SmCommandFactory B;
    private DiCommandFactory G;
    private JmiCommandFactory C;
    private UmlNameGenerator A;
    private UndoManager F;

    public Poseidon2UmlProjectReaderWriter() {
        ProjectMemberManager projectMemberManager = JBoogie.getInstance().getProjectMemberManager();
        projectMemberManager.addMemberReaderWriter("xmi", (ProjectMemberReaderWriter)this);
    }

    public void setSmCommandFactoryForNextProject(Uml1SmCommandFactoryImpl uml1SmCommandFactoryImpl) {
        this.B = uml1SmCommandFactoryImpl;
    }

    public void setNameGeneratorForNextProject(UmlNameGenerator umlNameGenerator) {
        this.A = umlNameGenerator;
    }

    public void setCommandDiFactoryForNextProject(DiCommandFactory diCommandFactory) {
        this.G = diCommandFactory;
    }

    public void setJmiCommandFactoryForNextProject(JmiCommandFactoryImpl jmiCommandFactoryImpl) {
        this.C = jmiCommandFactoryImpl;
    }

    public void setUndoManagerForNextProject(UndoManager undoManager) {
        this.F = undoManager;
    }

    public void setIdFactoryForNextProject(IdFactory idFactory) {
        this.E = idFactory;
    }

    public PoseidonProject createProject() {
        PoseidonProject poseidonProject = PoseidonApplicationState.getInstance().getProjectOfType("Uml1");
        if (this.E != null) {
            poseidonProject.setIdFactory(this.E);
            this.G.setProject((Project)poseidonProject);
            poseidonProject.setDiCommandFactory(this.G);
            this.C.setProject((Project)poseidonProject);
            poseidonProject.setJmiCommandFactory(this.C);
            this.B.setProject((Project)poseidonProject);
            ((UmlProject)poseidonProject).setUml1CommandSmFactory(this.B);
            poseidonProject.setUndoManager(this.F);
            this.A.setProject((UmlProject)poseidonProject);
            poseidonProject.setNameGenerator((NameGenerator)this.A);
        }
        this.E = null;
        this.G = null;
        this.C = null;
        this.B = null;
        this.A = null;
        return poseidonProject;
    }

    public PoseidonProject loadProject(URL uRL, ProgressDialog progressDialog) throws LoadException {
        PoseidonProject poseidonProject = this.A(uRL, progressDialog);
        try {
            poseidonProject = ((ProjectConverterImpl)ProjectConverter.get()).convertProjectIfNecessary(poseidonProject, progressDialog);
        }
        catch (IOException iOException) {
            throw new LoadException((Throwable)iOException);
        }
        catch (DocumentException documentException) {
            throw new LoadException((Throwable)documentException);
        }
        return poseidonProject;
    }

    private PoseidonProject A(URL uRL, ProgressDialog progressDialog) throws LoadException {
        PoseidonProject poseidonProject;
        ZipInputStream zipInputStream = null;
        try {
            PoseidonProject poseidonProject2 = this.createProject();
            PoseidonProject.fireProjectChanged(null, (PoseidonProject)poseidonProject2, (String)"LoadingPrepared");
            poseidonProject2.preLoad();
            zipInputStream = new ZipInputStream(new BufferedInputStream(uRL.openStream()));
            this.A(poseidonProject2, uRL, zipInputStream, progressDialog);
            zipInputStream.close();
            zipInputStream = new ZipInputStream(new BufferedInputStream(uRL.openStream(), 16384));
            this.A((UmlProject)poseidonProject2, zipInputStream, progressDialog);
            poseidonProject2.postLoad();
            poseidonProject = poseidonProject2;
        }
        catch (IOException iOException) {
            try {
                throw new LoadException((Throwable)iOException);
            }
            catch (Throwable throwable) {
                Files.close(zipInputStream);
                throw throwable;
            }
        }
        Files.close((InputStream)zipInputStream);
        return poseidonProject;
    }

    private void A(PoseidonProject poseidonProject, URL uRL, ZipInputStream zipInputStream, ProgressDialog progressDialog) throws IOException {
        String string = zipInputStream.getNextEntry().getName();
        while (!string.endsWith(".proj3") && !string.endsWith(".proj")) {
            string = zipInputStream.getNextEntry().getName();
        }
        JBoogieUtils.updateProgressDialog((ProgressDialog)progressDialog, (String)string);
        ArgoParser.SINGLETON.setURL(uRL);
        ProjectConfigurationReader projectConfigurationReader = new ProjectConfigurationReader(zipInputStream, string, poseidonProject);
        try {
            poseidonProject.getConfiguration().read((ConfigurationReader)projectConfigurationReader);
        }
        catch (ConfigurationException configurationException) {
            D.error("Cannot load project configuration", configurationException);
        }
        try {
            poseidonProject.setUrl(uRL);
        }
        catch (PropertyVetoException propertyVetoException) {
            D.warn("Url for project could not be set: " + uRL.toString());
            throw new IllegalArgumentException("Could not set url for project: " + uRL.toString());
        }
    }

    private void A(InputStream inputStream, ContentHandler contentHandler) throws ParserConfigurationException, SAXException, IOException {
        SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
        SAXParser sAXParser = sAXParserFactory.newSAXParser();
        ParserAdapter parserAdapter = new ParserAdapter(sAXParser.getParser());
        parserAdapter.setContentHandler(contentHandler);
        InputSource inputSource = new InputSource(inputStream);
        inputSource.setEncoding("utf-8");
        parserAdapter.parse(inputSource);
    }

    private void A(UmlProject umlProject, ZipInputStream zipInputStream, ProgressDialog progressDialog) throws LoadException {
        ProjectMemberManager projectMemberManager = JBoogie.getInstance().getProjectMemberManager();
        try {
            Map map = projectMemberManager.getProjectMemberReaderWriters();
            ZipEntry zipEntry = zipInputStream.getNextEntry();
            while (zipEntry != null) {
                String string = zipEntry.getName();
                String string2 = string.substring(string.lastIndexOf(".") + 1);
                String string3 = string.substring(0, string.lastIndexOf("."));
                SubInputStream subInputStream = new SubInputStream(zipInputStream);
                if (map.containsKey(string2)) {
                    JBoogieUtils.updateProgressDialog((ProgressDialog)progressDialog, (String)string);
                    ((ProjectMemberReaderWriter)map.get(string2)).loadMember(string3, (InputStream)subInputStream, (Project)umlProject);
                } else if (!"proj3".equals(string2)) {
                    ProjectMemberReaderWriterDefault projectMemberReaderWriterDefault = new ProjectMemberReaderWriterDefault();
                    JBoogieUtils.updateProgressDialog((ProgressDialog)progressDialog, (String)string);
                    projectMemberReaderWriterDefault.loadMember(string, (InputStream)subInputStream, (Project)umlProject);
                }
                zipEntry = zipInputStream.getNextEntry();
            }
        }
        catch (PropertyVetoException propertyVetoException) {
            throw new LoadException((Throwable)propertyVetoException);
        }
        catch (IOException iOException) {
            D.error("Some errors occured while reading zip file: " + umlProject.getUrl(), iOException);
        }
        catch (Exception exception) {
            D.error(exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mergeProjects(PoseidonProject poseidonProject, URL uRL, ProgressDialog progressDialog) {
        Object object;
        try {
            object = (ProjectConverterImpl)ProjectConverter.get();
            if (object.isConversionNecessary(uRL)) {
                object.showNeedToOpenMessage(uRL);
                return;
            }
        }
        catch (IOException iOException) {
            D.error("Caught Exception", iOException);
            return;
        }
        D.debug("[ProjectHandler]: merging projects");
        object = null;
        try {
            poseidonProject.preLoad();
            object = new ZipInputStream(new BufferedInputStream(uRL.openStream()));
            this.A((UmlProject)poseidonProject, uRL, progressDialog);
            poseidonProject.postLoad();
        }
        catch (FileNotFoundException fileNotFoundException) {
            String string = "The specified file " + uRL.toString() + " could not be found.";
            JBoogieUtils.showMessageDialog(null, (Object)string, (String)"Open project", (int)0);
        }
        catch (Exception exception) {
            Utils.logErrorOrThrow((Logger)D, (Object)"Oops, something went wrong in [ProjectHandler.mergeProjects] ", (Throwable)exception);
        }
        finally {
            Files.close((InputStream)object);
        }
    }

    public void exportProjectToXmi(PoseidonProject poseidonProject) {
    }

    private void A(UmlProject umlProject, URL uRL, ProgressDialog progressDialog) {
        try {
            ZipInputStream zipInputStream = new ZipInputStream(new BufferedInputStream(uRL.openStream()));
            String string = zipInputStream.getNextEntry().getName();
            while (!string.endsWith(".xmi")) {
                string = zipInputStream.getNextEntry().getName();
            }
            JBoogieUtils.updateProgressDialog((ProgressDialog)progressDialog, (String)string);
            Model model = (Model)umlProject.getModel(0);
            umlProject.removeModel(0);
            try {
                this.loadXmiFile(zipInputStream, UmlProject.LOAD_MDR, false, (Project)umlProject, null);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                try {
                    zipInputStream.close();
                    zipInputStream = new ZipInputStream(new BufferedInputStream(uRL.openStream()));
                    this.A(zipInputStream);
                    this.loadXmiFile(zipInputStream, UmlProject.LOAD_NOVOSOFT, false, (Project)umlProject, null);
                }
                catch (Exception exception) {
                    D.error("Loading of xmi file not possible. It is neither xmi 1.0 nor 1.2!");
                    throw new IllegalStateException("File is neither xmi 1.0 nor 1.2. Loading failed!");
                }
            }
            Map map = umlProject.getPasteHelper().mergeModelsForProject((RefObject)model);
            umlProject.getPasteHelper().mergeDiagramsIntoProject(map);
            Model model2 = (Model)umlProject.getModel(1);
            umlProject.removeModel(1);
            model2.refDelete();
        }
        catch (Exception exception) {
            Utils.logErrorOrThrow((Logger)D, (Object)"Oops, something went wrong in [ProjectHandler.mergeZippedProjectMembers()] ", (Throwable)exception);
        }
    }

    public void exportProjectToXmi(String string, OutputStream outputStream, PoseidonProject poseidonProject, boolean bl) {
    }

    private String A(ZipInputStream zipInputStream) throws IOException {
        String string = zipInputStream.getNextEntry().getName();
        while (!string.endsWith(".xmi")) {
            string = zipInputStream.getNextEntry().getName();
        }
        return string;
    }

    public ProductVersion loadXmiFile(InputStream inputStream, int n2, boolean bl, Project project, XMIReader xMIReader) throws LoadException {
        UmlProject umlProject = (UmlProject)project;
        XmiLoader xmiLoader = new XmiLoader(umlProject, bl);
        ProductVersion productVersion = xmiLoader.load(inputStream, umlProject.getMetamodel(), n2, xMIReader);
        return productVersion;
    }

    public ProjectMember loadMember(String string, InputStream inputStream, Project project) throws PropertyVetoException, LoadException {
        Object object;
        ModelClass modelClass;
        Object object2;
        ProductVersion productVersion;
        UmlProject umlProject = (UmlProject)project;
        URL uRL = umlProject.getUrl();
        umlProject.removeModel(0);
        D.info("reading from " + uRL.toString());
        try {
            productVersion = this.loadXmiFile(inputStream, UmlProject.LOAD_MDR, true, (Project)umlProject, null);
        }
        catch (BadXmiException badXmiException) {
            try {
                umlProject.refreshM1Extent();
                D.info("Loading failed.", badXmiException);
                D.info("Loading xmi again, with repair function enabled. ");
                object2 = new ZipInputStream(new BufferedInputStream(uRL.openStream()));
                this.A((ZipInputStream)object2);
                modelClass = new TObjectIntHashMap();
                this.A((InputStream)object2, new D(true, (TObjectIntHashMap)modelClass));
                ((ZipInputStream)object2).close();
                object2 = new ZipInputStream(new BufferedInputStream(uRL.openStream()));
                this.A((ZipInputStream)object2);
                this.A((InputStream)object2, new D(false, (TObjectIntHashMap)modelClass));
                object = new B((TObjectIntHashMap)modelClass);
                object2 = new ZipInputStream(new BufferedInputStream(uRL.openStream()));
                this.A((ZipInputStream)object2);
                productVersion = this.loadXmiFile((InputStream)object2, UmlProject.LOAD_MDR, true, (Project)umlProject, (XMIReader)object);
            }
            catch (ParserConfigurationException parserConfigurationException) {
                throw new LoadException((Throwable)parserConfigurationException);
            }
            catch (SAXException sAXException) {
                throw new LoadException((Throwable)sAXException);
            }
            catch (IOException iOException) {
                throw new LoadException((Throwable)iOException);
            }
        }
        if (inputStream != null) {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        Uml1SmFactory uml1SmFactory = umlProject.getUml1SmFactory();
        object2 = uml1SmFactory.getModelManagementPackage();
        modelClass = object2.getModel();
        object = modelClass.refAllOfClass();
        Model model = (Model)object.iterator().next();
        ProjectMember projectMember = umlProject.addModelMember(model);
        projectMember.setVersion(productVersion);
        return projectMember;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(ProjectMember projectMember, String string, OutputStream outputStream) {
        if (outputStream == null) {
            D.error("No output stream specified!");
            return;
        }
        MdrFacade.getInstance().beginReadTransaction();
        try {
            PoseidonUIConnector.showStatus((String)("Writing " + string + "..."));
            UmlProject umlProject = (UmlProject)projectMember.getProject();
            RefPackage refPackage = umlProject.getMetamodel();
            RepositoryHelper.writeXmi((OutputStream)outputStream, (RefPackage)refPackage, (XMIReferenceProvider)new XmiIdHandler((Project)umlProject));
            D.debug("Wrote " + string);
            PoseidonUIConnector.showStatus((String)("Wrote " + string));
        }
        catch (Exception exception) {
            D.error("[ProjectMemberModel]save", exception);
            JBoogieUtils.showMessageDialog(null, (Object)exception.toString(), (String)Localizer.localize((ResourceId)MenuResourceBundle.SaveProject), (int)0);
        }
        finally {
            MdrFacade.getInstance().endTransaction(false);
        }
    }
}

