/*
 * Decompiled with CFR 0.152.
 */
package com.gentleware.poseidon.uml.model_conversion;

import com.gentleware.openapi.util.CollectionFactory;
import com.gentleware.poseidon.uml.model_conversion.sequence_diagrams.IntermediateInteractionConverter;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Iterator;
import java.util.List;
import javax.xml.transform.Source;
import javax.xml.transform.SourceLocator;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.URIResolver;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamSource;
import org.apache.log4j.Logger;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.io.DocumentResult;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class XmiXsltConverter {
    private static final String F = "[XMI_XSLT_CONVERTER]";
    private static final Logger B = Logger.getLogger("com.gentleware.poseidon.uml.model_conversion.XmiXsltConverter");
    private final URIResolver G = new _A();
    private InputSource A;
    private SAXTransformerFactory C;
    private static _B E;
    private List D = CollectionFactory.createArrayList();

    private XmiXsltConverter() {
        this.B();
        B.debug("Using the following transformerFactory: " + this.C);
        this.C.setURIResolver(this.G);
    }

    private void B() {
        System.setProperty("javax.xml.transform.TransformerFactory", "net.sf.saxon.TransformerFactoryImpl");
        this.C = (SAXTransformerFactory)TransformerFactory.newInstance();
        this.C.setAttribute("http://saxon.sf.net/feature/treeModel", new Integer(1));
        this.C.setAttribute("http://saxon.sf.net/feature/timing", Boolean.TRUE);
    }

    private void A() {
        this.C = (SAXTransformerFactory)TransformerFactory.newInstance();
    }

    public XmiXsltConverter(InputStream inputStream) {
        this();
        this.A(inputStream);
    }

    private void A(InputStream inputStream) {
        this.A = new InputSource(inputStream);
    }

    public XmiXsltConverter(File file) {
        this();
        String string = file.getAbsolutePath();
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(string);
        }
        catch (FileNotFoundException fileNotFoundException) {
            B.error(fileNotFoundException);
        }
        BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);
        this.A(bufferedInputStream);
        this.A.setSystemId(string);
    }

    public static void logTransformMessage(String string) {
        if (E != null) {
            E.A(string);
        }
    }

    public Document convert() {
        return this.convert(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Document convert(_B _B2) {
        if (this.D.isEmpty()) {
            throw new IllegalStateException("Please feed the Converter with some transformations. Use the method addTransformations.");
        }
        E = _B2;
        try {
            DocumentResult documentResult = new DocumentResult();
            TransformerHandler transformerHandler = this.A(documentResult);
            this.A(transformerHandler);
            Document document = documentResult.getDocument();
            B.debug("[XMI_XSLT_CONVERTER] Result:");
            B.debug(document.asXML());
            Document document2 = document;
            return document2;
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            B.error("### Caught TransformerCobfigurationException", transformerConfigurationException);
            this.A(transformerConfigurationException);
        }
        catch (TransformerException transformerException) {
            B.error(transformerException);
            this.A(transformerException);
        }
        catch (IOException iOException) {
            B.error(iOException);
        }
        catch (SAXParseException sAXParseException) {
            B.error(sAXParseException);
            B.info("Error occured!!!");
            B.info("Column: " + sAXParseException.getColumnNumber());
            B.info("Line: " + sAXParseException.getLineNumber());
            B.info("System Id: " + sAXParseException.getSystemId());
            B.info("Public Id: " + sAXParseException.getPublicId());
        }
        catch (SAXException sAXException) {
            B.error(sAXException);
        }
        finally {
            E = null;
        }
        return null;
    }

    private void A(TransformerException transformerException) {
        SourceLocator sourceLocator = transformerException.getLocator();
        B.info("### DumpLocaterInformation");
        B.info(transformerException.getLocationAsString());
        B.info(transformerException.getMessageAndLocation());
        if (sourceLocator != null) {
            B.info("Column: " + sourceLocator.getColumnNumber());
            B.info("Line: " + sourceLocator.getLineNumber());
            B.info("System Id: " + sourceLocator.getSystemId());
            B.info("Public Id: " + sourceLocator.getPublicId());
        } else {
            B.info("Locator==null");
        }
    }

    private void A(TransformerHandler transformerHandler) throws SAXException, IOException {
        XMLReader xMLReader = XMLReaderFactory.createXMLReader();
        xMLReader.setContentHandler(transformerHandler);
        xMLReader.setProperty("http://xml.org/sax/properties/lexical-handler", transformerHandler);
        xMLReader.parse(this.A);
    }

    private TransformerHandler A(DocumentResult documentResult) throws TransformerConfigurationException {
        Iterator iterator = this.D.iterator();
        TransformerHandler transformerHandler = null;
        TransformerHandler transformerHandler2 = null;
        while (iterator.hasNext()) {
            URL uRL = (URL)iterator.next();
            B.info("###Loading File (String)" + uRL);
            InputStream inputStream = null;
            try {
                inputStream = uRL.openStream();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            StreamSource streamSource = new StreamSource(inputStream);
            B.info("### Adding system id: " + uRL + " as transformer handler.");
            TransformerHandler transformerHandler3 = this.C.newTransformerHandler(streamSource);
            if (transformerHandler != null) {
                SAXResult sAXResult = new SAXResult(transformerHandler3);
                transformerHandler.setResult(sAXResult);
                transformerHandler.getTransformer().setOutputProperty("indent", "no");
            } else {
                transformerHandler2 = transformerHandler3;
            }
            transformerHandler = transformerHandler3;
        }
        transformerHandler.setResult(documentResult);
        transformerHandler.getTransformer().setOutputProperty("indent", "yes");
        return transformerHandler2;
    }

    private static InputStream A(String string, ClassLoader classLoader) throws IOException {
        String string2 = XmiXsltConverter.A(string);
        return XmiXsltConverter.loadResource(classLoader, string2);
    }

    private static String A(String string) {
        String string2 = "com/gentleware/poseidon/uml/model_conversion/xslt/" + string;
        return string2;
    }

    public static InputStream loadResource(ClassLoader classLoader, String string) throws IOException {
        URL uRL = XmiXsltConverter.A(classLoader, string);
        InputStream inputStream = null;
        if (uRL != null) {
            B.debug("Loading XSLT from: \"" + uRL.toExternalForm() + "\"");
            inputStream = uRL.openStream();
        }
        return inputStream;
    }

    private static URL A(ClassLoader classLoader, String string) {
        URL uRL = classLoader.getResource(string);
        return uRL;
    }

    public void addTransformation(String string) throws IOException, DocumentException {
        String string2 = XmiXsltConverter.A(string);
        URL uRL = XmiXsltConverter.A(this.getClass().getClassLoader(), string2);
        B.info("### Temporary Xslt Resource File: " + uRL);
        this.D.add(uRL);
    }

    public static interface _B {
        public void A(String var1);
    }

    private static class _A
    implements URIResolver {
        private _A() {
        }

        public Source resolve(String string, String string2) throws TransformerException {
            IntermediateInteractionConverter intermediateInteractionConverter = IntermediateInteractionConverter.getInstance();
            Source source = intermediateInteractionConverter.resolve(string, string2);
            if (source != null) {
                return source;
            }
            try {
                String string3 = this.A(string);
                InputStream inputStream = XmiXsltConverter.A(string3, this.getClass().getClassLoader());
                if (inputStream != null) {
                    return new StreamSource(inputStream);
                }
            }
            catch (IOException iOException) {
                B.error("URIResolver called, Could not find resource HREF: " + string + " base: " + string2, iOException);
            }
            return null;
        }

        private String A(String string) {
            String string2 = "../";
            if (string.startsWith("../")) {
                String string3 = string.substring(3);
                return this.A(string3);
            }
            return string;
        }
    }
}

