<?xml version="1.0" encoding="ISO-8859-1"?>
<!--
Copyright (c) 2003-2005
Gentleware AG, Ludwigstra�e 12, 20357 Hamburg, Germany
-->
<xsl:transform version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:UML="org.omg.xmi.namespace.UML"
               xmlns:UML2="org.omg.xmi.namespace.UML2">
    <xsl:key name="pseudostates" match="UML:ActivityGraph/UML:StateMachine.top/UML:CompositeState/UML:CompositeState.subvertex/UML:Pseudostate"
             use="@xmi.id"/>
    <xsl:key name="moved-comments"
             match="//UML:Model//node()[@xmi.id=//UML:ActivityGraph[@xmi.id]/UML:StateMachine.context/node()/@xmi.idref]/UML:Namespace.ownedElement/UML:Comment[@xmi.id]"
             use="@xmi.id"/>
    <xsl:output method="xml"/>
    <!-- UML:ActivityGraph -->
    <xsl:template match="UML:ActivityGraph" mode="activityGraphRoot">
        <xsl:apply-templates select="." mode="activityGraph"/>
    </xsl:template>
    <xsl:template match="UML:ActivityGraph"/>
    <xsl:template match="UML:Diagram[UML:GraphElement.semanticModel/UML:SimpleSemanticModelElement[@typeInfo='ActivityDiagram']]">
        <xsl:apply-templates select="." mode="activityDiagram"/>
    </xsl:template>
    <xsl:template match="UML:Uml1SemanticModelBridge/UML:Uml1SemanticModelBridge.element" mode="activityDiagram">
        <UML:Uml1SemanticModelBridge.element>
            <xsl:apply-templates select="child::node()" mode="activityElement"/>
        </UML:Uml1SemanticModelBridge.element>
    </xsl:template>
    <xsl:template match="node()|@*" priority="-1" mode="activityDiagram">
        <xsl:copy>
            <xsl:apply-templates select="@*|node()" mode="activityDiagram"/>
        </xsl:copy>
    </xsl:template>
    <!-- ActivityGraph  -->
    <xsl:template match="UML:ActivityGraph" mode="activityGraph">
        <UML2:Activity xmi.id="{@xmi.id}" name="{@name}" visibility="public">
            <UML:Namespace.ownedElement>
                <xsl:variable name="activity.xmi-id" select="@xmi.id"/>
                <!--<xsl:copy-of-->
                <!--select="//UML:Model//node()[@xmi.id=//UML:ActivityGraph[@xmi.id=$activity.xmi-id]/UML:StateMachine.context/node()/@xmi.idref]/UML:Namespace.ownedElement/UML:Comment[@xmi.id]"-->
                <!--/>-->
            </UML:Namespace.ownedElement>
            <UML2:Activity.node>
                <xsl:apply-templates mode="activityGraph" select="UML:StateMachine.top/UML:CompositeState/UML:CompositeState.subvertex/*"/>
            </UML2:Activity.node>
            <UML2:Activity.edge>
                <xsl:apply-templates mode="activityGraph" select="UML:StateMachine.transitions/*"/>
            </UML2:Activity.edge>
        </UML2:Activity>
    </xsl:template>
    <xsl:template match="UML:ActivityGraph" mode="activityElement">
        <UML2:Activity xmi.idref="{@xmi.idref}"/>
    </xsl:template>
    <!-- UML:ActionState -->
    <xsl:template match="UML:ActionState" mode="activityGraph">
        <xsl:variable name="call-action" select="UML:State.entry/UML:CallAction"/>
        <xsl:variable name="name">
            <xsl:choose>
                <xsl:when test="@name!=''">
                    <xsl:value-of select="@name"/>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:value-of select="$call-action/UML:Action.script/UML:ActionExpression/@body"/>
                </xsl:otherwise>
            </xsl:choose>
        </xsl:variable>
        <UML2:CallAction xmi.id="{@xmi.id}" name="{$name}" visibility="public">
            <xsl:if test="UML:ModelElement.comment/UML:Comment">
                <xsl:copy-of select="UML:ModelElement.comment"/>
            </xsl:if>
            <UML2:CallAction.value>
                <xsl:call-template name="insertOpaqueExpression">
                    <xsl:with-param name="callAction" select="$call-action/UML:Action.script/UML:ActionExpression"/>
                </xsl:call-template>
            </UML2:CallAction.value>
            <xsl:apply-templates select="child::node()" mode="innerActionElements"/>
        </UML2:CallAction>
    </xsl:template>
    <xsl:template match="UML:ActionState" mode="activityElement">
        <UML2:CallAction xmi.idref="{@xmi.idref}"/>
    </xsl:template>
    <!-- UML:ObjectFlowState -->
    <xsl:template match="UML:ObjectFlowState" mode="activityGraph">
        <UML2:Pin xmi.id="{@xmi.id}" name="{@name}" visibility="public" isControlType="false" ordering="FIFO" isOrdered="false" isUnique="true"
                  upper="1" lower="1" isControl="false">
            <UML2:TypedElement.type>
                <xsl:variable name="classifilerInState-xmi.idref" select="UML:ObjectFlowState.type/UML:ClassifierInState/@xmi.idref"/>
                <xsl:variable name="classifilerInState" select="//UML:ClassifierInState[@xmi.id=$classifilerInState-xmi.idref]"/>
                <xsl:copy-of select="$classifilerInState/UML:ClassifierInState.type/UML:DataType"/>
            </UML2:TypedElement.type>
            <UML2:ObjectNode.upperBound>
                <UML2:OpaqueExpression name="" visibility="public" isSpecification="true" body="" language="java">
                    <xsl:call-template name="add-xmi-id-attribute"/>
                </UML2:OpaqueExpression>
            </UML2:ObjectNode.upperBound>
            <UML2:MultiplicityElement.upperValue>
                <UML2:LiteralUnlimitedNatural name="" value="1" visibility="public" isSpecification="true">
                    <xsl:call-template name="add-xmi-id-attribute"/>
                </UML2:LiteralUnlimitedNatural>
            </UML2:MultiplicityElement.upperValue>
            <UML2:MultiplicityElement.lowerValue>
                <UML2:LiteralInteger name="" value="1" visibility="public" isSpecification="true">
                    <xsl:call-template name="add-xmi-id-attribute"/>
                </UML2:LiteralInteger>
            </UML2:MultiplicityElement.lowerValue>
            <xsl:apply-templates select="child::node()" mode="innerActionElements"/>
        </UML2:Pin>
    </xsl:template>
    <xsl:template match="UML:ObjectFlowState" mode="activityElement">
        <UML2:Pin xmi.idref="{@xmi.idref}"/>
    </xsl:template>
    <xsl:template match="/XMI/XMI.content/UML:FinalState[@xmi.id]">
        <xsl:apply-templates select="." mode="activityGraph"/>
    </xsl:template>
    <!-- UML:FinalState -->
    <xsl:template match="UML:FinalState" mode="activityGraph">
        <UML2:ActivityFinalNode xmi.id="{@xmi.id}" name="{@name}" visibility="public">
            <xsl:apply-templates select="child::node()" mode="innerActionElements"/>
        </UML2:ActivityFinalNode>
    </xsl:template>
    <xsl:template match="UML:FinalState" mode="activityElement">
        <UML2:ActivityFinalNode xmi.idref="{@xmi.idref}"/>
    </xsl:template>
    <!-- UML:Pseudostate:  -->
    <xsl:template match="UML:Pseudostate" mode="activityElement">
        <xsl:variable name="pseudostate" select="key('pseudostates', @xmi.idref)"/>
        <xsl:call-template name="createRefElement">
            <xsl:with-param name="name">
                <xsl:call-template name="getPseudostateName">
                    <xsl:with-param name="pseudostate" select="$pseudostate"/>
                </xsl:call-template>
            </xsl:with-param>
            <xsl:with-param name="element" select="."/>
        </xsl:call-template>
    </xsl:template>
    <xsl:template match="UML:Pseudostate" mode="activityGraph">
        <xsl:call-template name="createElement">
            <xsl:with-param name="name">
                <xsl:call-template name="getPseudostateName">
                    <xsl:with-param name="pseudostate" select="."/>
                </xsl:call-template>
            </xsl:with-param>
            <xsl:with-param name="element" select="."/>
        </xsl:call-template>
    </xsl:template>
    <xsl:template name="getPseudostateName">
        <xsl:param name="pseudostate"/>
        <xsl:choose>
            <xsl:when test="$pseudostate/@kind = 'initial'">UML2:InitialNode</xsl:when>
            <xsl:when test="$pseudostate/@kind = 'junction'">UML2:DecisionNode</xsl:when>
            <xsl:when test="$pseudostate/@kind = 'fork'">UML2:ForkNode</xsl:when>
            <xsl:when test="$pseudostate/@kind = 'join'">UML2:JoinNode</xsl:when>
        </xsl:choose>
    </xsl:template>
    <xsl:template name="createRefElement">
        <xsl:param name="name"/>
        <xsl:param name="element"/>
        <xsl:element name="{$name}">
            <xsl:copy-of select="$element/@xmi.idref"/>
        </xsl:element>
    </xsl:template>
    <xsl:template name="createElement">
        <xsl:param name="name"/>
        <xsl:param name="element"/>
        <xsl:element name="{$name}">
            <xsl:copy-of select="$element/@xmi.id"/>
            <xsl:copy-of select="$element/@name"/>
            <xsl:attribute name="visibility">public</xsl:attribute>
            <xsl:apply-templates select="child::node()" mode="innerActionElements"/>
        </xsl:element>
    </xsl:template>
    <!-- Transitions -->
    <xsl:template match="UML:Transition" mode="activityElement">
        <UML2:ActivityEdge xmi.idref="{@xmi.idref}"/>
    </xsl:template>
    <xsl:template match="UML:Transition" mode="activityGraph">
        <UML2:ActivityEdge xmi.id="{@xmi.id}" name="{@name}" visibility="public">
            <UML2:ActivityEdge.source>
                <xsl:apply-templates mode="activityElement" select="UML:Transition.source/*"/>
            </UML2:ActivityEdge.source>
            <UML2:ActivityEdge.target>
                <xsl:apply-templates mode="activityElement" select="UML:Transition.target/*"/>
            </UML2:ActivityEdge.target>
            <xsl:if test="UML:Transition.guard">
                <UML2:ActivityEdge.guard>
                    <xsl:call-template name="insertOpaqueExpression">
                        <xsl:with-param name="callAction" select="UML:Transition.guard/UML:Guard/UML:Guard.expression/UML:BooleanExpression"/>
                        <xsl:with-param name="elementWithName" select="UML:Transition.guard/UML:Guard"/>
                    </xsl:call-template>
                </UML2:ActivityEdge.guard>
            </xsl:if>
            <xsl:apply-templates select="child::node()" mode="innerActionElements"/>
        </UML2:ActivityEdge>
    </xsl:template>
    <xsl:template match="UML:StateVertex.outgoing" mode="innerActionElements">
        <UML2:ActivityNode.outgoingEdge>
            <UML2:ActivityEdge xmi.idref="{UML:Transition/@xmi.idref}"/>
        </UML2:ActivityNode.outgoingEdge>
    </xsl:template>
    <xsl:template match="UML:StateVertex.incoming" mode="innerActionElements">
        <UML2:ActivityNode.incomingEdge>
            <UML2:ActivityEdge xmi.idref="{UML:Transition/@xmi.idref}"/>
        </UML2:ActivityNode.incomingEdge>
    </xsl:template>
    <!-- tagged values -->
    <xsl:template match="UML:CallAction/UML:ModelElement.taggedValue" mode="innerActionElements"/>
    <xsl:template match="UML:Guard/UML:ModelElement.taggedValue" mode="innerActionElements"/>
    <xsl:template match="UML:ModelElement.taggedValue" mode="innerActionElements" priority="-1">
        <xsl:copy-of select="."/>
    </xsl:template>
    <!-- Stereotype for elements -->
    <xsl:template match="UML:CallAction/UML:ModelElement.stereotype" mode="innerActionElements"/>
    <xsl:template match="UML:Guard/UML:ModelElement.stereotype" mode="innerActionElements"/>
    <xsl:template match="UML:ModelElement.stereotype" mode="innerActionElements" priority="-1">
        <xsl:copy-of select="."/>
    </xsl:template>
    <!-- Comments -->
    <xsl:template match="UML:Comment" mode="activityElement">
        <xsl:copy-of select="."/>
    </xsl:template>
    <!-- Delete moved comments -->
    <!--<xsl:template match="//UML:Namespace.ownedElement/UML:Comment[key('moved-comments', @xmi.id)]"/>-->
    <!-- Constraints -->
    <xsl:template
            match="/XMI/XMI.content/UML:Constraint/UML:Constraint.constrainedElement[UML:ActionState|UML:ObjectFlowState|UML:FinalState|UML:Pseudostate|UML:Transition]">
        <UML:Constraint.constrainedElement>
            <xsl:apply-templates select="child::node()" mode="activityElement"/>
        </UML:Constraint.constrainedElement>
    </xsl:template>
    <!-- Remove unessary di structure-->
    <xsl:template
            match="UML:GraphNode[UML:GraphElement.semanticModel/UML:Uml1SemanticModelBridge/UML:Uml1SemanticModelBridge.element/UML:ActionState]/UML:GraphElement.contained/*"
            mode="activityDiagram"/>

    <xsl:template
            match="UML:GraphNode[UML:GraphElement.semanticModel/UML:Uml1SemanticModelBridge/UML:Uml1SemanticModelBridge.element/UML:Pseudostate]/UML:GraphElement.contained/*"
            mode="activityDiagram"/>

    <xsl:template
            match="UML:GraphNode[UML:GraphElement.semanticModel/UML:Uml1SemanticModelBridge/UML:Uml1SemanticModelBridge.element/UML:FinalState]/UML:GraphElement.contained/*"
            mode="activityDiagram"/>

    <xsl:template
            match="UML:GraphNode[UML:GraphElement.semanticModel/UML:Uml1SemanticModelBridge/UML:Uml1SemanticModelBridge.element/UML:ObjectFlowState]/UML:GraphElement.contained/*"
            mode="activityDiagram"/>

    <xsl:template
            match="//UML:GraphEdge[UML:GraphElement.semanticModel/UML:Uml1SemanticModelBridge/UML:Uml1SemanticModelBridge.element/UML:Transition]/UML:GraphElement.contained/*"
            mode="activityDiagram"/>

</xsl:transform>
