<?xml version="1.0" encoding="ISO-8859-1"?>
<!--
Copyright (c) 2003-2005
Gentleware AG, Ludwigstrae 12, 20357 Hamburg, Germany
-->

<xsl:transform version="1.0" xmlns:UML="org.omg.xmi.namespace.UML" xmlns:UML2="org.omg.xmi.namespace.UML2"
               xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

    <xsl:template match="UML:StateMachine/UML:StateMachine.top/UML:CompositeState//UML:CompositeState">
        <xsl:element name="UML2:State">
            <xsl:apply-templates select="@*"/>

            <xsl:element name="UML2:State.region">
                <xsl:apply-templates select="." mode="region"/>
            </xsl:element>

            <xsl:apply-templates/>
        </xsl:element>
    </xsl:template>

    <xsl:template match="UML:StateMachine/UML:StateMachine.top/UML:CompositeState//UML:CompositeState[not(UML:CompositeState.subvertex)]"
                  mode="region">
        <xsl:apply-templates select="." mode="concurrentStateConversion">
            <xsl:with-param name="xmiId">
                <xsl:call-template name="generateXmiId"/>
            </xsl:with-param>
        </xsl:apply-templates>
    </xsl:template>

    <!-- is this really necessary? -->
    <xsl:template match="UML:StateMachine/UML:StateMachine.top/UML:CompositeState//UML:CompositeState[UML:CompositeState.subvertex]" mode="region">
        <xsl:apply-templates mode="region"/>
    </xsl:template>

    <!-- Converting Composite States -->
    <xsl:template
            match="UML:StateMachine/UML:StateMachine.top/UML:CompositeState//UML:CompositeState[@isConcurrent = 'false']/UML:CompositeState.subvertex"
            mode="region">
        <xsl:variable name="generatedXmiId">
            <xsl:call-template name="generateXmiId"/>
        </xsl:variable>

        <xsl:element name="UML2:Region">
            <xsl:attribute name="visibility">public</xsl:attribute>
            <xsl:attribute name="isSpecification">false</xsl:attribute>

            <xsl:attribute name="xmi.id">
                <xsl:value-of select="$generatedXmiId"/>
            </xsl:attribute>

            <xsl:attribute name="name">
                <xsl:text>region_</xsl:text>
                <xsl:value-of select="$generatedXmiId"/>
            </xsl:attribute>

            <xsl:element name="UML2:Region.subvertex">
                <xsl:apply-templates/>
            </xsl:element>
        </xsl:element>
    </xsl:template>

    <!-- Concurrent States -->
    <xsl:template
            match="UML:StateMachine/UML:StateMachine.top/UML:CompositeState//UML:CompositeState[@isConcurrent = 'true']/UML:CompositeState.subvertex"
            mode="region">
        <xsl:apply-templates select="UML:CompositeState" mode="concurrentStateConversion"/>
    </xsl:template>

    <!--xsl:template match="UML:Uml1SemanticModelBridge.element/UML:CompositeState">
        <xsl:element name="UML2:State">
            <xsl:attribute name="xmi.idref">
                <xsl:value-of select="@xmi.idref"/>
            </xsl:attribute>
        </xsl:element>
    </xsl:template-->

    <xsl:template match="UML:StateMachine//UML:CompositeState" mode="concurrentStateConversion">
        <xsl:param name="xmiId" select="@xmi.id"/>
        <xsl:element name="UML2:Region">
            <xsl:apply-templates select="@*"/>
            <xsl:attribute name="xmi.id">
                <xsl:value-of select="$xmiId"/>
            </xsl:attribute>
            <!--xsl:attribute name="name">
                <xsl:text>region_generated_</xsl:text>
                <xsl:value-of select="local-name()"/>
            </xsl:attribute-->
            <xsl:apply-templates select="UML:CompositeState.subvertex" mode="concurrentStateConversion"/>
        </xsl:element>
    </xsl:template>

    <xsl:template match="UML:StateMachine//UML:CompositeState.subvertex"/>

    <xsl:template match="UML:StateMachine//UML:CompositeState.subvertex" mode="concurrentStateConversion">
        <xsl:element name="UML2:Region.subvertex">
            <xsl:apply-templates/>
        </xsl:element>
    </xsl:template>

    <xsl:template match="UML:StateMachine//UML:CompositeState/@isConcurrent"/>

    <!-- [POS-4408] Default template rule for processing text elements which will be copied
    to the output if no substate exists of a composite states or a concurrent state-->
    <xsl:template match="text()" mode="region"/>

</xsl:transform>
