<?xml version="1.0" encoding="ISO-8859-1"?>

<!--
Copyright (c) 2003-2005
Gentleware AG, Ludwigstra�e 12, 20357 Hamburg, Germany
-->
<xsl:transform version="1.0" xmlns:UML="org.omg.xmi.namespace.UML" xmlns:UML2="org.omg.xmi.namespace.UML2"
               xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

    <xsl:template match="UML:Model/UML:Namespace.ownedElement">
        <xsl:copy>
            <xsl:call-template name="rearrageTaggedDefinitions"/>
            <xsl:apply-templates/>
        </xsl:copy>
    </xsl:template>

    <xsl:key
            match="/XMI/XMI.content//UML:Namespace.ownedElement//UML2:BehavioredClassifier.ownedBehavior//UML2:StateMachine//UML:TagDefinition/UML:TagDefinition"
            name="tagDefinition" use="@name"/>

    <xsl:template name="rearrageTaggedDefinitions">
        <!--xsl:apply-templates select="/XMI/XMI.content/UML:StateMachine//UML:TagDefinition/UML:TagDefinition"
            mode="modelCopy"/-->

        <!-- During the first proccessing it could be possible that more than on tag definition for the
                    same definition is created. We need to filter these-->
        <xsl:for-each
                select="/XMI/XMI.content//UML:Namespace.ownedElement//UML2:BehavioredClassifier.ownedBehavior//UML2:StateMachine//UML:TagDefinition/UML:TagDefinition">
            <xsl:variable name="xmiId" select="@xmi.id"/>
            <xsl:for-each select="key('tagDefinition', @name)">
                <xsl:if test="position() = 1 and @xmi.id = $xmiId">
                    <!-- Only copy the first generated tag definition node, leave all the others -->
                    <xsl:copy-of select="."/>
                </xsl:if>

            </xsl:for-each>
        </xsl:for-each>
    </xsl:template>

    <xsl:template match="UML:TagDefinition[@xmi.idref and UML:TagDefinition[@xmi.id]]">
        <xsl:copy>
            <xsl:attribute name="xmi.idref">
                <!-- select the xmi.id of the first generated tag definition wiht name=@name-->
                <!-- All other will be omited see template rule above-->
                <xsl:value-of select="key('tagDefinition', UML:TagDefinition/@name)[1]/@xmi.id"/>
            </xsl:attribute>
        </xsl:copy>
    </xsl:template>

    <!--
    '<' = '&lt'
    -->
    <xsl:template match="UML:Classifier.feature[count(child::*) &lt; 1]"/>

</xsl:transform>
