<?xml version="1.0" encoding="ISO-8859-1"?>
<!--
Copyright (c) 2003-2005
Gentleware AG, Ludwigstra�e 12, 20357 Hamburg, Germany
-->

<xsl:transform version="1.0" xmlns:UML="org.omg.xmi.namespace.UML" xmlns:UML2="org.omg.xmi.namespace.UML2"
               xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
    <!--xsl:import href="utilities.xsl"/-->

    <xsl:template match="UML:StateMachine">
        <xsl:apply-templates select="." mode="stateMachine"/>
    </xsl:template>

    <xsl:template match="UML:StateMachine" mode="stateMachine">
        <xsl:element name="UML2:StateMachine">
            <!--xsl:copy-of select="key('classXmiIdRef', @xmi.id)/../../@*"/-->
            <xsl:copy-of select="@*"/>
            <xsl:apply-templates mode="stateMachine"/>
        </xsl:element>
    </xsl:template>

    <xsl:template match="UML:StateMachine//UML:StateMachine.context" mode="stateMachine"/>

    <xsl:template match="UML:StateMachine/UML:StateMachine.top" mode="stateMachine">
        <xsl:element name="UML2:StateMachine.region">
            <xsl:apply-templates mode="stateMachine"/>
        </xsl:element>
    </xsl:template>

    <!-- Converting the statemachine top element-->
    <xsl:template match="UML:StateMachine/UML:StateMachine.top/UML:CompositeState" mode="stateMachine">
        <xsl:element name="UML2:Region">
            <xsl:apply-templates select="@*"/>
            <xsl:attribute name="name">
                <xsl:text>region_generated_</xsl:text>
                <xsl:value-of select="local-name()"/>
            </xsl:attribute>

            <xsl:apply-templates mode="stateMachine"/>

            <xsl:element name="UML2:Region.transition">
                <xsl:apply-templates select="../../UML:StateMachine.transitions/*"/>
                <xsl:apply-templates select=".//UML:State.internalTransition/*"/>
            </xsl:element>
        </xsl:element>
    </xsl:template>

    <xsl:template match="UML:StateMachine//UML:CompositeState/UML:CompositeState.subvertex" mode="stateMachine">
        <xsl:element name="UML2:Region.subvertex">
            <xsl:apply-templates/>
        </xsl:element>
    </xsl:template>

    <xsl:template match="XMI/XMI.content/UML:StateMachine | XMI/XMI.content/UML:Model//UML:Namespace.ownedElement/UML:StateMachine"/>

    <xsl:template match="node()" mode="stateMachine">
        <xsl:apply-templates select="."/>
    </xsl:template>
</xsl:transform>
