<?xml version="1.0" encoding="ISO-8859-1"?>
<!--
Copyright (c) 2003-2005
Gentleware AG, Ludwigstra�e 12, 20357 Hamburg, Germany
-->

<xsl:transform version="1.0" xmlns:UML="org.omg.xmi.namespace.UML" xmlns:UML2="org.omg.xmi.namespace.UML2"
               xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

    <!-- Key for accessing the guards xmi id -->
    <xsl:key match="/XMI/XMI.content/UML:StateMachine/UML:StateMachine.transitions/UML:Transition/UML:Transition.guard/UML:Guard |
										/XMI/XMI.content/UML:StateMachine/UML:StateMachine.top//UML:State.internalTransition/UML:Transition/UML:Transition.guard/UML:Guard"
             name="guardXmiId" use="@xmi.id"/>

    <!-- Process the Gaurd references: -->
    <xsl:template match="UML:Guard[@xmi.idref]">
        <xsl:choose>
            <!-- If the xmi.id is existant -that means the guard is subelement of a transition-
                     convert also the guard otherwise just do a copy of elements-->
            <xsl:when test="key('guardXmiId', @xmi.idref)">
                <xsl:call-template name="renameGuardAndProcessChilds"/>
            </xsl:when>

            <xsl:otherwise>
                <xsl:copy>
                    <xsl:copy-of select="@*"/>
                    <xsl:apply-templates/>
                </xsl:copy>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>

    <xsl:template name="renameGuardAndProcessChilds">
        <!--xsl:param name="node"/-->
        <xsl:element name="UML2:Constraint">
            <!-- Copy attributes: -->
            <xsl:apply-templates select="@*"/>
            <xsl:apply-templates mode="guard"/>

        </xsl:element>
    </xsl:template>

    <!-- xsl:template match="UML:StateMachine.transitions/UML:-->
    <!-- Process the Guard itself -->
    <xsl:template match="UML:Transition.guard/UML:Guard" mode="guard">
        <xsl:call-template name="renameGuardAndProcessChilds"/>
        <!--xsl:with-param name="node" select ="."/>
    </xsl:call-template-->
    </xsl:template>

    <xsl:template match="UML:Transition.guard/UML:Guard/UML:Guard.expression" mode="guard">
        <xsl:element name="UML2:Constraint.specification">
            <xsl:apply-templates mode="guard"/>
        </xsl:element>
    </xsl:template>

    <xsl:template match="UML:Transition.guard/UML:Guard/UML:Guard.expression/UML:BooleanExpression" mode="guard">
        <xsl:element name="UML2:OpaqueExpression">
            <!-- Copy attributes: -->
            <xsl:apply-templates select="@*"/>
        </xsl:element>
    </xsl:template>

    <!-- Default template for elements which are not matching the above rules. -->
    <xsl:template match="*" mode="guard" priority="-20">
        <xsl:copy>
            <xsl:call-template name="apply-others"/>
        </xsl:copy>
    </xsl:template>

</xsl:transform>
