#!/bin/bash
#
# Copyright (c) 2004
# Gentleware AG, Ludwigstr. 12, 20357 Hamburg, Germany
#
# Script requires bash v2.0 and above (for one-dimensional arrays)
#
# Script automatically generated by Ant. Don't modify directly.

# For debugging purpose activate the following:
# set -vx

ulimit -s 2048
declare -a JAVA_ARGS
declare -a JAVA_TRAILING_ARGS

# the next line is for the installer:
# it replaces this comment with a command to set POSEIDON_HOME to the install folder
#SET_POSEIDON_HOME_COMMAND

exists() {
        if [ -z `type -t "$1"` ] ; then
                echo ""
        else
                echo "ok"
        fi
}

pushTrailingArg() {
    if [[ ! (-z "${1}")]] ; then
        JAVA_TRAILING_ARGS_SIZE=${#JAVA_TRAILING_ARGS[*]}
        JAVA_TRAILING_ARGS[$JAVA_TRAILING_ARGS_SIZE]="${1}"
    fi
}

pushArg() {
    if [[ ! (-z "${1}")]] ; then
        JAVA_ARGS_SIZE=${#JAVA_ARGS[*]}
        JAVA_ARGS[$JAVA_ARGS_SIZE]="${1}"
    fi
}

resolvePath() {
    cmd="`basename "${1}"`"
    dir="`dirname "${1}"`"
    cd "$dir"

    while [ -h "$cmd" ]; do
        link="`ls -l "$cmd" | cut -d\> -f2 | cut -c2-`"
        cmd="`basename "$link"`"
        dir="`dirname "$link"`"
        cd "$dir"
    done

    echo `pwd -P`/$cmd
}

 checkJavaHome() {
     if [ -z "${JAVA_HOME}" ] ; then
         if [ -d "${POSEIDON_HOME}/jre" ] ; then
             echo "No JAVA_HOME set, using the installed JRE."
             JAVA_HOME="${POSEIDON_HOME}/jre"
         else
 	       JAVA_EXECUTABLE=`which java`
 	       if [ -x $JAVA_EXECUTABLE ] ; then
 	           JAVA_HOME=${JAVA_EXECUTABLE/\/bin\/java/}
 	       else
                 echo "Could not find a JDK."
                 echo "Either you have to install JDK 1.4 (or up),"
                 echo "or you have to set JAVA_HOME to your JDK installation directory."
                 exit
             fi
         fi
     fi
     echo "Found JAVA_HOME to be \"${JAVA_HOME}\"."
}

# You must not change to the script-directory before parsing the arguments
chdirToScriptDir() {
    MY_COMMAND="`resolvePath "${0}"`"
    echo "Absolute path: ${MY_COMMAND}"
    INSTALLATION_DIRECTORY="`dirname "${MY_COMMAND}"`"
    if [ -z "${POSEIDON_HOME}" ] ; then
        cd "${INSTALLATION_DIRECTORY}"
        cd ..
        export POSEIDON_HOME="`pwd -P`"
    fi
    cd "${INSTALLATION_DIRECTORY}"
}

setJavaCommand() {
    JAVA_COMMAND="$JAVA_HOME/bin/java"
    export JAVA_COMMAND
}

addJavaArgs() {
    # increase memory here, if required (e. g. -Xmx512m)
    pushArg -Xms64m
    pushArg -Xmx384m
    pushArg -Dorg.xml.sax.driver=org.apache.xerces.parsers.SAXParser
    pushArg "-Xdock:name=Poseidon for UML"
}

addJavaMain() {
    pushArg "com.gentleware.poseidon.Poseidon"
}

addJavaMainArgs() {
    pushArg "${POSEIDON_PROJECT_TO_LOAD}"
}

addJavaProperties() {
    pushArg "-Dposeidon.user.dir.CE=${POSEIDONCE_HOME}"
    pushArg "-Dposeidon.java.home=${JAVA_HOME}"
    pushArg "-Djava.net.preferIPv4Stack=true"
}

# Best: Parse arguments before everything else is done, because it relies on the current working directory to
# resolve paths
parseArguments() {
    POSEIDON_PROJECT_TO_LOAD=
    export POSEIDON_PROJECT_TO_LOAD

    # Copy all other args
    for arg in "$@"
    do
        pushTrailingArg "$arg"
    done
}

setJavaClasspath() {
    CLASSPATH="../lib/poseidon2.jar:../lib/uml14.jar:../lib/printing.jar:../lib/wmf_export.jar:../lib/concurrent_license_server.jar"
    CLASSPATH="${CLASSPATH}:${JAVA_HOME}/jre/lib/rt.jar" # for compilation

    export CLASSPATH
}

main() {
    # Take care when changing the order of the following calls, as they might depend on each other. Parsing arguments
    # is the first thing which needs to be done.
    if [ `exists parseArguments` ] ; then
        parseArguments "${@}"
    fi

    chdirToScriptDir

    if [ `exists hookAfterChdirToScriptDir` ] ; then
        hookAfterChdirToScriptDir
    fi
    if [ `exists addJavaArgs` ] ; then
        addJavaArgs
    fi
    if [ `exists addJavaProperties` ] ; then
        addJavaProperties
    fi
    if [ `exists addJavaMain` ] ; then
        addJavaMain
    fi
    if [ `exists addJavaMainArgs` ] ; then
        addJavaMainArgs
    fi

    checkJavaHome
    setJavaCommand

    if [ `exists setJavaClasspath` ] ; then
        setJavaClasspath
    fi

    if [ `exists initBeforeCommand` ] ; then
        initBeforeCommand
    fi


    if [ `exists doAfterCommand` ] ; then
        "${JAVA_COMMAND}" "${JAVA_ARGS[@]}" "${JAVA_TRAILING_ARGS[@]}" &
        doAfterCommand
    else
        echo "${JAVA_COMMAND}" "${JAVA_ARGS[@]}" "${JAVA_TRAILING_ARGS[@]}"
        "${JAVA_COMMAND}" "${JAVA_ARGS[@]}" "${JAVA_TRAILING_ARGS[@]}"
    fi
}

main "${@}"
