// Persistence Of Vision raytracer sample file.

// Teapot.inc - #include file for teapot.pov
// Bezier patch definition of the utah Teapot
// Adapted by Alexander Enzmann

// Updated: 09Aug2008 (jh) for v3.7 distribution
// Updated: 28Sep2008 (cjc): change Flat_Enough to 0.0001 (was 0.01) and fix error in one patch (line 179).

#declare Flat_Enough = 0.0001;

union { // The teapot
   bicubic_patch { type 1 flatness Flat_Enough u_steps 5 v_steps 5
         <1.40000, 0.00000, 2.40000> <1.40000, -0.78400, 2.40000> <0.78400, -1.40000, 2.40000> <0.00000, -1.40000, 2.40000>
         <1.33750, 0.00000, 2.53125> <1.33750, -0.74900, 2.53125> <0.74900, -1.33750, 2.53125> <0.00000, -1.33750, 2.53125>
         <1.43750, 0.00000, 2.53125> <1.43750, -0.80500, 2.53125> <0.80500, -1.43750, 2.53125> <0.00000, -1.43750, 2.53125>
         <1.50000, 0.00000, 2.40000> <1.50000, -0.84000, 2.40000> <0.84000, -1.50000, 2.40000> <0.00000, -1.50000, 2.40000>

      texture { Teapot_Texture }
   }

   bicubic_patch { type 1 flatness Flat_Enough u_steps 5 v_steps 5
         <0.00000, -1.40000, 2.40000> <-0.78400, -1.40000, 2.40000> <-1.40000, -0.78400, 2.40000> <-1.40000, 0.00000, 2.40000>
         <0.00000, -1.33750, 2.53125> <-0.74900, -1.33750, 2.53125> <-1.33750, -0.74900, 2.53125> <-1.33750, 0.00000, 2.53125>
         <0.00000, -1.43750, 2.53125> <-0.80500, -1.43750, 2.53125> <-1.43750, -0.80500, 2.53125> <-1.43750, 0.00000, 2.53125>
         <0.00000, -1.50000, 2.40000> <-0.84000, -1.50000, 2.40000> <-1.50000, -0.84000, 2.40000> <-1.50000, 0.00000, 2.40000>

      texture { Teapot_Texture }
   }

   bicubic_patch { type 1 flatness Flat_Enough u_steps 5 v_steps 5
         <-1.40000, 0.00000, 2.40000> <-1.40000, 0.78400, 2.40000> <-0.78400, 1.40000, 2.40000> <0.00000, 1.40000, 2.40000>
         <-1.33750, 0.00000, 2.53125> <-1.33750, 0.74900, 2.53125> <-0.74900, 1.33750, 2.53125> <0.00000, 1.33750, 2.53125>
         <-1.43750, 0.00000, 2.53125> <-1.43750, 0.80500, 2.53125> <-0.80500, 1.43750, 2.53125> <0.00000, 1.43750, 2.53125>
         <-1.50000, 0.00000, 2.40000> <-1.50000, 0.84000, 2.40000> <-0.84000, 1.50000, 2.40000> <0.00000, 1.50000, 2.40000>

      texture { Teapot_Texture }
   }

   bicubic_patch { type 1 flatness Flat_Enough u_steps 5 v_steps 5
         <0.00000, 1.40000, 2.40000> <0.78400, 1.40000, 2.40000> <1.40000, 0.78400, 2.40000> <1.40000, 0.00000, 2.40000>
         <0.00000, 1.33750, 2.53125> <0.74900, 1.33750, 2.53125> <1.33750, 0.74900, 2.53125> <1.33750, 0.00000, 2.53125>
         <0.00000, 1.43750, 2.53125> <0.80500, 1.43750, 2.53125> <1.43750, 0.80500, 2.53125> <1.43750, 0.00000, 2.53125>
         <0.00000, 1.50000, 2.40000> <0.84000, 1.50000, 2.40000> <1.50000, 0.84000, 2.40000> <1.50000, 0.00000, 2.40000>

      texture { Teapot_Texture }
   }

   bicubic_patch { type 1 flatness Flat_Enough u_steps 5 v_steps 5
         <1.50000, 0.00000, 2.40000> <1.50000, -0.84000, 2.40000> <0.84000, -1.50000, 2.40000> <0.00000, -1.50000, 2.40000>
         <1.75000, 0.00000, 1.87500> <1.75000, -0.98000, 1.87500> <0.98000, -1.75000, 1.87500> <0.00000, -1.75000, 1.87500>
         <2.00000, 0.00000, 1.35000> <2.00000, -1.12000, 1.35000> <1.12000, -2.00000, 1.35000> <0.00000, -2.00000, 1.35000>
         <2.00000, 0.00000, 0.90000> <2.00000, -1.12000, 0.90000> <1.12000, -2.00000, 0.90000> <0.00000, -2.00000, 0.90000>

      texture { Teapot_Texture }
   }

   bicubic_patch { type 1 flatness Flat_Enough u_steps 5 v_steps 5
         <0.00000, -1.50000, 2.40000> <-0.84000, -1.50000, 2.40000> <-1.50000, -0.84000, 2.40000> <-1.50000, 0.00000, 2.40000>
         <0.00000, -1.75000, 1.87500> <-0.98000, -1.75000, 1.87500> <-1.75000, -0.98000, 1.87500> <-1.75000, 0.00000, 1.87500>
         <0.00000, -2.00000, 1.35000> <-1.12000, -2.00000, 1.35000> <-2.00000, -1.12000, 1.35000> <-2.00000, 0.00000, 1.35000>
         <0.00000, -2.00000, 0.90000> <-1.12000, -2.00000, 0.90000> <-2.00000, -1.12000, 0.90000> <-2.00000, 0.00000, 0.90000>

      texture { Teapot_Texture }
   }

   bicubic_patch { type 1 flatness Flat_Enough u_steps 5 v_steps 5
         <-1.50000, 0.00000, 2.40000> <-1.50000, 0.84000, 2.40000> <-0.84000, 1.50000, 2.40000> <0.00000, 1.50000, 2.40000>
         <-1.75000, 0.00000, 1.87500> <-1.75000, 0.98000, 1.87500> <-0.98000, 1.75000, 1.87500> <0.00000, 1.75000, 1.87500>
         <-2.00000, 0.00000, 1.35000> <-2.00000, 1.12000, 1.35000> <-1.12000, 2.00000, 1.35000> <0.00000, 2.00000, 1.35000>
         <-2.00000, 0.00000, 0.90000> <-2.00000, 1.12000, 0.90000> <-1.12000, 2.00000, 0.90000> <0.00000, 2.00000, 0.90000>

      texture { Teapot_Texture }
   }

   bicubic_patch { type 1 flatness Flat_Enough u_steps 5 v_steps 5
         <0.00000, 1.50000, 2.40000> <0.84000, 1.50000, 2.40000> <1.50000, 0.84000, 2.40000> <1.50000, 0.00000, 2.40000>
         <0.00000, 1.75000, 1.87500> <0.98000, 1.75000, 1.87500> <1.75000, 0.98000, 1.87500> <1.75000, 0.00000, 1.87500>
         <0.00000, 2.00000, 1.35000> <1.12000, 2.00000, 1.35000> <2.00000, 1.12000, 1.35000> <2.00000, 0.00000, 1.35000>
         <0.00000, 2.00000, 0.90000> <1.12000, 2.00000, 0.90000> <2.00000, 1.12000, 0.90000> <2.00000, 0.00000, 0.90000>

      texture { Teapot_Texture }
   }

   bicubic_patch { type 1 flatness Flat_Enough u_steps 5 v_steps 5
         <2.00000, 0.00000, 0.90000> <2.00000, -1.12000, 0.90000> <1.12000, -2.00000, 0.90000> <0.00000, -2.00000, 0.90000>
         <2.00000, 0.00000, 0.45000> <2.00000, -1.12000, 0.45000> <1.12000, -2.00000, 0.45000> <0.00000, -2.00000, 0.45000>
         <1.50000, 0.00000, 0.22500> <1.50000, -0.84000, 0.22500> <0.84000, -1.50000, 0.22500> <0.00000, -1.50000, 0.22500>
         <1.50000, 0.00000, 0.15000> <1.50000, -0.84000, 0.15000> <0.84000, -1.50000, 0.15000> <0.00000, -1.50000, 0.15000>

      texture { Teapot_Texture }
   }

   bicubic_patch { type 1 flatness Flat_Enough u_steps 5 v_steps 5
         <0.00000, -2.00000, 0.90000> <-1.12000, -2.00000, 0.90000> <-2.00000, -1.12000, 0.90000> <-2.00000, 0.00000, 0.90000>
         <0.00000, -2.00000, 0.45000> <-1.12000, -2.00000, 0.45000> <-2.00000, -1.12000, 0.45000> <-2.00000, 0.00000, 0.45000>
         <0.00000, -1.50000, 0.22500> <-0.84000, -1.50000, 0.22500> <-1.50000, -0.84000, 0.22500> <-1.50000, 0.00000, 0.22500>
         <0.00000, -1.50000, 0.15000> <-0.84000, -1.50000, 0.15000> <-1.50000, -0.84000, 0.15000> <-1.50000, 0.00000, 0.15000>

      texture { Teapot_Texture }
   }

   bicubic_patch { type 1 flatness Flat_Enough u_steps 5 v_steps 5
         <-2.00000, 0.00000, 0.90000> <-2.00000, 1.12000, 0.90000> <-1.12000, 2.00000, 0.90000> <0.00000, 2.00000, 0.90000>
         <-2.00000, 0.00000, 0.45000> <-2.00000, 1.12000, 0.45000> <-1.12000, 2.00000, 0.45000> <0.00000, 2.00000, 0.45000>
         <-1.50000, 0.00000, 0.22500> <-1.50000, 0.84000, 0.22500> <-0.84000, 1.50000, 0.22500> <0.00000, 1.50000, 0.22500>
         <-1.50000, 0.00000, 0.15000> <-1.50000, 0.84000, 0.15000> <-0.84000, 1.50000, 0.15000> <0.00000, 1.50000, 0.15000>

      texture { Teapot_Texture }
   }

   bicubic_patch { type 1 flatness Flat_Enough u_steps 5 v_steps 5
         <0.00000, 2.00000, 0.90000> <1.12000, 2.00000, 0.90000> <2.00000, 1.12000, 0.90000> <2.00000, 0.00000, 0.90000>
         <0.00000, 2.00000, 0.45000> <1.12000, 2.00000, 0.45000> <2.00000, 1.20000, 0.45000> <2.00000, 0.00000, 0.45000>
         <0.00000, 1.50000, 0.22500> <0.84000, 1.50000, 0.22500> <1.50000, 0.84000, 0.22500> <1.50000, 0.00000, 0.22500>
         <0.00000, 1.50000, 0.15000> <0.84000, 1.50000, 0.15000> <1.50000, 0.84000, 0.15000> <1.50000, 0.00000, 0.15000>

      texture { Teapot_Texture }
   }

   bicubic_patch { type 1 flatness Flat_Enough u_steps 5 v_steps 5
         <-1.60000, 0.00000, 2.02500> <-1.60000, -0.30000, 2.02500> <-1.50000, -0.30000, 2.25000> <-1.50000, 0.00000, 2.25000>
         <-2.30000, 0.00000, 2.02500> <-2.30000, -0.30000, 2.02500> <-2.50000, -0.30000, 2.25000> <-2.50000, 0.00000, 2.25000>
         <-2.70000, 0.00000, 2.02500> <-2.70000, -0.30000, 2.02500> <-3.00000, -0.30000, 2.25000> <-3.00000, 0.00000, 2.25000>
         <-2.70000, 0.00000, 1.80000> <-2.70000, -0.30000, 1.80000> <-3.00000, -0.30000, 1.80000> <-3.00000, 0.00000, 1.80000>

      texture { Teapot_Texture }
   }

   bicubic_patch { type 1 flatness Flat_Enough u_steps 5 v_steps 5
         <-1.50000, 0.00000, 2.25000> <-1.50000, 0.30000, 2.25000> <-1.60000, 0.30000, 2.02500> <-1.60000, 0.00000, 2.02500>
         <-2.50000, 0.00000, 2.25000> <-2.50000, 0.30000, 2.25000> <-2.30000, 0.30000, 2.02500> <-2.30000, 0.00000, 2.02500>
         <-3.00000, 0.00000, 2.25000> <-3.00000, 0.30000, 2.25000> <-2.70000, 0.30000, 2.02500> <-2.70000, 0.00000, 2.02500>
         <-3.00000, 0.00000, 1.80000> <-3.00000, 0.30000, 1.80000> <-2.70000, 0.30000, 1.80000> <-2.70000, 0.00000, 1.80000>

      texture { Teapot_Texture }
   }

   bicubic_patch { type 1 flatness Flat_Enough u_steps 5 v_steps 5
         <-2.70000, 0.00000, 1.80000> <-2.70000, -0.30000, 1.80000> <-3.00000, -0.30000, 1.80000> <-3.00000, 0.00000, 1.80000>
         <-2.70000, 0.00000, 1.57500> <-2.70000, -0.30000, 1.57500> <-3.00000, -0.30000, 1.35000> <-3.00000, 0.00000, 1.35000>
         <-2.50000, 0.00000, 1.12500> <-2.50000, -0.30000, 1.12500> <-2.65000, -0.30000, 0.93750> <-2.65000, 0.00000, 0.93750>
         <-2.00000, 0.00000, 0.90000> <-2.00000, -0.30000, 0.90000> <-1.90000, -0.30000, 0.60000> <-1.90000, 0.00000, 0.60000>

      texture { Teapot_Texture }
   }

   bicubic_patch { type 1 flatness Flat_Enough u_steps 5 v_steps 5
         <-3.00000, 0.00000, 1.80000> <-3.00000, 0.30000, 1.80000> <-2.70000, 0.30000, 1.80000> <-2.70000, 0.00000, 1.80000>
         <-3.00000, 0.00000, 1.35000> <-3.00000, 0.30000, 1.35000> <-2.70000, 0.30000, 1.57500> <-2.70000, 0.00000, 1.57500>
         <-2.65000, 0.00000, 0.93750> <-2.65000, 0.30000, 0.93750> <-2.50000, 0.30000, 1.12500> <-2.50000, 0.00000, 1.12500>
         <-1.90000, 0.00000, 0.60000> <-1.90000, 0.30000, 0.60000> <-2.00000, 0.30000, 0.90000> <-2.00000, 0.00000, 0.90000>

      texture { Teapot_Texture }
   }

   bicubic_patch { type 1 flatness Flat_Enough u_steps 5 v_steps 5
         <1.70000, 0.00000, 1.42500> <1.70000, -0.66000, 1.42500> <1.70000, -0.66000, 0.60000> <1.70000, 0.00000, 0.60000>
         <2.60000, 0.00000, 1.42500> <2.60000, -0.66000, 1.42500> <3.10000, -0.66000, 0.82500> <3.10000, 0.00000, 0.82500>
         <2.30000, 0.00000, 2.10000> <2.30000, -0.25000, 2.10000> <2.40000, -0.25000, 2.02500> <2.40000, 0.00000, 2.02500>
         <2.70000, 0.00000, 2.40000> <2.70000, -0.25000, 2.40000> <3.30000, -0.25000, 2.40000> <3.30000, 0.00000, 2.40000>

      texture { Teapot_Texture }
   }

   bicubic_patch { type 1 flatness Flat_Enough u_steps 5 v_steps 5
         <1.70000, 0.00000, 0.60000> <1.70000, 0.66000, 0.60000> <1.70000, 0.66000, 1.42500> <1.70000, 0.00000, 1.42500>
         <3.10000, 0.00000, 0.82500> <3.10000, 0.66000, 0.82500> <2.60000, 0.66000, 1.42500> <2.60000, 0.00000, 1.42500>
         <2.40000, 0.00000, 2.02500> <2.40000, 0.25000, 2.02500> <2.30000, 0.25000, 2.10000> <2.30000, 0.00000, 2.10000>
         <3.30000, 0.00000, 2.40000> <3.30000, 0.25000, 2.40000> <2.70000, 0.25000, 2.40000> <2.70000, 0.00000, 2.40000>

      texture { Teapot_Texture }
   }

   bicubic_patch { type 1 flatness Flat_Enough u_steps 5 v_steps 5
         <2.70000, 0.00000, 2.40000> <2.70000, -0.25000, 2.40000> <3.30000, -0.25000, 2.40000> <3.30000, 0.00000, 2.40000>
         <2.80000, 0.00000, 2.47500> <2.80000, -0.25000, 2.47500> <3.52500, -0.25000, 2.49375> <3.52500, 0.00000, 2.49375>
         <2.90000, 0.00000, 2.47500> <2.90000, -0.15000, 2.47500> <3.45000, -0.15000, 2.51250> <3.45000, 0.00000, 2.51250>
         <2.80000, 0.00000, 2.40000> <2.80000, -0.15000, 2.40000> <3.20000, -0.15000, 2.40000> <3.20000, 0.00000, 2.40000>

      texture { Teapot_Texture }
   }

   bicubic_patch { type 1 flatness Flat_Enough u_steps 5 v_steps 5
         <3.30000, 0.00000, 2.40000> <3.30000, 0.25000, 2.40000> <2.70000, 0.25000, 2.40000> <2.70000, 0.00000, 2.40000>
         <3.52500, 0.00000, 2.49375> <3.52500, 0.25000, 2.49375> <2.80000, 0.25000, 2.47500> <2.80000, 0.00000, 2.47500>
         <3.45000, 0.00000, 2.51250> <3.45000, 0.15000, 2.51250> <2.90000, 0.15000, 2.47500> <2.90000, 0.00000, 2.47500>
         <3.20000, 0.00000, 2.40000> <3.20000, 0.15000, 2.40000> <2.80000, 0.15000, 2.40000> <2.80000, 0.00000, 2.40000>

      texture { Teapot_Texture }
   }

   bicubic_patch { type 1 flatness Flat_Enough u_steps 5 v_steps 5
         <0.00000, 0.00000, 3.15000> <0.00000, 0.00000, 3.15000> <0.00000, 0.00000, 3.15000> <0.00000, 0.00000, 3.15000>
         <0.80000, 0.00000, 3.15000> <0.80000, -0.45000, 3.15000> <0.45000, -0.80000, 3.15000> <0.00000, -0.80000, 3.15000>
         <0.00000, 0.00000, 2.85000> <0.00000, 0.00000, 2.85000> <0.00000, 0.00000, 2.85000> <0.00000, 0.00000, 2.85000>
         <0.20000, 0.00000, 2.70000> <0.20000, -0.11200, 2.70000> <0.11200, -0.20000, 2.70000> <0.00000, -0.20000, 2.70000>

      texture { Teapot_Texture }
   }

   bicubic_patch { type 1 flatness Flat_Enough u_steps 5 v_steps 5
         <0.00000, 0.00000, 3.15000> <0.00000, 0.00000, 3.15000> <0.00000, 0.00000, 3.15000> <0.00000, 0.00000, 3.15000>
         <0.00000, -0.80000, 3.15000> <-0.45000, -0.80000, 3.15000> <-0.80000, -0.45000, 3.15000> <-0.80000, 0.00000, 3.15000>
         <0.00000, 0.00000, 2.85000> <0.00000, 0.00000, 2.85000> <0.00000, 0.00000, 2.85000> <0.00000, 0.00000, 2.85000>
         <0.00000, -0.20000, 2.70000> <-0.11200, -0.20000, 2.70000> <-0.20000, -0.11200, 2.70000> <-0.20000, 0.00000, 2.70000>

      texture { Teapot_Texture }
   }

   bicubic_patch { type 1 flatness Flat_Enough u_steps 5 v_steps 5
         <0.00000, 0.00000, 3.15000> <0.00000, 0.00000, 3.15000> <0.00000, 0.00000, 3.15000> <0.00000, 0.00000, 3.15000>
         <-0.80000, 0.00000, 3.15000> <-0.80000, 0.45000, 3.15000> <-0.45000, 0.80000, 3.15000> <0.00000, 0.80000, 3.15000>
         <0.00000, 0.00000, 2.85000> <0.00000, 0.00000, 2.85000> <0.00000, 0.00000, 2.85000> <0.00000, 0.00000, 2.85000>
         <-0.20000, 0.00000, 2.70000> <-0.20000, 0.11200, 2.70000> <-0.11200, 0.20000, 2.70000> <0.00000, 0.20000, 2.70000>

      texture { Teapot_Texture }
   }

   bicubic_patch { type 1 flatness Flat_Enough u_steps 5 v_steps 5
         <0.00000, 0.00000, 3.15000> <0.00000, 0.00000, 3.15000> <0.00000, 0.00000, 3.15000> <0.00000, 0.00000, 3.15000>
         <0.00000, 0.80000, 3.15000> <0.45000, 0.80000, 3.15000> <0.80000, 0.45000, 3.15000> <0.80000, 0.00000, 3.15000>
         <0.00000, 0.00000, 2.85000> <0.00000, 0.00000, 2.85000> <0.00000, 0.00000, 2.85000> <0.00000, 0.00000, 2.85000>
         <0.00000, 0.20000, 2.70000> <0.11200, 0.20000, 2.70000> <0.20000, 0.11200, 2.70000> <0.20000, 0.00000, 2.70000>

      texture { Teapot_Texture }
   }

   bicubic_patch { type 1 flatness Flat_Enough u_steps 5 v_steps 5
         <0.20000, 0.00000, 2.70000> <0.20000, -0.11200, 2.70000> <0.11200, -0.20000, 2.70000> <0.00000, -0.20000, 2.70000>
         <0.40000, 0.00000, 2.55000> <0.40000, -0.22400, 2.55000> <0.22400, -0.40000, 2.55000> <0.00000, -0.40000, 2.55000>
         <1.30000, 0.00000, 2.55000> <1.30000, -0.72800, 2.55000> <0.72800, -1.30000, 2.55000> <0.00000, -1.30000, 2.55000>
         <1.30000, 0.00000, 2.40000> <1.30000, -0.72800, 2.40000> <0.72800, -1.30000, 2.40000> <0.00000, -1.30000, 2.40000>

      texture { Teapot_Texture }
   }

   bicubic_patch { type 1 flatness Flat_Enough u_steps 5 v_steps 5
         <0.00000, -0.20000, 2.70000> <-0.11200, -0.20000, 2.70000> <-0.20000, -0.11200, 2.70000> <-0.20000, 0.00000, 2.70000>
         <0.00000, -0.40000, 2.55000> <-0.22400, -0.40000, 2.55000> <-0.40000, -0.22400, 2.55000> <-0.40000, 0.00000, 2.55000>
         <0.00000, -1.30000, 2.55000> <-0.72800, -1.30000, 2.55000> <-1.30000, -0.72800, 2.55000> <-1.30000, 0.00000, 2.55000>
         <0.00000, -1.30000, 2.40000> <-0.72800, -1.30000, 2.40000> <-1.30000, -0.72800, 2.40000> <-1.30000, 0.00000, 2.40000>

      texture { Teapot_Texture }
   }

   bicubic_patch { type 1 flatness Flat_Enough u_steps 5 v_steps 5
         <-0.20000, 0.00000, 2.70000> <-0.20000, 0.11200, 2.70000> <-0.11200, 0.20000, 2.70000> <0.00000, 0.20000, 2.70000>
         <-0.40000, 0.00000, 2.55000> <-0.40000, 0.22400, 2.55000> <-0.22400, 0.40000, 2.55000> <0.00000, 0.40000, 2.55000>
         <-1.30000, 0.00000, 2.55000> <-1.30000, 0.72800, 2.55000> <-0.72800, 1.30000, 2.55000> <0.00000, 1.30000, 2.55000>
         <-1.30000, 0.00000, 2.40000> <-1.30000, 0.72800, 2.40000> <-0.72800, 1.30000, 2.40000> <0.00000, 1.30000, 2.40000>

      texture { Teapot_Texture }
   }

   bicubic_patch { type 1 flatness Flat_Enough u_steps 5 v_steps 5
         <0.00000, 0.20000, 2.70000> <0.11200, 0.20000, 2.70000> <0.20000, 0.11200, 2.70000> <0.20000, 0.00000, 2.70000>
         <0.00000, 0.40000, 2.55000> <0.22400, 0.40000, 2.55000> <0.40000, 0.22400, 2.55000> <0.40000, 0.00000, 2.55000>
         <0.00000, 1.30000, 2.55000> <0.72800, 1.30000, 2.55000> <1.30000, 0.72800, 2.55000> <1.30000, 0.00000, 2.55000>
         <0.00000, 1.30000, 2.40000> <0.72800, 1.30000, 2.40000> <1.30000, 0.72800, 2.40000> <1.30000, 0.00000, 2.40000>

      texture { Teapot_Texture }
   }

   bicubic_patch { type 1 flatness Flat_Enough u_steps 5 v_steps 5
         <0.00000, 0.00000, 0.00000> <0.00000, 0.00000, 0.00000> <0.00000, 0.00000, 0.00000> <0.00000, 0.00000, 0.00000>
         <1.42500, 0.00000, 0.00000> <1.42500, 0.79800, 0.00000> <0.79800, 1.42500, 0.00000> <0.00000, 1.42500, 0.00000>
         <1.50000, 0.00000, 0.07500> <1.50000, 0.84000, 0.07500> <0.84000, 1.50000, 0.07500> <0.00000, 1.50000, 0.07500>
         <1.50000, 0.00000, 0.15000> <1.50000, 0.84000, 0.15000> <0.84000, 1.50000, 0.15000> <0.00000, 1.50000, 0.15000>

      texture { Teapot_Texture }
   }

   bicubic_patch { type 1 flatness Flat_Enough u_steps 5 v_steps 5
         <0.00000, 0.00000, 0.00000> <0.00000, 0.00000, 0.00000> <0.00000, 0.00000, 0.00000> <0.00000, 0.00000, 0.00000>
         <0.00000, 1.42500, 0.00000> <-0.79800, 1.42500, 0.00000> <-1.42500, 0.79800, 0.00000> <-1.42500, 0.00000, 0.00000>
         <0.00000, 1.50000, 0.07500> <-0.84000, 1.50000, 0.07500> <-1.50000, 0.84000, 0.07500> <-1.50000, 0.00000, 0.07500>
         <0.00000, 1.50000, 0.15000> <-0.84000, 1.50000, 0.15000> <-1.50000, 0.84000, 0.15000> <-1.50000, 0.00000, 0.15000>

      texture { Teapot_Texture }
   }

   bicubic_patch { type 1 flatness Flat_Enough u_steps 5 v_steps 5
         <0.00000, 0.00000, 0.00000> <0.00000, 0.00000, 0.00000> <0.00000, 0.00000, 0.00000> <0.00000, 0.00000, 0.00000>
         <-1.42500, 0.00000, 0.00000> <-1.42500, -0.79800, 0.00000> <-0.79800, -1.42500, 0.00000> <0.00000, -1.42500, 0.00000>
         <-1.50000, 0.00000, 0.07500> <-1.50000, -0.84000, 0.07500> <-0.84000, -1.50000, 0.07500> <0.00000, -1.50000, 0.07500>
         <-1.50000, 0.00000, 0.15000> <-1.50000, -0.84000, 0.15000> <-0.84000, -1.50000, 0.15000> <0.00000, -1.50000, 0.15000>

      texture { Teapot_Texture }
   }

   bicubic_patch { type 1 flatness Flat_Enough u_steps 5 v_steps 5
         <0.00000, 0.00000, 0.00000> <0.00000, 0.00000, 0.00000> <0.00000, 0.00000, 0.00000> <0.00000, 0.00000, 0.00000>
         <0.00000, -1.42500, 0.00000> <0.79800, -1.42500, 0.00000> <1.42500, -0.79800, 0.00000> <1.42500, 0.00000, 0.00000>
         <0.00000, -1.50000, 0.07500> <0.84000, -1.50000, 0.07500> <1.50000, -0.84000, 0.07500> <1.50000, 0.00000, 0.07500>
         <0.00000, -1.50000, 0.15000> <0.84000, -1.50000, 0.15000> <1.50000, -0.84000, 0.15000> <1.50000, 0.00000, 0.15000>

      texture { Teapot_Texture }
   }

   rotate Teapot_Orientation
}
