// Persistence of Vision Ray Tracer Scene Description File
// File: subsurface.pov
// Vers: 3.7
// Desc: Subsurface Scattering Demo - Candle on a Checkered Plane
// Date: 2009-04-04
// Auth: Christoph Lipka
//
// Recommended settings:
//  +W640 +H480 +A0.3
// Rendering time:
//  ~4 min on a 2.3GHz AMD Phenom X4 9650 QuadCore

#version 3.7;

#include "colors.inc"

global_settings {
  assumed_gamma 2.2
  mm_per_unit 40
  subsurface { samples 400, 40 }
}

// ----------------------------------------

camera {
  location  <0.0, 2.5, -4.0>
  direction 1.5*z
  right     x*image_width/image_height
  look_at   <0.5, 1.0,  0.0>
}

sky_sphere {
  pigment {
    gradient y
    color_map {
      [0.0 rgb <0.6,0.7,1.0>]
      [0.7 rgb <0.0,0.1,0.8>]
    }
  }
}

light_source {
  <-30, 30, -30>
  color rgb <1,1,1>
}

// ----------------------------------------

// a checkered white marble / grey "plastic" plane
plane {
  y, -0.01
  texture {
    checker
    texture {
      pigment { color rgb 1 }
      finish{
        specular 0.6
        reflection { 0.2 }
        // marble physical parameters from Jensen et al. "A Practical Model for Subsurface Light Transport", Siggraph 2001
        subsurface { <2.19,2.62,3.00>,<0.0021, 0.0041, 0.0071> }
      }
    }
    texture {
      pigment { color rgb 1 }
      finish{
        specular 0.6
        diffuse 0.9
        reflection { 0.2 }
      }
    }
    scale 4
    translate <0.7,0,1>
  }
  interior { ior 1.5 }
}

// the classic chrome sphere
sphere { <1.5,0.7,1>, 0.7
  pigment { color rgb 1 }
  finish {
    ambient 0 diffuse 0
    specular 0.7  roughness 0.01
    reflection { 0.7 metallic }
  }
}

// a candle...
blob {
  threshold 0.5
  cylinder { <0.0, 0.0,  0.0>,
             <0.0, 2.0,  0.0>,  1.0,   1.0 } // candle "body"
  sphere   { <0.0, 2.5,  0.0>,  0.8,  -2.0 } // (used to shape the candle top)
  sphere   { <0.0,-0.52, 0.0>,  0.8,  -2.0 } // (used to shape the candle bottom)
  sphere   { <0.0, 2.0, -0.5>,  0.1,  -0.2 } // the "notch" where wax runs over
  cylinder { <0.0, 1.88,-0.52>,
             <0.0, 1.5, -0.52>, 0.05,  0.2 } // a streak of wax running over
  sphere   { <0.0, 1.5, -0.55>, 0.07,  0.2 } // a drop of of wax running over
  texture {
    pigment { color rgb 1 }
    finish{
      specular 0.6 roughness 0.1
      // "artificial" wax parameters
      subsurface { < 1.6732, 1.2806, 0.6947>,< 0.0005, 0.0018, 0.0131> }
    }
  }
  interior { ior 1.45 }
  rotate -y*45
}

// ... and the wick
intersection {
  box { <-1,-1,-1>, <0,1,1> }
  torus { 0.15, 0.03 }
  rotate x*90
  translate <0.15, 1.95, 0.0>
  pigment { color rgb 0 }
  finish { ambient 0 diffuse 1 specular 0 }
}
