/*******************************************************************************
 * vfe.h
 *
 * Author: Christopher J. Cason
 *
 * from Persistence of Vision Ray Tracer ('POV-Ray') version 3.7.
 * Copyright 2005-2008 Persistence of Vision Raytracer Pty. Ltd.
 * ---------------------------------------------------------------------------
 * NOTICE: This source code file is provided so that users may experiment
 * with enhancements to POV-Ray and to port the software to platforms other
 * than those supported by the POV-Ray developers. There are strict rules
 * regarding how you are permitted to use this file. These rules are contained
 * in the distribution and derivative versions licenses which should have been
 * provided with this file.
 *
 * These licences may be found online, linked from the end-user license
 * agreement that is located at http://www.povray.org/povlegal.html
 * ---------------------------------------------------------------------------
 * POV-Ray is based on the popular DKB raytracer version 2.12.
 * DKBTrace was originally written by David K. Buck.
 * DKBTrace Ver 2.0-2.12 were written by David K. Buck & Aaron A. Collins.
 * ---------------------------------------------------------------------------
 * $File: //depot/povray/smp/vfe/vfe.h $
 * $Revision: #17 $
 * $Change: 5261 $
 * $DateTime: 2010/12/14 06:50:20 $
 * $Author: chrisc $
 *******************************************************************************/

/*********************************************************************************
 * NOTICE
 *
 * This file is part of a BETA-TEST version of POV-Ray version 3.7. It is not
 * final code. Use of this source file is governed by both the standard POV-Ray
 * licences referred to in the copyright header block above this notice, and the
 * following additional restrictions numbered 1 through 4 below:
 *
 *   1. This source file may not be re-distributed without the written permission
 *      of Persistence of Vision Raytracer Pty. Ltd.
 *
 *   2. This notice may not be altered or removed.
 *   
 *   3. Binaries generated from this source file by individuals for their own
 *      personal use may not be re-distributed without the written permission
 *      of Persistence of Vision Raytracer Pty. Ltd. Such personal-use binaries
 *      are not required to have a timeout, and thus permission is granted in
 *      these circumstances only to disable the timeout code contained within
 *      the beta software.
 *   
 *   4. Binaries generated from this source file for use within an organizational
 *   	unit (such as, but not limited to, a company or university) may not be
 *      distributed beyond the local organizational unit in which they were made,
 *      unless written permission is obtained from Persistence of Vision Raytracer
 *      Pty. Ltd. Additionally, the timeout code implemented within the beta may
 *      not be disabled or otherwise bypassed in any manner.
 *
 * The following text is not part of the above conditions and is provided for
 * informational purposes only.
 *
 * The purpose of the no-redistribution clause is to attempt to keep the
 * circulating copies of the beta source fresh. The only authorized distribution
 * point for the source code is the POV-Ray website and Perforce server, where
 * the code will be kept up to date with recent fixes. Additionally the beta
 * timeout code mentioned above has been a standard part of POV-Ray betas since
 * version 1.0, and is intended to reduce bug reports from old betas as well as
 * keep any circulating beta binaries relatively fresh.
 *
 * All said, however, the POV-Ray developers are open to any reasonable request
 * for variations to the above conditions and will consider them on a case-by-case
 * basis.
 *
 * Additionally, the developers request your co-operation in fixing bugs and
 * generally improving the program. If submitting a bug-fix, please ensure that
 * you quote the revision number of the file shown above in the copyright header
 * (see the '$Revision:' field). This ensures that it is possible to determine
 * what specific copy of the file you are working with. The developers also would
 * like to make it known that until POV-Ray 3.7 is out of beta, they would prefer
 * to emphasize the provision of bug fixes over the addition of new features.
 *
 * Persons wishing to enhance this source are requested to take the above into
 * account. It is also strongly suggested that such enhancements are started with
 * a recent copy of the source.
 *
 * The source code page (see http://www.povray.org/beta/source/) sets out the
 * conditions under which the developers are willing to accept contributions back
 * into the primary source tree. Please refer to those conditions prior to making
 * any changes to this source, if you wish to submit those changes for inclusion
 * with POV-Ray.
 *
 *********************************************************************************/

#ifndef __VFE_H__
#define __VFE_H__

#include <cassert>

#include "syspovconfigfrontend.h"
#include <boost/format.hpp>
#include <boost/thread.hpp>
#include <boost/thread/condition.hpp>
#include <boost/bind.hpp>
#include <boost/function.hpp>
#include "base/povms.h"
#include "base/povmsgid.h"
#include "base/platformbase.h"
#include "base/timer.h"
#include "base/image/colourspace.h"
#include "frontend/console.h"
#include "frontend/simplefrontend.h"
#include "frontend/processrenderoptions.h"
#include "vfesession.h"
#include "vfeplatform.h"
#include "vfepovms.h"

namespace vfe
{
  using namespace pov_frontend;

  class vfeException : public runtime_error
  {
    public:
      vfeException() : runtime_error("") {}
      vfeException(const string str) : runtime_error(str) {}
      virtual ~vfeException() throw() {}
  } ;

  class vfeCriticalError : public vfeException
  {
    public:
      vfeCriticalError() : m_Line(0), vfeException() {}
      vfeCriticalError(const string str) : m_Line(0), vfeException(str) {}
      vfeCriticalError(const string str, const string filename, int line) :
        vfeException(str), m_Filename(filename), m_Line(line) {}
      virtual ~vfeCriticalError() throw() {}

      const string Filename() { return m_Filename; }
      int Line() { return m_Line; }

      const string m_Filename;
      const int m_Line;
  };

  class vfeInvalidDataError : public vfeCriticalError
  {
    public:
      vfeInvalidDataError(const string str) : vfeCriticalError(str) {}
      virtual ~vfeInvalidDataError() throw() {}
  };

  class vfeConsole : public Console
  {
    public:
      vfeConsole(vfeSession *session, int width = -1);
      virtual ~vfeConsole();

      virtual void Initialise();
      virtual void Output(const string&);
      virtual void Output(const string&, vfeSession::MessageType mType);
      virtual void Output(const char *str, vfeSession::MessageType mType = vfeSession::mUnclassified);
      virtual void BufferOutput(const char *str, unsigned int chars = 0, vfeSession::MessageType mType = vfeSession::mUnclassified);

    protected:
      char buffer [8192];
      char rawBuffer [16384] ;

      vfeSession* m_Session;
  };

  class vfePlatformBase : public PlatformBase
  {
    public:
      vfePlatformBase();
      vfePlatformBase(vfeSession& session);
      virtual ~vfePlatformBase();

      virtual pov_base::IStream *CreateIStream(const unsigned int stype);
      virtual pov_base::OStream *CreateOStream(const unsigned int stype);

      virtual UCS2String GetTemporaryPath(void);
      virtual UCS2String CreateTemporaryFile(void);
      virtual void DeleteTemporaryFile(const UCS2String& filename);
      virtual bool ReadFileFromURL(OStream *file, const UCS2String& url, const UCS2String& referrer = UCS2String());

    protected:
      vfeSession* m_Session;
  };

  class vfeParserMessageHandler : public ParserMessageHandler
  {
    public:
      vfeParserMessageHandler();
      virtual ~vfeParserMessageHandler();

    protected:
      virtual void Options(Console *, POVMS_Object&, bool);
      virtual void Statistics(Console *, POVMS_Object&, bool);
      virtual void Progress(Console *, POVMS_Object&, bool);
      virtual void Warning(Console *, POVMS_Object&, bool);
      virtual void Error(Console *, POVMS_Object&, bool);
      virtual void FatalError(Console *, POVMS_Object&, bool);
      virtual void DebugInfo(Console *, POVMS_Object&, bool);

      vfeSession* m_Session;
  };

  class vfeRenderMessageHandler : public RenderMessageHandler
  {
    public:
      vfeRenderMessageHandler();
      virtual ~vfeRenderMessageHandler();

    protected:
      virtual void Options(Console *, POVMS_Object&, bool);
      virtual void Statistics(Console *, POVMS_Object&, bool);
      virtual void Progress(Console *, POVMS_Object&, bool);
      virtual void Warning(Console *, POVMS_Object&, bool);
      virtual void Error(Console *, POVMS_Object&, bool);
      virtual void FatalError(Console *, POVMS_Object&, bool);

      vfeSession *m_Session;
  };

  class vfeProcessRenderOptions : public ProcessRenderOptions
  {
    public:
      vfeProcessRenderOptions(vfeSession *);
      virtual ~vfeProcessRenderOptions();

    protected:
      virtual int ReadSpecialOptionHandler(INI_Parser_Table *, char *, POVMSObjectPtr);
      virtual int ReadSpecialSwitchHandler(Cmd_Parser_Table *, char *, POVMSObjectPtr, bool);
      virtual int WriteSpecialOptionHandler(INI_Parser_Table *, POVMSObjectPtr, OTextStream *);
      virtual bool WriteOptionFilter(INI_Parser_Table *);
      virtual int ProcessUnknownString(char *, POVMSObjectPtr);
      virtual ITextStream *OpenFileForRead(const char *, POVMSObjectPtr);
      virtual OTextStream *OpenFileForWrite(const char *, POVMSObjectPtr);
      virtual void ParseError (const char *, ...);
      virtual void ParseErrorAt (ITextStream *, const char *, ...);
      virtual void WriteError (const char *, ...);

    protected:
      vfeSession* m_Session;
  };

  class vfeDisplay : public Display
  {
    public:
      vfeDisplay(unsigned int width, unsigned int height, GammaCurvePtr gamma, vfeSession *session, bool visible = false);
      virtual ~vfeDisplay();

      virtual void Initialise();
      virtual void Close();
      virtual void Show();
      virtual void Hide();
      virtual void DrawPixel(unsigned int x, unsigned int y, const RGBA8& colour);
      virtual void DrawRectangleFrame(unsigned int x1, unsigned int y1, unsigned int x2, unsigned int y2, const RGBA8& colour);
      virtual void DrawFilledRectangle(unsigned int x1, unsigned int y1, unsigned int x2, unsigned int y2, const RGBA8& colour);
      virtual void DrawPixelBlock(unsigned int x1, unsigned int y1, unsigned int x2, unsigned int y2, const RGBA8 *colour);
      virtual void Clear();

    protected:
      vfeSession *m_Session;
      vector<RGBA8> m_Pixels;
      bool m_VisibleOnCreation;
  };

  class VirtualFrontEnd
  {
    public:
      VirtualFrontEnd(vfeSession& session, POVMSContext ctx, POVMSAddress addr, POVMS_Object& msg, POVMS_Object *result, shared_ptr<Console>& console) ;
      virtual ~VirtualFrontEnd() ;

      virtual bool Start(POVMS_Object& opts) ;
      virtual bool Stop() ;
      virtual bool Pause() ;
      virtual bool Resume() ;
      virtual State Process() ;
      virtual State GetState() const { return state; }
      virtual void SetResultPointers(Console **cr, Image **ir, Display **dr) ;
      virtual bool IsPausable() ;
      virtual bool Paused() ;
      virtual bool PausePending() { return m_PauseRequested; }
      virtual boost::shared_ptr<Display> GetDisplay() { return renderFrontend.GetDisplay(viewId); }

      // TODO: take care of any pending messages (e.g. a thread waiting on a blocking send)
      virtual void InvalidateBackend() { backendAddress = POVMSInvalidAddress; }

    protected:
      virtual Console *CreateConsole()
        { return new vfeConsole(m_Session, m_Session->GetConsoleWidth()); }
      virtual Display *CreateDisplay(unsigned int width, unsigned int height, GammaCurvePtr gamma)
        { return m_Session->CreateDisplay(width, height, gamma) ; }
      bool HandleShelloutCancel();

      RenderFrontend<vfeParserMessageHandler,FileMessageHandler,vfeRenderMessageHandler,ImageMessageHandler> renderFrontend;
      POVMSAddress backendAddress;
      State state;
      POVMS_Object options;
      RenderFrontendBase::SceneId sceneId;
      RenderFrontendBase::ViewId viewId;
      shared_ptr<AnimationProcessing> animationProcessing ;
      shared_ptr<ImageProcessing> imageProcessing ;
      shared_ptr<ShelloutProcessing> shelloutProcessing;
      Console **consoleResult;
      Display **displayResult;
      vfeSession* m_Session;
      vfePlatformBase m_PlatformBase;
      bool m_PausedAfterFrame;
      bool m_PauseRequested;
      State m_PostPauseState;
  };
}

#endif
