/*
 * Decompiled with CFR 0.152.
 */
package povtree.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.UIManager;
import povtree.gui.EnterListener;
import povtree.gui.FloatSliderChangeListener;
import povtree.gui.Helper;
import povtree.gui.ImageAccessor;
import povtree.gui.ImageFilter;
import povtree.gui.Resources;
import povtree.gui.plaf.ButtonUI;
import povtree.gui.plaf.ColorChooser;
import povtree.gui.plaf.GradientPanel;
import povtree.gui.plaf.LabelTip;
import povtree.gui.plaf.LabelUI;
import povtree.interfaces.Constants;
import povtree.interfaces.Paintable;
import povtree.objects.Bark;

public class BarkPanel
extends JPanel
implements Constants,
Paintable {
    private JSlider widthSlider = new JSlider(0, 1000000, 0);
    private JSlider heightSlider = new JSlider(0, 1000000, 0);
    private JSlider depthSlider = new JSlider(-500000, 500000, 0);
    private JSlider shrinkXSlider = new JSlider(0, 500000, 0);
    private JSlider shrinkYSlider = new JSlider(0, 500000, 0);
    private JSlider atEndSlider = new JSlider(0, 100000, 0);
    private JSlider palmSlider = new JSlider(0, 100000, 0);
    private JSlider profileValueSlider = new JSlider(0, 1000000, 0);
    private JSlider branchChangeSlider = new JSlider(0, 200000, 0);
    private JSlider rootChangeSlider = new JSlider(0, 200000, 0);
    private JSlider taperSlider = new JSlider(0, 1000000, 0);
    private JTextField foliageAtEnd = new JTextField(7);
    private JTextField width = new JTextField(7);
    private JTextField height = new JTextField(7);
    private JTextField depth = new JTextField(7);
    private JTextField horizontalShrinking = new JTextField(7);
    private JTextField verticalShrinking = new JTextField(7);
    private JTextField profile = new JTextField(7);
    private JTextField change = new JTextField(7);
    private JTextField taper = new JTextField(7);
    private JTextField rootChange = new JTextField(7);
    private JTextField palm = new JTextField(7);
    private JCheckBox useUv = null;
    private JTextField imageName = new JTextField(15);
    private JTextField bumpName = new JTextField(15);
    private JTextField bumpSize = new JTextField(3);
    private String currentPath = null;
    private JButton loadImage = new JButton("...");
    private JButton loadBump = new JButton("...");
    private JFileChooser fc = null;
    private Resources resources = Resources.getInstance();
    private ResourceBundle rb = Resources.getLabelsBundle();
    private ResourceBundle mb = Resources.getMessagesBundle();
    private String invalidNumber = this.mb.getString("invalidNumber");
    private String errorLabel = this.rb.getString("error");
    private ColorChooser sunkenColorChooser;
    private ColorChooser raisedColorChooser;

    public BarkPanel(String string) {
        this.useUv = new JCheckBox(this.rb.getString("useUvMapping"), false);
        this.useUv.setOpaque(false);
        this.loadImage.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                BarkPanel.this.load(0);
            }
        });
        this.loadBump.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                BarkPanel.this.load(1);
            }
        });
        this.width.addActionListener(new EnterListener(this.width, this.widthSlider, this, this.invalidNumber, this.errorLabel));
        this.widthSlider.addChangeListener(new FloatSliderChangeListener(this.width, this));
        this.height.addActionListener(new EnterListener(this.height, this.heightSlider, this, this.invalidNumber, this.errorLabel));
        this.heightSlider.addChangeListener(new FloatSliderChangeListener(this.height, this));
        this.depth.addActionListener(new EnterListener(this.depth, this.depthSlider, this, this.invalidNumber, this.errorLabel));
        this.depthSlider.addChangeListener(new FloatSliderChangeListener(this.depth, this));
        this.horizontalShrinking.addActionListener(new EnterListener(this.horizontalShrinking, this.shrinkXSlider, this, this.invalidNumber, this.errorLabel));
        this.shrinkXSlider.addChangeListener(new FloatSliderChangeListener(this.horizontalShrinking, this));
        this.verticalShrinking.addActionListener(new EnterListener(this.verticalShrinking, this.shrinkYSlider, this, this.invalidNumber, this.errorLabel));
        this.shrinkYSlider.addChangeListener(new FloatSliderChangeListener(this.verticalShrinking, this));
        this.foliageAtEnd.addActionListener(new EnterListener(this.foliageAtEnd, this.atEndSlider, this, this.invalidNumber, this.errorLabel));
        this.atEndSlider.addChangeListener(new FloatSliderChangeListener(this.foliageAtEnd, this));
        this.palm.addActionListener(new EnterListener(this.palm, this.palmSlider, this, this.invalidNumber, this.errorLabel));
        this.palmSlider.addChangeListener(new FloatSliderChangeListener(this.palm, this));
        this.profile.addActionListener(new EnterListener(this.profile, this.profileValueSlider, this, this.invalidNumber, this.errorLabel));
        this.profileValueSlider.addChangeListener(new FloatSliderChangeListener(this.profile, this));
        this.change.addActionListener(new EnterListener(this.change, this.branchChangeSlider, this, this.invalidNumber, this.errorLabel));
        this.branchChangeSlider.addChangeListener(new FloatSliderChangeListener(this.change, this));
        this.rootChange.addActionListener(new EnterListener(this.rootChange, this.rootChangeSlider, this, this.invalidNumber, this.errorLabel));
        this.rootChangeSlider.addChangeListener(new FloatSliderChangeListener(this.rootChange, this));
        this.taper.addActionListener(new EnterListener(this.taper, this.taperSlider, this, this.invalidNumber, this.errorLabel));
        this.taperSlider.addChangeListener(new FloatSliderChangeListener(this.taper, this));
        this.setLayout(new GridBagLayout());
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 1;
        this.sunkenColorChooser = new ColorChooser(this.rb.getString("sunkenColor"), this.rb.getString("red"), this.rb.getString("green"), this.rb.getString("blue"), this.mb.getString("wrongColorValue"), this.rb.getString("error"));
        gridBagConstraints.insets = new Insets(0, 0, 6, 6);
        this.sunkenColorChooser.setCompact(150);
        jPanel.add((Component)this.sunkenColorChooser, gridBagConstraints);
        ++gridBagConstraints.gridy;
        this.raisedColorChooser = new ColorChooser(this.rb.getString("raisedColor"), this.rb.getString("red"), this.rb.getString("green"), this.rb.getString("blue"), this.mb.getString("wrongColorValue"), this.rb.getString("error"));
        this.raisedColorChooser.setCompact(150);
        jPanel.add((Component)this.raisedColorChooser, gridBagConstraints);
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.fill = 0;
        GradientPanel gradientPanel = new GradientPanel(20, 10);
        gradientPanel.setLayout(new GridBagLayout());
        gradientPanel.setGradientDirection(2);
        gradientPanel.setRound(1);
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        LabelTip labelTip = new LabelTip(this.rb.getString("width"), true, "tipsBark", "TRUNK_SCAR_WIDTH", this, string);
        gradientPanel.add((Component)labelTip, gridBagConstraints);
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 1;
        this.widthSlider.setPreferredSize(new Dimension(150, 16));
        gradientPanel.add((Component)this.widthSlider, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gradientPanel.add((Component)this.width, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        labelTip = new LabelTip(this.rb.getString("height"), true, "tipsBark", "TRUNK_SCAR_HEIGHT", this, string);
        gradientPanel.add((Component)labelTip, gridBagConstraints);
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 1;
        this.heightSlider.setPreferredSize(new Dimension(150, 16));
        gradientPanel.add((Component)this.heightSlider, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gradientPanel.add((Component)this.height, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        labelTip = new LabelTip(this.rb.getString("depth"), true, "tipsBark", "SCAR_DEPTH", this, string);
        gradientPanel.add((Component)labelTip, gridBagConstraints);
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 1;
        this.depthSlider.setPreferredSize(new Dimension(150, 16));
        gradientPanel.add((Component)this.depthSlider, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gradientPanel.add((Component)this.depth, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        labelTip = new LabelTip(this.rb.getString("shrinkingX"), true, "tipsBark", "HORIZONTAL_SCAR_SHRINKING", this, string);
        gradientPanel.add((Component)labelTip, gridBagConstraints);
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 1;
        this.shrinkXSlider.setPreferredSize(new Dimension(150, 16));
        gradientPanel.add((Component)this.shrinkXSlider, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gradientPanel.add((Component)this.horizontalShrinking, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        labelTip = new LabelTip(this.rb.getString("shrinkingY"), true, "tipsBark", "VERTICAL_SCAR_SHRINKING", this, string);
        gradientPanel.add((Component)labelTip, gridBagConstraints);
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 1;
        this.shrinkYSlider.setPreferredSize(new Dimension(150, 16));
        gradientPanel.add((Component)this.shrinkYSlider, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gradientPanel.add((Component)this.verticalShrinking, gridBagConstraints);
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.add((Component)gradientPanel, "Center");
        GradientPanel gradientPanel2 = new GradientPanel(40, 20);
        gradientPanel2.setLayout(new GridBagLayout());
        gradientPanel2.setGradientDirection(2);
        gradientPanel2.setRound(0);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        JLabel jLabel = new JLabel(this.rb.getString("scar"));
        jLabel.setFont((Font)UIManager.get("TitledBorder.font"));
        jLabel.setForeground(Color.black);
        gradientPanel2.add((Component)jLabel, gridBagConstraints);
        jPanel2.add((Component)gradientPanel2, "North");
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 6);
        jPanel.add((Component)jPanel2, gridBagConstraints);
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 1;
        this.add((Component)jPanel, gridBagConstraints);
        gridBagConstraints.fill = 0;
        jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        GradientPanel gradientPanel3 = new GradientPanel(15, 15);
        gradientPanel3.setLayout(new GridBagLayout());
        gradientPanel3.setLayout(new GridBagLayout());
        gradientPanel3.setGradientDirection(2);
        gradientPanel3.setRound(2);
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        labelTip = new LabelTip(this.rb.getString("foliageAtBranchEnd"), true, "tipsBark", "FOLIAGE_COLOR_AT_BRANCH_END", this, string);
        gradientPanel3.add((Component)labelTip, gridBagConstraints);
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 1;
        this.atEndSlider.setPreferredSize(new Dimension(150, 16));
        gradientPanel3.add((Component)this.atEndSlider, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gradientPanel3.add((Component)this.foliageAtEnd, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        labelTip = new LabelTip(this.rb.getString("palm"), true, "tipsBark", "PALM_TRUNK", this, string);
        gradientPanel3.add((Component)labelTip, gridBagConstraints);
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 1;
        this.palmSlider.setPreferredSize(new Dimension(150, 16));
        gradientPanel3.add((Component)this.palmSlider, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gradientPanel3.add((Component)this.palm, gridBagConstraints);
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 0, 6, 0);
        jPanel.add((Component)gradientPanel3, gridBagConstraints);
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.fill = 0;
        GradientPanel gradientPanel4 = new GradientPanel(20, 10);
        gradientPanel4.setLayout(new GridBagLayout());
        gradientPanel4.setGradientDirection(2);
        gradientPanel4.setRound(1);
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        labelTip = new LabelTip(this.rb.getString("value"), true, "tipsBark", "BARK_PROFILE", this, string);
        gradientPanel4.add((Component)labelTip, gridBagConstraints);
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 1;
        this.profileValueSlider.setPreferredSize(new Dimension(150, 16));
        gradientPanel4.add((Component)this.profileValueSlider, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gradientPanel4.add((Component)this.profile, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        labelTip = new LabelTip(this.rb.getString("change"), true, "tipsBark", "BRANCH_BARK_PROFILE_CHANGE", this, string);
        gradientPanel4.add((Component)labelTip, gridBagConstraints);
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 1;
        this.branchChangeSlider.setPreferredSize(new Dimension(150, 16));
        gradientPanel4.add((Component)this.branchChangeSlider, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gradientPanel4.add((Component)this.change, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        labelTip = new LabelTip(this.rb.getString("rootChange"), true, "tipsBark", "ROOT_BARK_PROFILE_CHANGE", this, string);
        gradientPanel4.add((Component)labelTip, gridBagConstraints);
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 1;
        this.rootChangeSlider.setPreferredSize(new Dimension(150, 16));
        gradientPanel4.add((Component)this.rootChangeSlider, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gradientPanel4.add((Component)this.rootChange, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        labelTip = new LabelTip(this.rb.getString("taper"), true, "tipsBark", "BRANCH_BARK_PROFILE_TAPER_OFF", this, string);
        gradientPanel4.add((Component)labelTip, gridBagConstraints);
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 1;
        this.taperSlider.setPreferredSize(new Dimension(150, 16));
        gradientPanel4.add((Component)this.taperSlider, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gradientPanel4.add((Component)this.taper, gridBagConstraints);
        jPanel2 = new JPanel(new BorderLayout());
        jPanel2.add((Component)gradientPanel4, "Center");
        gradientPanel2 = new GradientPanel(40, 20);
        gradientPanel2.setLayout(new GridBagLayout());
        gradientPanel2.setGradientDirection(2);
        gradientPanel2.setRound(0);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        jLabel = new JLabel(this.rb.getString("profile"));
        jLabel.setFont((Font)UIManager.get("TitledBorder.font"));
        jLabel.setForeground(Color.black);
        gradientPanel2.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.fill = 0;
        jPanel2.add((Component)gradientPanel2, "North");
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 0, 6, 0);
        jPanel.add((Component)jPanel2, gridBagConstraints);
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.fill = 0;
        GradientPanel gradientPanel5 = new GradientPanel(20, 10);
        gradientPanel5.setLayout(new GridBagLayout());
        gradientPanel5.setGradientDirection(2);
        gradientPanel5.setRound(1);
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 10;
        gradientPanel5.add((Component)this.useUv, gridBagConstraints);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridwidth = 1;
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        JLabel jLabel2 = new JLabel(this.rb.getString("imageMapName"));
        LabelUI labelUI = new LabelUI();
        labelUI.setIsUnderlinable(false);
        jLabel2.setUI(labelUI);
        gradientPanel5.add((Component)jLabel2, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gradientPanel5.add((Component)this.imageName, gridBagConstraints);
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 2;
        this.loadImage.setUI(new ButtonUI());
        gridBagConstraints.insets = new Insets(0, 4, 0, 0);
        gradientPanel5.add((Component)this.loadImage, gridBagConstraints);
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        jLabel2 = new JLabel(this.rb.getString("bumpMapName"));
        labelUI = new LabelUI();
        labelUI.setIsUnderlinable(false);
        jLabel2.setUI(labelUI);
        gradientPanel5.add((Component)jLabel2, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gradientPanel5.add((Component)this.bumpName, gridBagConstraints);
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 2;
        this.loadBump.setUI(new ButtonUI());
        gridBagConstraints.insets = new Insets(0, 4, 0, 0);
        gradientPanel5.add((Component)this.loadBump, gridBagConstraints);
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        jLabel2 = new JLabel(this.rb.getString("bumpSize"));
        labelUI = new LabelUI();
        labelUI.setIsUnderlinable(false);
        jLabel2.setUI(labelUI);
        gradientPanel5.add((Component)jLabel2, gridBagConstraints);
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 1;
        gradientPanel5.add((Component)this.bumpSize, gridBagConstraints);
        jPanel2 = new JPanel(new BorderLayout());
        jPanel2.add((Component)gradientPanel5, "Center");
        gradientPanel2 = new GradientPanel(40, 20);
        gradientPanel2.setLayout(new GridBagLayout());
        gradientPanel2.setGradientDirection(2);
        gradientPanel2.setRound(0);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        jLabel = new JLabel(this.rb.getString("uvMapping"));
        jLabel.setFont((Font)UIManager.get("TitledBorder.font"));
        jLabel.setForeground(Color.black);
        gradientPanel2.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.fill = 0;
        jPanel2.add((Component)gradientPanel2, "North");
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 1;
        jPanel.add((Component)jPanel2, gridBagConstraints);
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.fill = 1;
        this.add((Component)jPanel, gridBagConstraints);
    }

    public void paintElement() {
    }

    public boolean isValidFileExtension(String string) {
        boolean bl = false;
        String string2 = null;
        if (string == null) {
            return false;
        }
        if (string.trim().length() <= 4) {
            return false;
        }
        string2 = string.trim().substring(string.length() - 4);
        int n = 0;
        while (n < Constants.imageTypes.length) {
            if (string2.indexOf(Constants.imageTypes[n]) != -1) {
                bl = true;
            }
            ++n;
        }
        return bl;
    }

    public String getFileExtension(String string) {
        String string2 = null;
        if (string == null) {
            return null;
        }
        if (string.trim().length() <= 4) {
            return null;
        }
        string2 = string.trim().substring(string.length() - 4);
        int n = 0;
        while (n < Constants.imageTypes.length) {
            if (string2.indexOf(Constants.imageTypes[n]) != -1 && (string2 = Constants.imageTypes[n]).equals("jpg")) {
                string2 = "jpeg";
            }
            ++n;
        }
        return string2;
    }

    public void load(int n) {
        String string = null;
        if (this.currentPath == null) {
            this.currentPath = ".";
        }
        if (this.fc == null) {
            this.fc = new JFileChooser(this.currentPath);
            Helper.tuneFileChooser(this.fc);
            this.fc.addChoosableFileFilter(new ImageFilter());
            this.fc.setAccessory(new ImageAccessor(this.fc));
        }
        this.fc.validate();
        int n2 = this.fc.showDialog(this, this.rb.getString("select"));
        if (n2 == 0) {
            File file = this.fc.getSelectedFile();
            string = file.getPath();
            this.currentPath = file.getParent();
            if (string != null && string.trim().length() > 0) {
                if (!this.isValidFileExtension(string)) {
                    JOptionPane.showMessageDialog(this, this.mb.getString("invalidFileExtension"), this.rb.getString("error"), 0);
                    return;
                }
                if (n == 0) {
                    this.imageName.setText(string);
                } else if (n == 1) {
                    this.bumpName.setText(string);
                }
            }
        }
    }

    public void setBark(Bark bark) {
        this.foliageAtEnd.setText(bark.foliageAtEnd);
        Helper.setValue(this.foliageAtEnd, this.atEndSlider, this, this.invalidNumber, this.errorLabel);
        this.width.setText(bark.width);
        Helper.setValue(this.width, this.widthSlider, this, this.invalidNumber, this.errorLabel);
        this.height.setText(bark.height);
        Helper.setValue(this.height, this.heightSlider, this, this.invalidNumber, this.errorLabel);
        this.depth.setText(bark.depth);
        Helper.setValue(this.depth, this.depthSlider, this, this.invalidNumber, this.errorLabel);
        this.horizontalShrinking.setText(bark.horizontalShrinking);
        Helper.setValue(this.horizontalShrinking, this.shrinkXSlider, this, this.invalidNumber, this.errorLabel);
        this.verticalShrinking.setText(bark.verticalShrinking);
        Helper.setValue(this.verticalShrinking, this.shrinkYSlider, this, this.invalidNumber, this.errorLabel);
        this.profile.setText(bark.profile);
        Helper.setValue(this.profile, this.profileValueSlider, this, this.invalidNumber, this.errorLabel);
        this.change.setText(bark.change);
        Helper.setValue(this.change, this.branchChangeSlider, this, this.invalidNumber, this.errorLabel);
        this.taper.setText(bark.taper);
        Helper.setValue(this.taper, this.taperSlider, this, this.invalidNumber, this.errorLabel);
        this.rootChange.setText(bark.rootChange);
        Helper.setValue(this.rootChange, this.rootChangeSlider, this, this.invalidNumber, this.errorLabel);
        this.palm.setText(bark.palm);
        Helper.setValue(this.palm, this.palmSlider, this, this.invalidNumber, this.errorLabel);
        this.sunkenColorChooser.setColor(bark.sunkenR, bark.sunkenG, bark.sunkenB);
        this.raisedColorChooser.setColor(bark.raisedR, bark.raisedG, bark.raisedB);
        if (bark.imageName != null) {
            this.imageName.setText(bark.imageName.trim());
        } else {
            this.imageName.setText("");
        }
        if (bark.bumpName != null) {
            this.bumpName.setText(bark.bumpName.trim());
        } else {
            this.bumpName.setText("");
        }
        if (!(bark.imageName != null && bark.imageName.trim().length() != 0 || bark.imageType != null && bark.imageType.trim().length() != 0)) {
            this.useUv.setSelected(false);
        } else {
            this.useUv.setSelected(true);
        }
        if (bark.bumpSize != null) {
            this.bumpSize.setText(bark.bumpSize.trim());
        } else {
            this.bumpSize.setText("");
        }
    }

    public Bark getBark() {
        Bark bark = new Bark();
        bark.sunkenR = this.sunkenColorChooser.getRed();
        bark.sunkenG = this.sunkenColorChooser.getGreen();
        bark.sunkenB = this.sunkenColorChooser.getBlue();
        bark.raisedR = this.raisedColorChooser.getRed();
        bark.raisedG = this.raisedColorChooser.getGreen();
        bark.raisedB = this.raisedColorChooser.getBlue();
        bark.foliageAtEnd = this.foliageAtEnd.getText();
        bark.width = this.width.getText();
        bark.height = this.height.getText();
        bark.depth = this.depth.getText();
        bark.horizontalShrinking = this.horizontalShrinking.getText();
        bark.verticalShrinking = this.verticalShrinking.getText();
        bark.profile = this.profile.getText();
        bark.change = this.change.getText();
        bark.taper = this.taper.getText();
        bark.rootChange = this.rootChange.getText();
        bark.palm = this.palm.getText();
        if (this.useUv.isSelected()) {
            String string = this.imageName.getText().trim();
            bark.imageType = this.getFileExtension(string);
            bark.imageName = string;
            string = this.bumpName.getText().trim();
            bark.bumpType = this.getFileExtension(string);
            bark.bumpName = this.bumpName.getText().trim();
            bark.bumpSize = this.bumpSize.getText().trim();
        }
        return bark;
    }
}

