/*
 * Decompiled with CFR 0.152.
 */
package povtree.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import povtree.gui.EnterListener;
import povtree.gui.FloatSliderChangeListener;
import povtree.gui.Helper;
import povtree.gui.IntegerSliderChangeListener;
import povtree.gui.LeafPainter;
import povtree.gui.PovTree;
import povtree.gui.Resources;
import povtree.gui.plaf.ColorChooser;
import povtree.gui.plaf.GradientPanel;
import povtree.gui.plaf.LabelTip;
import povtree.interfaces.Constants;
import povtree.interfaces.Paintable;
import povtree.objects.Blossom;
import povtree.objects3D.DoubleLeafArray;
import povtree.objects3D.LeafArray;
import povtree.objects3D.QuadroLeafArray;
import povtree.objects3D.TripleLeafArray;
import povtree.povTreeGenerator.BlossomGenerator;
import povtree.povTreeGenerator.Parameters;

public class BlossomPanel
extends JPanel
implements Constants,
Paintable {
    private JSlider numberSlider = new JSlider(0, 10000000, 0);
    private JSlider lengthSlider = new JSlider(0, 5000000, 0);
    private JSlider widthSlider = new JSlider(0, 5000000, 0);
    private JSlider inclinationSlider = new JSlider(0, 36000000, 0);
    private JTextField number = new JTextField(7);
    private JTextField length = new JTextField(7);
    private JTextField width = new JTextField(7);
    private JTextField inclination = new JTextField(7);
    private String[] blossom = new String[]{"BLOSSOM1", "BLOSSOM2", "BlossomMesh5", "BlossomMesh6", "BlossomMesh10", "BlossomMesh15", "BlossomMesh16", "BlossomMesh35"};
    private JToggleButton[] typeTB = new JToggleButton[this.blossom.length];
    private JToggleButton invisibleTB = null;
    private ButtonGroup bg = new ButtonGroup();
    private JCheckBox useCustomMesh = null;
    private JTextArea editor = new JTextArea();
    private Resources resources = Resources.getInstance();
    private ResourceBundle rb = Resources.getLabelsBundle();
    private ResourceBundle mb = Resources.getMessagesBundle();
    private String invalidNumber = this.mb.getString("invalidNumber");
    private String errorLabel = this.rb.getString("error");
    private ColorChooser colorChooser;
    private LeafPainter painter = new LeafPainter(this.rb);
    private Parameters parameters = null;
    private PovTree povTree = null;
    private BlossomGenerator bgen = null;

    public BlossomPanel(PovTree povTree, String string) {
        this.povTree = povTree;
        this.invisibleTB = new JToggleButton(this.rb.getString("deselect"));
        this.useCustomMesh = new JCheckBox(this.rb.getString("useCustomMesh"), false);
        this.useCustomMesh.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                BlossomPanel.this.paintElement();
            }
        });
        int n = 0;
        while (n < this.typeTB.length) {
            this.typeTB[n] = new JToggleButton(new ImageIcon(this.getClass().getResource("images/" + this.blossom[n] + ".png")));
            this.typeTB[n].addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    BlossomPanel.this.paintElement();
                }
            });
            this.bg.add(this.typeTB[n]);
            ++n;
        }
        this.invisibleTB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JOptionPane.showMessageDialog(BlossomPanel.this, BlossomPanel.this.mb.getString("dontNeedBlossom"), BlossomPanel.this.rb.getString("tip"), 1);
                BlossomPanel.this.paintElement();
            }
        });
        this.bg.add(this.invisibleTB);
        this.number.addActionListener(new EnterListener(this.number, this.numberSlider, this, this.invalidNumber, this.errorLabel));
        this.numberSlider.addChangeListener(new IntegerSliderChangeListener(this.number, this));
        this.length.addActionListener(new EnterListener(this.length, this.lengthSlider, this, this.invalidNumber, this.errorLabel));
        this.lengthSlider.addChangeListener(new FloatSliderChangeListener(this.length, this));
        this.width.addActionListener(new EnterListener(this.width, this.widthSlider, this, this.invalidNumber, this.errorLabel));
        this.widthSlider.addChangeListener(new FloatSliderChangeListener(this.width, this));
        this.inclination.addActionListener(new EnterListener(this.inclination, this.inclinationSlider, this, this.invalidNumber, this.errorLabel));
        this.inclinationSlider.addChangeListener(new FloatSliderChangeListener(this.inclination, this));
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridBagLayout());
        jPanel2.setOpaque(false);
        gridBagConstraints.weighty = 4.0;
        int n2 = 0;
        while (n2 < this.typeTB.length) {
            this.typeTB[n2].setVerticalTextPosition(3);
            this.typeTB[n2].setHorizontalTextPosition(0);
            if (n2 < 4) {
                gridBagConstraints.gridx = n2;
                gridBagConstraints.gridy = 0;
                jPanel2.add((Component)this.typeTB[n2], gridBagConstraints);
            } else {
                gridBagConstraints.gridx = n2 - 4;
                gridBagConstraints.gridy = 1;
                jPanel2.add((Component)this.typeTB[n2], gridBagConstraints);
            }
            ++n2;
        }
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        jPanel2.add((Component)this.invisibleTB, gridBagConstraints);
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 1;
        GradientPanel gradientPanel = new GradientPanel(20, 10);
        gradientPanel.setLayout(new GridBagLayout());
        gradientPanel.setGradientDirection(2);
        gradientPanel.setRound(1);
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gradientPanel.add((Component)jPanel2, gridBagConstraints);
        gridBagConstraints.fill = 0;
        gradientPanel.setBorder(new EmptyBorder(10, 10, 10, 10));
        JPanel jPanel3 = new JPanel(new BorderLayout());
        jPanel3.add((Component)gradientPanel, "Center");
        GradientPanel gradientPanel2 = new GradientPanel(40, 20);
        gradientPanel2.setLayout(new GridBagLayout());
        gradientPanel2.setGradientDirection(2);
        gradientPanel2.setRound(0);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        JLabel jLabel = new JLabel(this.rb.getString("type"));
        jLabel.setFont((Font)UIManager.get("TitledBorder.font"));
        jLabel.setForeground(Color.black);
        gradientPanel2.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.fill = 0;
        jPanel3.add((Component)gradientPanel2, "North");
        jPanel2 = new JPanel();
        jPanel2.setLayout(new GridBagLayout());
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.insets = new Insets(0, 0, 6, 0);
        jPanel2.add((Component)jPanel3, gridBagConstraints);
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        GradientPanel gradientPanel3 = new GradientPanel(20, 10);
        gradientPanel3.setLayout(new GridBagLayout());
        gradientPanel3.setGradientDirection(2);
        gradientPanel3.setRound(1);
        gridBagConstraints.fill = 2;
        LabelTip labelTip = new LabelTip(this.rb.getString("number"), true, "tipsBlossom", "BLOSSOMS", this, string);
        gradientPanel3.add((Component)labelTip, gridBagConstraints);
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 1;
        this.numberSlider.setPreferredSize(new Dimension(150, 16));
        gradientPanel3.add((Component)this.numberSlider, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gradientPanel3.add((Component)this.number, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        labelTip = new LabelTip(this.rb.getString("length"), true, "tipsBlossom", "BLOSSOM_LENGTH", this, string);
        gradientPanel3.add((Component)labelTip, gridBagConstraints);
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 1;
        this.lengthSlider.setPreferredSize(new Dimension(150, 16));
        gradientPanel3.add((Component)this.lengthSlider, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gradientPanel3.add((Component)this.length, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        labelTip = new LabelTip(this.rb.getString("width"), true, "tipsBlossom", "BLOSSOM_WIDTH", this, string);
        gradientPanel3.add((Component)labelTip, gridBagConstraints);
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 1;
        this.widthSlider.setPreferredSize(new Dimension(150, 16));
        gradientPanel3.add((Component)this.widthSlider, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gradientPanel3.add((Component)this.width, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        labelTip = new LabelTip(this.rb.getString("inclination"), true, "tipsBlossom", "BLOSSOM_INCLINATION", this, string);
        gradientPanel3.add((Component)labelTip, gridBagConstraints);
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 1;
        this.inclinationSlider.setPreferredSize(new Dimension(150, 16));
        gradientPanel3.add((Component)this.inclinationSlider, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gradientPanel3.add((Component)this.inclination, gridBagConstraints);
        jPanel3 = new JPanel(new BorderLayout());
        jPanel3.add((Component)gradientPanel3, "Center");
        gradientPanel2 = new GradientPanel(40, 20);
        gradientPanel2.setLayout(new GridBagLayout());
        gradientPanel2.setGradientDirection(2);
        gradientPanel2.setRound(0);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        jLabel = new JLabel(this.rb.getString("size"));
        jLabel.setFont((Font)UIManager.get("TitledBorder.font"));
        jLabel.setForeground(Color.black);
        gradientPanel2.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.fill = 0;
        jPanel3.add((Component)gradientPanel2, "North");
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 0, 6, 0);
        jPanel2.add((Component)jPanel3, gridBagConstraints);
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.fill = 0;
        this.colorChooser = new ColorChooser(this.rb.getString("color"), this.rb.getString("red"), this.rb.getString("green"), this.rb.getString("blue"), this.mb.getString("wrongColorValue"), this.rb.getString("error"));
        this.colorChooser.getRedTextField().addActionListener(new EnterListener(this.colorChooser.getRedTextField(), this.colorChooser.getRedSlider(), this, this.invalidNumber, this.errorLabel));
        this.colorChooser.getRedSlider().addChangeListener(new FloatSliderChangeListener(this.colorChooser.getRedTextField(), this));
        this.colorChooser.getGreenTextField().addActionListener(new EnterListener(this.colorChooser.getGreenTextField(), this.colorChooser.getGreenSlider(), this, this.invalidNumber, this.errorLabel));
        this.colorChooser.getGreenSlider().addChangeListener(new FloatSliderChangeListener(this.colorChooser.getGreenTextField(), this));
        this.colorChooser.getBlueTextField().addActionListener(new EnterListener(this.colorChooser.getBlueTextField(), this.colorChooser.getBlueSlider(), this, this.invalidNumber, this.errorLabel));
        this.colorChooser.getBlueSlider().addChangeListener(new FloatSliderChangeListener(this.colorChooser.getBlueTextField(), this));
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridwidth = 1;
        this.colorChooser.setCompact(150);
        gridBagConstraints.insets = new Insets(0, 0, 0, 6);
        this.colorChooser.setCompact(120);
        jPanel2.add((Component)this.colorChooser, gridBagConstraints);
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        GradientPanel gradientPanel4 = new GradientPanel(20, 10);
        gradientPanel4.setLayout(new BorderLayout());
        gradientPanel4.setGradientDirection(2);
        gradientPanel4.setRound(1);
        gradientPanel4.setLayout(new BorderLayout());
        JPanel jPanel4 = new JPanel();
        jPanel4.setOpaque(false);
        jPanel4.setLayout(new BorderLayout());
        JPanel jPanel5 = new JPanel();
        jPanel5.setOpaque(false);
        this.useCustomMesh.setOpaque(false);
        jPanel5.add(this.useCustomMesh);
        jPanel4.add((Component)jPanel5, "North");
        jPanel5 = new JPanel(new GridBagLayout());
        jPanel5.setOpaque(false);
        JLabel jLabel2 = new JLabel(this.rb.getString("example") + ": triangle{<0, 0, -0.5>, <1, 0, 0>, <0, 0, 0.5>}", 0);
        jLabel2.setOpaque(false);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 10;
        jPanel5.add((Component)jLabel2, gridBagConstraints);
        gridBagConstraints.anchor = 17;
        jPanel4.add((Component)jPanel5, "Center");
        gradientPanel4.add((Component)jPanel4, "North");
        this.editor.setBackground(gradientPanel4.getBackground());
        JScrollPane jScrollPane = new JScrollPane(this.editor);
        gradientPanel4.add((Component)jScrollPane, "Center");
        gradientPanel4.setBorder(new EmptyBorder(0, 10, 12, 10));
        jPanel3 = new JPanel(new BorderLayout());
        jPanel3.add((Component)gradientPanel4, "Center");
        gradientPanel2 = new GradientPanel(40, 20);
        gradientPanel2.setLayout(new GridBagLayout());
        gradientPanel2.setGradientDirection(2);
        gradientPanel2.setRound(0);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        jLabel = new JLabel(this.rb.getString("customMeshBlossom"));
        jLabel.setFont((Font)UIManager.get("TitledBorder.font"));
        jLabel.setForeground(Color.black);
        gradientPanel2.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.fill = 0;
        jPanel3.add((Component)gradientPanel2, "North");
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 1;
        jPanel2.add((Component)jPanel3, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 0, 6, 6);
        gridBagConstraints.gridheight = 2;
        jPanel2.add((Component)this.painter, gridBagConstraints);
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 10;
        this.add((Component)jPanel2, gridBagConstraints);
    }

    public void paintElement() {
        if (this.povTree.getTree() == null) {
            return;
        }
        LeafArray leafArray = null;
        try {
            this.parameters = new Parameters(this.povTree.getTree());
        }
        catch (NumberFormatException numberFormatException) {
            JOptionPane.showMessageDialog(this, this.invalidNumber + " " + numberFormatException.getMessage(), this.rb.getString("error"), 0);
            return;
        }
        if (this.parameters.blossomType != null && this.parameters.twigs >= 1.0f) {
            float f = this.parameters.blossoms / this.parameters.bunches;
            this.parameters.blossoms = f > 500.0f ? 500.0f : f;
            this.parameters.branches = 1.0f;
            this.parameters.twigs = 1.0f;
            this.parameters.bunches = 1.0f;
            this.bgen = this.parameters.blossomType.startsWith("BlossomMesh") || this.parameters.blossomType.startsWith("CustomMeshBlossom") ? new BlossomGenerator(this.parameters, true, this.parameters.blossomType) : new BlossomGenerator(this.parameters, true, "BlossomMesh5");
            try {
                QuadroLeafArray quadroLeafArray = (QuadroLeafArray)this.bgen.generate();
                TripleLeafArray tripleLeafArray = quadroLeafArray.get(0);
                DoubleLeafArray doubleLeafArray = tripleLeafArray.get(0);
                leafArray = doubleLeafArray.get(0);
                if (leafArray != null) {
                    leafArray.rotateX(180.0f);
                }
                this.painter.setElement(leafArray, this.colorChooser.getColor());
            }
            catch (Exception exception) {
                this.painter.setElement(null, null);
            }
        } else {
            this.painter.setElement(null, null);
        }
    }

    public void setBlossom(Blossom blossom) {
        if (blossom == null || blossom != null && blossom.name == null) {
            return;
        }
        this.invisibleTB.setSelected(true);
        this.useCustomMesh.setSelected(false);
        this.editor.setText("");
        if (blossom.name.equals("CustomMeshBlossom")) {
            this.useCustomMesh.setSelected(true);
            this.editor.setText(blossom.customMesh);
        } else {
            int n = 0;
            while (n < this.blossom.length) {
                if (this.blossom[n].equals(blossom.name)) {
                    this.typeTB[n].setSelected(true);
                    break;
                }
                ++n;
            }
        }
        this.number.setText(blossom.number);
        Helper.setValue(this.number, this.numberSlider, this, this.invalidNumber, this.errorLabel);
        this.length.setText(blossom.length);
        Helper.setValue(this.length, this.lengthSlider, this, this.invalidNumber, this.errorLabel);
        this.width.setText(blossom.width);
        Helper.setValue(this.width, this.widthSlider, this, this.invalidNumber, this.errorLabel);
        this.inclination.setText(blossom.inclination);
        Helper.setValue(this.inclination, this.inclinationSlider, this, this.invalidNumber, this.errorLabel);
        this.colorChooser.setColor(blossom.r, blossom.g, blossom.b);
    }

    public Blossom getBlossom() {
        Blossom blossom = new Blossom();
        int n = 0;
        while (n < this.blossom.length) {
            if (this.typeTB[n].isSelected()) {
                blossom.name = this.blossom[n];
                break;
            }
            ++n;
        }
        if (this.useCustomMesh.isSelected()) {
            blossom.name = "CustomMeshBlossom";
            blossom.customMesh = this.editor.getText();
        }
        blossom.number = this.number.getText();
        blossom.length = this.length.getText();
        blossom.width = this.width.getText();
        blossom.inclination = this.inclination.getText();
        blossom.r = this.colorChooser.getRed();
        blossom.g = this.colorChooser.getGreen();
        blossom.b = this.colorChooser.getBlue();
        return blossom;
    }
}

