/*
 * Decompiled with CFR 0.152.
 */
package povtree.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Random;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.UIManager;
import povtree.gui.EnterListener;
import povtree.gui.FloatSliderChangeListener;
import povtree.gui.Helper;
import povtree.gui.IntegerSliderChangeListener;
import povtree.gui.Painter;
import povtree.gui.PovTree;
import povtree.gui.Resources;
import povtree.gui.plaf.ButtonUI;
import povtree.gui.plaf.GradientPanel;
import povtree.gui.plaf.LabelTip;
import povtree.gui.plaf.LabelUI;
import povtree.interfaces.Paintable;
import povtree.objects.Branch;
import povtree.objects3D.BlobArray;
import povtree.objects3D.DoubleBlobArray;
import povtree.povTreeGenerator.Accuracy;
import povtree.povTreeGenerator.BranchGenerator;
import povtree.povTreeGenerator.Parameters;

public class BranchPanel
extends JPanel
implements Paintable {
    private JSlider branchRadialSlider = new JSlider(100000, 3000000, 100000);
    private JSlider branchVertSlider = new JSlider(100000, 1000000, 100000);
    private JSlider numberSlider = new JSlider(0, 20000000, 0);
    private JSlider startAtSlider = new JSlider(0, 40000000, 0);
    private JSlider areaSlider = new JSlider(0, 100000000, 0);
    private JSlider thicknessSlider = new JSlider(0, 100000, 0);
    private JSlider strengthSlider = new JSlider(0, 100000, 0);
    private JSlider bendValueSlider = new JSlider(-10000000, 10000000, 0);
    private JSlider bendFrequencySlider = new JSlider(0, 1000000, 0);
    private JSlider horizBendSlider = new JSlider(0, 200000, 0);
    private JSlider curveValueSlider = new JSlider(-10000000, 10000000, 0);
    private JSlider curveFreqSlider = new JSlider(0, 1000000, 0);
    private JSlider longitudinalSlider = new JSlider(0, 200000, 0);
    private JSlider snagValueSlider = new JSlider(0, 10000000, 0);
    private JSlider snagFreqSlider = new JSlider(0, 10000000, 0);
    private JSlider reductionSlider = new JSlider(0, 100000, 0);
    private JSlider taperSlider = new JSlider(0, 100000, 0);
    private JSlider endEqSlider = new JSlider(0, 100000, 0);
    private JSlider tipSlider = new JSlider(0, 100000, 0);
    private JSlider spiralSlider = new JSlider(0, 72000000, 0);
    private JSlider angleSlider = new JSlider(-9000000, 9000000, 0);
    private JSlider angleScopeSlider = new JSlider(0, 100000, 0);
    private JSlider alignmentSlider = new JSlider(0, 100000, 0);
    private JSlider straightSlider = new JSlider(0, 100000, 0);
    private JSlider turnSlider = new JSlider(0, 100000, 0);
    private JSlider alternateSlider = new JSlider(0, 100000, 0);
    private JSlider extraNoiseSlider = new JSlider(0, 100000, 0);
    private JSlider horizCurveSlider = new JSlider(0, 100000, 0);
    private JTextField branchRadial = new JTextField(4);
    private JTextField branchVertical = new JTextField(4);
    private JTextField number = new JTextField(7);
    private JTextField randomness = new JTextField(7);
    private JTextField startAt = new JTextField(7);
    private JTextField areaAtTrunk = new JTextField(7);
    private JTextField thicknessRatio = new JTextField(7);
    private JTextField strength = new JTextField(7);
    private JTextField bendValue = new JTextField(7);
    private JTextField bendFrequency = new JTextField(7);
    private JTextField horizontalBend = new JTextField(7);
    private JTextField extraNoise = new JTextField(7);
    private JTextField curveValue = new JTextField(7);
    private JTextField curveFrequency = new JTextField(7);
    private JTextField horizontalCurve = new JTextField(7);
    private JTextField longitudinal = new JTextField(7);
    private JTextField snagValue = new JTextField(7);
    private JTextField snagFrequency = new JTextField(7);
    private JTextField reduction = new JTextField(7);
    private JTextField taper = new JTextField(7);
    private JTextField endEqualizer = new JTextField(7);
    private JTextField tipTF = new JTextField(7);
    private JTextField turn = new JTextField(7);
    private JTextField alternate = new JTextField(7);
    private JTextField spiral = new JTextField(7);
    private JTextField angle = new JTextField(7);
    private JTextField angleScope = new JTextField(7);
    private JTextField alignment = new JTextField(7);
    private JTextField straightenTowardsTop = new JTextField(7);
    private JButton random = null;
    private Random r = new Random();
    private Resources resources = Resources.getInstance();
    private ResourceBundle rb = Resources.getLabelsBundle();
    private ResourceBundle mb = Resources.getMessagesBundle();
    private String invalidNumber = this.mb.getString("invalidNumber");
    private String errorLabel = this.rb.getString("error");
    private Painter painter = new Painter(this.rb);
    private Parameters parameters = null;
    private PovTree povTree = null;
    private BranchGenerator bg = null;
    private JTabbedPane tabPane = new JTabbedPane();
    private Accuracy acc = new Accuracy();

    public BranchPanel(PovTree povTree, String string) {
        int n = 0;
        this.povTree = povTree;
        this.random = new JButton(this.rb.getString("randomness"));
        this.random.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                BranchPanel.this.setNextFloat();
            }
        });
        this.branchRadial.addActionListener(new EnterListener(this.branchRadial, this.branchRadialSlider, this, this.invalidNumber, this.errorLabel));
        this.branchRadialSlider.addChangeListener(new IntegerSliderChangeListener(this.branchRadial, this));
        this.branchRadial.setText(String.valueOf(this.acc.branchRadial));
        Helper.setValue(this.branchRadial, this.branchRadialSlider, this, this.invalidNumber, this.errorLabel);
        this.branchVertical.addActionListener(new EnterListener(this.branchVertical, this.branchVertSlider, this, this.invalidNumber, this.errorLabel));
        this.branchVertSlider.addChangeListener(new IntegerSliderChangeListener(this.branchVertical, this));
        this.branchVertical.setText(String.valueOf(this.acc.branchVertical));
        Helper.setValue(this.branchVertical, this.branchVertSlider, this, this.invalidNumber, this.errorLabel);
        this.number.addActionListener(new EnterListener(this.number, this.numberSlider, this, this.invalidNumber, this.errorLabel));
        this.numberSlider.addChangeListener(new IntegerSliderChangeListener(this.number, this));
        this.startAt.addActionListener(new EnterListener(this.startAt, this.startAtSlider, this, this.invalidNumber, this.errorLabel));
        this.startAtSlider.addChangeListener(new FloatSliderChangeListener(this.startAt, this));
        this.areaAtTrunk.addActionListener(new EnterListener(this.areaAtTrunk, this.areaSlider, this, this.invalidNumber, this.errorLabel));
        this.areaSlider.addChangeListener(new FloatSliderChangeListener(this.areaAtTrunk, this));
        this.thicknessRatio.addActionListener(new EnterListener(this.thicknessRatio, this.thicknessSlider, this, this.invalidNumber, this.errorLabel));
        this.thicknessSlider.addChangeListener(new FloatSliderChangeListener(this.thicknessRatio, this));
        this.strength.addActionListener(new EnterListener(this.strength, this.strengthSlider, this, this.invalidNumber, this.errorLabel));
        this.strengthSlider.addChangeListener(new FloatSliderChangeListener(this.strength, this));
        this.reduction.addActionListener(new EnterListener(this.reduction, this.reductionSlider, this, this.invalidNumber, this.errorLabel));
        this.reductionSlider.addChangeListener(new FloatSliderChangeListener(this.reduction, this));
        this.taper.addActionListener(new EnterListener(this.taper, this.taperSlider, this, this.invalidNumber, this.errorLabel));
        this.taperSlider.addChangeListener(new FloatSliderChangeListener(this.taper, this));
        this.endEqualizer.addActionListener(new EnterListener(this.endEqualizer, this.endEqSlider, this, this.invalidNumber, this.errorLabel));
        this.endEqSlider.addChangeListener(new FloatSliderChangeListener(this.endEqualizer, this));
        this.tipTF.addActionListener(new EnterListener(this.tipTF, this.tipSlider, this, this.invalidNumber, this.errorLabel));
        this.tipSlider.addChangeListener(new FloatSliderChangeListener(this.tipTF, this));
        this.spiral.addActionListener(new EnterListener(this.spiral, this.spiralSlider, this, this.invalidNumber, this.errorLabel));
        this.spiralSlider.addChangeListener(new FloatSliderChangeListener(this.spiral, this));
        this.straightenTowardsTop.addActionListener(new EnterListener(this.straightenTowardsTop, this.straightSlider, this, this.invalidNumber, this.errorLabel));
        this.straightSlider.addChangeListener(new FloatSliderChangeListener(this.straightenTowardsTop, this));
        this.angle.addActionListener(new EnterListener(this.angle, this.angleSlider, this, this.invalidNumber, this.errorLabel));
        this.angleSlider.addChangeListener(new FloatSliderChangeListener(this.angle, this));
        this.angleScope.addActionListener(new EnterListener(this.angleScope, this.angleScopeSlider, this, this.invalidNumber, this.errorLabel));
        this.angleScopeSlider.addChangeListener(new FloatSliderChangeListener(this.angleScope, this));
        this.alignment.addActionListener(new EnterListener(this.alignment, this.alignmentSlider, this, this.invalidNumber, this.errorLabel));
        this.alignmentSlider.addChangeListener(new FloatSliderChangeListener(this.alignment, this));
        this.turn.addActionListener(new EnterListener(this.turn, this.turnSlider, this, this.invalidNumber, this.errorLabel));
        this.turnSlider.addChangeListener(new FloatSliderChangeListener(this.turn, this));
        this.alternate.addActionListener(new EnterListener(this.alternate, this.alternateSlider, this, this.invalidNumber, this.errorLabel));
        this.alternateSlider.addChangeListener(new FloatSliderChangeListener(this.alternate, this));
        this.bendValue.addActionListener(new EnterListener(this.bendValue, this.bendValueSlider, this, this.invalidNumber, this.errorLabel));
        this.bendValueSlider.addChangeListener(new FloatSliderChangeListener(this.bendValue, this));
        this.bendFrequency.addActionListener(new EnterListener(this.bendFrequency, this.bendFrequencySlider, this, this.invalidNumber, this.errorLabel));
        this.bendFrequencySlider.addChangeListener(new FloatSliderChangeListener(this.bendFrequency, this));
        this.horizontalBend.addActionListener(new EnterListener(this.horizontalBend, this.horizBendSlider, this, this.invalidNumber, this.errorLabel));
        this.horizBendSlider.addChangeListener(new FloatSliderChangeListener(this.horizontalBend, this));
        this.extraNoise.addActionListener(new EnterListener(this.extraNoise, this.extraNoiseSlider, this, this.invalidNumber, this.errorLabel));
        this.extraNoiseSlider.addChangeListener(new FloatSliderChangeListener(this.extraNoise, this));
        this.curveValue.addActionListener(new EnterListener(this.curveValue, this.curveValueSlider, this, this.invalidNumber, this.errorLabel));
        this.curveValueSlider.addChangeListener(new FloatSliderChangeListener(this.curveValue, this));
        this.curveFrequency.addActionListener(new EnterListener(this.curveFrequency, this.curveFreqSlider, this, this.invalidNumber, this.errorLabel));
        this.curveFreqSlider.addChangeListener(new FloatSliderChangeListener(this.curveFrequency, this));
        this.longitudinal.addActionListener(new EnterListener(this.longitudinal, this.longitudinalSlider, this, this.invalidNumber, this.errorLabel));
        this.longitudinalSlider.addChangeListener(new FloatSliderChangeListener(this.longitudinal, this));
        this.horizontalCurve.addActionListener(new EnterListener(this.horizontalCurve, this.horizCurveSlider, this, this.invalidNumber, this.errorLabel));
        this.horizCurveSlider.addChangeListener(new FloatSliderChangeListener(this.horizontalCurve, this));
        this.snagValue.addActionListener(new EnterListener(this.snagValue, this.snagValueSlider, this, this.invalidNumber, this.errorLabel));
        this.snagValueSlider.addChangeListener(new FloatSliderChangeListener(this.snagValue, this));
        this.snagFrequency.addActionListener(new EnterListener(this.snagFrequency, this.snagFreqSlider, this, this.invalidNumber, this.errorLabel));
        this.snagFreqSlider.addChangeListener(new FloatSliderChangeListener(this.snagFrequency, this));
        this.setLayout(new GridBagLayout());
        GradientPanel gradientPanel = new GradientPanel(15, 15);
        gradientPanel.setLayout(new GridBagLayout());
        gradientPanel.setGradientDirection(2);
        gradientPanel.setRound(2);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        LabelTip labelTip = new LabelTip(this.rb.getString("number"), true, "tipsBranch", "BRANCHES", this, string);
        gradientPanel.add((Component)labelTip, gridBagConstraints);
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 1;
        this.numberSlider.setPreferredSize(new Dimension(150, 16));
        gradientPanel.add((Component)this.numberSlider, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gradientPanel.add((Component)this.number, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        labelTip = new LabelTip(this.rb.getString("startAt"), true, "tipsBranch", "FIRST_BRANCH_AT_TRUNK", this, string);
        gradientPanel.add((Component)labelTip, gridBagConstraints);
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 1;
        this.startAtSlider.setPreferredSize(new Dimension(150, 16));
        gradientPanel.add((Component)this.startAtSlider, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gradientPanel.add((Component)this.startAt, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        labelTip = new LabelTip(this.rb.getString("branchAreaAtTrunk"), true, "tipsBranch", "BRANCH_AREA_AT_TRUNK", this, string);
        gradientPanel.add((Component)labelTip, gridBagConstraints);
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 1;
        this.areaSlider.setPreferredSize(new Dimension(150, 16));
        gradientPanel.add((Component)this.areaSlider, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gradientPanel.add((Component)this.areaAtTrunk, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        labelTip = new LabelTip(this.rb.getString("thickness"), true, "tipsBranch", "BRANCH_THICKNESS_CHANGE", this, string);
        gradientPanel.add((Component)labelTip, gridBagConstraints);
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 1;
        this.thicknessSlider.setPreferredSize(new Dimension(150, 16));
        gradientPanel.add((Component)this.thicknessSlider, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gradientPanel.add((Component)this.thicknessRatio, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        labelTip = new LabelTip(this.rb.getString("strength"), true, "tipsBranch", "BRANCH_STRENGTH", this, string);
        gradientPanel.add((Component)labelTip, gridBagConstraints);
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 1;
        this.strengthSlider.setPreferredSize(new Dimension(150, 16));
        gradientPanel.add((Component)this.strengthSlider, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gradientPanel.add((Component)this.strength, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        labelTip = new LabelTip(this.rb.getString("branchReduction"), true, "tipsBranch", "BRANCH_REDUCTION", this, string);
        gradientPanel.add((Component)labelTip, gridBagConstraints);
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 1;
        this.reductionSlider.setPreferredSize(new Dimension(150, 16));
        gradientPanel.add((Component)this.reductionSlider, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gradientPanel.add((Component)this.reduction, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        labelTip = new LabelTip(this.rb.getString("taper"), true, "tipsBranch", "BRANCH_TAPER", this, string);
        gradientPanel.add((Component)labelTip, gridBagConstraints);
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 1;
        this.taperSlider.setPreferredSize(new Dimension(150, 16));
        gradientPanel.add((Component)this.taperSlider, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gradientPanel.add((Component)this.taper, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        labelTip = new LabelTip(this.rb.getString("branchEndEqualizer"), true, "tipsBranch", "BRANCH_END_EQUALIZER", this, string);
        gradientPanel.add((Component)labelTip, gridBagConstraints);
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 1;
        this.endEqSlider.setPreferredSize(new Dimension(150, 16));
        gradientPanel.add((Component)this.endEqSlider, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gradientPanel.add((Component)this.endEqualizer, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        labelTip = new LabelTip(this.rb.getString("tipEnd"), true, "tipsBranch", "BRANCH_TIP", this, string);
        gradientPanel.add((Component)labelTip, gridBagConstraints);
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 1;
        this.tipSlider.setPreferredSize(new Dimension(150, 16));
        gradientPanel.add((Component)this.tipSlider, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gradientPanel.add((Component)this.tipTF, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        labelTip = new LabelTip(this.rb.getString("spiral"), true, "tipsBranch", "BRANCH_SPIRAL", this, string);
        gradientPanel.add((Component)labelTip, gridBagConstraints);
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 1;
        this.spiralSlider.setPreferredSize(new Dimension(150, 16));
        gradientPanel.add((Component)this.spiralSlider, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gradientPanel.add((Component)this.spiral, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        labelTip = new LabelTip(this.rb.getString("branchStraightToTop"), true, "tipsBranch", "STRAIGHTEN_TOWARDS_TOP", this, string);
        gradientPanel.add((Component)labelTip, gridBagConstraints);
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 1;
        this.straightSlider.setPreferredSize(new Dimension(150, 16));
        gradientPanel.add((Component)this.straightSlider, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gradientPanel.add((Component)this.straightenTowardsTop, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        labelTip = new LabelTip(this.rb.getString("angle"), true, "tipsBranch", "BRANCH_ANGLE", this, string);
        gradientPanel.add((Component)labelTip, gridBagConstraints);
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 1;
        this.angleSlider.setPreferredSize(new Dimension(150, 16));
        gradientPanel.add((Component)this.angleSlider, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gradientPanel.add((Component)this.angle, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        labelTip = new LabelTip(this.rb.getString("angleScope"), true, "tipsBranch", "BRANCH_ANGLE_SCOPE", this, string);
        gradientPanel.add((Component)labelTip, gridBagConstraints);
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 1;
        this.angleScopeSlider.setPreferredSize(new Dimension(150, 16));
        gradientPanel.add((Component)this.angleScopeSlider, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gradientPanel.add((Component)this.angleScope, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        labelTip = new LabelTip(this.rb.getString("alignment"), true, "tipsBranch", "BRANCH_ALIGNMENT", this, string);
        gradientPanel.add((Component)labelTip, gridBagConstraints);
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 1;
        this.alignmentSlider.setPreferredSize(new Dimension(150, 16));
        gradientPanel.add((Component)this.alignmentSlider, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gradientPanel.add((Component)this.alignment, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        labelTip = new LabelTip(this.rb.getString("turn"), true, "tipsBranch", "BRANCH_TURN_SWITCH", this, string);
        gradientPanel.add((Component)labelTip, gridBagConstraints);
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 1;
        this.turnSlider.setPreferredSize(new Dimension(150, 16));
        gradientPanel.add((Component)this.turnSlider, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gradientPanel.add((Component)this.turn, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        labelTip = new LabelTip(this.rb.getString("alternate"), true, "tipsBranch", "BRANCH_ALTERNATE_SWITCH", this, string);
        gradientPanel.add((Component)labelTip, gridBagConstraints);
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 1;
        this.alternateSlider.setPreferredSize(new Dimension(150, 16));
        gradientPanel.add((Component)this.alternateSlider, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gradientPanel.add((Component)this.alternate, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 0;
        this.random.setUI(new ButtonUI());
        gridBagConstraints.insets = new Insets(3, 0, 6, 0);
        gradientPanel.add((Component)this.random, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gradientPanel.add((Component)this.randomness, gridBagConstraints);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(6, 6, 6, 6);
        jPanel.add((Component)gradientPanel, gridBagConstraints);
        this.tabPane.addTab(this.rb.getString("general"), jPanel);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 10.0;
        this.add((Component)this.painter, gridBagConstraints);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 0;
        GradientPanel gradientPanel2 = new GradientPanel(25, 5);
        gradientPanel2.setLayout(new GridBagLayout());
        gradientPanel2.setGradientDirection(2);
        gradientPanel2.setRound(1);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        JLabel jLabel = new JLabel(this.rb.getString("treeLatitude"));
        LabelUI labelUI = new LabelUI();
        labelUI.setIsUnderlinable(false);
        jLabel.setUI(labelUI);
        gradientPanel2.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 1;
        this.branchRadialSlider.setPreferredSize(new Dimension(150, 16));
        gradientPanel2.add((Component)this.branchRadialSlider, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gradientPanel2.add((Component)this.branchRadial, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        jLabel = new JLabel(this.rb.getString("treeLongitude"));
        labelUI = new LabelUI();
        labelUI.setIsUnderlinable(false);
        jLabel.setUI(labelUI);
        gradientPanel2.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 1;
        this.branchVertSlider.setPreferredSize(new Dimension(150, 16));
        gradientPanel2.add((Component)this.branchVertSlider, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gradientPanel2.add((Component)this.branchVertical, gridBagConstraints);
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.setOpaque(false);
        jPanel2.add((Component)gradientPanel2, "Center");
        GradientPanel gradientPanel3 = new GradientPanel(40, 20);
        gradientPanel3.setLayout(new GridBagLayout());
        gradientPanel3.setGradientDirection(2);
        gradientPanel3.setRound(0);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        JLabel jLabel2 = new JLabel(this.rb.getString("treeMeshAccuracy"));
        jLabel2.setFont((Font)UIManager.get("TitledBorder.font"));
        jLabel2.setForeground(Color.black);
        gradientPanel3.add((Component)jLabel2, gridBagConstraints);
        jPanel2.add((Component)gradientPanel3, "North");
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.add((Component)jPanel2, gridBagConstraints);
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.weightx = 1.0;
        GradientPanel gradientPanel4 = new GradientPanel(20, 10);
        gradientPanel4.setLayout(new GridBagLayout());
        gradientPanel4.setGradientDirection(2);
        gradientPanel4.setRound(1);
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        labelTip = new LabelTip(this.rb.getString("value"), true, "tipsBranch", "BRANCH_BEND", this, string);
        gradientPanel4.add((Component)labelTip, gridBagConstraints);
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 1;
        this.bendValueSlider.setPreferredSize(new Dimension(150, 16));
        gradientPanel4.add((Component)this.bendValueSlider, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gradientPanel4.add((Component)this.bendValue, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        labelTip = new LabelTip(this.rb.getString("frequency"), true, "tipsBranch", "BRANCH_BEND_FREQUENCY", this, string);
        gradientPanel4.add((Component)labelTip, gridBagConstraints);
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 1;
        this.bendFrequencySlider.setPreferredSize(new Dimension(150, 16));
        gradientPanel4.add((Component)this.bendFrequencySlider, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gradientPanel4.add((Component)this.bendFrequency, gridBagConstraints);
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        labelTip = new LabelTip(this.rb.getString("horizontal"), true, "tipsBranch", "HORIZONTAL_BRANCH_BEND_SWITCH", this, string);
        gradientPanel4.add((Component)labelTip, gridBagConstraints);
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 1;
        this.horizBendSlider.setPreferredSize(new Dimension(150, 16));
        gradientPanel4.add((Component)this.horizBendSlider, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gradientPanel4.add((Component)this.horizontalBend, gridBagConstraints);
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        labelTip = new LabelTip(this.rb.getString("branchExtraNoise"), true, "tipsBranch", "EXTRA_NOISE_SWITCH", this, string);
        gradientPanel4.add((Component)labelTip, gridBagConstraints);
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 1;
        this.extraNoiseSlider.setPreferredSize(new Dimension(150, 16));
        gradientPanel4.add((Component)this.extraNoiseSlider, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gradientPanel4.add((Component)this.extraNoise, gridBagConstraints);
        jPanel2 = new JPanel(new BorderLayout());
        jPanel2.add((Component)gradientPanel4, "Center");
        gradientPanel3 = new GradientPanel(40, 20);
        gradientPanel3.setLayout(new GridBagLayout());
        gradientPanel3.setGradientDirection(2);
        gradientPanel3.setRound(0);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        jLabel2 = new JLabel(this.rb.getString("bend"));
        jLabel2.setFont((Font)UIManager.get("TitledBorder.font"));
        jLabel2.setForeground(Color.black);
        gradientPanel3.add((Component)jLabel2, gridBagConstraints);
        jPanel2.add((Component)gradientPanel3, "North");
        ++n;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(6, 6, 0, 6);
        jPanel.add((Component)jPanel2, gridBagConstraints);
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.fill = 0;
        GradientPanel gradientPanel5 = new GradientPanel(20, 10);
        gradientPanel5.setLayout(new GridBagLayout());
        gradientPanel5.setLayout(new GridBagLayout());
        gradientPanel5.setGradientDirection(2);
        gradientPanel5.setRound(1);
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        labelTip = new LabelTip(this.rb.getString("value"), true, "tipsBranch", "BRANCH_CURVE", this, string);
        gradientPanel5.add((Component)labelTip, gridBagConstraints);
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 1;
        this.curveValueSlider.setPreferredSize(new Dimension(150, 16));
        gradientPanel5.add((Component)this.curveValueSlider, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gradientPanel5.add((Component)this.curveValue, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        labelTip = new LabelTip(this.rb.getString("frequency"), true, "tipsBranch", "BRANCH_CURVE_FREQUENCY", this, string);
        gradientPanel5.add((Component)labelTip, gridBagConstraints);
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 1;
        this.curveFreqSlider.setPreferredSize(new Dimension(150, 16));
        gradientPanel5.add((Component)this.curveFreqSlider, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gradientPanel5.add((Component)this.curveFrequency, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        labelTip = new LabelTip(this.rb.getString("branchLongitudinal"), true, "tipsBranch", "BRANCH_LONGITUDINAL_CURVE", this, string);
        gradientPanel5.add((Component)labelTip, gridBagConstraints);
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 1;
        this.longitudinalSlider.setPreferredSize(new Dimension(150, 16));
        gradientPanel5.add((Component)this.longitudinalSlider, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gradientPanel5.add((Component)this.longitudinal, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        labelTip = new LabelTip(this.rb.getString("branchHorizCurve"), true, "tipsBranch", "HORIZONTAL_BRANCH_CURVE_SWITCH", this, string);
        gradientPanel5.add((Component)labelTip, gridBagConstraints);
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 1;
        this.horizCurveSlider.setPreferredSize(new Dimension(150, 16));
        gradientPanel5.add((Component)this.horizCurveSlider, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gradientPanel5.add((Component)this.horizontalCurve, gridBagConstraints);
        jPanel2 = new JPanel(new BorderLayout());
        jPanel2.add((Component)gradientPanel5, "Center");
        gradientPanel3 = new GradientPanel(40, 20);
        gradientPanel3.setLayout(new GridBagLayout());
        gradientPanel3.setGradientDirection(2);
        gradientPanel3.setRound(0);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        jLabel2 = new JLabel(this.rb.getString("curve"));
        jLabel2.setFont((Font)UIManager.get("TitledBorder.font"));
        jLabel2.setForeground(Color.black);
        gradientPanel3.add((Component)jLabel2, gridBagConstraints);
        jPanel2.add((Component)gradientPanel3, "North");
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(6, 6, 0, 6);
        jPanel.add((Component)jPanel2, gridBagConstraints);
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.fill = 0;
        GradientPanel gradientPanel6 = new GradientPanel(20, 10);
        gradientPanel6.setLayout(new GridBagLayout());
        gradientPanel6.setGradientDirection(2);
        gradientPanel6.setRound(1);
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        labelTip = new LabelTip(this.rb.getString("value"), true, "tipsBranch", "BRANCH_SNAG", this, string);
        gradientPanel6.add((Component)labelTip, gridBagConstraints);
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 1;
        this.snagValueSlider.setPreferredSize(new Dimension(150, 16));
        gradientPanel6.add((Component)this.snagValueSlider, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gradientPanel6.add((Component)this.snagValue, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        labelTip = new LabelTip(this.rb.getString("frequency"), true, "tipsBranch", "BRANCH_SNAG_FREQUENCY", this, string);
        gradientPanel6.add((Component)labelTip, gridBagConstraints);
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 1;
        this.snagFreqSlider.setPreferredSize(new Dimension(150, 16));
        gradientPanel6.add((Component)this.snagFreqSlider, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gradientPanel6.add((Component)this.snagFrequency, gridBagConstraints);
        jPanel2 = new JPanel(new BorderLayout());
        jPanel2.add((Component)gradientPanel6, "Center");
        gradientPanel3 = new GradientPanel(40, 20);
        gradientPanel3.setLayout(new GridBagLayout());
        gradientPanel3.setGradientDirection(2);
        gradientPanel3.setRound(0);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        jLabel2 = new JLabel(this.rb.getString("snag"));
        jLabel2.setFont((Font)UIManager.get("TitledBorder.font"));
        jLabel2.setForeground(Color.black);
        gradientPanel3.add((Component)jLabel2, gridBagConstraints);
        jPanel2.add((Component)gradientPanel3, "North");
        gridBagConstraints.gridy = n;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(6, 6, 6, 6);
        jPanel.add((Component)jPanel2, gridBagConstraints);
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 1;
        this.tabPane.addTab(this.rb.getString("additional"), jPanel);
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(0, 6, 0, 0);
        this.add((Component)this.tabPane, gridBagConstraints);
    }

    public void paintElement() {
        if (this.povTree.getTree() == null) {
            return;
        }
        BlobArray blobArray = null;
        try {
            this.parameters = new Parameters(this.povTree.getTree());
        }
        catch (NumberFormatException numberFormatException) {
            JOptionPane.showMessageDialog(this, this.invalidNumber + " " + numberFormatException.getMessage(), this.rb.getString("error"), 0);
            return;
        }
        if (this.parameters.branches >= 1.0f) {
            this.parameters.branches = 1.0f;
            this.bg = new BranchGenerator(this.parameters);
            try {
                DoubleBlobArray doubleBlobArray = this.bg.generate();
                if (doubleBlobArray != null && (blobArray = doubleBlobArray.get(0)) != null) {
                    blobArray.rotateX(180.0f);
                }
                int n = this.getRadialAccuracy();
                int n2 = this.getVerticalAccuracy();
                if (n != 0 && n2 != 0) {
                    this.painter.setElement(blobArray, n, n2);
                }
            }
            catch (Exception exception) {
                this.painter.setElement(null, 0, 0);
            }
        } else {
            this.painter.setElement(null, 0, 0);
        }
    }

    public void setNextFloat() {
        float f = this.r.nextFloat();
        String string = String.valueOf(f);
        if (string.length() > 6) {
            string = string.substring(0, 6);
        }
        this.randomness.setText(string);
    }

    public void setBranch(Branch branch) {
        this.number.setText(branch.number);
        Helper.setValue(this.number, this.numberSlider, this, this.invalidNumber, this.errorLabel);
        this.randomness.setText(branch.randomness);
        this.startAt.setText(branch.startAt);
        Helper.setValue(this.startAt, this.startAtSlider, this, this.invalidNumber, this.errorLabel);
        this.areaAtTrunk.setText(branch.areaAtTrunk);
        Helper.setValue(this.areaAtTrunk, this.areaSlider, this, this.invalidNumber, this.errorLabel);
        this.thicknessRatio.setText(branch.thicknessRatio);
        Helper.setValue(this.thicknessRatio, this.thicknessSlider, this, this.invalidNumber, this.errorLabel);
        this.strength.setText(branch.strength);
        Helper.setValue(this.strength, this.strengthSlider, this, this.invalidNumber, this.errorLabel);
        this.bendValue.setText(branch.bendValue);
        Helper.setValue(this.bendValue, this.bendValueSlider, this, this.invalidNumber, this.errorLabel);
        this.bendFrequency.setText(branch.bendFrequency);
        Helper.setValue(this.bendFrequency, this.bendFrequencySlider, this, this.invalidNumber, this.errorLabel);
        this.horizontalBend.setText(branch.horizontalBend);
        Helper.setValue(this.horizontalBend, this.horizBendSlider, this, this.invalidNumber, this.errorLabel);
        this.extraNoise.setText(branch.extraNoise);
        Helper.setValue(this.extraNoise, this.extraNoiseSlider, this, this.invalidNumber, this.errorLabel);
        this.curveValue.setText(branch.curveValue);
        Helper.setValue(this.curveValue, this.curveValueSlider, this, this.invalidNumber, this.errorLabel);
        this.curveFrequency.setText(branch.curveFrequency);
        Helper.setValue(this.curveFrequency, this.curveFreqSlider, this, this.invalidNumber, this.errorLabel);
        this.horizontalCurve.setText(branch.horizontalCurve);
        Helper.setValue(this.horizontalCurve, this.horizCurveSlider, this, this.invalidNumber, this.errorLabel);
        this.longitudinal.setText(branch.longitudinal);
        Helper.setValue(this.longitudinal, this.longitudinalSlider, this, this.invalidNumber, this.errorLabel);
        this.snagValue.setText(branch.snagValue);
        Helper.setValue(this.snagValue, this.snagValueSlider, this, this.invalidNumber, this.errorLabel);
        this.snagFrequency.setText(branch.snagFrequency);
        Helper.setValue(this.snagFrequency, this.snagFreqSlider, this, this.invalidNumber, this.errorLabel);
        this.reduction.setText(branch.reduction);
        Helper.setValue(this.reduction, this.reductionSlider, this, this.invalidNumber, this.errorLabel);
        this.taper.setText(branch.taper);
        Helper.setValue(this.taper, this.taperSlider, this, this.invalidNumber, this.errorLabel);
        this.endEqualizer.setText(branch.endEqualizer);
        Helper.setValue(this.endEqualizer, this.endEqSlider, this, this.invalidNumber, this.errorLabel);
        this.tipTF.setText(branch.tip);
        this.turn.setText(branch.turn);
        Helper.setValue(this.turn, this.turnSlider, this, this.invalidNumber, this.errorLabel);
        this.alternate.setText(branch.alternate);
        Helper.setValue(this.alternate, this.alternateSlider, this, this.invalidNumber, this.errorLabel);
        this.spiral.setText(branch.spiral);
        Helper.setValue(this.spiral, this.spiralSlider, this, this.invalidNumber, this.errorLabel);
        this.angle.setText(branch.angle);
        Helper.setValue(this.angle, this.angleSlider, this, this.invalidNumber, this.errorLabel);
        this.angleScope.setText(branch.angleScope);
        Helper.setValue(this.angleScope, this.angleScopeSlider, this, this.invalidNumber, this.errorLabel);
        this.alignment.setText(branch.alignment);
        Helper.setValue(this.alignment, this.alignmentSlider, this, this.invalidNumber, this.errorLabel);
        this.straightenTowardsTop.setText(branch.straightenTowardsTop);
        Helper.setValue(this.straightenTowardsTop, this.straightSlider, this, this.invalidNumber, this.errorLabel);
    }

    public Branch getBranch() {
        Branch branch = new Branch();
        branch.number = this.number.getText();
        branch.randomness = this.randomness.getText();
        branch.startAt = this.startAt.getText();
        branch.areaAtTrunk = this.areaAtTrunk.getText();
        branch.thicknessRatio = this.thicknessRatio.getText();
        branch.strength = this.strength.getText();
        branch.bendValue = this.bendValue.getText();
        branch.bendFrequency = this.bendFrequency.getText();
        branch.horizontalBend = this.horizontalBend.getText();
        branch.extraNoise = this.extraNoise.getText();
        branch.curveValue = this.curveValue.getText();
        branch.curveFrequency = this.curveFrequency.getText();
        branch.horizontalCurve = this.horizontalCurve.getText();
        branch.longitudinal = this.longitudinal.getText();
        branch.snagValue = this.snagValue.getText();
        branch.snagFrequency = this.snagFrequency.getText();
        branch.reduction = this.reduction.getText();
        branch.taper = this.taper.getText();
        branch.endEqualizer = this.endEqualizer.getText();
        branch.tip = this.tipTF.getText();
        branch.turn = this.turn.getText();
        branch.alternate = this.alternate.getText();
        branch.spiral = this.spiral.getText();
        branch.angle = this.angle.getText();
        branch.angleScope = this.angleScope.getText();
        branch.alignment = this.alignment.getText();
        branch.straightenTowardsTop = this.straightenTowardsTop.getText();
        return branch;
    }

    public int getRadialAccuracy() {
        int n = 0;
        String string = this.branchRadial.getText();
        try {
            n = new Integer(string);
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this, this.invalidNumber + " " + string, this.rb.getString("error"), 0);
        }
        return n;
    }

    public int getVerticalAccuracy() {
        int n = 0;
        String string = this.branchVertical.getText();
        try {
            n = new Integer(string);
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this, this.invalidNumber + " " + string, this.rb.getString("error"), 0);
        }
        return n;
    }
}

