/*
 * Decompiled with CFR 0.152.
 */
package povtree.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ResourceBundle;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import povtree.gui.EnterListener;
import povtree.gui.FloatSliderChangeListener;
import povtree.gui.Helper;
import povtree.gui.IntegerSliderChangeListener;
import povtree.gui.LeafPainter;
import povtree.gui.PovTree;
import povtree.gui.Resources;
import povtree.gui.plaf.GradientPanel;
import povtree.gui.plaf.LabelTip;
import povtree.interfaces.Paintable;
import povtree.objects.Bunch;
import povtree.objects3D.DoubleLeafArray;
import povtree.objects3D.LeafArray;
import povtree.objects3D.QuadroLeafArray;
import povtree.objects3D.TripleLeafArray;
import povtree.povTreeGenerator.FoliageGenerator;
import povtree.povTreeGenerator.Parameters;

public class BunchPanel
extends JPanel
implements Paintable {
    private JSlider numberSlider = new JSlider(0, 1000000, 0);
    private JSlider startAtSlider = new JSlider(0, 20000000, 0);
    private JSlider areaSlider = new JSlider(0, 40000000, 0);
    private JSlider majorRadiusSlider = new JSlider(0, 30000000, 0);
    private JSlider minorRadiusSlider = new JSlider(0, 20000000, 0);
    private JSlider angleXSlider = new JSlider(0, 36000000, 0);
    private JSlider angleScopeXSlider = new JSlider(0, 1000000, 0);
    private JSlider alignmentXSlider = new JSlider(0, 100000, 0);
    private JSlider angleYSlider = new JSlider(0, 36000000, 0);
    private JSlider angleScopeYSlider = new JSlider(0, 1000000, 0);
    private JSlider alignmentYSlider = new JSlider(0, 100000, 0);
    private JSlider turnShiftSlider = new JSlider(0, 100000, 0);
    private JSlider funnelHorizSlider = new JSlider(0, 10000000, 0);
    private JSlider funnelVertSlider = new JSlider(0, 10000000, 0);
    private JSlider funnelRotationSlider = new JSlider(0, 36000000, 0);
    private JSlider offTreeSlider = new JSlider(0, 100000, 0);
    private JSlider offBranchSlider = new JSlider(0, 100000, 0);
    private JSlider offTwigSlider = new JSlider(0, 100000, 0);
    private JSlider turnSlider = new JSlider(0, 100000, 0);
    private JSlider alternateSlider = new JSlider(0, 100000, 0);
    private JSlider twigXSlider = new JSlider(0, 300000, 0);
    private JSlider twigYSlider = new JSlider(0, 300000, 0);
    private JSlider twigZSlider = new JSlider(0, 300000, 0);
    private JSlider branchXSlider = new JSlider(0, 300000, 0);
    private JSlider branchYSlider = new JSlider(0, 300000, 0);
    private JSlider branchZSlider = new JSlider(0, 300000, 0);
    private JSlider deformXSlider = new JSlider(0, 300000, 0);
    private JSlider deformYSlider = new JSlider(0, 300000, 0);
    private JSlider deformZSlider = new JSlider(0, 300000, 0);
    private JTextField startAt = new JTextField(7);
    private JTextField areaAtTwig = new JTextField(7);
    private JTextField number = new JTextField(7);
    private JTextField majorRadius = new JTextField(7);
    private JTextField minorRadius = new JTextField(7);
    private JTextField funnelHorizontal = new JTextField(7);
    private JTextField funnelVertical = new JTextField(7);
    private JTextField funnelRotation = new JTextField(7);
    private JTextField horizontalAngle = new JTextField(7);
    private JTextField horizontalAngleScope = new JTextField(7);
    private JTextField horizontalAlignment = new JTextField(7);
    private JTextField verticalAngle = new JTextField(7);
    private JTextField verticalAngleScope = new JTextField(7);
    private JTextField verticalAlignment = new JTextField(7);
    private JTextField turn = new JTextField(7);
    private JTextField turnShift = new JTextField(7);
    private JTextField alternate = new JTextField(7);
    private JTextField taperTree = new JTextField(7);
    private JTextField taperBranch = new JTextField(7);
    private JTextField taperTwig = new JTextField(7);
    private JTextField twigX = new JTextField(7);
    private JTextField twigY = new JTextField(7);
    private JTextField twigZ = new JTextField(7);
    private JTextField branchX = new JTextField(7);
    private JTextField branchY = new JTextField(7);
    private JTextField branchZ = new JTextField(7);
    private JTextField deformX = new JTextField(7);
    private JTextField deformY = new JTextField(7);
    private JTextField deformZ = new JTextField(7);
    private Resources resources = Resources.getInstance();
    private ResourceBundle rb = Resources.getLabelsBundle();
    private ResourceBundle mb = Resources.getMessagesBundle();
    private String invalidNumber = this.mb.getString("invalidNumber");
    private String errorLabel = this.rb.getString("error");
    private LeafPainter painter = new LeafPainter(this.rb);
    private Parameters parameters = null;
    private PovTree povTree = null;
    private FoliageGenerator fg = null;
    private JTabbedPane tabPane = new JTabbedPane();

    public BunchPanel(PovTree povTree, String string) {
        this.povTree = povTree;
        this.setLayout(new GridBagLayout());
        this.setBorder(new EmptyBorder(7, 7, 7, 7));
        this.number.addActionListener(new EnterListener(this.number, this.numberSlider, this, this.invalidNumber, this.errorLabel));
        this.numberSlider.addChangeListener(new IntegerSliderChangeListener(this.number, this));
        this.startAt.addActionListener(new EnterListener(this.startAt, this.startAtSlider, this, this.invalidNumber, this.errorLabel));
        this.startAtSlider.addChangeListener(new FloatSliderChangeListener(this.startAt, this));
        this.areaAtTwig.addActionListener(new EnterListener(this.areaAtTwig, this.areaSlider, this, this.invalidNumber, this.errorLabel));
        this.areaSlider.addChangeListener(new FloatSliderChangeListener(this.areaAtTwig, this));
        this.majorRadius.addActionListener(new EnterListener(this.majorRadius, this.majorRadiusSlider, this, this.invalidNumber, this.errorLabel));
        this.majorRadiusSlider.addChangeListener(new FloatSliderChangeListener(this.majorRadius, this));
        this.minorRadius.addActionListener(new EnterListener(this.minorRadius, this.minorRadiusSlider, this, this.invalidNumber, this.errorLabel));
        this.minorRadiusSlider.addChangeListener(new FloatSliderChangeListener(this.minorRadius, this));
        this.horizontalAngle.addActionListener(new EnterListener(this.horizontalAngle, this.angleXSlider, this, this.invalidNumber, this.errorLabel));
        this.angleXSlider.addChangeListener(new FloatSliderChangeListener(this.horizontalAngle, this));
        this.horizontalAngleScope.addActionListener(new EnterListener(this.horizontalAngleScope, this.angleScopeXSlider, this, this.invalidNumber, this.errorLabel));
        this.angleScopeXSlider.addChangeListener(new FloatSliderChangeListener(this.horizontalAngleScope, this));
        this.horizontalAlignment.addActionListener(new EnterListener(this.horizontalAlignment, this.alignmentXSlider, this, this.invalidNumber, this.errorLabel));
        this.alignmentXSlider.addChangeListener(new FloatSliderChangeListener(this.horizontalAlignment, this));
        this.verticalAngle.addActionListener(new EnterListener(this.verticalAngle, this.angleYSlider, this, this.invalidNumber, this.errorLabel));
        this.angleYSlider.addChangeListener(new FloatSliderChangeListener(this.verticalAngle, this));
        this.verticalAngleScope.addActionListener(new EnterListener(this.verticalAngleScope, this.angleScopeYSlider, this, this.invalidNumber, this.errorLabel));
        this.angleScopeYSlider.addChangeListener(new FloatSliderChangeListener(this.verticalAngleScope, this));
        this.verticalAlignment.addActionListener(new EnterListener(this.verticalAlignment, this.alignmentYSlider, this, this.invalidNumber, this.errorLabel));
        this.alignmentYSlider.addChangeListener(new FloatSliderChangeListener(this.verticalAlignment, this));
        this.turnShift.addActionListener(new EnterListener(this.turnShift, this.turnShiftSlider, this, this.invalidNumber, this.errorLabel));
        this.turnShiftSlider.addChangeListener(new FloatSliderChangeListener(this.turnShift, this));
        this.funnelHorizontal.addActionListener(new EnterListener(this.funnelHorizontal, this.funnelHorizSlider, this, this.invalidNumber, this.errorLabel));
        this.funnelHorizSlider.addChangeListener(new FloatSliderChangeListener(this.funnelHorizontal, this));
        this.funnelVertical.addActionListener(new EnterListener(this.funnelVertical, this.funnelVertSlider, this, this.invalidNumber, this.errorLabel));
        this.funnelVertSlider.addChangeListener(new FloatSliderChangeListener(this.funnelVertical, this));
        this.funnelRotation.addActionListener(new EnterListener(this.funnelRotation, this.funnelRotationSlider, this, this.invalidNumber, this.errorLabel));
        this.funnelRotationSlider.addChangeListener(new FloatSliderChangeListener(this.funnelRotation, this));
        this.taperTree.addActionListener(new EnterListener(this.taperTree, this.offTreeSlider, this, this.invalidNumber, this.errorLabel));
        this.offTreeSlider.addChangeListener(new FloatSliderChangeListener(this.taperTree, this));
        this.taperBranch.addActionListener(new EnterListener(this.taperBranch, this.offBranchSlider, this, this.invalidNumber, this.errorLabel));
        this.offBranchSlider.addChangeListener(new FloatSliderChangeListener(this.taperBranch, this));
        this.taperTwig.addActionListener(new EnterListener(this.taperTwig, this.offTwigSlider, this, this.invalidNumber, this.errorLabel));
        this.offTwigSlider.addChangeListener(new FloatSliderChangeListener(this.taperTwig, this));
        this.twigX.addActionListener(new EnterListener(this.twigX, this.twigXSlider, this, this.invalidNumber, this.errorLabel));
        this.twigXSlider.addChangeListener(new FloatSliderChangeListener(this.twigX, this));
        this.twigY.addActionListener(new EnterListener(this.twigY, this.twigYSlider, this, this.invalidNumber, this.errorLabel));
        this.twigYSlider.addChangeListener(new FloatSliderChangeListener(this.twigY, this));
        this.twigZ.addActionListener(new EnterListener(this.twigZ, this.twigZSlider, this, this.invalidNumber, this.errorLabel));
        this.twigZSlider.addChangeListener(new FloatSliderChangeListener(this.twigZ, this));
        this.branchX.addActionListener(new EnterListener(this.branchX, this.branchXSlider, this, this.invalidNumber, this.errorLabel));
        this.branchXSlider.addChangeListener(new FloatSliderChangeListener(this.branchX, this));
        this.branchY.addActionListener(new EnterListener(this.branchY, this.branchYSlider, this, this.invalidNumber, this.errorLabel));
        this.branchYSlider.addChangeListener(new FloatSliderChangeListener(this.branchY, this));
        this.branchZ.addActionListener(new EnterListener(this.branchZ, this.branchZSlider, this, this.invalidNumber, this.errorLabel));
        this.branchZSlider.addChangeListener(new FloatSliderChangeListener(this.branchZ, this));
        this.deformX.addActionListener(new EnterListener(this.deformX, this.deformXSlider, this, this.invalidNumber, this.errorLabel));
        this.deformXSlider.addChangeListener(new FloatSliderChangeListener(this.deformX, this));
        this.deformY.addActionListener(new EnterListener(this.deformY, this.deformYSlider, this, this.invalidNumber, this.errorLabel));
        this.deformYSlider.addChangeListener(new FloatSliderChangeListener(this.deformY, this));
        this.deformZ.addActionListener(new EnterListener(this.deformZ, this.deformZSlider, this, this.invalidNumber, this.errorLabel));
        this.deformZSlider.addChangeListener(new FloatSliderChangeListener(this.deformZ, this));
        this.turn.addActionListener(new EnterListener(this.turn, this.turnSlider, this, this.invalidNumber, this.errorLabel));
        this.turnSlider.addChangeListener(new FloatSliderChangeListener(this.turn, this));
        this.alternate.addActionListener(new EnterListener(this.alternate, this.alternateSlider, this, this.invalidNumber, this.errorLabel));
        this.alternateSlider.addChangeListener(new FloatSliderChangeListener(this.alternate, this));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        GradientPanel gradientPanel = new GradientPanel(15, 15);
        gradientPanel.setLayout(new GridBagLayout());
        gradientPanel.setGradientDirection(2);
        gradientPanel.setRound(2);
        LabelTip labelTip = new LabelTip(this.rb.getString("number"), true, "tipsBunch", "BUNCHES", this, string);
        gradientPanel.add((Component)labelTip, gridBagConstraints);
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 1;
        this.numberSlider.setPreferredSize(new Dimension(150, 16));
        gradientPanel.add((Component)this.numberSlider, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gradientPanel.add((Component)this.number, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        labelTip = new LabelTip(this.rb.getString("startAt"), true, "tipsBunch", "FIRST_BUNCH_AT_TWIG", this, string);
        gradientPanel.add((Component)labelTip, gridBagConstraints);
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 1;
        this.startAtSlider.setPreferredSize(new Dimension(150, 16));
        gradientPanel.add((Component)this.startAtSlider, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gradientPanel.add((Component)this.startAt, gridBagConstraints);
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        labelTip = new LabelTip(this.rb.getString("areaAtTwig"), true, "tipsBunch", "BUNCH_AREA_AT_TWIG", this, string);
        gradientPanel.add((Component)labelTip, gridBagConstraints);
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 1;
        this.areaSlider.setPreferredSize(new Dimension(150, 16));
        gradientPanel.add((Component)this.areaSlider, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gradientPanel.add((Component)this.areaAtTwig, gridBagConstraints);
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        labelTip = new LabelTip(this.rb.getString("majorRadius"), true, "tipsBunch", "BUNCH_MAJOR_RADIUS", this, string);
        gradientPanel.add((Component)labelTip, gridBagConstraints);
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 1;
        this.majorRadiusSlider.setPreferredSize(new Dimension(150, 16));
        gradientPanel.add((Component)this.majorRadiusSlider, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gradientPanel.add((Component)this.majorRadius, gridBagConstraints);
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        labelTip = new LabelTip(this.rb.getString("minorRadius"), true, "tipsBunch", "BUNCH_MINOR_RADIUS", this, string);
        gradientPanel.add((Component)labelTip, gridBagConstraints);
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 1;
        this.minorRadiusSlider.setPreferredSize(new Dimension(150, 16));
        gradientPanel.add((Component)this.minorRadiusSlider, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gradientPanel.add((Component)this.minorRadius, gridBagConstraints);
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        labelTip = new LabelTip(this.rb.getString("turn"), true, "tipsBunch", "BUNCH_TURN_SWITCH", this, string);
        gradientPanel.add((Component)labelTip, gridBagConstraints);
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 1;
        this.turnSlider.setPreferredSize(new Dimension(150, 16));
        gradientPanel.add((Component)this.turnSlider, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gradientPanel.add((Component)this.turn, gridBagConstraints);
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        labelTip = new LabelTip(this.rb.getString("turnShift"), true, "tipsBunch", "BUNCH_TURN_SHIFT", this, string);
        gradientPanel.add((Component)labelTip, gridBagConstraints);
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 1;
        this.turnShiftSlider.setPreferredSize(new Dimension(150, 16));
        gradientPanel.add((Component)this.turnShiftSlider, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gradientPanel.add((Component)this.turnShift, gridBagConstraints);
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        labelTip = new LabelTip(this.rb.getString("alternate"), true, "tipsBunch", "BUNCH_ALTERNATE_SWITCH", this, string);
        gradientPanel.add((Component)labelTip, gridBagConstraints);
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 1;
        this.alternateSlider.setPreferredSize(new Dimension(150, 16));
        gradientPanel.add((Component)this.alternateSlider, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gradientPanel.add((Component)this.alternate, gridBagConstraints);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(6, 6, 6, 6);
        jPanel.add((Component)gradientPanel, gridBagConstraints);
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        GradientPanel gradientPanel2 = new GradientPanel(20, 10);
        gradientPanel2.setLayout(new GridBagLayout());
        gradientPanel2.setGradientDirection(2);
        gradientPanel2.setRound(1);
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        labelTip = new LabelTip(this.rb.getString("angle"), true, "tipsBunch", "HORIZONTAL_BUNCH_ANGLE", this, string);
        gradientPanel2.add((Component)labelTip, gridBagConstraints);
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 1;
        this.angleXSlider.setPreferredSize(new Dimension(150, 16));
        gradientPanel2.add((Component)this.angleXSlider, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gradientPanel2.add((Component)this.horizontalAngle, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        labelTip = new LabelTip(this.rb.getString("angleScope"), true, "tipsBunch", "HORIZONTAL_BUNCH_ANGLE_SCOPE", this, string);
        gradientPanel2.add((Component)labelTip, gridBagConstraints);
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 1;
        this.angleScopeXSlider.setPreferredSize(new Dimension(150, 16));
        gradientPanel2.add((Component)this.angleScopeXSlider, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gradientPanel2.add((Component)this.horizontalAngleScope, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        labelTip = new LabelTip(this.rb.getString("alignment"), true, "tipsBunch", "HORIZONTAL_BUNCH_ALIGNMENT", this, string);
        gradientPanel2.add((Component)labelTip, gridBagConstraints);
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 1;
        this.alignmentXSlider.setPreferredSize(new Dimension(150, 16));
        gradientPanel2.add((Component)this.alignmentXSlider, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gradientPanel2.add((Component)this.horizontalAlignment, gridBagConstraints);
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.add((Component)gradientPanel2, "Center");
        GradientPanel gradientPanel3 = new GradientPanel(40, 20);
        gradientPanel3.setLayout(new GridBagLayout());
        gradientPanel3.setGradientDirection(2);
        gradientPanel3.setRound(0);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        JLabel jLabel = new JLabel(this.rb.getString("horizontal"));
        jLabel.setFont((Font)UIManager.get("TitledBorder.font"));
        jLabel.setForeground(Color.black);
        gradientPanel3.add((Component)jLabel, gridBagConstraints);
        jPanel2.add((Component)gradientPanel3, "North");
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 6, 6, 6);
        jPanel.add((Component)jPanel2, gridBagConstraints);
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gradientPanel2 = new GradientPanel(20, 10);
        gradientPanel2.setLayout(new GridBagLayout());
        gradientPanel2.setGradientDirection(2);
        gradientPanel2.setRound(1);
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        labelTip = new LabelTip(this.rb.getString("angle"), true, "tipsBunch", "VERTICAL_BUNCH_ANGLE", this, string);
        gradientPanel2.add((Component)labelTip, gridBagConstraints);
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 1;
        this.angleYSlider.setPreferredSize(new Dimension(150, 16));
        gradientPanel2.add((Component)this.angleYSlider, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gradientPanel2.add((Component)this.verticalAngle, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        labelTip = new LabelTip(this.rb.getString("angleScope"), true, "tipsBunch", "VERTICAL_BUNCH_ANGLE_SCOPE", this, string);
        gradientPanel2.add((Component)labelTip, gridBagConstraints);
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 1;
        this.angleScopeYSlider.setPreferredSize(new Dimension(150, 16));
        gradientPanel2.add((Component)this.angleScopeYSlider, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gradientPanel2.add((Component)this.verticalAngleScope, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        labelTip = new LabelTip(this.rb.getString("alignment"), true, "tipsBunch", "VERTICAL_BUNCH_ALIGNMENT", this, string);
        gradientPanel2.add((Component)labelTip, gridBagConstraints);
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 1;
        this.alignmentYSlider.setPreferredSize(new Dimension(150, 16));
        gradientPanel2.add((Component)this.alignmentYSlider, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gradientPanel2.add((Component)this.verticalAlignment, gridBagConstraints);
        jPanel2 = new JPanel(new BorderLayout());
        jPanel2.add((Component)gradientPanel2, "Center");
        gradientPanel3 = new GradientPanel(40, 20);
        gradientPanel3.setLayout(new GridBagLayout());
        gradientPanel3.setGradientDirection(2);
        gradientPanel3.setRound(0);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        jLabel = new JLabel(this.rb.getString("vertical"));
        jLabel.setFont((Font)UIManager.get("TitledBorder.font"));
        jLabel.setForeground(Color.black);
        gradientPanel3.add((Component)jLabel, gridBagConstraints);
        jPanel2.add((Component)gradientPanel3, "North");
        gridBagConstraints.gridy = 9;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 6, 6, 6);
        jPanel.add((Component)jPanel2, gridBagConstraints);
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 4.0;
        gridBagConstraints.weighty = 10.0;
        this.add((Component)this.painter, gridBagConstraints);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.tabPane.addTab(this.rb.getString("general"), jPanel);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gradientPanel2 = new GradientPanel(20, 10);
        gradientPanel2.setLayout(new GridBagLayout());
        gradientPanel2.setGradientDirection(2);
        gradientPanel2.setRound(1);
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        labelTip = new LabelTip(this.rb.getString("horizontal"), true, "tipsBunch", "HORIZONTAL_BUNCH_FUNNEL", this, string);
        gradientPanel2.add((Component)labelTip, gridBagConstraints);
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 1;
        this.funnelHorizSlider.setPreferredSize(new Dimension(150, 16));
        gradientPanel2.add((Component)this.funnelHorizSlider, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gradientPanel2.add((Component)this.funnelHorizontal, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        labelTip = new LabelTip(this.rb.getString("vertical"), true, "tipsBunch", "VERTICAL_BUNCH_FUNNEL", this, string);
        gradientPanel2.add((Component)labelTip, gridBagConstraints);
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 1;
        this.funnelVertSlider.setPreferredSize(new Dimension(150, 16));
        gradientPanel2.add((Component)this.funnelVertSlider, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gradientPanel2.add((Component)this.funnelVertical, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        labelTip = new LabelTip(this.rb.getString("rotation"), true, "tipsBunch", "ROTATION_BUNCH_FUNNEL", this, string);
        gradientPanel2.add((Component)labelTip, gridBagConstraints);
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 1;
        this.funnelRotationSlider.setPreferredSize(new Dimension(150, 16));
        gradientPanel2.add((Component)this.funnelRotationSlider, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gradientPanel2.add((Component)this.funnelRotation, gridBagConstraints);
        jPanel2 = new JPanel(new BorderLayout());
        jPanel2.add((Component)gradientPanel2, "Center");
        gradientPanel3 = new GradientPanel(40, 20);
        gradientPanel3.setLayout(new GridBagLayout());
        gradientPanel3.setGradientDirection(2);
        gradientPanel3.setRound(0);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        jLabel = new JLabel(this.rb.getString("funnel"));
        jLabel.setFont((Font)UIManager.get("TitledBorder.font"));
        jLabel.setForeground(Color.black);
        gradientPanel3.add((Component)jLabel, gridBagConstraints);
        jPanel2.add((Component)gradientPanel3, "North");
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.add((Component)jPanel2, gridBagConstraints);
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new GridBagLayout());
        gradientPanel2 = new GradientPanel(20, 10);
        gradientPanel2.setLayout(new GridBagLayout());
        gradientPanel2.setGradientDirection(2);
        gradientPanel2.setRound(1);
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        labelTip = new LabelTip(this.rb.getString("tree"), true, "tipsBunch", "BUNCH_TAPER_OFF_AT_TREE", this, string);
        gradientPanel2.add((Component)labelTip, gridBagConstraints);
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 1;
        this.offTreeSlider.setPreferredSize(new Dimension(150, 16));
        gradientPanel2.add((Component)this.offTreeSlider, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gradientPanel2.add((Component)this.taperTree, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        labelTip = new LabelTip(this.rb.getString("branch"), true, "tipsBunch", "BUNCH_TAPER_OFF_AT_BRANCH", this, string);
        gradientPanel2.add((Component)labelTip, gridBagConstraints);
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 1;
        this.offBranchSlider.setPreferredSize(new Dimension(150, 16));
        gradientPanel2.add((Component)this.offBranchSlider, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gradientPanel2.add((Component)this.taperBranch, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        labelTip = new LabelTip(this.rb.getString("twig"), true, "tipsBunch", "BUNCH_TAPER_OFF_AT_TWIG", this, string);
        gradientPanel2.add((Component)labelTip, gridBagConstraints);
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 1;
        this.offTwigSlider.setPreferredSize(new Dimension(150, 16));
        gradientPanel2.add((Component)this.offTwigSlider, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gradientPanel2.add((Component)this.taperTwig, gridBagConstraints);
        jPanel2 = new JPanel(new BorderLayout());
        jPanel2.add((Component)gradientPanel2, "Center");
        gradientPanel3 = new GradientPanel(40, 20);
        gradientPanel3.setLayout(new GridBagLayout());
        gradientPanel3.setGradientDirection(2);
        gradientPanel3.setRound(0);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        jLabel = new JLabel(this.rb.getString("taperOffAt"));
        jLabel.setFont((Font)UIManager.get("TitledBorder.font"));
        jLabel.setForeground(Color.black);
        gradientPanel3.add((Component)jLabel, gridBagConstraints);
        jPanel2.add((Component)gradientPanel3, "North");
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(6, 6, 6, 6);
        jPanel.add((Component)jPanel2, gridBagConstraints);
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 6, 6, 6);
        gradientPanel2 = new GradientPanel(20, 10);
        gradientPanel2.setLayout(new GridBagLayout());
        gradientPanel2.setGradientDirection(2);
        gradientPanel2.setRound(1);
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        labelTip = new LabelTip("X", true, "tipsBunch", "BUNCH_ARC_AT_TWIG", this, string);
        gradientPanel2.add((Component)labelTip, gridBagConstraints);
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 1;
        this.twigXSlider.setPreferredSize(new Dimension(150, 16));
        gradientPanel2.add((Component)this.twigXSlider, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gradientPanel2.add((Component)this.twigX, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        labelTip = new LabelTip("Y", true, "tipsBunch", "BUNCH_ARC_AT_TWIG", this, string);
        gradientPanel2.add((Component)labelTip, gridBagConstraints);
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 1;
        this.twigYSlider.setPreferredSize(new Dimension(150, 16));
        gradientPanel2.add((Component)this.twigYSlider, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gradientPanel2.add((Component)this.twigY, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        labelTip = new LabelTip("Z", true, "tipsBunch", "BUNCH_ARC_AT_TWIG", this, string);
        gradientPanel2.add((Component)labelTip, gridBagConstraints);
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 1;
        this.twigZSlider.setPreferredSize(new Dimension(150, 16));
        gradientPanel2.add((Component)this.twigZSlider, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gradientPanel2.add((Component)this.twigZ, gridBagConstraints);
        jPanel2 = new JPanel(new BorderLayout());
        jPanel2.add((Component)gradientPanel2, "Center");
        gradientPanel3 = new GradientPanel(40, 20);
        gradientPanel3.setLayout(new GridBagLayout());
        gradientPanel3.setGradientDirection(2);
        gradientPanel3.setRound(0);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        jLabel = new JLabel(this.rb.getString("arcAtTwig"));
        jLabel.setFont((Font)UIManager.get("TitledBorder.font"));
        jLabel.setForeground(Color.black);
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gradientPanel3.add((Component)jLabel, gridBagConstraints);
        jPanel2.add((Component)gradientPanel3, "North");
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 6, 6, 6);
        jPanel.add((Component)jPanel2, gridBagConstraints);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gradientPanel2 = new GradientPanel(20, 10);
        gradientPanel2.setLayout(new GridBagLayout());
        gradientPanel2.setGradientDirection(2);
        gradientPanel2.setRound(1);
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        labelTip = new LabelTip("X", true, "tipsBunch", "BUNCH_ARC_AT_BRANCH", this, string);
        gradientPanel2.add((Component)labelTip, gridBagConstraints);
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 1;
        this.branchXSlider.setPreferredSize(new Dimension(150, 16));
        gradientPanel2.add((Component)this.branchXSlider, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gradientPanel2.add((Component)this.branchX, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        labelTip = new LabelTip("Y", true, "tipsBunch", "BUNCH_ARC_AT_BRANCH", this, string);
        gradientPanel2.add((Component)labelTip, gridBagConstraints);
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 1;
        this.branchYSlider.setPreferredSize(new Dimension(150, 16));
        gradientPanel2.add((Component)this.branchYSlider, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gradientPanel2.add((Component)this.branchY, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        labelTip = new LabelTip("Z", true, "tipsBunch", "BUNCH_ARC_AT_BRANCH", this, string);
        gradientPanel2.add((Component)labelTip, gridBagConstraints);
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 1;
        this.branchZSlider.setPreferredSize(new Dimension(150, 16));
        gradientPanel2.add((Component)this.branchZSlider, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gradientPanel2.add((Component)this.branchZ, gridBagConstraints);
        jPanel2 = new JPanel(new BorderLayout());
        jPanel2.add((Component)gradientPanel2, "Center");
        gradientPanel3 = new GradientPanel(40, 20);
        gradientPanel3.setLayout(new GridBagLayout());
        gradientPanel3.setGradientDirection(2);
        gradientPanel3.setRound(0);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        jLabel = new JLabel(this.rb.getString("arcAtBranch"));
        jLabel.setFont((Font)UIManager.get("TitledBorder.font"));
        jLabel.setForeground(Color.black);
        gradientPanel3.add((Component)jLabel, gridBagConstraints);
        jPanel2.add((Component)gradientPanel3, "North");
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 6, 6, 6);
        jPanel.add((Component)jPanel2, gridBagConstraints);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gradientPanel2 = new GradientPanel(20, 10);
        gradientPanel2.setLayout(new GridBagLayout());
        gradientPanel2.setGradientDirection(2);
        gradientPanel2.setRound(1);
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        labelTip = new LabelTip("X", true, "tipsBunch", "BUNCH_DEFORM", this, string);
        gradientPanel2.add((Component)labelTip, gridBagConstraints);
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 1;
        this.deformXSlider.setPreferredSize(new Dimension(150, 16));
        gradientPanel2.add((Component)this.deformXSlider, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gradientPanel2.add((Component)this.deformX, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        labelTip = new LabelTip("Y", true, "tipsBunch", "BUNCH_DEFORM", this, string);
        gradientPanel2.add((Component)labelTip, gridBagConstraints);
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 1;
        this.deformYSlider.setPreferredSize(new Dimension(150, 16));
        gradientPanel2.add((Component)this.deformYSlider, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gradientPanel2.add((Component)this.deformY, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        labelTip = new LabelTip("Z", true, "tipsBunch", "BUNCH_DEFORM", this, string);
        gradientPanel2.add((Component)labelTip, gridBagConstraints);
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 1;
        this.deformZSlider.setPreferredSize(new Dimension(150, 16));
        gradientPanel2.add((Component)this.deformZSlider, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gradientPanel2.add((Component)this.deformZ, gridBagConstraints);
        jPanel2 = new JPanel(new BorderLayout());
        jPanel2.add((Component)gradientPanel2, "Center");
        gradientPanel3 = new GradientPanel(40, 20);
        gradientPanel3.setLayout(new GridBagLayout());
        gradientPanel3.setGradientDirection(2);
        gradientPanel3.setRound(0);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        jLabel = new JLabel(this.rb.getString("deform"));
        jLabel.setFont((Font)UIManager.get("TitledBorder.font"));
        jLabel.setForeground(Color.black);
        gradientPanel3.add((Component)jLabel, gridBagConstraints);
        jPanel2.add((Component)gradientPanel3, "North");
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 6, 6, 6);
        jPanel.add((Component)jPanel2, gridBagConstraints);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 1;
        this.tabPane.addTab(this.rb.getString("additional"), jPanel);
        gridBagConstraints.insets = new Insets(0, 6, 0, 0);
        this.add((Component)this.tabPane, gridBagConstraints);
    }

    public void paintElement() {
        if (this.povTree.getTree() == null) {
            return;
        }
        LeafArray leafArray = null;
        try {
            this.parameters = new Parameters(this.povTree.getTree());
        }
        catch (NumberFormatException numberFormatException) {
            JOptionPane.showMessageDialog(this, this.invalidNumber + " " + numberFormatException.getMessage(), this.rb.getString("error"), 0);
            return;
        }
        if (this.parameters.twigs >= 1.0f) {
            float f = this.parameters.leaves / this.parameters.bunches;
            this.parameters.leaves = f > 500.0f ? 500.0f : f;
            this.parameters.branches = 1.0f;
            this.parameters.twigs = 1.0f;
            this.parameters.bunches = 1.0f;
            this.fg = this.parameters.leafType != null && this.parameters.leafType.startsWith("Mesh") ? new FoliageGenerator(this.parameters, true, this.parameters.leafType) : new FoliageGenerator(this.parameters, true, "Mesh1");
            try {
                QuadroLeafArray quadroLeafArray = (QuadroLeafArray)this.fg.generate();
                TripleLeafArray tripleLeafArray = quadroLeafArray.get(0);
                DoubleLeafArray doubleLeafArray = tripleLeafArray.get(0);
                leafArray = doubleLeafArray.get(0);
                if (leafArray != null) {
                    leafArray.rotateX(180.0f);
                }
                this.painter.setElement(leafArray, new Color(this.parameters.topR1, this.parameters.topG1, this.parameters.topB1));
            }
            catch (Exception exception) {
                this.painter.setElement(null, null);
            }
        } else {
            this.painter.setElement(null, null);
        }
    }

    public void setBunch(Bunch bunch) {
        this.startAt.setText(bunch.startAt);
        Helper.setValue(this.startAt, this.startAtSlider, this, this.invalidNumber, this.errorLabel);
        this.areaAtTwig.setText(bunch.areaAtTwig);
        Helper.setValue(this.areaAtTwig, this.areaSlider, this, this.invalidNumber, this.errorLabel);
        this.number.setText(bunch.number);
        Helper.setValue(this.number, this.numberSlider, this, this.invalidNumber, this.errorLabel);
        this.majorRadius.setText(bunch.majorRadius);
        Helper.setValue(this.majorRadius, this.majorRadiusSlider, this, this.invalidNumber, this.errorLabel);
        this.minorRadius.setText(bunch.minorRadius);
        Helper.setValue(this.minorRadius, this.minorRadiusSlider, this, this.invalidNumber, this.errorLabel);
        this.funnelHorizontal.setText(bunch.funnelHorizontal);
        Helper.setValue(this.funnelHorizontal, this.funnelHorizSlider, this, this.invalidNumber, this.errorLabel);
        this.funnelVertical.setText(bunch.funnelVertical);
        Helper.setValue(this.funnelVertical, this.funnelVertSlider, this, this.invalidNumber, this.errorLabel);
        this.funnelRotation.setText(bunch.funnelRotation);
        Helper.setValue(this.funnelRotation, this.funnelRotationSlider, this, this.invalidNumber, this.errorLabel);
        this.horizontalAngle.setText(bunch.horizontalAngle);
        Helper.setValue(this.horizontalAngle, this.angleXSlider, this, this.invalidNumber, this.errorLabel);
        this.horizontalAngleScope.setText(bunch.horizontalAngleScope);
        Helper.setValue(this.horizontalAngleScope, this.angleScopeXSlider, this, this.invalidNumber, this.errorLabel);
        this.horizontalAlignment.setText(bunch.horizontalAlignment);
        Helper.setValue(this.horizontalAlignment, this.alignmentXSlider, this, this.invalidNumber, this.errorLabel);
        this.verticalAngle.setText(bunch.verticalAngle);
        Helper.setValue(this.verticalAngle, this.angleYSlider, this, this.invalidNumber, this.errorLabel);
        this.verticalAngleScope.setText(bunch.verticalAngleScope);
        Helper.setValue(this.verticalAngleScope, this.angleScopeYSlider, this, this.invalidNumber, this.errorLabel);
        this.verticalAlignment.setText(bunch.verticalAlignment);
        Helper.setValue(this.verticalAlignment, this.alignmentYSlider, this, this.invalidNumber, this.errorLabel);
        this.turn.setText(bunch.turn);
        Helper.setValue(this.turn, this.turnSlider, this, this.invalidNumber, this.errorLabel);
        this.alternate.setText(bunch.alternate);
        Helper.setValue(this.alternate, this.alternateSlider, this, this.invalidNumber, this.errorLabel);
        this.turnShift.setText(bunch.turnShift);
        Helper.setValue(this.turnShift, this.turnShiftSlider, this, this.invalidNumber, this.errorLabel);
        this.taperTree.setText(bunch.taperTree);
        Helper.setValue(this.taperTree, this.offTreeSlider, this, this.invalidNumber, this.errorLabel);
        this.taperBranch.setText(bunch.taperBranch);
        Helper.setValue(this.taperBranch, this.offBranchSlider, this, this.invalidNumber, this.errorLabel);
        this.taperTwig.setText(bunch.taperTwig);
        Helper.setValue(this.taperTwig, this.offTwigSlider, this, this.invalidNumber, this.errorLabel);
        this.twigX.setText(bunch.twigX);
        Helper.setValue(this.twigX, this.twigXSlider, this, this.invalidNumber, this.errorLabel);
        this.twigY.setText(bunch.twigY);
        Helper.setValue(this.twigY, this.twigYSlider, this, this.invalidNumber, this.errorLabel);
        this.twigZ.setText(bunch.twigZ);
        Helper.setValue(this.twigZ, this.twigZSlider, this, this.invalidNumber, this.errorLabel);
        this.branchX.setText(bunch.branchX);
        Helper.setValue(this.branchX, this.branchXSlider, this, this.invalidNumber, this.errorLabel);
        this.branchY.setText(bunch.branchY);
        Helper.setValue(this.branchY, this.branchYSlider, this, this.invalidNumber, this.errorLabel);
        this.branchZ.setText(bunch.branchZ);
        Helper.setValue(this.branchZ, this.branchZSlider, this, this.invalidNumber, this.errorLabel);
        this.deformX.setText(bunch.deformX);
        Helper.setValue(this.deformX, this.deformXSlider, this, this.invalidNumber, this.errorLabel);
        this.deformY.setText(bunch.deformY);
        Helper.setValue(this.deformY, this.deformYSlider, this, this.invalidNumber, this.errorLabel);
        this.deformZ.setText(bunch.deformZ);
        Helper.setValue(this.deformZ, this.deformZSlider, this, this.invalidNumber, this.errorLabel);
    }

    public Bunch getBunch() {
        Bunch bunch = new Bunch();
        bunch.startAt = this.startAt.getText();
        bunch.areaAtTwig = this.areaAtTwig.getText();
        bunch.number = this.number.getText();
        bunch.majorRadius = this.majorRadius.getText();
        bunch.minorRadius = this.minorRadius.getText();
        bunch.funnelHorizontal = this.funnelHorizontal.getText();
        bunch.funnelVertical = this.funnelVertical.getText();
        bunch.funnelRotation = this.funnelRotation.getText();
        bunch.horizontalAngle = this.horizontalAngle.getText();
        bunch.horizontalAngleScope = this.horizontalAngleScope.getText();
        bunch.horizontalAlignment = this.horizontalAlignment.getText();
        bunch.verticalAngle = this.verticalAngle.getText();
        bunch.verticalAngleScope = this.verticalAngleScope.getText();
        bunch.verticalAlignment = this.verticalAlignment.getText();
        bunch.turn = this.turn.getText();
        bunch.turnShift = this.turnShift.getText();
        bunch.alternate = this.alternate.getText();
        bunch.taperTree = this.taperTree.getText();
        bunch.taperBranch = this.taperBranch.getText();
        bunch.taperTwig = this.taperTwig.getText();
        bunch.twigX = this.twigX.getText();
        bunch.twigY = this.twigY.getText();
        bunch.twigZ = this.twigZ.getText();
        bunch.branchX = this.branchX.getText();
        bunch.branchY = this.branchY.getText();
        bunch.branchZ = this.branchZ.getText();
        bunch.deformX = this.deformX.getText();
        bunch.deformY = this.deformY.getText();
        bunch.deformZ = this.deformZ.getText();
        return bunch;
    }
}

