/*
 * Decompiled with CFR 0.152.
 */
package povtree.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ResourceBundle;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListSelectionModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import povtree.gui.EnterListener;
import povtree.gui.FloatSliderChangeListener;
import povtree.gui.Helper;
import povtree.gui.ImageAccessor;
import povtree.gui.ImageFilter;
import povtree.gui.IntegerSliderChangeListener;
import povtree.gui.LeafPainter;
import povtree.gui.LeafUvPainter;
import povtree.gui.MapTableModel;
import povtree.gui.PovTree;
import povtree.gui.Resources;
import povtree.gui.plaf.ButtonUI;
import povtree.gui.plaf.ColorChooser;
import povtree.gui.plaf.GradientPanel;
import povtree.gui.plaf.LabelTip;
import povtree.gui.plaf.LabelUI;
import povtree.interfaces.Constants;
import povtree.interfaces.Paintable;
import povtree.objects.Foliage;
import povtree.objects3D.DoubleLeafArray;
import povtree.objects3D.LeafArray;
import povtree.objects3D.LeafMesh;
import povtree.objects3D.LeafUv1;
import povtree.objects3D.LeafUv10;
import povtree.objects3D.LeafUv11;
import povtree.objects3D.LeafUv12;
import povtree.objects3D.LeafUv2;
import povtree.objects3D.LeafUv3;
import povtree.objects3D.LeafUv4;
import povtree.objects3D.LeafUv5;
import povtree.objects3D.LeafUv6;
import povtree.objects3D.LeafUv7;
import povtree.objects3D.LeafUv8;
import povtree.objects3D.LeafUv9;
import povtree.objects3D.QuadroLeafArray;
import povtree.objects3D.TableLeaf;
import povtree.objects3D.TripleLeafArray;
import povtree.povTreeGenerator.FoliageGenerator;
import povtree.povTreeGenerator.Parameters;

public class FoliagePanel
extends JPanel
implements Constants,
Paintable {
    private JSlider numberSlider = new JSlider(0, 50000000, 0);
    private JSlider lengthSlider = new JSlider(0, 5000000, 0);
    private JSlider breadthSlider = new JSlider(0, 5000000, 0);
    private JSlider heightSlider = new JSlider(0, 1000000, 0);
    private JSlider tiltSlider = new JSlider(0, 36000000, 0);
    private JSlider turnSlider = new JSlider(0, 36000000, 0);
    private JSlider inclinationSlider = new JSlider(0, 36000000, 0);
    private JSlider inclinationScopeSlider = new JSlider(0, 2000000, 0);
    private JSlider turbulenceSlider = new JSlider(0, 100000, 0);
    private JSlider transitionSlider = new JSlider(0, 100000, 0);
    private JSlider transTurbSlider = new JSlider(0, 100000, 0);
    private JSlider glossSlider = new JSlider(0, 100000, 0);
    private JSlider filterSlider = new JSlider(0, 100000, 0);
    private JSlider transparencySlider = new JSlider(0, 100000, 0);
    private JTabbedPane tabbedPane = new JTabbedPane();
    private JTextField number = new JTextField(7);
    private JTextField length = new JTextField(7);
    private JTextField breadth = new JTextField(7);
    private JTextField height = new JTextField(7);
    private JTextField maxTilt = new JTextField(7);
    private JTextField maxTurn = new JTextField(7);
    private JTextField inclination = new JTextField(7);
    private JTextField inclinationScope = new JTextField(7);
    private JTextField turbulence = new JTextField(7);
    private JTextField transition = new JTextField(7);
    private JTextField transitionTurbulence = new JTextField(7);
    private JTextField gloss = new JTextField(7);
    private JTextField filter = new JTextField(7);
    private JTextField transparency = new JTextField(7);
    private String[] leaves = new String[]{"LEAF", "CSG_LEAF", "HF_LEAF", "HF_LEAF_tex", "HF_PALMLEAF", "HF_PALMLEAF_tex", "HF_PALMLEAF1", "HF_PALMLEAF1_tex", "Mesh1", "Mesh3", "Mesh4", "Mesh4a", "Mesh6a", "Mesh6b", "Mesh10", "Mesh12a", "Mesh12b", "Mesh24"};
    private JToggleButton[] typeTB = new JToggleButton[this.leaves.length];
    private JToggleButton invisibleTB = null;
    private JToggleButton[] typeUvTB = new JToggleButton[12];
    private ButtonGroup bg = new ButtonGroup();
    private JCheckBox useCustomMesh = null;
    private JTextArea editor = new JTextArea();
    private JButton topRight = new JButton(new ImageIcon(this.getClass().getResource("images/right.png")));
    private JButton topLeft = new JButton(new ImageIcon(this.getClass().getResource("images/left.png")));
    private JButton bottomRight = new JButton(new ImageIcon(this.getClass().getResource("images/right.png")));
    private JButton bottomLeft = new JButton(new ImageIcon(this.getClass().getResource("images/left.png")));
    private JButton up1 = new JButton(new ImageIcon(this.getClass().getResource("images/up.png")));
    private JButton down1 = new JButton(new ImageIcon(this.getClass().getResource("images/down.png")));
    private JButton up2 = new JButton(new ImageIcon(this.getClass().getResource("images/up.png")));
    private JButton down2 = new JButton(new ImageIcon(this.getClass().getResource("images/down.png")));
    private JCheckBox useUv = null;
    private JTextField imageName = new JTextField(15);
    private JTextField bumpName = new JTextField(15);
    private JTextField bumpSize = new JTextField(3);
    private JTable mapTable = new JTable();
    private MapTableModel mtm = null;
    private JButton add = null;
    private JButton remove = null;
    private String currentPath = null;
    private JButton loadImage = new JButton("...");
    private JButton loadBump = new JButton("...");
    private JFileChooser fc = null;
    private String selectUv = null;
    private String enterImageName = null;
    private String notSupportedFileType = null;
    private String wrongNumber = null;
    private String invalidFileExtension = null;
    private Resources resources = Resources.getInstance();
    private ResourceBundle rb = Resources.getLabelsBundle();
    private ResourceBundle mb = Resources.getMessagesBundle();
    private String invalidNumber = this.mb.getString("invalidNumber");
    private String errorLabel = this.rb.getString("error");
    private ColorChooser top1Chooser;
    private ColorChooser top2Chooser;
    private ColorChooser bottom1Chooser;
    private ColorChooser bottom2Chooser;
    private LeafPainter painter = new LeafPainter(this.rb);
    private Parameters parameters = null;
    private PovTree povTree = null;
    private FoliageGenerator fg = null;
    private JSlider leafLongitudinalSlider = new JSlider(100000, 3000000, 100000);
    private JSlider leafLatitudinalSlider = new JSlider(100000, 3000000, 100000);
    private JTextField leafLongitudinal = new JTextField(4);
    private JTextField leafLatitudinal = new JTextField(4);
    private LeafUvPainter painterUv = new LeafUvPainter();
    private LeafMesh currentUvLeaf = new LeafUv1();
    private boolean fromTable = false;

    public FoliagePanel(PovTree povTree, String string, String string2) {
        Object object;
        this.povTree = povTree;
        this.currentPath = string;
        this.numberSlider.setPreferredSize(new Dimension(150, 16));
        this.lengthSlider.setPreferredSize(new Dimension(150, 16));
        this.breadthSlider.setPreferredSize(new Dimension(150, 16));
        this.heightSlider.setPreferredSize(new Dimension(150, 16));
        this.tiltSlider.setPreferredSize(new Dimension(150, 16));
        this.turnSlider.setPreferredSize(new Dimension(150, 16));
        this.inclinationSlider.setPreferredSize(new Dimension(150, 16));
        this.inclinationScopeSlider.setPreferredSize(new Dimension(150, 16));
        this.turbulenceSlider.setPreferredSize(new Dimension(120, 16));
        this.transitionSlider.setPreferredSize(new Dimension(120, 16));
        this.transTurbSlider.setPreferredSize(new Dimension(120, 16));
        this.glossSlider.setPreferredSize(new Dimension(120, 16));
        this.filterSlider.setPreferredSize(new Dimension(120, 16));
        this.transparencySlider.setPreferredSize(new Dimension(120, 16));
        this.selectUv = this.mb.getString("selectUv");
        this.enterImageName = this.mb.getString("enterImageName");
        this.notSupportedFileType = this.mb.getString("notSupportedFileType");
        this.wrongNumber = this.mb.getString("invalidNumber");
        this.invalidFileExtension = this.mb.getString("invalidFileExtension");
        this.mtm = new MapTableModel(this.rb.getString("type"), this.rb.getString("imageName"), this.rb.getString("bumpName"), this.rb.getString("bumpSize"));
        this.invisibleTB = new JToggleButton(this.rb.getString("deselect"));
        this.useCustomMesh = new JCheckBox(this.rb.getString("useCustomMesh"), false);
        this.useUv = new JCheckBox(this.rb.getString("useUvMapping"), false);
        this.add = new JButton(this.rb.getString("add"));
        this.remove = new JButton(this.rb.getString("remove"));
        this.mapTable.setModel(this.mtm);
        this.mapTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                DefaultListSelectionModel defaultListSelectionModel = (DefaultListSelectionModel)listSelectionEvent.getSource();
                int n = defaultListSelectionModel.getMinSelectionIndex();
                if (!listSelectionEvent.getValueIsAdjusting() && n != -1) {
                    FoliagePanel.this.fromTable = true;
                    FoliagePanel.this.typeUvTB[(Integer)FoliagePanel.this.mtm.getValueAt(n, 0) - 1].doClick();
                }
            }
        });
        int n = 0;
        while (n < this.typeTB.length) {
            this.typeTB[n] = new JToggleButton(new ImageIcon(this.getClass().getResource("images/" + this.leaves[n] + ".png")));
            this.typeTB[n].addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    FoliagePanel.this.paintElement();
                }
            });
            this.bg.add(this.typeTB[n]);
            ++n;
        }
        this.invisibleTB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JOptionPane.showMessageDialog(FoliagePanel.this, FoliagePanel.this.mb.getString("dontNeedFoliage"), FoliagePanel.this.rb.getString("tip"), 1);
                FoliagePanel.this.paintElement();
            }
        });
        this.bg.add(this.invisibleTB);
        this.bg = new ButtonGroup();
        int n2 = 0;
        while (n2 < this.typeUvTB.length) {
            object = Constants.leavesUv[n2];
            this.typeUvTB[n2] = new JToggleButton(String.valueOf(n2 + 1), new ImageIcon(this.getClass().getResource("images/" + (String)object + ".png")));
            this.typeUvTB[n2].addActionListener(new ActionListener((String)object){
                private final /* synthetic */ String val$name;
                {
                    this.val$name = string;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    if (this.val$name.equals("LeafUv1")) {
                        FoliagePanel.this.currentUvLeaf = new LeafUv1();
                    } else if (this.val$name.equals("LeafUv2")) {
                        FoliagePanel.this.currentUvLeaf = new LeafUv2();
                    } else if (this.val$name.equals("LeafUv3")) {
                        FoliagePanel.this.currentUvLeaf = new LeafUv3();
                    } else if (this.val$name.equals("LeafUv4")) {
                        FoliagePanel.this.currentUvLeaf = new LeafUv4();
                    } else if (this.val$name.equals("LeafUv5")) {
                        FoliagePanel.this.currentUvLeaf = new LeafUv5();
                    } else if (this.val$name.equals("LeafUv6")) {
                        FoliagePanel.this.currentUvLeaf = new LeafUv6();
                    } else if (this.val$name.equals("LeafUv7")) {
                        FoliagePanel.this.currentUvLeaf = new LeafUv7();
                    } else if (this.val$name.equals("LeafUv8")) {
                        FoliagePanel.this.currentUvLeaf = new LeafUv8();
                    } else if (this.val$name.equals("LeafUv9")) {
                        FoliagePanel.this.currentUvLeaf = new LeafUv9();
                    } else if (this.val$name.equals("LeafUv10")) {
                        FoliagePanel.this.currentUvLeaf = new LeafUv10();
                    } else if (this.val$name.equals("LeafUv11")) {
                        FoliagePanel.this.currentUvLeaf = new LeafUv11();
                    } else if (this.val$name.equals("LeafUv12")) {
                        FoliagePanel.this.currentUvLeaf = new LeafUv12();
                    }
                    if (FoliagePanel.this.fromTable && FoliagePanel.this.mapTable.getSelectedRow() != -1) {
                        TableLeaf tableLeaf = FoliagePanel.this.mtm.getRow(FoliagePanel.this.mapTable.getSelectedRow());
                        if (tableLeaf.getLatitudinal() != null) {
                            FoliagePanel.this.currentUvLeaf.setLatitudinal(tableLeaf.getLatitudinal());
                        }
                        if (tableLeaf.getLongitudinal() != null) {
                            FoliagePanel.this.currentUvLeaf.setLongitudinal(tableLeaf.getLongitudinal());
                        }
                        FoliagePanel.this.currentUvLeaf.buildLeaf();
                        FoliagePanel.this.fromTable = false;
                    } else {
                        FoliagePanel.this.mtm.fireTableDataChanged();
                    }
                    FoliagePanel.this.painterUv.setElement(FoliagePanel.this.currentUvLeaf);
                    FoliagePanel.this.leafLongitudinalSlider.setValue(FoliagePanel.this.currentUvLeaf.getLongitudinal() * 100000);
                    FoliagePanel.this.leafLongitudinal.setText(String.valueOf(FoliagePanel.this.currentUvLeaf.getLongitudinal()));
                    FoliagePanel.this.leafLatitudinalSlider.setValue(FoliagePanel.this.currentUvLeaf.getLatitudinal() * 100000);
                    FoliagePanel.this.leafLatitudinal.setText(String.valueOf(FoliagePanel.this.currentUvLeaf.getLatitudinal()));
                }
            });
            this.bg.add(this.typeUvTB[n2]);
            ++n2;
        }
        this.typeUvTB[0].setSelected(true);
        this.topRight.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FoliagePanel.this.top2Chooser.setColor(FoliagePanel.this.top1Chooser.getRed(), FoliagePanel.this.top1Chooser.getGreen(), FoliagePanel.this.top1Chooser.getBlue());
            }
        });
        this.topLeft.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FoliagePanel.this.top1Chooser.setColor(FoliagePanel.this.top2Chooser.getRed(), FoliagePanel.this.top2Chooser.getGreen(), FoliagePanel.this.top2Chooser.getBlue());
            }
        });
        this.bottomRight.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FoliagePanel.this.bottom2Chooser.setColor(FoliagePanel.this.bottom1Chooser.getRed(), FoliagePanel.this.bottom1Chooser.getGreen(), FoliagePanel.this.bottom1Chooser.getBlue());
            }
        });
        this.bottomLeft.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FoliagePanel.this.bottom1Chooser.setColor(FoliagePanel.this.bottom2Chooser.getRed(), FoliagePanel.this.bottom2Chooser.getGreen(), FoliagePanel.this.bottom2Chooser.getBlue());
            }
        });
        this.up1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FoliagePanel.this.top1Chooser.setColor(FoliagePanel.this.bottom1Chooser.getRed(), FoliagePanel.this.bottom1Chooser.getGreen(), FoliagePanel.this.bottom1Chooser.getBlue());
            }
        });
        this.up2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FoliagePanel.this.top2Chooser.setColor(FoliagePanel.this.bottom2Chooser.getRed(), FoliagePanel.this.bottom2Chooser.getGreen(), FoliagePanel.this.bottom2Chooser.getBlue());
            }
        });
        this.down1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FoliagePanel.this.bottom1Chooser.setColor(FoliagePanel.this.top1Chooser.getRed(), FoliagePanel.this.top1Chooser.getGreen(), FoliagePanel.this.top1Chooser.getBlue());
            }
        });
        this.down2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FoliagePanel.this.bottom2Chooser.setColor(FoliagePanel.this.top2Chooser.getRed(), FoliagePanel.this.top2Chooser.getGreen(), FoliagePanel.this.top2Chooser.getBlue());
            }
        });
        this.number.addActionListener(new EnterListener(this.number, this.numberSlider, this, this.invalidNumber, this.errorLabel));
        this.numberSlider.addChangeListener(new IntegerSliderChangeListener(this.number, this));
        this.length.addActionListener(new EnterListener(this.length, this.lengthSlider, this, this.invalidNumber, this.errorLabel));
        this.lengthSlider.addChangeListener(new FloatSliderChangeListener(this.length, this));
        this.breadth.addActionListener(new EnterListener(this.breadth, this.breadthSlider, this, this.invalidNumber, this.errorLabel));
        this.breadthSlider.addChangeListener(new FloatSliderChangeListener(this.breadth, this));
        this.height.addActionListener(new EnterListener(this.height, this.heightSlider, this, this.invalidNumber, this.errorLabel));
        this.heightSlider.addChangeListener(new FloatSliderChangeListener(this.height, this));
        this.maxTilt.addActionListener(new EnterListener(this.maxTilt, this.tiltSlider, this, this.invalidNumber, this.errorLabel));
        this.tiltSlider.addChangeListener(new FloatSliderChangeListener(this.maxTilt, this));
        this.maxTurn.addActionListener(new EnterListener(this.maxTurn, this.turnSlider, this, this.invalidNumber, this.errorLabel));
        this.turnSlider.addChangeListener(new FloatSliderChangeListener(this.maxTurn, this));
        this.inclination.addActionListener(new EnterListener(this.inclination, this.inclinationSlider, this, this.invalidNumber, this.errorLabel));
        this.inclinationSlider.addChangeListener(new FloatSliderChangeListener(this.inclination, this));
        this.inclinationScope.addActionListener(new EnterListener(this.inclinationScope, this.inclinationScopeSlider, this, this.invalidNumber, this.errorLabel));
        this.inclinationScopeSlider.addChangeListener(new FloatSliderChangeListener(this.inclinationScope, this));
        this.turbulence.addActionListener(new EnterListener(this.turbulence, this.turbulenceSlider, this, this.invalidNumber, this.errorLabel));
        this.turbulenceSlider.addChangeListener(new FloatSliderChangeListener(this.turbulence, this));
        this.transition.addActionListener(new EnterListener(this.transition, this.transitionSlider, this, this.invalidNumber, this.errorLabel));
        this.transitionSlider.addChangeListener(new FloatSliderChangeListener(this.transition, this));
        this.transitionTurbulence.addActionListener(new EnterListener(this.transitionTurbulence, this.transTurbSlider, this, this.invalidNumber, this.errorLabel));
        this.transTurbSlider.addChangeListener(new FloatSliderChangeListener(this.transitionTurbulence, this));
        this.gloss.addActionListener(new EnterListener(this.gloss, this.glossSlider, this, this.invalidNumber, this.errorLabel));
        this.glossSlider.addChangeListener(new FloatSliderChangeListener(this.gloss, this));
        this.filter.addActionListener(new EnterListener(this.filter, this.filterSlider, this, this.invalidNumber, this.errorLabel));
        this.filterSlider.addChangeListener(new FloatSliderChangeListener(this.filter, this));
        this.transparency.addActionListener(new EnterListener(this.transparency, this.transparencySlider, this, this.invalidNumber, this.errorLabel));
        this.transparencySlider.addChangeListener(new FloatSliderChangeListener(this.transparency, this));
        this.leafLongitudinal.setEditable(false);
        this.leafLongitudinalSlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                JSlider jSlider = (JSlider)changeEvent.getSource();
                if (jSlider.getValueIsAdjusting()) {
                    int n = jSlider.getValue() / 100000;
                    FoliagePanel.this.leafLongitudinal.setText(String.valueOf(n));
                    FoliagePanel.this.currentUvLeaf.setLongitudinal(n);
                    FoliagePanel.this.currentUvLeaf.buildLeaf();
                    FoliagePanel.this.painterUv.setElement(FoliagePanel.this.currentUvLeaf);
                }
            }
        });
        this.leafLongitudinal.setText(String.valueOf(this.currentUvLeaf.getLongitudinal()));
        this.leafLatitudinal.setEditable(false);
        this.leafLatitudinalSlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                JSlider jSlider = (JSlider)changeEvent.getSource();
                if (jSlider.getValueIsAdjusting()) {
                    int n = jSlider.getValue() / 100000;
                    FoliagePanel.this.leafLatitudinal.setText(String.valueOf(n));
                    FoliagePanel.this.currentUvLeaf.setLatitudinal(n);
                    FoliagePanel.this.currentUvLeaf.buildLeaf();
                    FoliagePanel.this.painterUv.setElement(FoliagePanel.this.currentUvLeaf);
                }
            }
        });
        this.leafLatitudinal.setText(String.valueOf(this.currentUvLeaf.getLatitudinal()));
        this.add.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Object object;
                if (!FoliagePanel.this.useUv.isSelected()) {
                    JOptionPane.showMessageDialog(FoliagePanel.this, FoliagePanel.this.selectUv, FoliagePanel.this.rb.getString("error"), 0);
                    return;
                }
                String string = FoliagePanel.this.imageName.getText();
                if (string.length() == 0) {
                    JOptionPane.showMessageDialog(FoliagePanel.this, FoliagePanel.this.enterImageName, FoliagePanel.this.rb.getString("error"), 0);
                    return;
                }
                if (!FoliagePanel.this.isValidFileExtension(string)) {
                    JOptionPane.showMessageDialog(FoliagePanel.this, FoliagePanel.this.notSupportedFileType, FoliagePanel.this.rb.getString("error"), 0);
                    return;
                }
                TableLeaf tableLeaf = new TableLeaf();
                tableLeaf.setImageName(new String(string));
                tableLeaf.setImageType(FoliagePanel.this.getFileExtension(string));
                int n = 0;
                int n2 = 0;
                while (n2 < Constants.leavesUv.length) {
                    if (FoliagePanel.this.typeUvTB[n2].isSelected()) {
                        n = n2;
                        break;
                    }
                    ++n2;
                }
                tableLeaf.setLeafUvName(Constants.leavesUv[n]);
                tableLeaf.setIndex(new Integer(n + 1));
                tableLeaf.setLatitudinal(new Integer(FoliagePanel.this.currentUvLeaf.getLatitudinal()));
                tableLeaf.setLongitudinal(new Integer(FoliagePanel.this.currentUvLeaf.getLongitudinal()));
                string = FoliagePanel.this.bumpName.getText();
                if (string.length() != 0) {
                    if (!FoliagePanel.this.isValidFileExtension(string)) {
                        JOptionPane.showMessageDialog(FoliagePanel.this, FoliagePanel.this.notSupportedFileType, FoliagePanel.this.rb.getString("error"), 0);
                        return;
                    }
                    tableLeaf.setBumpName(string);
                    tableLeaf.setBumpType(FoliagePanel.this.getFileExtension(string));
                    object = FoliagePanel.this.bumpSize.getText();
                    if (((String)object).length() != 0) {
                        try {
                            Float f = new Float((String)object);
                            tableLeaf.setBumpSize(f.toString());
                        }
                        catch (Exception exception) {
                            JOptionPane.showMessageDialog(FoliagePanel.this, FoliagePanel.this.wrongNumber + " " + (String)object, FoliagePanel.this.rb.getString("error"), 0);
                            return;
                        }
                    }
                }
                FoliagePanel.this.mtm.addRow(tableLeaf);
                object = new Runnable(this){
                    private final /* synthetic */ 15 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void run() {
                        15.access$2400(this.this$1).paintElement();
                    }
                };
                SwingUtilities.invokeLater((Runnable)object);
            }

            static /* synthetic */ FoliagePanel access$2400(15 var0) {
                return var0.FoliagePanel.this;
            }
        });
        this.remove.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n = FoliagePanel.this.mapTable.getSelectedRow();
                if (n >= 0) {
                    FoliagePanel.this.mtm.removeRow(n);
                    FoliagePanel.this.paintElement();
                }
            }
        });
        this.useUv.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (FoliagePanel.this.useUv.isSelected() && FoliagePanel.this.useCustomMesh.isSelected()) {
                    FoliagePanel.this.useCustomMesh.setSelected(false);
                }
            }
        });
        this.useCustomMesh.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (FoliagePanel.this.useCustomMesh.isSelected() && FoliagePanel.this.useUv.isSelected()) {
                    FoliagePanel.this.useUv.setSelected(false);
                }
            }
        });
        this.loadImage.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FoliagePanel.this.load(0);
            }
        });
        this.loadBump.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FoliagePanel.this.load(1);
            }
        });
        object = new GridBagConstraints();
        ((GridBagConstraints)object).gridx = 0;
        ((GridBagConstraints)object).gridy = 0;
        ((GridBagConstraints)object).gridwidth = 1;
        ((GridBagConstraints)object).gridheight = 2;
        ((GridBagConstraints)object).weightx = 1.0;
        ((GridBagConstraints)object).weighty = 1.0;
        ((GridBagConstraints)object).anchor = 17;
        ((GridBagConstraints)object).fill = 1;
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        this.setLayout(new GridBagLayout());
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridBagLayout());
        ((GridBagConstraints)object).gridheight = 1;
        ((GridBagConstraints)object).weighty = 5.0;
        ((GridBagConstraints)object).insets = new Insets(0, 0, 0, 0);
        int n3 = 0;
        while (n3 < 6) {
            int n4 = 0;
            while (n4 < 3) {
                ((GridBagConstraints)object).gridx = n4;
                ((GridBagConstraints)object).gridy = n3;
                this.typeTB[n3 * 3 + n4].setVerticalTextPosition(3);
                this.typeTB[n3 * 3 + n4].setHorizontalTextPosition(0);
                jPanel2.add((Component)this.typeTB[n3 * 3 + n4], object);
                ++n4;
            }
            ++n3;
        }
        ((GridBagConstraints)object).gridx = 0;
        ++((GridBagConstraints)object).gridy;
        ((GridBagConstraints)object).gridwidth = 3;
        ((GridBagConstraints)object).weighty = 1.0;
        jPanel2.add((Component)this.invisibleTB, object);
        ((GridBagConstraints)object).gridwidth = 1;
        ((GridBagConstraints)object).gridx = 0;
        ((GridBagConstraints)object).gridy = 0;
        ((GridBagConstraints)object).gridheight = 2;
        JPanel jPanel3 = new JPanel(new GridBagLayout());
        jPanel3.setBorder(new EmptyBorder(7, 6, 5, 6));
        jPanel3.add((Component)jPanel2, object);
        ((GridBagConstraints)object).insets = new Insets(0, 0, 0, 0);
        ((GridBagConstraints)object).gridheight = 1;
        GradientPanel gradientPanel = new GradientPanel(20, 10);
        gradientPanel.setLayout(new BorderLayout());
        gradientPanel.setGradientDirection(2);
        gradientPanel.setRound(1);
        JPanel jPanel4 = new JPanel(new BorderLayout());
        jPanel4.setOpaque(false);
        jPanel2 = new JPanel();
        jPanel2.setOpaque(false);
        this.useCustomMesh.setOpaque(false);
        jPanel2.add(this.useCustomMesh);
        jPanel4.add((Component)jPanel2, "North");
        jPanel2 = new JPanel(new GridBagLayout());
        jPanel2.setOpaque(false);
        JLabel jLabel = new JLabel(this.rb.getString("example") + ": triangle{<0, 0, -0.5>, <1, 0, 0>, <0, 0, 0.5>}", 0);
        jLabel.setOpaque(false);
        ((GridBagConstraints)object).gridx = 0;
        ((GridBagConstraints)object).gridy = 0;
        ((GridBagConstraints)object).fill = 2;
        ((GridBagConstraints)object).anchor = 10;
        jPanel2.add((Component)jLabel, object);
        ((GridBagConstraints)object).anchor = 17;
        jPanel4.add((Component)jPanel2, "Center");
        gradientPanel.add((Component)jPanel4, "North");
        this.editor.setBackground(gradientPanel.getBackground());
        gradientPanel.add((Component)new JScrollPane(this.editor), "Center");
        JPanel jPanel5 = new JPanel(new BorderLayout());
        jPanel5.setOpaque(false);
        gradientPanel.setBorder(new EmptyBorder(2, 10, 10, 10));
        jPanel5.add((Component)gradientPanel, "Center");
        GradientPanel gradientPanel2 = new GradientPanel(40, 20);
        gradientPanel2.setLayout(new GridBagLayout());
        gradientPanel2.setGradientDirection(2);
        gradientPanel2.setRound(0);
        JLabel jLabel2 = new JLabel(this.rb.getString("customMeshLeaf"));
        jLabel2.setOpaque(false);
        jLabel2.setFont((Font)UIManager.get("TitledBorder.font"));
        jLabel2.setForeground(Color.black);
        gradientPanel2.add((Component)jLabel2, object);
        ((GridBagConstraints)object).fill = 0;
        jPanel5.add((Component)gradientPanel2, "North");
        ((GridBagConstraints)object).gridx = 1;
        ((GridBagConstraints)object).weightx = 6.0;
        ((GridBagConstraints)object).fill = 1;
        ((GridBagConstraints)object).anchor = 17;
        ((GridBagConstraints)object).insets = new Insets(1, 5, 1, 0);
        jPanel3.add((Component)jPanel5, object);
        ((GridBagConstraints)object).insets = new Insets(0, 0, 0, 0);
        ((GridBagConstraints)object).weightx = 1.0;
        this.tabbedPane.add(this.rb.getString("type"), jPanel3);
        jPanel2 = new JPanel();
        jPanel2.setLayout(new GridBagLayout());
        ((GridBagConstraints)object).gridheight = 1;
        ((GridBagConstraints)object).weighty = 5.0;
        ((GridBagConstraints)object).insets = new Insets(0, 0, 0, 0);
        int n5 = 0;
        while (n5 < 4) {
            int n6 = 0;
            while (n6 < 3) {
                ((GridBagConstraints)object).gridx = n6;
                ((GridBagConstraints)object).gridy = n5;
                this.typeUvTB[n5 * 3 + n6].setVerticalTextPosition(3);
                this.typeUvTB[n5 * 3 + n6].setHorizontalTextPosition(0);
                jPanel2.add((Component)this.typeUvTB[n5 * 3 + n6], object);
                ++n6;
            }
            ++n5;
        }
        ((GridBagConstraints)object).weighty = 1.0;
        ((GridBagConstraints)object).gridx = 0;
        ((GridBagConstraints)object).gridy = 0;
        ((GridBagConstraints)object).gridheight = 3;
        jPanel3 = new JPanel(new GridBagLayout());
        jPanel3.setBorder(new EmptyBorder(7, 6, 5, 6));
        jPanel3.add((Component)jPanel2, object);
        ((GridBagConstraints)object).insets = new Insets(0, 0, 0, 0);
        ((GridBagConstraints)object).gridheight = 1;
        ((GridBagConstraints)object).gridx = 1;
        ((GridBagConstraints)object).gridy = 0;
        ((GridBagConstraints)object).fill = 1;
        ((GridBagConstraints)object).insets = new Insets(0, 5, 6, 0);
        this.painterUv.setElement(this.currentUvLeaf);
        jPanel3.add((Component)this.painterUv, object);
        ((GridBagConstraints)object).fill = 0;
        ((GridBagConstraints)object).insets = new Insets(0, 0, 0, 0);
        GradientPanel gradientPanel3 = new GradientPanel(25, 5);
        gradientPanel3.setLayout(new GridBagLayout());
        gradientPanel3.setGradientDirection(2);
        gradientPanel3.setRound(1);
        ((GridBagConstraints)object).gridx = 0;
        ((GridBagConstraints)object).gridy = 0;
        ((GridBagConstraints)object).gridheight = 1;
        ((GridBagConstraints)object).weightx = 1.0;
        ((GridBagConstraints)object).fill = 2;
        JLabel jLabel3 = new JLabel(this.rb.getString("treeLatitude"));
        LabelUI labelUI = new LabelUI();
        labelUI.setIsUnderlinable(false);
        jLabel3.setUI(labelUI);
        gradientPanel3.add((Component)jLabel3, object);
        ((GridBagConstraints)object).fill = 0;
        ((GridBagConstraints)object).gridx = 1;
        this.leafLatitudinalSlider.setPreferredSize(new Dimension(150, 16));
        gradientPanel3.add((Component)this.leafLatitudinalSlider, object);
        ((GridBagConstraints)object).gridx = 2;
        gradientPanel3.add((Component)this.leafLatitudinal, object);
        ((GridBagConstraints)object).gridx = 0;
        ((GridBagConstraints)object).gridy = 1;
        ((GridBagConstraints)object).fill = 2;
        jLabel3 = new JLabel(this.rb.getString("treeLongitude"));
        labelUI = new LabelUI();
        labelUI.setIsUnderlinable(false);
        jLabel3.setUI(labelUI);
        gradientPanel3.add((Component)jLabel3, object);
        ((GridBagConstraints)object).fill = 0;
        ((GridBagConstraints)object).gridx = 1;
        this.leafLongitudinalSlider.setPreferredSize(new Dimension(150, 16));
        gradientPanel3.add((Component)this.leafLongitudinalSlider, object);
        ((GridBagConstraints)object).gridx = 2;
        gradientPanel3.add((Component)this.leafLongitudinal, object);
        jPanel5 = new JPanel(new BorderLayout());
        jPanel5.setOpaque(false);
        jPanel5.add((Component)gradientPanel3, "Center");
        gradientPanel2 = new GradientPanel(40, 20);
        gradientPanel2.setLayout(new GridBagLayout());
        gradientPanel2.setGradientDirection(2);
        gradientPanel2.setRound(0);
        ((GridBagConstraints)object).gridx = 0;
        ((GridBagConstraints)object).gridy = 0;
        ((GridBagConstraints)object).fill = 2;
        jLabel2 = new JLabel(this.rb.getString("treeMeshAccuracy"));
        jLabel2.setFont((Font)UIManager.get("TitledBorder.font"));
        jLabel2.setForeground(Color.black);
        gradientPanel2.add((Component)jLabel2, object);
        jPanel5.add((Component)gradientPanel2, "North");
        ((GridBagConstraints)object).gridx = 2;
        ((GridBagConstraints)object).gridy = 0;
        ((GridBagConstraints)object).gridheight = 1;
        ((GridBagConstraints)object).fill = 1;
        ((GridBagConstraints)object).insets = new Insets(0, 6, 6, 0);
        jPanel3.add((Component)jPanel5, object);
        ((GridBagConstraints)object).insets = new Insets(0, 0, 0, 0);
        ((GridBagConstraints)object).fill = 1;
        jPanel4 = new JPanel(new BorderLayout());
        JPanel jPanel6 = new JPanel();
        jPanel6.setOpaque(false);
        this.useUv.setOpaque(false);
        jPanel6.add(this.useUv);
        jPanel4.setOpaque(false);
        jPanel4.add((Component)jPanel6, "North");
        ((GridBagConstraints)object).gridx = 0;
        ((GridBagConstraints)object).gridy = 0;
        jPanel6 = new JPanel(new GridBagLayout());
        jPanel6.setOpaque(false);
        ((GridBagConstraints)object).fill = 2;
        jLabel3 = new JLabel(this.rb.getString("imageMapName"));
        labelUI = new LabelUI();
        labelUI.setIsUnderlinable(false);
        jLabel3.setUI(labelUI);
        jPanel6.add((Component)jLabel3, object);
        ((GridBagConstraints)object).fill = 0;
        ((GridBagConstraints)object).gridx = 1;
        ((GridBagConstraints)object).anchor = 17;
        jPanel6.add((Component)this.imageName, object);
        ((GridBagConstraints)object).gridx = 2;
        this.loadImage.setUI(new ButtonUI());
        jPanel6.add((Component)this.loadImage, object);
        ++((GridBagConstraints)object).gridy;
        ((GridBagConstraints)object).gridx = 0;
        ((GridBagConstraints)object).fill = 2;
        jLabel3 = new JLabel(this.rb.getString("bumpMapName"));
        labelUI = new LabelUI();
        labelUI.setIsUnderlinable(false);
        jLabel3.setUI(labelUI);
        jPanel6.add((Component)jLabel3, object);
        ((GridBagConstraints)object).fill = 0;
        ((GridBagConstraints)object).gridx = 1;
        jPanel6.add((Component)this.bumpName, object);
        ((GridBagConstraints)object).gridx = 2;
        this.loadBump.setUI(new ButtonUI());
        ((GridBagConstraints)object).anchor = 17;
        jPanel6.add((Component)this.loadBump, object);
        ++((GridBagConstraints)object).gridy;
        ((GridBagConstraints)object).gridx = 0;
        ((GridBagConstraints)object).fill = 2;
        jLabel3 = new JLabel(this.rb.getString("bumpSize"));
        labelUI = new LabelUI();
        labelUI.setIsUnderlinable(false);
        jLabel3.setUI(labelUI);
        jPanel6.add((Component)jLabel3, object);
        ((GridBagConstraints)object).fill = 0;
        ((GridBagConstraints)object).gridx = 1;
        jPanel6.add((Component)this.bumpSize, object);
        jPanel4.add((Component)jPanel6, "Center");
        ++((GridBagConstraints)object).gridy;
        ((GridBagConstraints)object).gridx = 0;
        jPanel6 = new JPanel();
        jPanel6.setOpaque(false);
        this.add.setUI(new ButtonUI());
        this.remove.setUI(new ButtonUI());
        jPanel6.add(this.add);
        jPanel6.add(this.remove);
        jPanel4.add((Component)jPanel6, "South");
        ++((GridBagConstraints)object).gridy;
        ((GridBagConstraints)object).gridx = 0;
        ((GridBagConstraints)object).gridy = 0;
        ((GridBagConstraints)object).fill = 1;
        GradientPanel gradientPanel4 = new GradientPanel(15, 15);
        gradientPanel4.setLayout(new GridBagLayout());
        gradientPanel4.setGradientDirection(2);
        gradientPanel4.setRound(2);
        gradientPanel4.add((Component)jPanel4, object);
        this.mapTable.setBackground(jPanel4.getBackground());
        JScrollPane jScrollPane = new JScrollPane(this.mapTable);
        Dimension dimension = jScrollPane.getPreferredSize();
        jScrollPane.setPreferredSize(new Dimension(dimension.width, 100));
        int n7 = dimension.width / 10;
        this.mapTable.getColumn(this.mtm.getColumnName(0)).setPreferredWidth(n7 * 2);
        this.mapTable.getColumn(this.mtm.getColumnName(1)).setPreferredWidth(n7 * 4);
        this.mapTable.getColumn(this.mtm.getColumnName(2)).setPreferredWidth(n7 * 4);
        this.mapTable.getColumn(this.mtm.getColumnName(3)).setPreferredWidth(n7 * 2);
        ((GridBagConstraints)object).gridy = 1;
        gradientPanel4.add((Component)jScrollPane, object);
        jPanel5 = new JPanel(new BorderLayout());
        gradientPanel4.setBorder(new EmptyBorder(10, 10, 10, 10));
        jPanel5.add((Component)gradientPanel4, "Center");
        ((GridBagConstraints)object).gridx = 1;
        ((GridBagConstraints)object).gridy = 1;
        ((GridBagConstraints)object).gridwidth = 2;
        ((GridBagConstraints)object).fill = 1;
        ((GridBagConstraints)object).insets = new Insets(0, 5, 1, 0);
        jPanel3.add((Component)jPanel5, object);
        ((GridBagConstraints)object).insets = new Insets(0, 0, 0, 0);
        ((GridBagConstraints)object).gridwidth = 1;
        this.tabbedPane.add(this.rb.getString("uvMapping"), jPanel3);
        JPanel jPanel7 = new JPanel(new GridBagLayout());
        ((GridBagConstraints)object).fill = 1;
        ((GridBagConstraints)object).anchor = 10;
        ((GridBagConstraints)object).insets = new Insets(6, 6, 6, 0);
        ((GridBagConstraints)object).weightx = 4.0;
        ((GridBagConstraints)object).weighty = 10.0;
        ((GridBagConstraints)object).gridy = 0;
        ((GridBagConstraints)object).gridx = 0;
        jPanel7.add((Component)this.painter, object);
        ((GridBagConstraints)object).insets = new Insets(0, 0, 0, 0);
        ((GridBagConstraints)object).fill = 0;
        ((GridBagConstraints)object).weightx = 1.0;
        ((GridBagConstraints)object).weighty = 1.0;
        GradientPanel gradientPanel5 = new GradientPanel(20, 10);
        gradientPanel5.setLayout(new GridBagLayout());
        gradientPanel5.setLayout(new GridBagLayout());
        gradientPanel5.setGradientDirection(2);
        gradientPanel5.setRound(1);
        ((GridBagConstraints)object).gridx = 0;
        ((GridBagConstraints)object).fill = 2;
        LabelTip labelTip = new LabelTip(this.rb.getString("number"), true, "tipsFoliage", "LEAVES", this, string2);
        gradientPanel5.add((Component)labelTip, object);
        ((GridBagConstraints)object).fill = 0;
        ((GridBagConstraints)object).gridx = 1;
        gradientPanel5.add((Component)this.numberSlider, object);
        ((GridBagConstraints)object).gridx = 2;
        gradientPanel5.add((Component)this.number, object);
        ++((GridBagConstraints)object).gridy;
        ((GridBagConstraints)object).gridx = 0;
        ((GridBagConstraints)object).fill = 2;
        labelTip = new LabelTip(this.rb.getString("length"), true, "tipsFoliage", "LEAF_LENGTH", this, string2);
        gradientPanel5.add((Component)labelTip, object);
        ((GridBagConstraints)object).fill = 0;
        ((GridBagConstraints)object).gridx = 1;
        gradientPanel5.add((Component)this.lengthSlider, object);
        ((GridBagConstraints)object).gridx = 2;
        gradientPanel5.add((Component)this.length, object);
        ++((GridBagConstraints)object).gridy;
        ((GridBagConstraints)object).gridx = 0;
        ((GridBagConstraints)object).fill = 2;
        labelTip = new LabelTip(this.rb.getString("breadth"), true, "tipsFoliage", "LEAF_BREADTH", this, string2);
        gradientPanel5.add((Component)labelTip, object);
        ((GridBagConstraints)object).fill = 0;
        ((GridBagConstraints)object).gridx = 1;
        gradientPanel5.add((Component)this.breadthSlider, object);
        ((GridBagConstraints)object).gridx = 2;
        gradientPanel5.add((Component)this.breadth, object);
        ++((GridBagConstraints)object).gridy;
        ((GridBagConstraints)object).gridx = 0;
        ((GridBagConstraints)object).fill = 2;
        labelTip = new LabelTip(this.rb.getString("height"), true, "tipsFoliage", "LEAF_HEIGHT", this, string2);
        gradientPanel5.add((Component)labelTip, object);
        ((GridBagConstraints)object).fill = 0;
        ((GridBagConstraints)object).gridx = 1;
        gradientPanel5.add((Component)this.heightSlider, object);
        ((GridBagConstraints)object).gridx = 2;
        gradientPanel5.add((Component)this.height, object);
        ++((GridBagConstraints)object).gridy;
        ((GridBagConstraints)object).gridx = 0;
        ((GridBagConstraints)object).fill = 2;
        labelTip = new LabelTip(this.rb.getString("maxTilt"), true, "tipsFoliage", "MAX_LEAF_TILT", this, string2);
        gradientPanel5.add((Component)labelTip, object);
        ((GridBagConstraints)object).fill = 0;
        ((GridBagConstraints)object).gridx = 1;
        gradientPanel5.add((Component)this.tiltSlider, object);
        ((GridBagConstraints)object).gridx = 2;
        gradientPanel5.add((Component)this.maxTilt, object);
        ++((GridBagConstraints)object).gridy;
        ((GridBagConstraints)object).gridx = 0;
        ((GridBagConstraints)object).fill = 2;
        labelTip = new LabelTip(this.rb.getString("maxTurn"), true, "tipsFoliage", "MAX_LEAF_TURN", this, string2);
        gradientPanel5.add((Component)labelTip, object);
        ((GridBagConstraints)object).fill = 0;
        ((GridBagConstraints)object).gridx = 1;
        gradientPanel5.add((Component)this.turnSlider, object);
        ((GridBagConstraints)object).gridx = 2;
        gradientPanel5.add((Component)this.maxTurn, object);
        ++((GridBagConstraints)object).gridy;
        ((GridBagConstraints)object).gridx = 0;
        ((GridBagConstraints)object).fill = 2;
        labelTip = new LabelTip(this.rb.getString("inclination"), true, "tipsFoliage", "LEAF_INCLINATION", this, string2);
        gradientPanel5.add((Component)labelTip, object);
        ((GridBagConstraints)object).fill = 0;
        ((GridBagConstraints)object).gridx = 1;
        gradientPanel5.add((Component)this.inclinationSlider, object);
        ((GridBagConstraints)object).gridx = 2;
        gradientPanel5.add((Component)this.inclination, object);
        ++((GridBagConstraints)object).gridy;
        ((GridBagConstraints)object).gridx = 0;
        ((GridBagConstraints)object).fill = 2;
        labelTip = new LabelTip(this.rb.getString("inclinationScope"), true, "tipsFoliage", "MAX_INCLINATION_SCOPE", this, string2);
        gradientPanel5.add((Component)labelTip, object);
        ((GridBagConstraints)object).fill = 0;
        ((GridBagConstraints)object).gridx = 1;
        gradientPanel5.add((Component)this.inclinationScopeSlider, object);
        ((GridBagConstraints)object).gridx = 2;
        gradientPanel5.add((Component)this.inclinationScope, object);
        ((GridBagConstraints)object).gridy = 0;
        ((GridBagConstraints)object).gridx = 0;
        ((GridBagConstraints)object).anchor = 10;
        ((GridBagConstraints)object).fill = 1;
        ((GridBagConstraints)object).weightx = 1.0;
        jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel5 = new JPanel(new BorderLayout());
        jPanel5.add((Component)gradientPanel5, "Center");
        gradientPanel2 = new GradientPanel(40, 20);
        gradientPanel2.setLayout(new GridBagLayout());
        gradientPanel2.setGradientDirection(2);
        gradientPanel2.setRound(0);
        ((GridBagConstraints)object).gridx = 0;
        ((GridBagConstraints)object).gridy = 0;
        jLabel2 = new JLabel(this.rb.getString("leaf"));
        jLabel2.setFont((Font)UIManager.get("TitledBorder.font"));
        jLabel2.setForeground(Color.black);
        gradientPanel2.add((Component)jLabel2, object);
        jPanel5.add((Component)gradientPanel2, "North");
        ((GridBagConstraints)object).fill = 1;
        ((GridBagConstraints)object).insets = new Insets(6, 6, 6, 6);
        ((GridBagConstraints)object).gridx = 1;
        ((GridBagConstraints)object).gridy = 0;
        jPanel7.add((Component)jPanel5, object);
        ((GridBagConstraints)object).insets = new Insets(0, 0, 0, 0);
        ((GridBagConstraints)object).fill = 0;
        this.tabbedPane.add(this.rb.getString("size"), jPanel7);
        ((GridBagConstraints)object).insets = new Insets(0, 0, 0, 0);
        ((GridBagConstraints)object).weightx = 1.0;
        ((GridBagConstraints)object).gridheight = 1;
        jPanel2 = new JPanel();
        ((GridBagConstraints)object).gridy = 0;
        ((GridBagConstraints)object).gridx = 0;
        ((GridBagConstraints)object).fill = 1;
        this.top1Chooser = new ColorChooser(this.rb.getString("top1"), this.rb.getString("red"), this.rb.getString("green"), this.rb.getString("blue"), this.mb.getString("wrongColorValue"), this.rb.getString("error"));
        this.top1Chooser.getRedTextField().addActionListener(new EnterListener(this.top1Chooser.getRedTextField(), this.top1Chooser.getRedSlider(), this, this.invalidNumber, this.errorLabel));
        this.top1Chooser.getRedSlider().addChangeListener(new FloatSliderChangeListener(this.top1Chooser.getRedTextField(), this));
        this.top1Chooser.getGreenTextField().addActionListener(new EnterListener(this.top1Chooser.getGreenTextField(), this.top1Chooser.getGreenSlider(), this, this.invalidNumber, this.errorLabel));
        this.top1Chooser.getGreenSlider().addChangeListener(new FloatSliderChangeListener(this.top1Chooser.getGreenTextField(), this));
        this.top1Chooser.getBlueTextField().addActionListener(new EnterListener(this.top1Chooser.getBlueTextField(), this.top1Chooser.getBlueSlider(), this, this.invalidNumber, this.errorLabel));
        this.top1Chooser.getBlueSlider().addChangeListener(new FloatSliderChangeListener(this.top1Chooser.getBlueTextField(), this));
        ((GridBagConstraints)object).insets = new Insets(6, 6, 0, 0);
        ((GridBagConstraints)object).anchor = 17;
        ((GridBagConstraints)object).weightx = 4.0;
        ((GridBagConstraints)object).weighty = 3.0;
        jPanel.add((Component)this.top1Chooser, object);
        ((GridBagConstraints)object).weightx = 1.0;
        ((GridBagConstraints)object).weighty = 1.0;
        ((GridBagConstraints)object).fill = 0;
        ((GridBagConstraints)object).anchor = 10;
        jPanel3 = new JPanel();
        jPanel3.setOpaque(false);
        jPanel3.setLayout(new GridBagLayout());
        ((GridBagConstraints)object).gridy = 0;
        ((GridBagConstraints)object).gridx = 0;
        ((GridBagConstraints)object).insets = new Insets(2, 2, 2, 2);
        this.topRight.setUI(new ButtonUI());
        jPanel3.add((Component)this.topRight, object);
        ((GridBagConstraints)object).gridy = 1;
        this.topLeft.setUI(new ButtonUI());
        jPanel3.add((Component)this.topLeft, object);
        ((GridBagConstraints)object).insets = new Insets(0, 0, 0, 0);
        ((GridBagConstraints)object).gridy = 0;
        ((GridBagConstraints)object).gridx = 1;
        jPanel.add((Component)jPanel3, object);
        ((GridBagConstraints)object).gridy = 0;
        ((GridBagConstraints)object).gridx = 2;
        ((GridBagConstraints)object).fill = 1;
        this.top2Chooser = new ColorChooser(this.rb.getString("top2"), this.rb.getString("red"), this.rb.getString("green"), this.rb.getString("blue"), this.mb.getString("wrongColorValue"), this.rb.getString("error"));
        ((GridBagConstraints)object).anchor = 17;
        ((GridBagConstraints)object).insets = new Insets(6, 0, 0, 5);
        ((GridBagConstraints)object).weightx = 4.0;
        ((GridBagConstraints)object).weighty = 3.0;
        jPanel.add((Component)this.top2Chooser, object);
        ((GridBagConstraints)object).weightx = 1.0;
        ((GridBagConstraints)object).weighty = 1.0;
        ((GridBagConstraints)object).insets = new Insets(0, 0, 0, 0);
        ((GridBagConstraints)object).fill = 0;
        ((GridBagConstraints)object).anchor = 10;
        jPanel3 = new JPanel();
        jPanel3.setOpaque(false);
        this.down1.setUI(new ButtonUI());
        jPanel3.add(this.down1);
        this.up1.setUI(new ButtonUI());
        jPanel3.add(this.up1);
        ((GridBagConstraints)object).gridx = 0;
        ((GridBagConstraints)object).gridy = 1;
        jPanel.add((Component)jPanel3, object);
        jPanel3 = new JPanel();
        jPanel3.setOpaque(false);
        this.down2.setUI(new ButtonUI());
        jPanel3.add(this.down2);
        this.up2.setUI(new ButtonUI());
        jPanel3.add(this.up2);
        ((GridBagConstraints)object).gridx = 2;
        jPanel.add((Component)jPanel3, object);
        ((GridBagConstraints)object).gridy = 2;
        ((GridBagConstraints)object).gridx = 0;
        ((GridBagConstraints)object).fill = 1;
        this.bottom1Chooser = new ColorChooser(this.rb.getString("bottom1"), this.rb.getString("red"), this.rb.getString("green"), this.rb.getString("blue"), this.mb.getString("wrongColorValue"), this.rb.getString("error"));
        ((GridBagConstraints)object).anchor = 17;
        ((GridBagConstraints)object).insets = new Insets(0, 6, 6, 0);
        ((GridBagConstraints)object).weightx = 4.0;
        ((GridBagConstraints)object).weighty = 3.0;
        jPanel.add((Component)this.bottom1Chooser, object);
        ((GridBagConstraints)object).weightx = 1.0;
        ((GridBagConstraints)object).weighty = 1.0;
        ((GridBagConstraints)object).fill = 0;
        ((GridBagConstraints)object).anchor = 10;
        jPanel3 = new JPanel();
        jPanel3.setOpaque(false);
        jPanel3.setLayout(new GridBagLayout());
        ((GridBagConstraints)object).gridy = 0;
        ((GridBagConstraints)object).gridx = 1;
        this.bottomRight.setUI(new ButtonUI());
        ((GridBagConstraints)object).insets = new Insets(2, 2, 2, 2);
        jPanel3.add((Component)this.bottomRight, object);
        ((GridBagConstraints)object).gridy = 1;
        this.bottomLeft.setUI(new ButtonUI());
        jPanel3.add((Component)this.bottomLeft, object);
        ((GridBagConstraints)object).insets = new Insets(0, 0, 0, 0);
        ((GridBagConstraints)object).gridy = 2;
        ((GridBagConstraints)object).gridx = 1;
        jPanel.add((Component)jPanel3, object);
        ((GridBagConstraints)object).gridy = 2;
        ((GridBagConstraints)object).gridx = 2;
        ((GridBagConstraints)object).anchor = 10;
        ((GridBagConstraints)object).fill = 1;
        this.bottom2Chooser = new ColorChooser(this.rb.getString("bottom2"), this.rb.getString("red"), this.rb.getString("green"), this.rb.getString("blue"), this.mb.getString("wrongColorValue"), this.rb.getString("error"));
        ((GridBagConstraints)object).anchor = 17;
        ((GridBagConstraints)object).insets = new Insets(0, 0, 6, 5);
        ((GridBagConstraints)object).weightx = 4.0;
        ((GridBagConstraints)object).weighty = 3.0;
        jPanel.add((Component)this.bottom2Chooser, object);
        ((GridBagConstraints)object).weightx = 1.0;
        ((GridBagConstraints)object).weighty = 1.0;
        ((GridBagConstraints)object).fill = 0;
        ((GridBagConstraints)object).anchor = 17;
        gradientPanel3 = new GradientPanel(15, 15);
        gradientPanel3.setLayout(new GridBagLayout());
        gradientPanel3.setLayout(new GridBagLayout());
        gradientPanel3.setGradientDirection(2);
        gradientPanel3.setRound(2);
        ((GridBagConstraints)object).gridy = 0;
        ((GridBagConstraints)object).gridx = 0;
        ((GridBagConstraints)object).fill = 2;
        labelTip = new LabelTip(this.rb.getString("turbulence"), true, "tipsFoliage", "COLOR_TURB", this, string2);
        gradientPanel3.add((Component)labelTip, object);
        ((GridBagConstraints)object).fill = 0;
        ((GridBagConstraints)object).gridx = 1;
        gradientPanel3.add((Component)this.turbulenceSlider, object);
        ((GridBagConstraints)object).gridx = 2;
        gradientPanel3.add((Component)this.turbulence, object);
        ++((GridBagConstraints)object).gridy;
        ((GridBagConstraints)object).gridx = 0;
        ((GridBagConstraints)object).fill = 2;
        labelTip = new LabelTip(this.rb.getString("transition"), true, "tipsFoliage", "TRANSITION_BOTTOM_TOP", this, string2);
        gradientPanel3.add((Component)labelTip, object);
        ((GridBagConstraints)object).fill = 0;
        ((GridBagConstraints)object).gridx = 1;
        gradientPanel3.add((Component)this.transitionSlider, object);
        ((GridBagConstraints)object).gridx = 2;
        gradientPanel3.add((Component)this.transition, object);
        ++((GridBagConstraints)object).gridy;
        ((GridBagConstraints)object).gridx = 0;
        ((GridBagConstraints)object).fill = 2;
        labelTip = new LabelTip(this.rb.getString("transitionTurbulence"), true, "tipsFoliage", "TRANSITION_TURB", this, string2);
        gradientPanel3.add((Component)labelTip, object);
        ((GridBagConstraints)object).fill = 0;
        ((GridBagConstraints)object).gridx = 1;
        gradientPanel3.add((Component)this.transTurbSlider, object);
        ((GridBagConstraints)object).gridx = 2;
        gradientPanel3.add((Component)this.transitionTurbulence, object);
        jPanel4 = new JPanel(new GridLayout(1, 2, 10, 10));
        ((GridBagConstraints)object).fill = 1;
        ((GridBagConstraints)object).gridy = 0;
        ((GridBagConstraints)object).gridx = 0;
        ((GridBagConstraints)object).insets = new Insets(0, 0, 0, 6);
        ((GridBagConstraints)object).weightx = 4.0;
        jPanel4.add(gradientPanel3);
        ((GridBagConstraints)object).weightx = 1.0;
        gradientPanel3 = new GradientPanel(15, 15);
        gradientPanel3.setLayout(new GridBagLayout());
        gradientPanel3.setLayout(new GridBagLayout());
        gradientPanel3.setGradientDirection(2);
        gradientPanel3.setRound(2);
        ((GridBagConstraints)object).fill = 2;
        labelTip = new LabelTip(this.rb.getString("gloss"), true, "tipsFoliage", "FOLIAGE_GLOSS", this, string2);
        gradientPanel3.add((Component)labelTip, object);
        ((GridBagConstraints)object).fill = 0;
        ((GridBagConstraints)object).gridx = 1;
        gradientPanel3.add((Component)this.glossSlider, object);
        ((GridBagConstraints)object).gridx = 2;
        gradientPanel3.add((Component)this.gloss, object);
        ++((GridBagConstraints)object).gridy;
        ((GridBagConstraints)object).gridx = 0;
        ((GridBagConstraints)object).fill = 2;
        labelTip = new LabelTip(this.rb.getString("filter"), true, "tipsFoliage", "FOLIAGE_FILTER", this, string2);
        gradientPanel3.add((Component)labelTip, object);
        ((GridBagConstraints)object).fill = 0;
        ((GridBagConstraints)object).gridx = 1;
        gradientPanel3.add((Component)this.filterSlider, object);
        ((GridBagConstraints)object).gridx = 2;
        gradientPanel3.add((Component)this.filter, object);
        ++((GridBagConstraints)object).gridy;
        ((GridBagConstraints)object).gridx = 0;
        ((GridBagConstraints)object).fill = 2;
        labelTip = new LabelTip(this.rb.getString("transparency"), true, "tipsFoliage", "FOLIAGE_TRANSPARENCY", this, string2);
        gradientPanel3.add((Component)labelTip, object);
        ((GridBagConstraints)object).fill = 0;
        ((GridBagConstraints)object).gridx = 1;
        gradientPanel3.add((Component)this.transparencySlider, object);
        ((GridBagConstraints)object).gridx = 2;
        gradientPanel3.add((Component)this.transparency, object);
        ((GridBagConstraints)object).fill = 1;
        ((GridBagConstraints)object).insets = new Insets(0, 0, 0, 0);
        ((GridBagConstraints)object).weightx = 6.0;
        ((GridBagConstraints)object).gridy = 0;
        ((GridBagConstraints)object).gridx = 1;
        jPanel4.add(gradientPanel3);
        ((GridBagConstraints)object).weightx = 1.0;
        ((GridBagConstraints)object).gridy = 3;
        ((GridBagConstraints)object).gridx = 0;
        ((GridBagConstraints)object).gridwidth = 3;
        ((GridBagConstraints)object).insets = new Insets(4, 6, 5, 5);
        ((GridBagConstraints)object).fill = 1;
        jPanel.add((Component)jPanel4, object);
        ((GridBagConstraints)object).gridwidth = 1;
        ((GridBagConstraints)object).fill = 1;
        ((GridBagConstraints)object).weightx = 1.0;
        this.tabbedPane.add(this.rb.getString("color"), jPanel);
        ((GridBagConstraints)object).anchor = 17;
        ((GridBagConstraints)object).gridwidth = 1;
        ((GridBagConstraints)object).gridy = 0;
        ((GridBagConstraints)object).gridx = 0;
        ((GridBagConstraints)object).insets = new Insets(0, 0, 0, 0);
        this.add((Component)this.tabbedPane, object);
    }

    public void paintElement() {
        if (this.povTree.getTree() == null) {
            return;
        }
        LeafArray leafArray = null;
        try {
            this.parameters = new Parameters(this.povTree.getTree());
        }
        catch (NumberFormatException numberFormatException) {
            JOptionPane.showMessageDialog(this, this.invalidNumber + " " + numberFormatException.getMessage(), this.rb.getString("error"), 0);
            return;
        }
        if (this.parameters.leafType != null && this.parameters.twigs >= 1.0f) {
            float f = this.parameters.leaves / this.parameters.bunches;
            this.parameters.leaves = f > 500.0f ? 500.0f : f;
            this.parameters.branches = 1.0f;
            this.parameters.twigs = 1.0f;
            this.parameters.bunches = 1.0f;
            this.fg = this.parameters.leafType.startsWith("LeafUv") || this.parameters.leafType.startsWith("Mesh") || this.parameters.leafType.startsWith("CustomMesh") ? new FoliageGenerator(this.parameters, true, this.parameters.leafType) : new FoliageGenerator(this.parameters, true, "Mesh1");
            try {
                QuadroLeafArray quadroLeafArray = (QuadroLeafArray)this.fg.generate();
                TripleLeafArray tripleLeafArray = quadroLeafArray.get(0);
                DoubleLeafArray doubleLeafArray = tripleLeafArray.get(0);
                leafArray = doubleLeafArray.get(0);
                if (leafArray != null) {
                    leafArray.rotateX(180.0f);
                }
                this.painter.setElement(leafArray, this.top1Chooser.getColor());
            }
            catch (Exception exception) {
                this.painter.setElement(null, null);
            }
        } else {
            this.painter.setElement(null, null);
        }
    }

    public String getFileExtension(String string) {
        String string2 = null;
        if (string.trim().length() <= 4) {
            return null;
        }
        string2 = string.trim().substring(string.length() - 4);
        int n = 0;
        while (n < Constants.imageTypes.length) {
            if (string2.indexOf(Constants.imageTypes[n]) != -1 && (string2 = Constants.imageTypes[n]).equals("jpg")) {
                string2 = "jpeg";
            }
            ++n;
        }
        return string2;
    }

    public boolean isValidFileExtension(String string) {
        boolean bl = false;
        String string2 = null;
        if (string == null) {
            return false;
        }
        if (string.trim().length() <= 4) {
            return false;
        }
        string2 = string.trim().substring(string.length() - 4);
        int n = 0;
        while (n < Constants.imageTypes.length) {
            if (string2.indexOf(Constants.imageTypes[n]) != -1) {
                bl = true;
            }
            ++n;
        }
        return bl;
    }

    public void load(int n) {
        int n2;
        String string = null;
        if (this.currentPath == null) {
            this.currentPath = ".";
        }
        if (this.fc == null) {
            this.fc = new JFileChooser(this.currentPath);
            Helper.tuneFileChooser(this.fc);
            this.fc.addChoosableFileFilter(new ImageFilter());
            this.fc.setAccessory(new ImageAccessor(this.fc));
        }
        if ((n2 = this.fc.showDialog(this, this.rb.getString("select"))) == 0) {
            File file = this.fc.getSelectedFile();
            string = file.getPath();
            this.currentPath = file.getParent();
            if (string != null && string.trim().length() > 0) {
                if (!this.isValidFileExtension(string)) {
                    JOptionPane.showMessageDialog(this, this.invalidFileExtension, this.rb.getString("error"), 0);
                    return;
                }
                if (n == 0) {
                    this.imageName.setText(string);
                } else if (n == 1) {
                    this.bumpName.setText(string);
                }
            }
        }
    }

    public void setFoliage(Foliage foliage) {
        if (foliage == null || foliage != null && foliage.type == null) {
            return;
        }
        this.number.setText(foliage.number);
        Helper.setValue(this.number, this.numberSlider, this, this.invalidNumber, this.errorLabel);
        this.invisibleTB.setSelected(true);
        this.useCustomMesh.setSelected(false);
        this.editor.setText("");
        this.useUv.setSelected(false);
        this.imageName.setText("");
        this.bumpName.setText("");
        this.bumpSize.setText("");
        this.mtm.setData(null);
        if (foliage.type.startsWith("CustomMesh")) {
            this.useCustomMesh.setSelected(true);
            this.editor.setText(foliage.customMesh);
        } else if (foliage.type.startsWith("LeafUv")) {
            this.useUv.setSelected(true);
            this.mtm.setData(foliage.leafArrayElements);
        } else {
            int n = 0;
            while (n < this.leaves.length) {
                if (this.leaves[n].equals(foliage.type)) {
                    this.typeTB[n].setSelected(true);
                    break;
                }
                ++n;
            }
        }
        this.length.setText(foliage.length);
        Helper.setValue(this.length, this.lengthSlider, this, this.invalidNumber, this.errorLabel);
        this.breadth.setText(foliage.breadth);
        Helper.setValue(this.breadth, this.breadthSlider, this, this.invalidNumber, this.errorLabel);
        this.height.setText(foliage.height);
        Helper.setValue(this.height, this.heightSlider, this, this.invalidNumber, this.errorLabel);
        this.maxTilt.setText(foliage.maxTilt);
        Helper.setValue(this.maxTilt, this.tiltSlider, this, this.invalidNumber, this.errorLabel);
        this.maxTurn.setText(foliage.maxTurn);
        Helper.setValue(this.maxTurn, this.turnSlider, this, this.invalidNumber, this.errorLabel);
        this.inclination.setText(foliage.inclination);
        Helper.setValue(this.inclination, this.inclinationSlider, this, this.invalidNumber, this.errorLabel);
        this.inclinationScope.setText(foliage.inclinationScope);
        Helper.setValue(this.inclinationScope, this.inclinationScopeSlider, this, this.invalidNumber, this.errorLabel);
        this.turbulence.setText(foliage.turbulence);
        Helper.setValue(this.turbulence, this.turbulenceSlider, this, this.invalidNumber, this.errorLabel);
        this.transition.setText(foliage.transition);
        Helper.setValue(this.transition, this.transitionSlider, this, this.invalidNumber, this.errorLabel);
        this.transitionTurbulence.setText(foliage.transitionTurbulence);
        Helper.setValue(this.transitionTurbulence, this.transTurbSlider, this, this.invalidNumber, this.errorLabel);
        this.gloss.setText(foliage.gloss);
        Helper.setValue(this.gloss, this.glossSlider, this, this.invalidNumber, this.errorLabel);
        if (foliage.filter != null) {
            this.filter.setText(foliage.filter);
        } else {
            this.filter.setText("");
        }
        Helper.setValue(this.filter, this.filterSlider, this, this.invalidNumber, this.errorLabel);
        if (foliage.transparency != null) {
            this.transparency.setText(foliage.transparency);
        } else {
            this.transparency.setText("");
        }
        Helper.setValue(this.transparency, this.transparencySlider, this, this.invalidNumber, this.errorLabel);
        this.bottom1Chooser.setColor(foliage.bottomR1, foliage.bottomG1, foliage.bottomB1);
        this.bottom2Chooser.setColor(foliage.bottomR2, foliage.bottomG2, foliage.bottomB2);
        this.top1Chooser.setColor(foliage.topR1, foliage.topG1, foliage.topB1);
        this.top2Chooser.setColor(foliage.topR2, foliage.topG2, foliage.topB2);
        this.paintElement();
    }

    public Foliage getFoliage() {
        Foliage foliage = new Foliage();
        foliage.number = this.number.getText();
        int n = 0;
        while (n < this.leaves.length) {
            if (this.typeTB[n].isSelected()) {
                foliage.type = this.leaves[n];
                break;
            }
            ++n;
        }
        if (this.useCustomMesh.isSelected()) {
            foliage.type = "CustomMesh";
            foliage.customMesh = this.editor.getText();
        }
        if (this.useUv.isSelected()) {
            foliage.type = "LeafUv";
            int n2 = this.mtm.getRowCount();
            if (n2 != 0) {
                TableLeaf tableLeaf;
                int n3 = 0;
                while (n3 < n2) {
                    tableLeaf = this.mtm.getRow(n3);
                    if (tableLeaf.getLeafUvName() == null) {
                        tableLeaf.setLeafUvName(Constants.leavesUv[tableLeaf.getIndex() - 1]);
                    }
                    ++n3;
                }
                foliage.leafArrayDeclaration = "#declare LeafArrayNames = array[" + n2 + "];" + Constants.EOL;
                int n4 = 0;
                while (n4 < n2) {
                    tableLeaf = this.mtm.getRow(n4);
                    foliage.leafArrayDeclaration = foliage.leafArrayDeclaration + "#declare LeafArrayNames[" + n4 + "] = \"" + tableLeaf.getLeafUvName() + "\";" + Constants.EOL;
                    ++n4;
                }
                foliage.leafArrayDeclaration = foliage.leafArrayDeclaration + "#declare LeafArray = array[" + n2 + "];";
                foliage.leafArrayElements = this.mtm.getData();
            }
        }
        foliage.length = this.length.getText();
        foliage.breadth = this.breadth.getText();
        foliage.height = this.height.getText();
        foliage.maxTilt = this.maxTilt.getText();
        foliage.maxTurn = this.maxTurn.getText();
        foliage.inclination = this.inclination.getText();
        foliage.inclinationScope = this.inclinationScope.getText();
        foliage.turbulence = this.turbulence.getText();
        foliage.transition = this.transition.getText();
        foliage.transitionTurbulence = this.transitionTurbulence.getText();
        foliage.gloss = this.gloss.getText();
        foliage.filter = this.filter.getText();
        foliage.transparency = this.transparency.getText();
        foliage.bottomR1 = this.bottom1Chooser.getRed();
        foliage.bottomG1 = this.bottom1Chooser.getGreen();
        foliage.bottomB1 = this.bottom1Chooser.getBlue();
        foliage.bottomR2 = this.bottom2Chooser.getRed();
        foliage.bottomG2 = this.bottom2Chooser.getGreen();
        foliage.bottomB2 = this.bottom2Chooser.getBlue();
        foliage.topR1 = this.top1Chooser.getRed();
        foliage.topG1 = this.top1Chooser.getGreen();
        foliage.topB1 = this.top1Chooser.getBlue();
        foliage.topR2 = this.top2Chooser.getRed();
        foliage.topG2 = this.top2Chooser.getGreen();
        foliage.topB2 = this.top2Chooser.getBlue();
        return foliage;
    }
}

