/*
 * Decompiled with CFR 0.152.
 */
package povtree.gui;

import java.awt.Color;
import java.awt.Component;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTextField;
import povtree.gui.plaf.FileComboBoxRenderer;
import povtree.interfaces.Paintable;
import povtree.objects3D.Blob;

public class Helper {
    public static Color getDarker(Color color, int n) {
        if (color == null) {
            return null;
        }
        int n2 = color.getRed();
        int n3 = color.getGreen();
        int n4 = color.getBlue();
        n2 = n2 - n >= 0 ? (n2 -= n) : 0;
        n3 = n3 - n >= 0 ? (n3 -= n) : 0;
        n4 = n4 - n >= 0 ? (n4 -= n) : 0;
        return new Color(n2, n3, n4);
    }

    public static Color getLighter(Color color, int n) {
        if (color == null) {
            return null;
        }
        int n2 = color.getRed();
        int n3 = color.getGreen();
        int n4 = color.getBlue();
        n2 = n2 + n < 255 ? (n2 += n) : 255;
        n3 = n3 + n < 255 ? (n3 += n) : 255;
        n4 = n4 + n < 255 ? (n4 += n) : 255;
        return new Color(n2, n3, n4);
    }

    public static void setValue(JTextField jTextField, JSlider jSlider, JPanel jPanel, String string, String string2) {
        String string3 = jTextField.getText().trim();
        float f = 0.0f;
        try {
            if (string3.length() == 0) {
                jTextField.setText("0.0");
            } else {
                f = new Float(string3).floatValue();
            }
            jSlider.setValue((int)(f * 100000.0f));
            jSlider.validate();
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(jPanel, string + " " + string3, string2, 0);
        }
    }

    public static void setValueFromTextField(JTextField jTextField, JSlider jSlider, JPanel jPanel, String string, String string2) {
        String string3 = jTextField.getText().trim();
        float f = 0.0f;
        try {
            if (string3.length() == 0) {
                jTextField.setText("0.0");
            } else {
                f = new Float(string3).floatValue();
            }
            jSlider.setValue((int)(f * 100000.0f));
            jSlider.validate();
            ((Paintable)((Object)jPanel)).paintElement();
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(jPanel, string + " " + string3, string2, 0);
        }
    }

    public static float getDistanceBetweenTwoBlobs(Blob blob, Blob blob2) {
        float f = blob.center.x - blob2.center.x;
        float f2 = blob.center.y - blob2.center.y;
        float f3 = blob.center.z - blob2.center.z;
        return (float)Math.sqrt(f * f + f2 * f2 + f3 * f3);
    }

    public static float getAngleZ(float f, float f2) {
        if (f2 > 0.0f) {
            return (float)Math.toDegrees(Math.atan2(f2, f));
        }
        return 360.0f + (float)Math.toDegrees(Math.atan2(f2, f));
    }

    public static float getAngleX(float f, float f2) {
        float f3 = -f2;
        if (f3 > 0.0f) {
            return (float)Math.toDegrees(Math.atan2(f3, f));
        }
        return 360.0f + (float)Math.toDegrees(Math.atan2(f3, f));
    }

    public static void tuneFileChooser(JFileChooser jFileChooser) {
        Component[] componentArray = jFileChooser.getComponents();
        int n = 0;
        while (n < componentArray.length) {
            Component[] componentArray2 = ((JPanel)componentArray[n]).getComponents();
            int n2 = 0;
            while (n2 < componentArray2.length) {
                JComboBox jComboBox;
                if (componentArray2[n2] instanceof JComboBox) {
                    jComboBox = (JComboBox)componentArray2[n2];
                    jComboBox.setRenderer(new FileComboBoxRenderer(jFileChooser));
                    jComboBox.setFocusable(false);
                } else if (componentArray2[n2] instanceof JPanel) {
                    Component[] componentArray3 = ((JPanel)componentArray2[n2]).getComponents();
                    int n3 = 0;
                    while (n3 < componentArray3.length) {
                        if (componentArray3[n3] instanceof JComboBox) {
                            jComboBox = (JComboBox)componentArray3[n3];
                            jComboBox.setRenderer(new FileComboBoxRenderer(jFileChooser));
                            jComboBox.setFocusable(false);
                        }
                        ++n3;
                    }
                }
                ++n2;
            }
            ++n;
        }
    }
}

