/*
 * Decompiled with CFR 0.152.
 */
package povtree.gui;

import java.awt.Dimension;
import java.awt.Graphics;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFileChooser;

public class ImageAccessor
extends JComponent
implements PropertyChangeListener {
    ImageIcon preview = null;
    File file = null;

    public ImageAccessor(JFileChooser jFileChooser) {
        this.setPreferredSize(new Dimension(100, 100));
        jFileChooser.addPropertyChangeListener(this);
    }

    public void loadImage() {
        if (this.file == null) {
            this.preview = null;
            return;
        }
        ImageIcon imageIcon = new ImageIcon(this.file.getPath());
        if (imageIcon != null) {
            this.preview = imageIcon.getIconWidth() > 100 ? new ImageIcon(imageIcon.getImage().getScaledInstance(100, -1, 1)) : (imageIcon.getIconWidth() <= 100 && imageIcon.getIconHeight() > 100 ? new ImageIcon(imageIcon.getImage().getScaledInstance(-1, 100, 1)) : imageIcon);
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        boolean bl = false;
        String string = propertyChangeEvent.getPropertyName();
        if ("directoryChanged".equals(string)) {
            this.file = null;
            bl = true;
        } else if ("SelectedFileChangedProperty".equals(string)) {
            this.file = (File)propertyChangeEvent.getNewValue();
            bl = true;
        }
        if (bl) {
            this.preview = null;
            if (this.isShowing()) {
                this.loadImage();
                this.repaint();
            }
        }
    }

    protected void paintComponent(Graphics graphics) {
        if (this.preview == null) {
            this.loadImage();
        }
        if (this.preview != null) {
            int n = this.getWidth() / 2 - this.preview.getIconWidth() / 2;
            int n2 = this.getHeight() / 2 - this.preview.getIconHeight() / 2;
            if (n2 < 0) {
                n2 = 0;
            }
            if (n < 5) {
                n = 5;
            }
            this.preview.paintIcon(this, graphics, n, n2);
        }
    }
}

