/*
 * Decompiled with CFR 0.152.
 */
package povtree.gui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;

public class ImagePanel
extends JPanel {
    private JLayeredPane[] jlp = new JLayeredPane[7];
    private JLabel roots = new JLabel(new ImageIcon(this.getClass().getResource("images/roots.png")));
    private JLabel trunk = new JLabel(new ImageIcon(this.getClass().getResource("images/trunk.png")));
    private JLabel branches = new JLabel(new ImageIcon(this.getClass().getResource("images/branches.png")));
    private JLabel twigs = new JLabel(new ImageIcon(this.getClass().getResource("images/twigs.png")));
    private JLabel rami = new JLabel(new ImageIcon(this.getClass().getResource("images/rami.png")));
    private JLabel foliage = new JLabel(new ImageIcon(this.getClass().getResource("images/foliage.png")));
    private JLabel blossom = new JLabel(new ImageIcon(this.getClass().getResource("images/blossom.png")));
    private JLabel[] empty = new JLabel[7];
    private String emptyName = "images/empty.png";
    private GridBagConstraints c = new GridBagConstraints();
    private int blossomIndex = 0;
    private int twigsIndex = 1;
    private int branchesIndex = 2;
    private int ramiIndex = 3;
    private int rootsIndex = 4;
    private int trunkIndex = 5;
    private int foliageIndex = 6;

    public ImagePanel() {
        this.c.gridx = 0;
        this.c.gridy = 0;
        this.c.weightx = 1.0;
        this.c.weighty = 1.0;
        this.c.anchor = 17;
        this.c.ipadx = 0;
        this.setLayout(new GridBagLayout());
        int n = 0;
        while (n < 7) {
            this.jlp[n] = new JLayeredPane();
            this.jlp[n].setLayout(new GridBagLayout());
            this.empty[n] = new JLabel(new ImageIcon(this.getClass().getResource(this.emptyName)));
            this.add((Component)this.jlp[n], this.c);
            ++n;
        }
    }

    public void addRoots() {
        this.adds(this.roots, this.rootsIndex);
    }

    public void removeRoots() {
        this.remove(this.roots, this.rootsIndex);
    }

    public void addTrunk() {
        this.adds(this.trunk, this.trunkIndex);
    }

    public void removeTrunk() {
        this.remove(this.trunk, this.trunkIndex);
    }

    public void addBranches() {
        this.adds(this.branches, this.branchesIndex);
    }

    public void removeBranches() {
        this.remove(this.branches, this.branchesIndex);
    }

    public void addTwigs() {
        this.adds(this.twigs, this.twigsIndex);
    }

    public void removeTwigs() {
        this.remove(this.twigs, this.twigsIndex);
    }

    public void addRami() {
        this.adds(this.rami, this.ramiIndex);
    }

    public void removeRami() {
        this.remove(this.rami, this.ramiIndex);
    }

    public void addFoliage() {
        this.adds(this.foliage, this.foliageIndex);
    }

    public void removeFoliage() {
        this.remove(this.foliage, this.foliageIndex);
    }

    public void addBlossom() {
        this.adds(this.blossom, this.blossomIndex);
    }

    public void removeBlossom() {
        this.remove(this.blossom, this.blossomIndex);
    }

    public void adds(Component component, int n) {
        int n2 = this.jlp[n].getIndexOf(component);
        int n3 = this.jlp[n].getIndexOf(this.empty[n]);
        if (n2 != -1) {
            return;
        }
        if (n2 == -1 && n3 == -1) {
            this.jlp[n].add(component, this.c);
        } else if (n2 == -1 && n3 != -1) {
            this.jlp[n].remove(n3);
            this.jlp[n].add(component, this.c);
        }
        this.revalidate();
        this.repaint();
    }

    public void remove(Component component, int n) {
        int n2 = this.jlp[n].getIndexOf(component);
        if (n2 == -1) {
            return;
        }
        this.jlp[n].remove(component);
        this.jlp[n].add((Component)this.empty[n], this.c);
        this.revalidate();
        this.repaint();
    }
}

