/*
 * Decompiled with CFR 0.152.
 */
package povtree.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.ResourceBundle;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.border.BevelBorder;
import povtree.gui.Helper;
import povtree.gui.plaf.ButtonUI;
import povtree.gui.plaf.ToggleButtonUI;
import povtree.interfaces.Leaf;
import povtree.objects3D.Coordinate;
import povtree.objects3D.LeafArray;
import povtree.objects3D.LeafMesh;
import povtree.objects3D.Triangle;

public class LeafPainter
extends JPanel {
    private int x;
    private int y;
    private int mouseX;
    private int mouseY;
    private boolean dragged = false;
    private LeafArray element = null;
    private JPanel topPanel = new JPanel();
    private JButton centerB = null;
    private byte transformationType;
    private JPanel canvas;
    private boolean initial = false;
    private Color currentColor;
    private JToggleButton rotate;
    private JToggleButton scale;
    private JToggleButton translate;

    public LeafPainter(ResourceBundle resourceBundle) {
        this.setLayout(new BorderLayout());
        this.setBorder(new BevelBorder(1, Helper.getLighter(this.getBackground(), 40), Helper.getLighter(this.getBackground(), 40), this.getBackground().darker().darker(), this.getBackground().darker().darker()));
        this.setOpaque(false);
        Dimension dimension = new Dimension(28, 24);
        ButtonGroup buttonGroup = new ButtonGroup();
        this.rotate = new JToggleButton(new ImageIcon(this.getClass().getResource("images/rotate1.png")));
        this.rotate.setRolloverIcon(new ImageIcon(this.getClass().getResource("images/rotate2.png")));
        this.rotate.setSelectedIcon(new ImageIcon(this.getClass().getResource("images/rotate2.png")));
        this.rotate.setPreferredSize(dimension);
        this.rotate.setToolTipText(resourceBundle.getString("rotate"));
        this.rotate.setSelected(true);
        this.rotate.setUI(new ToggleButtonUI());
        buttonGroup.add(this.rotate);
        this.scale = new JToggleButton(new ImageIcon(this.getClass().getResource("images/scale1.png")));
        this.scale.setRolloverIcon(new ImageIcon(this.getClass().getResource("images/scale2.png")));
        this.scale.setSelectedIcon(new ImageIcon(this.getClass().getResource("images/scale2.png")));
        this.scale.setPreferredSize(dimension);
        this.scale.setToolTipText(resourceBundle.getString("scale"));
        this.scale.setUI(new ToggleButtonUI());
        buttonGroup.add(this.scale);
        this.translate = new JToggleButton(new ImageIcon(this.getClass().getResource("images/translate1.png")));
        this.translate.setRolloverIcon(new ImageIcon(this.getClass().getResource("images/translate2.png")));
        this.translate.setSelectedIcon(new ImageIcon(this.getClass().getResource("images/translate2.png")));
        this.translate.setPreferredSize(dimension);
        this.translate.setToolTipText(resourceBundle.getString("translate"));
        this.translate.setUI(new ToggleButtonUI());
        buttonGroup.add(this.translate);
        dimension = new Dimension(30, 26);
        this.centerB = new JButton(new ImageIcon(this.getClass().getResource("images/center.png")));
        this.centerB.setToolTipText(resourceBundle.getString("center"));
        this.centerB.setPreferredSize(dimension);
        this.canvas = new JPanel(){

            public void paintComponent(Graphics graphics) {
                super.paintComponent(graphics);
                Rectangle rectangle = LeafPainter.this.canvas.getBounds();
                float f = (LeafPainter.this.mouseY - LeafPainter.this.y) * 360 / rectangle.width;
                float f2 = (LeafPainter.this.x - LeafPainter.this.mouseX) * 360 / rectangle.height;
                float f3 = LeafPainter.this.x - LeafPainter.this.mouseX;
                float f4 = LeafPainter.this.y - LeafPainter.this.mouseY;
                if (!LeafPainter.this.dragged && LeafPainter.this.initial) {
                    f4 = 0.0f;
                    f3 = 0.0f;
                    f2 = 0.0f;
                    f = 0.0f;
                    LeafPainter.this.center(LeafPainter.this.canvas.getBounds());
                    LeafPainter.this.initial = false;
                }
                if (LeafPainter.this.rotate.isSelected()) {
                    LeafPainter.this.transformationType = (byte)0;
                } else if (LeafPainter.this.scale.isSelected()) {
                    LeafPainter.this.transformationType = (byte)1;
                } else if (LeafPainter.this.translate.isSelected()) {
                    LeafPainter.this.transformationType = (byte)2;
                }
                LeafPainter.this.drawWireframe(rectangle, f, f2, f3, f4, graphics, LeafPainter.this.transformationType);
                LeafPainter.this.mouseX = LeafPainter.this.x;
                LeafPainter.this.mouseY = LeafPainter.this.y;
                LeafPainter.this.dragged = false;
            }
        };
        this.topPanel.add(this.rotate);
        this.topPanel.add(this.scale);
        this.topPanel.add(this.translate);
        this.centerB.setUI(new ButtonUI());
        this.centerB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (LeafPainter.this.element != null) {
                    LeafPainter.this.center(LeafPainter.this.canvas.getBounds());
                    LeafPainter.this.canvas.repaint();
                }
            }
        });
        JPanel jPanel = new JPanel();
        jPanel.setPreferredSize(new Dimension(10, 2));
        this.topPanel.add(jPanel);
        this.topPanel.add(this.centerB);
        this.topPanel.setBorder(new BevelBorder(0, Helper.getLighter(this.topPanel.getBackground(), 40), Helper.getLighter(this.topPanel.getBackground(), 40), this.topPanel.getBackground().darker().darker(), this.topPanel.getBackground().darker().darker()));
        this.add((Component)this.topPanel, "North");
        this.canvas.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseDragged(MouseEvent mouseEvent) {
                LeafPainter.this.x = mouseEvent.getX();
                LeafPainter.this.y = mouseEvent.getY();
                LeafPainter.this.dragged = true;
                LeafPainter.this.canvas.repaint();
            }
        });
        this.canvas.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                LeafPainter.this.mouseX = mouseEvent.getX();
                LeafPainter.this.mouseY = mouseEvent.getY();
            }
        });
        this.canvas.repaint();
        this.add((Component)this.canvas, "Center");
    }

    public void setElement(LeafArray leafArray, Color color) {
        this.element = leafArray;
        this.initial = true;
        this.canvas.repaint();
        this.currentColor = color;
    }

    public void setCanvasColor(Color color) {
        this.canvas.setBackground(color);
        this.canvas.repaint();
    }

    public void drawWireframe(Rectangle rectangle, float f, float f2, float f3, float f4, Graphics graphics, byte by) {
        if (this.element == null) {
            return;
        }
        if (by == 0 && this.dragged) {
            this.element.translate(-rectangle.width / 2, -rectangle.height / 2, 0.0f);
            this.element.rotateX(f);
            this.element.rotateY(f2);
            this.element.translate(rectangle.width / 2, rectangle.height / 2, 0.0f);
        } else if (by == 1 && this.dragged) {
            float f5 = 0.0f;
            f5 = f3 > 0.0f ? 1.1f : 0.9f;
            this.element.translate(-rectangle.width / 2, -rectangle.height / 2, 0.0f);
            this.element.scale(f5);
            this.element.translate(rectangle.width / 2, rectangle.height / 2, 0.0f);
        } else if (by == 2 && this.dragged) {
            this.element.translate(f3, f4, 0.0f);
        }
        if (this.element != null) {
            this.drawLeaves(this.element, graphics);
        }
    }

    public void drawLeaves(LeafArray leafArray, Graphics graphics) {
        int n = leafArray.size();
        int[] nArray = new int[3];
        int[] nArray2 = new int[3];
        float f = (float)this.currentColor.getRed() / 255.0f;
        float f2 = (float)this.currentColor.getGreen() / 255.0f;
        float f3 = (float)this.currentColor.getBlue() / 255.0f;
        float f4 = f / (float)n;
        float f5 = f2 / (float)n;
        float f6 = f3 / (float)n;
        Collections.sort(leafArray.get());
        int n2 = 0;
        while (n2 < n) {
            Leaf leaf = leafArray.get(n2);
            ArrayList arrayList = leaf.getTriangles();
            int n3 = 0;
            while (n3 < arrayList.size()) {
                Triangle triangle = (Triangle)arrayList.get(n3);
                graphics.setColor(new Color((float)n2 * f4, (float)n2 * f5, (float)n2 * f6));
                nArray[0] = (int)triangle.c1.x;
                nArray[1] = (int)triangle.c2.x;
                nArray[2] = (int)triangle.c3.x;
                nArray2[0] = (int)triangle.c1.y;
                nArray2[1] = (int)triangle.c2.y;
                nArray2[2] = (int)triangle.c3.y;
                Polygon polygon = new Polygon(nArray, nArray2, 3);
                graphics.fillPolygon(polygon);
                ++n3;
            }
            ++n2;
        }
    }

    public ArrayList getMinMax(LeafArray leafArray) {
        ArrayList<Coordinate> arrayList = new ArrayList<Coordinate>(2);
        Coordinate coordinate = new Coordinate();
        Coordinate coordinate2 = new Coordinate();
        float f = 0.0f;
        float f2 = 0.0f;
        float f3 = 0.0f;
        float f4 = 0.0f;
        float f5 = 0.0f;
        float f6 = 0.0f;
        if (leafArray != null) {
            ArrayList arrayList2 = leafArray.get();
            LeafMesh leafMesh = (LeafMesh)arrayList2.get(0);
            f = leafMesh.getMinimumX();
            f2 = leafMesh.getMinimumY();
            f3 = leafMesh.getMinimumZ();
            f4 = leafMesh.getMaximumX();
            f5 = leafMesh.getMaximumY();
            f6 = leafMesh.getMaximumZ();
            int n = 1;
            while (n < arrayList2.size()) {
                leafMesh = (LeafMesh)arrayList2.get(n);
                float f7 = leafMesh.getMinimumX();
                float f8 = leafMesh.getMinimumY();
                float f9 = leafMesh.getMinimumZ();
                float f10 = leafMesh.getMaximumX();
                float f11 = leafMesh.getMaximumY();
                float f12 = leafMesh.getMaximumZ();
                if (f7 < f) {
                    f = f7;
                }
                if (f10 > f4) {
                    f4 = f10;
                }
                if (f8 < f2) {
                    f2 = f8;
                }
                if (f11 > f5) {
                    f5 = f11;
                }
                if (f9 < f3) {
                    f3 = f9;
                }
                if (f12 > f6) {
                    f6 = f12;
                }
                ++n;
            }
        }
        coordinate.set(f, f2, f3);
        coordinate2.set(f4, f5, f6);
        arrayList.add(coordinate);
        arrayList.add(coordinate2);
        return arrayList;
    }

    public void center(Rectangle rectangle) {
        float f;
        if (this.element == null) {
            return;
        }
        ArrayList arrayList = this.getMinMax(this.element);
        Coordinate coordinate = (Coordinate)arrayList.get(0);
        Coordinate coordinate2 = (Coordinate)arrayList.get(1);
        float f2 = Math.abs(coordinate2.x - coordinate.x);
        float f3 = Math.abs(coordinate2.y - coordinate.y);
        float f4 = Math.abs(coordinate2.z - coordinate.z);
        float f5 = rectangle.width - 60;
        float f6 = rectangle.height - 60;
        if (f2 > f3) {
            f = f5 / f2;
            if (f3 * f > f6) {
                f = f6 / f3;
            }
        } else {
            f = f6 / f3;
            if (f2 * f > f5) {
                f = f5 / f2;
            }
        }
        this.element.translate(-coordinate.x, -coordinate.y, -coordinate.z);
        this.element.translate(-f2 / 2.0f, -f3 / 2.0f, -f4 / 2.0f);
        this.element.scale(f);
        this.element.translate(rectangle.width / 2, rectangle.height / 2, 0.0f);
    }
}

