/*
 * Decompiled with CFR 0.152.
 */
package povtree.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.ArrayList;
import javax.swing.JPanel;
import javax.swing.border.BevelBorder;
import povtree.gui.Helper;
import povtree.interfaces.Leaf;
import povtree.objects3D.Coordinate;
import povtree.objects3D.LeafMesh;
import povtree.objects3D.Triangle;

public class LeafUvPainter
extends JPanel {
    private int x;
    private int y;
    private int mouseX;
    private int mouseY;
    private boolean dragged = false;
    private Leaf element = null;
    private JPanel canvas;

    public LeafUvPainter() {
        this.setLayout(new BorderLayout());
        this.setBorder(new BevelBorder(1, Helper.getLighter(this.getBackground(), 40), Helper.getLighter(this.getBackground(), 40), this.getBackground().darker().darker(), this.getBackground().darker().darker()));
        this.setOpaque(false);
        this.canvas = new JPanel(){

            public void paintComponent(Graphics graphics) {
                super.paintComponent(graphics);
                Rectangle rectangle = LeafUvPainter.this.canvas.getBounds();
                float f = (LeafUvPainter.this.mouseY - LeafUvPainter.this.y) * 360 / rectangle.width;
                float f2 = (LeafUvPainter.this.x - LeafUvPainter.this.mouseX) * 360 / rectangle.height;
                float f3 = LeafUvPainter.this.x - LeafUvPainter.this.mouseX;
                float f4 = LeafUvPainter.this.y - LeafUvPainter.this.mouseY;
                if (!LeafUvPainter.this.dragged) {
                    f4 = 0.0f;
                    f3 = 0.0f;
                    f2 = 0.0f;
                    f = 0.0f;
                    LeafUvPainter.this.center(LeafUvPainter.this.canvas.getBounds());
                }
                LeafUvPainter.this.drawWireframe(rectangle, f, f2, f3, f4, graphics);
                LeafUvPainter.this.mouseX = LeafUvPainter.this.x;
                LeafUvPainter.this.mouseY = LeafUvPainter.this.y;
                LeafUvPainter.this.dragged = false;
            }
        };
        this.canvas.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseDragged(MouseEvent mouseEvent) {
                LeafUvPainter.this.x = mouseEvent.getX();
                LeafUvPainter.this.y = mouseEvent.getY();
                LeafUvPainter.this.dragged = true;
                LeafUvPainter.this.canvas.repaint();
            }
        });
        this.canvas.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                LeafUvPainter.this.mouseX = mouseEvent.getX();
                LeafUvPainter.this.mouseY = mouseEvent.getY();
            }
        });
        this.canvas.repaint();
        this.add((Component)this.canvas, "Center");
    }

    public void setElement(Leaf leaf) {
        this.element = leaf;
        this.element.rotateY(135.0f);
        this.element.rotateX(130.0f);
        this.canvas.repaint();
    }

    public void setCanvasColor(Color color) {
        this.canvas.setBackground(color);
        this.canvas.repaint();
    }

    public void drawWireframe(Rectangle rectangle, float f, float f2, float f3, float f4, Graphics graphics) {
        if (this.element == null) {
            return;
        }
        if (this.dragged) {
            this.element.translate(-rectangle.width / 2, -rectangle.height / 2, 0.0f);
            this.element.rotateX(f);
            this.element.rotateY(f2);
            this.element.translate(rectangle.width / 2, rectangle.height / 2, 0.0f);
        }
        if (this.element != null) {
            this.drawLeaf(this.element, graphics);
        }
    }

    public void drawLeaf(Leaf leaf, Graphics graphics) {
        Leaf leaf2 = leaf;
        int[] nArray = new int[3];
        int[] nArray2 = new int[3];
        graphics.setColor(Color.black);
        ArrayList arrayList = leaf2.getTriangles();
        int n = 0;
        while (n < arrayList.size()) {
            Triangle triangle = (Triangle)arrayList.get(n);
            nArray[0] = (int)triangle.c1.x;
            nArray[1] = (int)triangle.c2.x;
            nArray[2] = (int)triangle.c3.x;
            nArray2[0] = (int)triangle.c1.y;
            nArray2[1] = (int)triangle.c2.y;
            nArray2[2] = (int)triangle.c3.y;
            Polygon polygon = new Polygon(nArray, nArray2, 3);
            graphics.drawPolygon(polygon);
            ++n;
        }
    }

    public ArrayList getMinMax(Leaf leaf) {
        ArrayList<Coordinate> arrayList = new ArrayList<Coordinate>(2);
        Coordinate coordinate = new Coordinate();
        Coordinate coordinate2 = new Coordinate();
        float f = 0.0f;
        float f2 = 0.0f;
        float f3 = 0.0f;
        float f4 = 0.0f;
        float f5 = 0.0f;
        float f6 = 0.0f;
        if (leaf != null) {
            LeafMesh leafMesh = (LeafMesh)leaf;
            f = leafMesh.getMinimumX();
            f2 = leafMesh.getMinimumY();
            f3 = leafMesh.getMinimumZ();
            f4 = leafMesh.getMaximumX();
            f5 = leafMesh.getMaximumY();
            f6 = leafMesh.getMaximumZ();
        }
        coordinate.set(f, f2, f3);
        coordinate2.set(f4, f5, f6);
        arrayList.add(coordinate);
        arrayList.add(coordinate2);
        return arrayList;
    }

    public void center(Rectangle rectangle) {
        float f;
        if (this.element == null) {
            return;
        }
        ArrayList arrayList = this.getMinMax(this.element);
        Coordinate coordinate = (Coordinate)arrayList.get(0);
        Coordinate coordinate2 = (Coordinate)arrayList.get(1);
        float f2 = Math.abs(coordinate2.x - coordinate.x);
        float f3 = Math.abs(coordinate2.y - coordinate.y);
        float f4 = Math.abs(coordinate2.z - coordinate.z);
        float f5 = rectangle.width - 20;
        float f6 = rectangle.height - 20;
        if (f2 > f3) {
            f = f5 / f2;
            if (f3 * f > f6) {
                f = f6 / f3;
            }
        } else {
            f = f6 / f3;
            if (f2 * f > f5) {
                f = f5 / f2;
            }
        }
        this.element.translate(-coordinate.x, -coordinate.y, -coordinate.z);
        this.element.translate(-f2 / 2.0f, -f3 / 2.0f, -f4 / 2.0f);
        this.element.scale(f);
        this.element.translate(rectangle.width / 2, rectangle.height / 2, 0.0f);
    }
}

