/*
 * Decompiled with CFR 0.152.
 */
package povtree.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.ResourceBundle;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.border.BevelBorder;
import povtree.gui.Helper;
import povtree.gui.plaf.ButtonUI;
import povtree.gui.plaf.ToggleButtonUI;
import povtree.interfaces.Transformable;
import povtree.objects3D.Blob;
import povtree.objects3D.BlobArray;
import povtree.objects3D.Coordinate;
import povtree.objects3D.DoubleBlobArray;

public class Painter
extends JPanel {
    private int x;
    private int y;
    private int mouseX;
    private int mouseY;
    private boolean dragged = false;
    private byte drawType = 0;
    private Object element = null;
    private float fraction;
    private float maximumZ;
    private JPanel topPanel = new JPanel();
    private JPanel bottomPanel = new JPanel();
    private JButton centerB = null;
    private byte transformationType;
    private JPanel canvas;
    private int radial;
    private int vertical;
    private boolean initial = false;
    private boolean isRami = false;
    private JToggleButton lines;
    private JToggleButton blobs;
    private JToggleButton mesh;
    private JToggleButton rotate;
    private JToggleButton scale;
    private JToggleButton translate;

    public Painter(ResourceBundle resourceBundle) {
        this.setLayout(new BorderLayout());
        this.setBorder(new BevelBorder(1, Helper.getLighter(this.getBackground(), 40), Helper.getLighter(this.getBackground(), 40), this.getBackground().darker().darker(), this.getBackground().darker().darker()));
        this.setOpaque(false);
        Dimension dimension = new Dimension(28, 24);
        ButtonGroup buttonGroup = new ButtonGroup();
        this.rotate = new JToggleButton(new ImageIcon(this.getClass().getResource("images/rotate1.png")));
        this.rotate.setRolloverIcon(new ImageIcon(this.getClass().getResource("images/rotate2.png")));
        this.rotate.setSelectedIcon(new ImageIcon(this.getClass().getResource("images/rotate2.png")));
        this.rotate.setPreferredSize(dimension);
        this.rotate.setToolTipText(resourceBundle.getString("rotate"));
        this.rotate.setSelected(true);
        this.rotate.setUI(new ToggleButtonUI());
        buttonGroup.add(this.rotate);
        this.scale = new JToggleButton(new ImageIcon(this.getClass().getResource("images/scale1.png")));
        this.scale.setRolloverIcon(new ImageIcon(this.getClass().getResource("images/scale2.png")));
        this.scale.setSelectedIcon(new ImageIcon(this.getClass().getResource("images/scale2.png")));
        this.scale.setPreferredSize(dimension);
        this.scale.setToolTipText(resourceBundle.getString("scale"));
        this.scale.setUI(new ToggleButtonUI());
        buttonGroup.add(this.scale);
        this.translate = new JToggleButton(new ImageIcon(this.getClass().getResource("images/translate1.png")));
        this.translate.setRolloverIcon(new ImageIcon(this.getClass().getResource("images/translate2.png")));
        this.translate.setSelectedIcon(new ImageIcon(this.getClass().getResource("images/translate2.png")));
        this.translate.setPreferredSize(dimension);
        this.translate.setToolTipText(resourceBundle.getString("translate"));
        this.translate.setUI(new ToggleButtonUI());
        buttonGroup.add(this.translate);
        dimension = new Dimension(30, 26);
        this.centerB = new JButton(new ImageIcon(this.getClass().getResource("images/center.png")));
        this.centerB.setToolTipText(resourceBundle.getString("center"));
        this.centerB.setPreferredSize(dimension);
        buttonGroup = new ButtonGroup();
        dimension = new Dimension(27, 22);
        this.lines = new JToggleButton(new ImageIcon(this.getClass().getResource("images/lines1.png")));
        this.lines.setRolloverIcon(new ImageIcon(this.getClass().getResource("images/lines2.png")));
        this.lines.setSelectedIcon(new ImageIcon(this.getClass().getResource("images/lines2.png")));
        this.lines.setPreferredSize(dimension);
        this.lines.setToolTipText(resourceBundle.getString("lines"));
        this.lines.setSelected(true);
        this.lines.setUI(new ToggleButtonUI());
        this.lines.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Painter.this.dragged = true;
                Painter.this.canvas.repaint();
            }
        });
        buttonGroup.add(this.lines);
        this.blobs = new JToggleButton(new ImageIcon(this.getClass().getResource("images/blobs1.png")));
        this.blobs.setRolloverIcon(new ImageIcon(this.getClass().getResource("images/blobs2.png")));
        this.blobs.setSelectedIcon(new ImageIcon(this.getClass().getResource("images/blobs2.png")));
        this.blobs.setPreferredSize(dimension);
        this.blobs.setToolTipText(resourceBundle.getString("spheres"));
        this.blobs.setSelected(true);
        this.blobs.setUI(new ToggleButtonUI());
        this.blobs.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Painter.this.dragged = true;
                Painter.this.canvas.repaint();
            }
        });
        buttonGroup.add(this.blobs);
        this.mesh = new JToggleButton(new ImageIcon(this.getClass().getResource("images/meshIcon1.png")));
        this.mesh.setRolloverIcon(new ImageIcon(this.getClass().getResource("images/meshIcon2.png")));
        this.blobs.setSelectedIcon(new ImageIcon(this.getClass().getResource("images/meshIcon2.png")));
        this.mesh.setPreferredSize(dimension);
        this.mesh.setToolTipText(resourceBundle.getString("mesh"));
        this.mesh.setSelected(true);
        this.mesh.setUI(new ToggleButtonUI());
        this.mesh.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Painter.this.dragged = true;
                Painter.this.canvas.repaint();
            }
        });
        buttonGroup.add(this.mesh);
        this.canvas = new JPanel(){

            public void paintComponent(Graphics graphics) {
                super.paintComponent(graphics);
                Rectangle rectangle = Painter.this.canvas.getBounds();
                float f = (Painter.this.mouseY - Painter.this.y) * 360 / rectangle.width;
                float f2 = (Painter.this.x - Painter.this.mouseX) * 360 / rectangle.height;
                float f3 = Painter.this.x - Painter.this.mouseX;
                float f4 = Painter.this.y - Painter.this.mouseY;
                if (!Painter.this.dragged && Painter.this.initial) {
                    f4 = 0.0f;
                    f3 = 0.0f;
                    f2 = 0.0f;
                    f = 0.0f;
                    Painter.this.center(Painter.this.canvas.getBounds());
                    Painter.this.initial = false;
                }
                if (Painter.this.rotate.isSelected()) {
                    Painter.this.transformationType = (byte)0;
                } else if (Painter.this.scale.isSelected()) {
                    Painter.this.transformationType = (byte)1;
                } else if (Painter.this.translate.isSelected()) {
                    Painter.this.transformationType = (byte)2;
                }
                Painter.this.draw(rectangle, f, f2, f3, f4, graphics, Painter.this.transformationType);
                Painter.this.mouseX = Painter.this.x;
                Painter.this.mouseY = Painter.this.y;
                Painter.this.dragged = false;
            }
        };
        this.topPanel.add(this.rotate);
        this.topPanel.add(this.scale);
        this.topPanel.add(this.translate);
        this.centerB.setUI(new ButtonUI());
        this.centerB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (Painter.this.element != null) {
                    Painter.this.center(Painter.this.canvas.getBounds());
                    Painter.this.canvas.repaint();
                }
            }
        });
        JPanel jPanel = new JPanel();
        jPanel.setPreferredSize(new Dimension(10, 2));
        this.topPanel.add(jPanel);
        this.topPanel.add(this.centerB);
        this.topPanel.setBorder(new BevelBorder(0, Helper.getLighter(this.topPanel.getBackground(), 40), Helper.getLighter(this.topPanel.getBackground(), 40), this.topPanel.getBackground().darker().darker(), this.topPanel.getBackground().darker().darker()));
        this.add((Component)this.topPanel, "North");
        this.bottomPanel = new JPanel();
        this.bottomPanel.add(this.lines);
        this.bottomPanel.add(this.blobs);
        this.bottomPanel.add(this.mesh);
        this.bottomPanel.setOpaque(true);
        this.bottomPanel.setBorder(new BevelBorder(0, Helper.getLighter(this.bottomPanel.getBackground(), 40), Helper.getLighter(this.bottomPanel.getBackground(), 40), this.bottomPanel.getBackground().darker().darker(), this.bottomPanel.getBackground().darker().darker()));
        this.add((Component)this.bottomPanel, "South");
        this.canvas.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseDragged(MouseEvent mouseEvent) {
                Painter.this.x = mouseEvent.getX();
                Painter.this.y = mouseEvent.getY();
                Painter.this.dragged = true;
                Painter.this.canvas.repaint();
            }
        });
        this.canvas.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                Painter.this.mouseX = mouseEvent.getX();
                Painter.this.mouseY = mouseEvent.getY();
            }
        });
        this.canvas.setBackground(Helper.getLighter(this.canvas.getBackground(), 20));
        this.canvas.repaint();
        this.add((Component)this.canvas, "Center");
    }

    public void setElement(Object object, int n, int n2) {
        this.radial = n;
        this.vertical = n2;
        this.initial = true;
        this.element = object;
        if (this.element != null) {
            if (object instanceof BlobArray) {
                int n3 = ((BlobArray)this.element).size();
                float f = ((BlobArray)this.element).get((int)0).center.z;
                float f2 = ((BlobArray)this.element).get((int)(n3 - 1)).center.z;
                float f3 = ((BlobArray)this.element).get((int)0).center.x;
                float f4 = ((BlobArray)this.element).get((int)0).center.x;
                float f5 = ((BlobArray)this.element).get((int)(n3 - 1)).center.x;
                float f6 = (float)Math.toDegrees(Math.atan2(Math.abs(f3 - f5), Math.abs(f - f2)));
                ((Transformable)this.element).translate(-f3, -f4, -f);
                ((Transformable)this.element).rotateY(90.0f - f6);
                this.isRami = false;
            } else {
                BlobArray blobArray = ((DoubleBlobArray)this.element).get(0);
                int n4 = blobArray.size();
                float f = blobArray.get((int)0).center.z;
                float f7 = blobArray.get((int)(n4 - 1)).center.z;
                float f8 = blobArray.get((int)0).center.x;
                float f9 = blobArray.get((int)0).center.x;
                float f10 = blobArray.get((int)(n4 - 1)).center.x;
                float f11 = (float)Math.toDegrees(Math.atan2(Math.abs(f8 - f10), Math.abs(f - f7)));
                ((Transformable)this.element).translate(-f8, -f9, -f);
                ((Transformable)this.element).rotateY(90.0f - f11);
                this.isRami = true;
            }
        }
        this.canvas.repaint();
    }

    public void draw(Rectangle rectangle, float f, float f2, float f3, float f4, Graphics graphics, byte by) {
        if (this.lines.isSelected()) {
            this.drawType = 0;
        } else if (this.blobs.isSelected()) {
            this.drawType = 1;
        } else if (this.mesh.isSelected()) {
            this.drawType = (byte)2;
        }
        if (this.element == null) {
            graphics.setColor(this.canvas.getBackground());
            graphics.fillRect(0, 0, rectangle.width, rectangle.height);
            return;
        }
        if (by == 0 && this.dragged) {
            ((Transformable)this.element).translate(-rectangle.width / 2, -rectangle.height / 2, 0.0f);
            ((Transformable)this.element).rotateX(f);
            ((Transformable)this.element).rotateY(f2);
            ((Transformable)this.element).translate(rectangle.width / 2, rectangle.height / 2, 0.0f);
        } else if (by == 1 && this.dragged) {
            float f5 = 0.0f;
            f5 = f3 > 0.0f ? 1.1f : 0.9f;
            ((Transformable)this.element).translate(-rectangle.width / 2, -rectangle.height / 2, 0.0f);
            ((Transformable)this.element).scale(f5);
            ((Transformable)this.element).translate(rectangle.width / 2, rectangle.height / 2, 0.0f);
        } else if (by == 2 && this.dragged) {
            ((Transformable)this.element).translate(f3, f4, 0.0f);
        }
        ArrayList arrayList = !this.isRami ? this.getMinMax((BlobArray)this.element) : this.getMinMax(this.makeBlobArrayFromDoubleArray(this.element));
        Coordinate coordinate = (Coordinate)arrayList.get(0);
        Coordinate coordinate2 = (Coordinate)arrayList.get(1);
        this.fraction = (Math.abs(coordinate.z) + Math.abs(coordinate2.z)) / 180.0f;
        this.maximumZ = coordinate2.z;
        if (this.element != null) {
            if (this.drawType == 0) {
                this.drawLines(this.element, graphics);
            } else if (this.drawType == 1) {
                this.drawBlobs(graphics);
            } else if (this.drawType == 2) {
                if (!this.isRami) {
                    this.drawMesh(graphics, (BlobArray)this.element);
                } else {
                    int n = ((DoubleBlobArray)this.element).size();
                    int n2 = 0;
                    while (n2 < n) {
                        BlobArray blobArray = ((DoubleBlobArray)this.element).get(n2);
                        this.drawMesh(graphics, blobArray);
                        ++n2;
                    }
                }
            }
        }
    }

    public void drawLines(Object object, Graphics graphics) {
        BlobArray blobArray = null;
        int n = 0;
        if (!this.isRami) {
            n = ((BlobArray)object).get().size();
            int n2 = 0;
            while (n2 < n - 1) {
                Blob blob = (Blob)((BlobArray)object).get().get(n2);
                Coordinate coordinate = blob.center;
                Blob blob2 = (Blob)((BlobArray)object).get().get(n2 + 1);
                Coordinate coordinate2 = blob2.center;
                graphics.setColor(this.getColor(blob.center, this.fraction, this.maximumZ));
                graphics.drawLine((int)coordinate.x, (int)coordinate.y, (int)coordinate2.x, (int)coordinate2.y);
                ++n2;
            }
        } else {
            n = ((DoubleBlobArray)object).size();
            int n3 = 0;
            while (n3 < n) {
                blobArray = ((DoubleBlobArray)object).get(n3);
                int n4 = 0;
                while (n4 < blobArray.size() - 1) {
                    Blob blob = (Blob)blobArray.get().get(n4);
                    Coordinate coordinate = blob.center;
                    Blob blob3 = (Blob)blobArray.get().get(n4 + 1);
                    Coordinate coordinate3 = blob3.center;
                    graphics.setColor(this.getColor(blob.center, this.fraction, this.maximumZ));
                    graphics.drawLine((int)coordinate.x, (int)coordinate.y, (int)coordinate3.x, (int)coordinate3.y);
                    ++n4;
                }
                ++n3;
            }
        }
    }

    public BlobArray makeBlobArrayFromDoubleArray(Object object) {
        BlobArray blobArray = new BlobArray();
        DoubleBlobArray doubleBlobArray = (DoubleBlobArray)((DoubleBlobArray)object).clone();
        int n = doubleBlobArray.size();
        int n2 = 0;
        while (n2 < n) {
            BlobArray blobArray2 = doubleBlobArray.get(n2);
            int n3 = 0;
            while (n3 < blobArray2.size() - 1) {
                blobArray.add(blobArray2.get(n3));
                ++n3;
            }
            ++n2;
        }
        return blobArray;
    }

    public void drawBlobs(Graphics graphics) {
        BlobArray blobArray = null;
        blobArray = !this.isRami ? (BlobArray)((BlobArray)this.element).clone() : this.makeBlobArrayFromDoubleArray(this.element);
        Collections.sort(blobArray.get());
        int n = 0;
        while (n < blobArray.size()) {
            Blob blob = blobArray.get(n);
            Coordinate coordinate = blob.center;
            graphics.setColor(this.getColor(blob.center, this.fraction, this.maximumZ));
            if ((int)blob.radius > 0) {
                graphics.fillOval((int)coordinate.x - (int)blob.radius, (int)coordinate.y - (int)blob.radius, (int)blob.radius * 2, (int)blob.radius * 2);
            }
            ++n;
        }
    }

    public void drawMesh(Graphics graphics, BlobArray blobArray) {
        BlobArray blobArray2 = new BlobArray();
        int n = blobArray.size();
        if (this.vertical > n) {
            blobArray2.add(blobArray.get(0));
            blobArray2.add(blobArray.get(n - 1));
        } else {
            int n2 = 0;
            while (n2 < n) {
                if (n2 + this.vertical < n) {
                    blobArray2.add(blobArray.get(n2));
                } else {
                    blobArray2.add(blobArray.get(n - 1));
                }
                n2 += this.vertical;
            }
        }
        n = blobArray2.size();
        if (n == 0 || n == 1) {
            return;
        }
        ArrayList arrayList = this.makeStartingRing(blobArray2.get(0), blobArray2.get(1));
        boolean bl = false;
        int n3 = 1;
        while (n3 < n - 1) {
            Blob blob = (Blob)blobArray2.get(n3 - 1).clone();
            Blob blob2 = (Blob)blobArray2.get(n3).clone();
            Blob blob3 = (Blob)blobArray2.get(n3 + 1).clone();
            ArrayList arrayList2 = this.makeNextRing(blob, blob2, blob3);
            bl = n3 == n - 2;
            this.drawRing(graphics, arrayList, arrayList2, bl);
            arrayList = (ArrayList)arrayList2.clone();
            ++n3;
        }
    }

    public ArrayList makeStartingRing(Blob blob, Blob blob2) {
        Blob blob3 = (Blob)blob2.clone();
        blob3.translate(-blob.center.x, -blob.center.y, -blob.center.z);
        blob3.mirrorX();
        blob3.mirrorY();
        blob3.mirrorZ();
        blob3.translate(blob.center.x, blob.center.y, blob.center.z);
        return this.makeNextRing(blob3, blob, blob2);
    }

    public ArrayList makeNextRing(Blob blob, Blob blob2, Blob blob3) {
        ArrayList<Coordinate> arrayList = new ArrayList<Coordinate>(this.radial);
        Blob blob4 = (Blob)blob2.clone();
        Blob blob5 = (Blob)blob3.clone();
        Coordinate coordinate = null;
        float f = (float)(360.0 / (double)this.radial);
        blob4.translate(-blob.center.x, -blob.center.y, -blob.center.z);
        blob5.translate(-blob2.center.x, -blob2.center.y, -blob2.center.z);
        float f2 = (float)Math.toDegrees(Math.atan2(blob5.center.y, blob5.center.z));
        float f3 = (float)Math.toDegrees(Math.atan2(blob5.center.y, blob5.center.x));
        int n = 0;
        while (n < this.radial) {
            coordinate = new Coordinate();
            coordinate.translate(blob2.radius, 0.0f, 0.0f);
            coordinate.rotateY(f * (float)n);
            coordinate.rotateX(f2 + 90.0f);
            coordinate.rotateZ(f3 + 90.0f);
            coordinate.translate(blob2.center.x, blob2.center.y, blob2.center.z);
            arrayList.add(coordinate);
            ++n;
        }
        return arrayList;
    }

    public void drawRing(Graphics graphics, ArrayList arrayList, ArrayList arrayList2, boolean bl) {
        graphics.setColor(Color.black);
        int n = 0;
        while (n < this.radial) {
            Coordinate coordinate;
            Coordinate coordinate2;
            Coordinate coordinate3;
            Coordinate coordinate4;
            if (n == this.radial - 1) {
                coordinate4 = (Coordinate)arrayList.get(n);
                coordinate3 = (Coordinate)arrayList2.get(n);
                coordinate2 = (Coordinate)arrayList2.get(0);
                coordinate = (Coordinate)arrayList.get(0);
            } else {
                coordinate4 = (Coordinate)arrayList.get(n);
                coordinate3 = (Coordinate)arrayList2.get(n);
                coordinate2 = (Coordinate)arrayList2.get(n + 1);
                coordinate = (Coordinate)arrayList.get(n + 1);
            }
            graphics.drawLine((int)coordinate.x, (int)coordinate.y, (int)coordinate4.x, (int)coordinate4.y);
            graphics.drawLine((int)coordinate.x, (int)coordinate.y, (int)coordinate2.x, (int)coordinate2.y);
            if (bl) {
                graphics.drawLine((int)coordinate2.x, (int)coordinate2.y, (int)coordinate3.x, (int)coordinate3.y);
            }
            ++n;
        }
    }

    public Color getColor(Coordinate coordinate, float f, float f2) {
        float f3 = f2 - coordinate.z;
        int n = (int)Math.abs(f3 / f);
        return new Color(n, n, n);
    }

    public ArrayList getMinMax(BlobArray blobArray) {
        ArrayList<Coordinate> arrayList = new ArrayList<Coordinate>(2);
        Coordinate coordinate = new Coordinate();
        Coordinate coordinate2 = new Coordinate();
        Coordinate coordinate3 = null;
        float f = 0.0f;
        float f2 = 0.0f;
        float f3 = 0.0f;
        float f4 = 0.0f;
        float f5 = 0.0f;
        float f6 = 0.0f;
        if (blobArray != null && blobArray.size() != 0) {
            Blob blob = blobArray.get(0);
            coordinate3 = blob.center;
            f = coordinate3.x;
            f2 = coordinate3.y;
            f3 = coordinate3.z;
            f4 = f;
            f5 = f2;
            f6 = f3;
            int n = 0;
            while (n < blobArray.size()) {
                blob = blobArray.get(n);
                coordinate3 = blob.center;
                if (coordinate3.x < f) {
                    f = coordinate3.x;
                }
                if (coordinate3.x > f4) {
                    f4 = coordinate3.x;
                }
                if (coordinate3.y < f2) {
                    f2 = coordinate3.y;
                }
                if (coordinate3.y > f5) {
                    f5 = coordinate3.y;
                }
                if (coordinate3.z < f3) {
                    f3 = coordinate3.z;
                }
                if (coordinate3.z > f6) {
                    f6 = coordinate3.z;
                }
                ++n;
            }
        }
        coordinate.set(f, f2, f3);
        coordinate2.set(f4, f5, f6);
        arrayList.add(coordinate);
        arrayList.add(coordinate2);
        return arrayList;
    }

    public void center(Rectangle rectangle) {
        float f;
        if (this.element == null) {
            return;
        }
        ArrayList arrayList = !this.isRami ? this.getMinMax((BlobArray)this.element) : this.getMinMax(this.makeBlobArrayFromDoubleArray(this.element));
        Coordinate coordinate = (Coordinate)arrayList.get(0);
        Coordinate coordinate2 = (Coordinate)arrayList.get(1);
        float f2 = Math.abs(coordinate2.x - coordinate.x);
        float f3 = Math.abs(coordinate2.y - coordinate.y);
        float f4 = rectangle.width - 60;
        float f5 = rectangle.height - 60;
        if (f2 > f3) {
            f = f4 / f2;
            if (f3 * f > f5) {
                f = f5 / f3;
            }
        } else {
            f = f5 / f3;
            if (f2 * f > f4) {
                f = f4 / f2;
            }
        }
        ((Transformable)this.element).translate(-coordinate.x, -coordinate.y, 0.0f);
        ((Transformable)this.element).translate(-f2 / 2.0f, -f3 / 2.0f, 0.0f);
        ((Transformable)this.element).scale(f);
        ((Transformable)this.element).translate(rectangle.width / 2, rectangle.height / 2, 0.0f);
    }
}

