/*
 * Decompiled with CFR 0.152.
 */
package povtree.gui;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.BevelBorder;
import javax.swing.border.EmptyBorder;
import povtree.examples.Birch;
import povtree.examples.Cherry;
import povtree.examples.Default;
import povtree.examples.Eucalyptus;
import povtree.examples.Linden;
import povtree.examples.Maple;
import povtree.examples.Olive;
import povtree.examples.Palm;
import povtree.examples.Pine;
import povtree.examples.Poplar;
import povtree.examples.Spruce;
import povtree.examples.Willow;
import povtree.gui.BarkPanel;
import povtree.gui.BlossomPanel;
import povtree.gui.BranchPanel;
import povtree.gui.BunchPanel;
import povtree.gui.Clipboard;
import povtree.gui.CustomFileChooser;
import povtree.gui.FoliagePanel;
import povtree.gui.Helper;
import povtree.gui.ImagePanel;
import povtree.gui.IncludeFilter;
import povtree.gui.PovtreeException;
import povtree.gui.PreviewPanel;
import povtree.gui.RamiPanel;
import povtree.gui.Resources;
import povtree.gui.RootPanel;
import povtree.gui.SwingWorker;
import povtree.gui.ToolBar;
import povtree.gui.TrunkPanel;
import povtree.gui.TwigPanel;
import povtree.gui.plaf.ButtonUI;
import povtree.gui.plaf.GradientPanel;
import povtree.gui.plaf.Label;
import povtree.gui.plaf.LabelUI;
import povtree.gui.plaf.PovtreeLookAndFeel;
import povtree.gui.plaf.ProgressBarUI;
import povtree.interfaces.Constants;
import povtree.interfaces.Generator;
import povtree.interfaces.Randomizer;
import povtree.objects.Bark;
import povtree.objects.Blossom;
import povtree.objects.Foliage;
import povtree.objects.Tree;
import povtree.objects3D.Tree3D;
import povtree.povTreeGenerator.Accuracy;
import povtree.povTreeGenerator.MeshGenerator;
import povtree.povTreeGenerator.Parser;
import povtree.povTreeGenerator.PovTreeGenerator;

public class PovTree
extends JFrame
implements Randomizer {
    public static PovTree frame = null;
    private Tree tree;
    private Tree3D tree3D;
    private String currentPath;
    private String currentFile;
    private JMenuBar menuBar;
    private static JPanel mainPanel = new JPanel();
    private JProgressBar progressBar = new JProgressBar();
    private JTextField name = new JTextField(20);
    private ImagePanel imagePanel = new ImagePanel();
    private JCheckBox hasRoot = null;
    private JCheckBox hasTrunk = null;
    private JCheckBox hasBranches = null;
    private JCheckBox hasTwigs = null;
    private JCheckBox hasBunch = null;
    private JCheckBox hasFoliage = null;
    private JCheckBox hasBlossom = null;
    private RootPanel rootPanel;
    private TrunkPanel trunkPanel;
    private BranchPanel branchPanel;
    private TwigPanel twigPanel;
    private RamiPanel ramiPanel;
    private BunchPanel bunchPanel;
    private BarkPanel barkPanel;
    private FoliagePanel foliagePanel;
    private BlossomPanel blossomPanel;
    private JFrame aboutFrame = null;
    private PreviewPanel previewPanel;
    private JButton previewButton = null;
    private JButton cancelButton = null;
    private static JPanel cardPanel = new JPanel(new CardLayout());
    private JPanel treePanel;
    private static String[] trees = new String[]{"Default", "Birch", "Cherry", "Eucalyptus", "Linden", "Maple", "Olive", "Palm", "Pine", "Poplar", "Spruce", "Willow"};
    private static String[] treesToolTip = new String[trees.length];
    private JToggleButton[] treeTB = new JToggleButton[trees.length];
    private JToggleButton invisibleTB = new JToggleButton();
    private ButtonGroup bg = new ButtonGroup();
    private static ResourceBundle labelsBundle = null;
    private static ResourceBundle messagesBundle = null;
    private boolean inPreview = false;
    private SwingWorker worker = null;
    private SwingWorker saver = null;
    private boolean inSaving = false;
    private static Font titleFont = new Font("Default", 1, 30);
    private static Font authorsFont = new Font("Default", 0, 12);
    private JMenu fileMenu = new JMenu(labelsBundle.getString("file"));
    private static JToggleButton previewToggleButton = null;

    public PovTree(String string) {
        super("POV-Tree");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
        });
        this.setIconImage(new ImageIcon(this.getClass().getResource("images/title.png")).getImage());
        this.makeMenus();
        this.rootPanel = new RootPanel(this, string);
        this.trunkPanel = new TrunkPanel(this, string);
        this.branchPanel = new BranchPanel(this, string);
        this.twigPanel = new TwigPanel(this, string);
        this.ramiPanel = new RamiPanel(this, string);
        this.bunchPanel = new BunchPanel(this, string);
        this.barkPanel = new BarkPanel(string);
        this.foliagePanel = new FoliagePanel(this, this.currentPath, string);
        this.blossomPanel = new BlossomPanel(this, string);
        this.previewButton = new JButton(labelsBundle.getString("previewButton"));
        this.cancelButton = new JButton(labelsBundle.getString("cancel"));
        this.cancelButton.addKeyListener(new KeyListener(){

            public void keyTyped(KeyEvent keyEvent) {
                if (keyEvent.getKeyChar() == '\u001b') {
                    PovTree.this.cancelAction();
                }
            }

            public void keyPressed(KeyEvent keyEvent) {
            }

            public void keyReleased(KeyEvent keyEvent) {
            }
        });
        this.previewPanel = new PreviewPanel(this);
        mainPanel.setLayout(new BorderLayout());
        this.previewButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PovTree.this.inPreview = true;
                PovTree.this.disableButtons();
                PovTree.this.setTreeInPreviewPanel();
            }
        });
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PovTree.this.cancelAction();
            }
        });
        this.hasRoot = new JCheckBox(labelsBundle.getString("roots"), true);
        this.hasTrunk = new JCheckBox(labelsBundle.getString("trunk"), true);
        this.hasBranches = new JCheckBox(labelsBundle.getString("branches"), true);
        this.hasTwigs = new JCheckBox(labelsBundle.getString("twigs"), true);
        this.hasBunch = new JCheckBox(labelsBundle.getString("ramification"), true);
        this.hasFoliage = new JCheckBox(labelsBundle.getString("foliage"), true);
        this.hasBlossom = new JCheckBox(labelsBundle.getString("blossom"), true);
        this.treePanel = this.makeTreePanel();
        BevelBorder bevelBorder = new BevelBorder(0, Helper.getLighter(this.previewButton.getBackground(), 40), Helper.getLighter(this.previewButton.getBackground(), 40), this.previewButton.getBackground().darker().darker(), this.previewButton.getBackground().darker().darker());
        EmptyBorder emptyBorder = new EmptyBorder(7, 7, 7, 7);
        this.treePanel.setBorder(BorderFactory.createCompoundBorder(bevelBorder, emptyBorder));
        this.rootPanel.setBorder(BorderFactory.createCompoundBorder(bevelBorder, emptyBorder));
        this.trunkPanel.setBorder(BorderFactory.createCompoundBorder(bevelBorder, emptyBorder));
        this.branchPanel.setBorder(BorderFactory.createCompoundBorder(bevelBorder, emptyBorder));
        this.twigPanel.setBorder(BorderFactory.createCompoundBorder(bevelBorder, emptyBorder));
        this.ramiPanel.setBorder(BorderFactory.createCompoundBorder(bevelBorder, emptyBorder));
        this.bunchPanel.setBorder(BorderFactory.createCompoundBorder(bevelBorder, emptyBorder));
        this.barkPanel.setBorder(BorderFactory.createCompoundBorder(bevelBorder, emptyBorder));
        this.foliagePanel.setBorder(BorderFactory.createCompoundBorder(bevelBorder, emptyBorder));
        this.blossomPanel.setBorder(BorderFactory.createCompoundBorder(bevelBorder, emptyBorder));
        cardPanel.add((Component)this.treePanel, "Tree");
        cardPanel.add((Component)this.rootPanel, "Root");
        cardPanel.add((Component)this.trunkPanel, "Trunk");
        cardPanel.add((Component)this.branchPanel, "Branch");
        cardPanel.add((Component)this.twigPanel, "Twig");
        cardPanel.add((Component)this.ramiPanel, "Rami");
        cardPanel.add((Component)this.bunchPanel, "Bunch");
        cardPanel.add((Component)this.barkPanel, "Bark");
        cardPanel.add((Component)this.foliagePanel, "Foliage");
        cardPanel.add((Component)this.blossomPanel, "Blossom");
        cardPanel.add((Component)this.previewPanel.getPreviewRootPanel(), "Preview");
        mainPanel.add((Component)cardPanel, "Center");
        mainPanel.add((Component)this.makeStatusBar(), "South");
        this.setTree(new Default(labelsBundle.getString("default")));
        this.treeTB[0].setSelected(true);
    }

    public void cancelAction() {
        if (this.inPreview && this.worker != null) {
            this.worker.interrupt();
            this.inPreview = false;
        }
        this.previewPanel.cancelStatistics();
        if (this.inSaving && this.saver != null) {
            this.saver.interrupt();
            this.inSaving = false;
        }
        this.enableButtons();
    }

    public JPanel makeStatusBar() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(new EmptyBorder(4, 4, 4, 4));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        gridBagConstraints.fill = 2;
        this.progressBar.setUI(new ProgressBarUI());
        this.progressBar.setMaximum(100);
        this.progressBar.setStringPainted(true);
        this.progressBar.setString("");
        Dimension dimension = this.progressBar.getPreferredSize();
        this.progressBar.setPreferredSize(new Dimension(dimension.width, (int)this.previewButton.getPreferredSize().getHeight()));
        gridBagConstraints.weightx = 0.8;
        jPanel.add((Component)this.progressBar, gridBagConstraints);
        ++gridBagConstraints.gridx;
        this.previewButton.setUI(new ButtonUI());
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.insets = new Insets(4, 0, 4, 0);
        jPanel.add((Component)this.previewButton, gridBagConstraints);
        ++gridBagConstraints.gridx;
        this.cancelButton.setUI(new ButtonUI());
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        jPanel.add((Component)this.cancelButton, gridBagConstraints);
        jPanel.setBorder(new BevelBorder(0, Helper.getLighter(jPanel.getBackground(), 40), Helper.getLighter(jPanel.getBackground(), 40), jPanel.getBackground().darker().darker(), jPanel.getBackground().darker().darker()));
        return jPanel;
    }

    public void makeMenus() {
        this.menuBar = new JMenuBar();
        this.menuBar.setOpaque(true);
        this.menuBar.add(this.makeFileMenu());
        this.menuBar.add(this.makeEditMenu());
        this.menuBar.add(this.makeHelpMenu());
        this.setJMenuBar(this.menuBar);
    }

    public JMenu makeEditMenu() {
        Clipboard clipboard = new Clipboard(labelsBundle, this);
        return clipboard.makeEditMenu();
    }

    public JMenu makeFileMenu() {
        this.fileMenu.setMnemonic(70);
        JMenuItem jMenuItem = new JMenuItem(labelsBundle.getString("load"));
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(79, 2));
        JMenuItem jMenuItem2 = new JMenuItem(labelsBundle.getString("save"));
        jMenuItem2.setAccelerator(KeyStroke.getKeyStroke(83, 2));
        JMenuItem jMenuItem3 = new JMenuItem(labelsBundle.getString("saveAs"));
        JMenu jMenu = new JMenu(labelsBundle.getString("export"));
        JMenuItem jMenuItem4 = new JMenuItem("POV-Ray mesh");
        jMenuItem4.setAccelerator(KeyStroke.getKeyStroke(80, 2));
        JMenuItem jMenuItem5 = new JMenuItem("POV-Ray mesh2");
        jMenuItem5.setEnabled(false);
        jMenuItem5.setAccelerator(KeyStroke.getKeyStroke(77, 2));
        JMenuItem jMenuItem6 = new JMenuItem("Wavefront OBJ");
        jMenuItem6.setEnabled(false);
        jMenuItem6.setAccelerator(KeyStroke.getKeyStroke(87, 2));
        JMenuItem jMenuItem7 = new JMenuItem(labelsBundle.getString("quit"));
        jMenuItem7.setAccelerator(KeyStroke.getKeyStroke(81, 2));
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PovTree.this.load();
            }
        });
        jMenuItem2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PovTree.this.saveFile();
            }
        });
        jMenuItem3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PovTree.this.saveAsFile();
            }
        });
        jMenuItem4.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PovTree.this.inSaving = true;
                PovTree.this.disableButtons();
                PovTree.this.saveMesh(0);
            }
        });
        jMenuItem5.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PovTree.this.inSaving = true;
                PovTree.this.disableButtons();
                PovTree.this.saveMesh(1);
            }
        });
        jMenuItem6.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PovTree.this.inSaving = true;
                PovTree.this.disableButtons();
                PovTree.this.saveMesh(2);
            }
        });
        jMenuItem7.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (PovTree.this.worker != null) {
                    PovTree.this.worker.interrupt();
                }
                PovTree.this.previewPanel.interruptStatistics();
                if (PovTree.this.saver != null) {
                    PovTree.this.saver.interrupt();
                }
                System.exit(0);
            }
        });
        this.fileMenu.add(jMenuItem);
        this.fileMenu.add(jMenuItem2);
        this.fileMenu.add(jMenuItem3);
        jMenu.add(jMenuItem4);
        jMenu.add(jMenuItem5);
        jMenu.add(jMenuItem6);
        this.fileMenu.add(jMenu);
        this.fileMenu.addSeparator();
        this.fileMenu.add(jMenuItem7);
        return this.fileMenu;
    }

    public JPanel makeExamplesPanel() {
        Object object;
        GradientPanel gradientPanel = new GradientPanel(15, 15);
        gradientPanel.setLayout(new GridLayout(4, 3, 0, 0));
        gradientPanel.setGradientDirection(2);
        gradientPanel.setRound(1);
        gradientPanel.setOpaque(false);
        int n = 0;
        while (n < this.treeTB.length) {
            this.treeTB[n] = new JToggleButton(new ImageIcon(this.getClass().getResource("images/" + trees[n] + ".png")));
            object = trees[n];
            this.treeTB[n].addActionListener(new ActionListener((String)object){
                private final /* synthetic */ String val$str;
                {
                    this.val$str = string;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    PovTree.this.currentFile = null;
                    PovTree.this.setFrameTitle("POV-Tree");
                    if (this.val$str.equals("Default")) {
                        PovTree.this.setTree(new Default(labelsBundle.getString("default")));
                    } else if (this.val$str.equals("Birch")) {
                        PovTree.this.setTree(new Birch(labelsBundle.getString("birch")));
                    } else if (this.val$str.equals("Cherry")) {
                        PovTree.this.setTree(new Cherry(labelsBundle.getString("cherry")));
                    } else if (this.val$str.equals("Eucalyptus")) {
                        PovTree.this.setTree(new Eucalyptus(labelsBundle.getString("eucalyptus")));
                    } else if (this.val$str.equals("Linden")) {
                        PovTree.this.setTree(new Linden(labelsBundle.getString("linden")));
                    } else if (this.val$str.equals("Maple")) {
                        PovTree.this.setTree(new Maple(labelsBundle.getString("maple")));
                    } else if (this.val$str.equals("Olive")) {
                        PovTree.this.setTree(new Olive(labelsBundle.getString("olive")));
                    } else if (this.val$str.equals("Palm")) {
                        PovTree.this.setTree(new Palm(labelsBundle.getString("palm")));
                    } else if (this.val$str.equals("Pine")) {
                        PovTree.this.setTree(new Pine(labelsBundle.getString("pine")));
                    } else if (this.val$str.equals("Poplar")) {
                        PovTree.this.setTree(new Poplar(labelsBundle.getString("poplar")));
                    } else if (this.val$str.equals("Spruce")) {
                        PovTree.this.setTree(new Spruce(labelsBundle.getString("spruce")));
                    } else if (this.val$str.equals("Willow")) {
                        PovTree.this.setTree(new Willow(labelsBundle.getString("willow")));
                    }
                    PovTree.this.previewPanel.clearStatistics();
                }
            });
            this.bg.add(this.treeTB[n]);
            this.treeTB[n].setToolTipText(treesToolTip[n]);
            gradientPanel.add(this.treeTB[n]);
            ++n;
        }
        this.bg.add(this.invisibleTB);
        object = new JPanel(new BorderLayout());
        ((JComponent)object).setOpaque(false);
        gradientPanel.setBorder(new EmptyBorder(10, 10, 10, 10));
        ((Container)object).add((Component)gradientPanel, "Center");
        GradientPanel gradientPanel2 = new GradientPanel(40, 20);
        gradientPanel2.setLayout(new GridBagLayout());
        gradientPanel2.setGradientDirection(2);
        gradientPanel2.setRound(0);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        JLabel jLabel = new JLabel(labelsBundle.getString("treeExamples"));
        jLabel.setFont((Font)UIManager.get("TitledBorder.font"));
        jLabel.setForeground(Color.black);
        gradientPanel2.add((Component)jLabel, gridBagConstraints);
        ((Container)object).add((Component)gradientPanel2, "North");
        return object;
    }

    public JMenu makeHelpMenu() {
        JMenu jMenu = new JMenu(labelsBundle.getString("help"));
        jMenu.setMnemonic(72);
        JMenuItem jMenuItem = new JMenuItem(labelsBundle.getString("about"));
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PovTree.this.showAbout();
            }
        });
        jMenu.add(jMenuItem);
        return jMenu;
    }

    public void showAbout() {
        if (this.aboutFrame != null) {
            this.aboutFrame.setVisible(true);
            return;
        }
        this.aboutFrame = new JFrame();
        JPanel jPanel = new JPanel(new BorderLayout());
        this.aboutFrame.setTitle(labelsBundle.getString("about"));
        this.aboutFrame.setDefaultCloseOperation(1);
        this.aboutFrame.setIconImage(new ImageIcon(this.getClass().getResource("images/title.png")).getImage());
        this.aboutFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                PovTree.this.aboutFrame = null;
            }
        });
        Container container = this.aboutFrame.getContentPane();
        ImageIcon imageIcon = new ImageIcon(this.getClass().getResource("images/tree.png"));
        jPanel.add((Component)new JLabel(imageIcon), "Center");
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 1;
        Label label = new Label("POV-Tree 1.5", 0, Helper.getDarker(jPanel.getBackground(), 100));
        label.setFont(titleFont);
        jPanel2.add((Component)label, gridBagConstraints);
        JPanel jPanel3 = new JPanel(new GridBagLayout());
        jPanel3.setBorder(new EmptyBorder(10, 10, 10, 10));
        Label label2 = new Label("Tom Aust - Tree Algorithm", 0, Helper.getDarker(jPanel.getBackground(), 120));
        Label label3 = new Label("Gena Obukhov - Java Programming", 0, Helper.getDarker(jPanel.getBackground(), 120));
        label2.setFont(authorsFont);
        label3.setFont(authorsFont);
        jPanel3.add((Component)label2, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        jPanel3.add((Component)label3, gridBagConstraints);
        jPanel.add((Component)jPanel2, "North");
        jPanel.add((Component)new JLabel(imageIcon), "Center");
        jPanel.add((Component)jPanel3, "South");
        container.add(jPanel);
        this.aboutFrame.pack();
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        int n = jPanel.getPreferredSize().width + 70;
        int n2 = this.aboutFrame.getPreferredSize().height + 10;
        this.aboutFrame.setBounds(dimension.width / 2 - n / 2, dimension.height / 2 - n2 / 2, n, n2);
        this.aboutFrame.setVisible(true);
    }

    public void setFrameTitle(String string) {
        this.setTitle(string);
    }

    public RootPanel getRootPanel() {
        return this.rootPanel;
    }

    public TrunkPanel getTrunkPanel() {
        return this.trunkPanel;
    }

    public BranchPanel getBranchPanel() {
        return this.branchPanel;
    }

    public TwigPanel getTwigPanel() {
        return this.twigPanel;
    }

    public RamiPanel getRamiPanel() {
        return this.ramiPanel;
    }

    public BunchPanel getBunchPanel() {
        return this.bunchPanel;
    }

    public BarkPanel getBarkPanel() {
        return this.barkPanel;
    }

    public FoliagePanel getFoliagePanel() {
        return this.foliagePanel;
    }

    public BlossomPanel getBlossomPanel() {
        return this.blossomPanel;
    }

    public JPanel getCardPanel() {
        return cardPanel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void load() {
        String string;
        String string2;
        block16: {
            BufferedReader bufferedReader;
            FileInputStream fileInputStream;
            block15: {
                string2 = null;
                string = null;
                fileInputStream = null;
                bufferedReader = null;
                if (this.currentPath == null) {
                    this.currentPath = ".";
                }
                JFileChooser jFileChooser = new JFileChooser(this.currentPath);
                jFileChooser.addChoosableFileFilter(new IncludeFilter());
                jFileChooser.setDialogTitle(labelsBundle.getString("load"));
                Helper.tuneFileChooser(jFileChooser);
                int n = jFileChooser.showOpenDialog(this);
                if (n != 0) break block15;
                File file = jFileChooser.getSelectedFile();
                int n2 = (int)file.length();
                string = file.getName();
                this.currentPath = file.getParent();
                fileInputStream = new FileInputStream(file);
                char[] cArray = new char[n2];
                bufferedReader = new BufferedReader(new InputStreamReader((InputStream)fileInputStream, "UTF-8"));
                bufferedReader.read(cArray, 0, n2);
                string2 = new String(cArray);
            }
            Object var11_15 = null;
            try {
                fileInputStream.close();
                bufferedReader.close();
            }
            catch (Exception exception) {}
            break block16;
            {
                catch (FileNotFoundException fileNotFoundException) {
                    JOptionPane.showMessageDialog(this, messagesBundle.getString("fileNotFound"), labelsBundle.getString("error"), 0);
                    Object var11_16 = null;
                    try {
                        fileInputStream.close();
                        bufferedReader.close();
                    }
                    catch (Exception exception) {}
                    break block16;
                }
                catch (IOException iOException) {
                    JOptionPane.showMessageDialog(this, messagesBundle.getString("cannotLoadFile"), labelsBundle.getString("error"), 0);
                    Object var11_17 = null;
                    try {
                        fileInputStream.close();
                        bufferedReader.close();
                    }
                    catch (Exception exception) {}
                }
            }
            catch (Throwable throwable) {
                Object var11_18 = null;
                try {
                    fileInputStream.close();
                    bufferedReader.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        if (string2 != null) {
            this.currentFile = new String(string);
            int n = string.lastIndexOf(".");
            if (n != -1) {
                string = string.substring(0, n);
            }
            try {
                Parser parser = new Parser(string2, string);
                this.invisibleTB.setSelected(true);
                this.setTree(parser.getTree());
                this.setFrameTitle("POV-Tree  " + this.currentFile);
            }
            catch (Exception exception) {
                JOptionPane.showMessageDialog(this, messagesBundle.getString("invalidFileFormat"), labelsBundle.getString("error"), 0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void saveFile() {
        block13: {
            this.tree = this.getTree();
            FileOutputStream fileOutputStream = null;
            if (this.tree != null && this.currentFile != null) {
                if (this.currentPath == null) {
                    this.currentPath = ".";
                }
                this.setCursor(Cursor.getPredefinedCursor(3));
                String string = this.tree.toString();
                File file = new File(this.currentPath + File.separator + this.currentFile);
                fileOutputStream = new FileOutputStream(file);
                byte[] byArray = string.getBytes();
                fileOutputStream.write(byArray);
                Object var6_7 = null;
                try {
                    fileOutputStream.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.setCursor(Cursor.getPredefinedCursor(0));
                {
                    break block13;
                    catch (FileNotFoundException fileNotFoundException) {
                        JOptionPane.showMessageDialog(this, messagesBundle.getString("fileNotFound"), labelsBundle.getString("error"), 0);
                        Object var6_8 = null;
                        try {
                            fileOutputStream.close();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        this.setCursor(Cursor.getPredefinedCursor(0));
                        break block13;
                    }
                    catch (IOException iOException) {
                        JOptionPane.showMessageDialog(this, messagesBundle.getString("cannotSaveFile"), labelsBundle.getString("error"), 0);
                        Object var6_9 = null;
                        try {
                            fileOutputStream.close();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        this.setCursor(Cursor.getPredefinedCursor(0));
                    }
                }
                catch (Throwable throwable) {
                    Object var6_10 = null;
                    try {
                        fileOutputStream.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    this.setCursor(Cursor.getPredefinedCursor(0));
                    throw throwable;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void saveAsFile() {
        block14: {
            this.tree = this.getTree();
            FileOutputStream fileOutputStream = null;
            BufferedWriter bufferedWriter = null;
            if (this.tree != null) {
                block12: {
                    if (this.currentPath == null) {
                        this.currentPath = ".";
                    }
                    CustomFileChooser customFileChooser = new CustomFileChooser(this.currentPath, messagesBundle);
                    Helper.tuneFileChooser(customFileChooser);
                    customFileChooser.addChoosableFileFilter(new IncludeFilter());
                    customFileChooser.setDialogTitle(labelsBundle.getString("saveAs"));
                    int n = customFileChooser.showSaveDialog(this);
                    if (n != 0) break block12;
                    this.setCursor(Cursor.getPredefinedCursor(3));
                    String string = this.tree.toString();
                    File file = customFileChooser.getSelectedFile();
                    this.currentPath = file.getParent();
                    fileOutputStream = new FileOutputStream(file);
                    bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)fileOutputStream, "UTF-8"));
                    bufferedWriter.write(string, 0, string.length());
                    bufferedWriter.flush();
                    this.currentFile = new String(file.getName());
                    this.setFrameTitle("POV-Tree  " + this.currentFile);
                }
                Object var8_9 = null;
                try {
                    fileOutputStream.close();
                    bufferedWriter.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.setCursor(Cursor.getPredefinedCursor(0));
                {
                    break block14;
                    catch (FileNotFoundException fileNotFoundException) {
                        JOptionPane.showMessageDialog(this, messagesBundle.getString("fileNotFound"), labelsBundle.getString("error"), 0);
                        Object var8_10 = null;
                        try {
                            fileOutputStream.close();
                            bufferedWriter.close();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        this.setCursor(Cursor.getPredefinedCursor(0));
                        break block14;
                    }
                    catch (IOException iOException) {
                        JOptionPane.showMessageDialog(this, messagesBundle.getString("cannotSaveFile"), labelsBundle.getString("error"), 0);
                        Object var8_11 = null;
                        try {
                            fileOutputStream.close();
                            bufferedWriter.close();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        this.setCursor(Cursor.getPredefinedCursor(0));
                    }
                }
                catch (Throwable throwable) {
                    Object var8_12 = null;
                    try {
                        fileOutputStream.close();
                        bufferedWriter.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    this.setCursor(Cursor.getPredefinedCursor(0));
                    throw throwable;
                }
            }
        }
    }

    public void enableButtons() {
        this.previewPanel.enableStatisticsButton();
        this.previewButton.setEnabled(true);
        this.fileMenu.setEnabled(true);
    }

    public void disableButtons() {
        this.previewPanel.disableStatisticsButton();
        this.previewButton.setEnabled(false);
        this.fileMenu.setEnabled(false);
    }

    public void saveMesh(final int n) {
        this.tree = this.getTree();
        if (this.tree != null) {
            Foliage foliage = this.tree.getFoliage();
            boolean bl = this.tree.getFoliageFlag();
            if (bl && foliage != null && foliage.type != null && !foliage.type.startsWith("LeafUv") && !foliage.type.startsWith("Mesh") && !foliage.type.startsWith("Custom")) {
                this.enableButtons();
                JOptionPane.showMessageDialog(this, messagesBundle.getString("selectMeshLeafType"), labelsBundle.getString("error"), 0);
                return;
            }
            Blossom blossom = this.tree.getBlossom();
            boolean bl2 = this.tree.getBlossomFlag();
            if (bl2 && blossom != null && blossom.name != null && !blossom.name.startsWith("BlossomMesh") && !blossom.name.startsWith("CustomMeshBlossom")) {
                this.enableButtons();
                JOptionPane.showMessageDialog(this, messagesBundle.getString("selectMeshBlossomType"), labelsBundle.getString("error"), 0);
                return;
            }
            try {
                if (this.currentPath == null) {
                    this.currentPath = ".";
                }
                CustomFileChooser customFileChooser = new CustomFileChooser(this.currentPath, messagesBundle);
                Helper.tuneFileChooser(customFileChooser);
                customFileChooser.addChoosableFileFilter(new IncludeFilter());
                customFileChooser.setDialogTitle(labelsBundle.getString("export"));
                int n2 = customFileChooser.showSaveDialog(this);
                if (n2 == 0) {
                    File file = customFileChooser.getSelectedFile();
                    this.currentPath = file.getParent();
                    final FileOutputStream fileOutputStream = new FileOutputStream(file);
                    final BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream, 512);
                    this.tree3D = this.previewPanel.getTree3D();
                    final Bark bark = this.tree.getBark();
                    this.saver = new SwingWorker(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public Object construct() {
                            block19: {
                                Generator generator = null;
                                if (PovTree.this.tree3D != null) {
                                    block18: {
                                        try {
                                            try {
                                                PovTree.this.tree3D.unitScale();
                                                Accuracy accuracy = PovTree.this.getAccuracy();
                                                if (n == 0) {
                                                    generator = new MeshGenerator(PovTree.this.tree, PovTree.this.tree3D, bufferedOutputStream, accuracy, bark.imageType, bark.imageName, bark.bumpType, bark.bumpName, bark.bumpSize, false, frame);
                                                }
                                                generator.generateMesh();
                                            }
                                            catch (InterruptedException interruptedException) {
                                                PovTree.this.updateStatus(0, null);
                                                this.cleanUpResources();
                                                Object var7_6 = null;
                                                this.cleanUpResources();
                                                break block18;
                                            }
                                            catch (PovtreeException povtreeException) {
                                                PovTree.this.updateStatus(0, null);
                                                this.cleanUpResources();
                                                JOptionPane.showMessageDialog(PovTree.this, povtreeException.getMessage(), labelsBundle.getString("error"), 0);
                                                Object var7_7 = null;
                                                this.cleanUpResources();
                                                break block18;
                                            }
                                            catch (IOException iOException) {
                                                PovTree.this.updateStatus(0, null);
                                                this.cleanUpResources();
                                                JOptionPane.showMessageDialog(PovTree.this, messagesBundle.getString("cannotSaveFile"), labelsBundle.getString("error"), 0);
                                                Object var7_8 = null;
                                                this.cleanUpResources();
                                                break block18;
                                            }
                                            catch (NumberFormatException numberFormatException) {
                                                PovTree.this.updateStatus(0, null);
                                                this.cleanUpResources();
                                                JOptionPane.showMessageDialog(PovTree.this, messagesBundle.getString("invalidNumber") + " " + numberFormatException.getMessage(), labelsBundle.getString("error"), 0);
                                                Object var7_9 = null;
                                                this.cleanUpResources();
                                            }
                                            Object var7_5 = null;
                                            this.cleanUpResources();
                                        }
                                        catch (Throwable throwable) {
                                            Object var7_10 = null;
                                            this.cleanUpResources();
                                            throw throwable;
                                        }
                                    }
                                    PovTree.this.tree3D.center();
                                    PovTree.this.previewPanel.repaint();
                                } else {
                                    PovTreeGenerator povTreeGenerator = new PovTreeGenerator();
                                    try {
                                        try {
                                            Tree3D tree3D = povTreeGenerator.makePreviewTree(PovTree.this.tree, true, true, frame);
                                            tree3D.unitScale();
                                            Accuracy accuracy = PovTree.this.getAccuracy();
                                            if (n == 0) {
                                                generator = new MeshGenerator(PovTree.this.tree, tree3D, bufferedOutputStream, accuracy, bark.imageType, bark.imageName, bark.bumpType, bark.bumpName, bark.bumpSize, false, frame);
                                            }
                                            generator.generateMesh();
                                            tree3D = null;
                                        }
                                        catch (InterruptedException interruptedException) {
                                            PovTree.this.updateStatus(0, null);
                                            this.cleanUpResources();
                                            Object var9_22 = null;
                                            this.cleanUpResources();
                                            break block19;
                                        }
                                        catch (PovtreeException povtreeException) {
                                            PovTree.this.updateStatus(0, null);
                                            this.cleanUpResources();
                                            JOptionPane.showMessageDialog(PovTree.this, povtreeException.getMessage(), labelsBundle.getString("error"), 0);
                                            Object var9_23 = null;
                                            this.cleanUpResources();
                                            break block19;
                                        }
                                        catch (IOException iOException) {
                                            PovTree.this.updateStatus(0, null);
                                            this.cleanUpResources();
                                            JOptionPane.showMessageDialog(PovTree.this, messagesBundle.getString("cannotSaveFile"), labelsBundle.getString("error"), 0);
                                            Object var9_24 = null;
                                            this.cleanUpResources();
                                            break block19;
                                        }
                                        catch (NumberFormatException numberFormatException) {
                                            PovTree.this.updateStatus(0, null);
                                            this.cleanUpResources();
                                            JOptionPane.showMessageDialog(PovTree.this, messagesBundle.getString("invalidNumber") + " " + numberFormatException.getMessage(), labelsBundle.getString("error"), 0);
                                            Object var9_25 = null;
                                            this.cleanUpResources();
                                        }
                                        Object var9_21 = null;
                                        this.cleanUpResources();
                                    }
                                    catch (Throwable throwable) {
                                        Object var9_26 = null;
                                        this.cleanUpResources();
                                        throw throwable;
                                    }
                                }
                            }
                            return null;
                        }

                        public void finished() {
                            PovTree.this.inSaving = false;
                            PovTree.this.enableButtons();
                        }

                        public void cleanUpResources() {
                            try {
                                if (fileOutputStream != null) {
                                    fileOutputStream.close();
                                }
                                if (bufferedOutputStream != null) {
                                    bufferedOutputStream.close();
                                }
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    };
                    this.saver.start();
                } else {
                    this.inSaving = false;
                    this.enableButtons();
                }
            }
            catch (NumberFormatException numberFormatException) {
                JOptionPane.showMessageDialog(this, messagesBundle.getString("invalidNumber") + " " + numberFormatException.getMessage(), labelsBundle.getString("error"), 0);
            }
            catch (FileNotFoundException fileNotFoundException) {
                JOptionPane.showMessageDialog(this, messagesBundle.getString("fileNotFound"), labelsBundle.getString("error"), 0);
            }
        }
    }

    public JPanel makeTreePanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        JPanel jPanel2 = new JPanel(new BorderLayout());
        JPanel jPanel3 = new JPanel(new GridBagLayout());
        gridBagConstraints.fill = 2;
        JLabel jLabel = new JLabel(labelsBundle.getString("treeName"));
        LabelUI labelUI = new LabelUI();
        labelUI.setIsUnderlinable(false);
        jLabel.setUI(labelUI);
        gridBagConstraints.insets = new Insets(0, 0, 6, 0);
        jPanel3.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 1;
        jPanel3.add((Component)this.name, gridBagConstraints);
        jPanel2.add((Component)jPanel3, "North");
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        jPanel3 = new JPanel(new GridBagLayout());
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 1;
        this.hasRoot.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (PovTree.this.hasRoot.isSelected()) {
                    PovTree.this.imagePanel.addRoots();
                } else {
                    PovTree.this.imagePanel.removeRoots();
                }
            }
        });
        jPanel3.add((Component)this.hasRoot, gridBagConstraints);
        ++gridBagConstraints.gridy;
        this.hasTrunk.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (PovTree.this.hasTrunk.isSelected()) {
                    PovTree.this.imagePanel.addTrunk();
                } else {
                    PovTree.this.imagePanel.removeTrunk();
                }
            }
        });
        jPanel3.add((Component)this.hasTrunk, gridBagConstraints);
        ++gridBagConstraints.gridy;
        this.hasBranches.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (PovTree.this.hasBranches.isSelected()) {
                    PovTree.this.imagePanel.addBranches();
                } else {
                    PovTree.this.imagePanel.removeBranches();
                }
            }
        });
        jPanel3.add((Component)this.hasBranches, gridBagConstraints);
        ++gridBagConstraints.gridy;
        this.hasTwigs.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (PovTree.this.hasTwigs.isSelected()) {
                    PovTree.this.imagePanel.addTwigs();
                } else {
                    PovTree.this.imagePanel.removeTwigs();
                }
            }
        });
        jPanel3.add((Component)this.hasTwigs, gridBagConstraints);
        ++gridBagConstraints.gridy;
        this.hasBunch.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (PovTree.this.hasBunch.isSelected()) {
                    PovTree.this.imagePanel.addRami();
                } else {
                    PovTree.this.imagePanel.removeRami();
                }
            }
        });
        jPanel3.add((Component)this.hasBunch, gridBagConstraints);
        ++gridBagConstraints.gridy;
        this.hasFoliage.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (PovTree.this.hasFoliage.isSelected()) {
                    PovTree.this.imagePanel.addFoliage();
                } else {
                    PovTree.this.imagePanel.removeFoliage();
                }
            }
        });
        jPanel3.add((Component)this.hasFoliage, gridBagConstraints);
        ++gridBagConstraints.gridy;
        this.hasBlossom.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (PovTree.this.hasBlossom.isSelected()) {
                    PovTree.this.imagePanel.addBlossom();
                } else {
                    PovTree.this.imagePanel.removeBlossom();
                }
            }
        });
        jPanel3.add((Component)this.hasBlossom, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 7;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 1;
        jPanel3.setBorder(new BevelBorder(1, Helper.getLighter(jPanel3.getBackground(), 40), Helper.getLighter(jPanel3.getBackground(), 40), jPanel3.getBackground().darker().darker(), jPanel3.getBackground().darker().darker()));
        jPanel3.add((Component)this.imagePanel, gridBagConstraints);
        jPanel2.add((Component)jPanel3, "Center");
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.weightx = 0.2;
        gridBagConstraints.fill = 1;
        jPanel.add((Component)jPanel2, gridBagConstraints);
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.8;
        gridBagConstraints.insets = new Insets(0, 6, 0, 0);
        jPanel.add((Component)this.makeExamplesPanel(), gridBagConstraints);
        return jPanel;
    }

    public void setTree(Tree tree) {
        this.tree = tree;
        this.name.setText(this.tree.getName());
        if (this.tree.getRootFlag()) {
            this.hasRoot.setSelected(true);
            this.imagePanel.addRoots();
        } else {
            this.hasRoot.setSelected(false);
            this.imagePanel.removeRoots();
        }
        if (this.tree.getTrunkFlag()) {
            this.hasTrunk.setSelected(true);
            this.imagePanel.addTrunk();
        } else {
            this.hasTrunk.setSelected(false);
            this.imagePanel.removeTrunk();
        }
        if (this.tree.getBranchesFlag()) {
            this.hasBranches.setSelected(true);
            this.imagePanel.addBranches();
        } else {
            this.hasBranches.setSelected(false);
            this.imagePanel.removeBranches();
        }
        if (this.tree.getTwigsFlag()) {
            this.hasTwigs.setSelected(true);
            this.imagePanel.addTwigs();
        } else {
            this.hasTwigs.setSelected(false);
            this.imagePanel.removeTwigs();
        }
        if (this.tree.getRamiFlag()) {
            this.hasBunch.setSelected(true);
            this.imagePanel.addRami();
        } else {
            this.hasBunch.setSelected(false);
            this.imagePanel.removeRami();
        }
        if (this.tree.getFoliageFlag()) {
            this.hasFoliage.setSelected(true);
            this.imagePanel.addFoliage();
        } else {
            this.hasFoliage.setSelected(false);
            this.imagePanel.removeFoliage();
        }
        if (this.tree.getBlossomFlag()) {
            this.hasBlossom.setSelected(true);
            this.imagePanel.addBlossom();
        } else {
            this.hasBlossom.setSelected(false);
            this.imagePanel.removeBlossom();
        }
        this.validate();
        SwingWorker swingWorker = new SwingWorker(){

            public Object construct() {
                PovTree.this.rootPanel.setRoot(PovTree.this.tree.getRoot());
                PovTree.this.trunkPanel.setTrunk(PovTree.this.tree.getTrunk());
                PovTree.this.branchPanel.setBranch(PovTree.this.tree.getBranch());
                PovTree.this.twigPanel.setTwig(PovTree.this.tree.getTwig());
                PovTree.this.bunchPanel.setBunch(PovTree.this.tree.getBunch());
                PovTree.this.barkPanel.setBark(PovTree.this.tree.getBark());
                PovTree.this.ramiPanel.setRami(PovTree.this.tree.getRami());
                PovTree.this.blossomPanel.setBlossom(PovTree.this.tree.getBlossom());
                PovTree.this.foliagePanel.setFoliage(PovTree.this.tree.getFoliage());
                return null;
            }
        };
        swingWorker.start();
    }

    public Tree getTree() {
        if (this.tree == null) {
            return null;
        }
        this.tree.setName(new String(this.name.getText()));
        if (this.hasRoot.isSelected()) {
            this.tree.setRootFlag(true);
        } else {
            this.tree.setRootFlag(false);
        }
        if (this.hasTrunk.isSelected()) {
            this.tree.setTrunkFlag(true);
        } else {
            this.tree.setTrunkFlag(false);
        }
        if (this.hasBranches.isSelected()) {
            this.tree.setBranchesFlag(true);
        } else {
            this.tree.setBranchesFlag(false);
        }
        if (this.hasTwigs.isSelected()) {
            this.tree.setTwigsFlag(true);
        } else {
            this.tree.setTwigsFlag(false);
        }
        if (this.hasBunch.isSelected()) {
            this.tree.setRamiFlag(true);
        } else {
            this.tree.setRamiFlag(false);
        }
        if (this.hasFoliage.isSelected()) {
            this.tree.setFoliageFlag(true);
        } else {
            this.tree.setFoliageFlag(false);
        }
        if (this.hasBlossom.isSelected()) {
            this.tree.setBlossomFlag(true);
        } else {
            this.tree.setBlossomFlag(false);
        }
        this.tree.setRoot(this.rootPanel.getRoot());
        this.tree.setTrunk(this.trunkPanel.getTrunk());
        this.tree.setBranch(this.branchPanel.getBranch());
        this.tree.setTwig(this.twigPanel.getTwig());
        this.tree.setRami(this.ramiPanel.getRami());
        this.tree.setBunch(this.bunchPanel.getBunch());
        this.tree.setBark(this.barkPanel.getBark());
        this.tree.setFoliage(this.foliagePanel.getFoliage());
        this.tree.setBlossom(this.blossomPanel.getBlossom());
        return this.tree;
    }

    public Tree3D calculateTreeModel() {
        try {
            Tree tree = this.getTree();
            if (tree == null) {
                return null;
            }
            PovTreeGenerator povTreeGenerator = new PovTreeGenerator();
            boolean bl = false;
            boolean bl2 = false;
            bl = !tree.getFoliageFlag() || tree.getFoliage() == null || tree.getFoliage() != null && tree.getFoliage().type != null && !tree.getFoliage().type.startsWith("Mesh") ? tree.getFoliage() != null && tree.getFoliage().type != null && tree.getFoliage().type.startsWith("Custom") : true;
            bl2 = !tree.getBlossomFlag() || tree.getBlossom() == null || tree.getBlossom() != null && tree.getBlossom().name != null && !tree.getBlossom().name.startsWith("BlossomMesh") ? tree.getBlossom() != null && tree.getBlossom().name != null && tree.getBlossom().name.startsWith("CustomMeshBlossom") : true;
            return povTreeGenerator.makePreviewTree(tree, bl, bl2, frame);
        }
        catch (NumberFormatException numberFormatException) {
            this.updateStatus(0, null);
            JOptionPane.showMessageDialog(this, messagesBundle.getString("invalidNumber") + " " + numberFormatException.getMessage(), labelsBundle.getString("error"), 0);
            return null;
        }
        catch (PovtreeException povtreeException) {
            this.updateStatus(0, null);
            JOptionPane.showMessageDialog(this, povtreeException.getMessage(), labelsBundle.getString("error"), 0);
            return null;
        }
        catch (InterruptedException interruptedException) {
            this.updateStatus(0, null);
            return null;
        }
    }

    public void updateStatus(final int n, final String string) {
        Runnable runnable = new Runnable(){

            public void run() {
                if (string == null) {
                    PovTree.this.progressBar.setString("");
                } else {
                    PovTree.this.progressBar.setString(labelsBundle.getString(string));
                }
                PovTree.this.progressBar.setValue(n);
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    public void setTreeInPreviewPanel() {
        this.worker = new SwingWorker(){
            Tree tree = null;

            public Object construct() {
                this.tree = PovTree.this.getTree();
                PovTree.this.tree3D = null;
                try {
                    PovTree.this.tree3D = PovTree.this.calculateTreeModel();
                }
                catch (OutOfMemoryError outOfMemoryError) {
                    PovTree.this.updateStatus(0, null);
                    JOptionPane.showMessageDialog(PovTree.this, messagesBundle.getString("outOfMemory"), labelsBundle.getString("error"), 0);
                }
                return PovTree.this.tree3D;
            }

            public void finished() {
                PovTree.this.tree3D = (Tree3D)this.get();
                if (PovTree.this.tree3D != null) {
                    try {
                        PovTree.this.previewPanel.setTree(this.tree, PovTree.this.tree3D);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    ((CardLayout)cardPanel.getLayout()).show(cardPanel, "Preview");
                    previewToggleButton.setSelected(true);
                }
                PovTree.this.tree3D = null;
                PovTree.this.inPreview = false;
                PovTree.this.enableButtons();
            }
        };
        this.worker.start();
    }

    public void randomizeRoots() {
        this.rootPanel.setNextFloat();
    }

    public void randomizeBranches() {
        this.branchPanel.setNextFloat();
    }

    public void randomizeTwigs() {
        this.twigPanel.setNextFloat();
    }

    public ImageIcon getIcon(String string) {
        return new ImageIcon(this.getClass().getResource("images/" + string + ".png"));
    }

    public Accuracy getAccuracy() {
        Accuracy accuracy = new Accuracy();
        accuracy.rootRadial = this.rootPanel.getRadialAccuracy();
        accuracy.rootVertical = this.rootPanel.getVerticalAccuracy();
        accuracy.trunkRadial = this.trunkPanel.getRadialAccuracy();
        accuracy.trunkVertical = this.trunkPanel.getVerticalAccuracy();
        accuracy.branchRadial = this.branchPanel.getRadialAccuracy();
        accuracy.branchVertical = this.branchPanel.getVerticalAccuracy();
        accuracy.twigRadial = this.twigPanel.getRadialAccuracy();
        accuracy.twigVertical = this.twigPanel.getVerticalAccuracy();
        accuracy.ramiRadial = this.ramiPanel.getRadialAccuracy();
        accuracy.ramiVertical = this.ramiPanel.getVerticalAccuracy();
        return accuracy;
    }

    public static void main(String[] stringArray) {
        String string = stringArray.length != 0 ? stringArray[0] : Locale.getDefault().getLanguage();
        Locale locale = new Locale(string, "");
        try {
            labelsBundle = ResourceBundle.getBundle("resources/" + string + "/labels", locale);
            messagesBundle = ResourceBundle.getBundle("resources/" + string + "/messages", locale);
        }
        catch (MissingResourceException missingResourceException) {
            labelsBundle = ResourceBundle.getBundle("resources/en/labels", locale);
            messagesBundle = ResourceBundle.getBundle("resources/en/messages", locale);
            string = "en";
        }
        Resources resources = Resources.getInstance();
        Resources.setLocale(locale);
        Resources.setLabelsBundle(labelsBundle);
        Resources.setMessagesBundle(messagesBundle);
        PovTree.treesToolTip[0] = labelsBundle.getString("default");
        PovTree.treesToolTip[1] = labelsBundle.getString("birch");
        PovTree.treesToolTip[2] = labelsBundle.getString("cherry");
        PovTree.treesToolTip[3] = labelsBundle.getString("eucalyptus");
        PovTree.treesToolTip[4] = labelsBundle.getString("linden");
        PovTree.treesToolTip[5] = labelsBundle.getString("maple");
        PovTree.treesToolTip[6] = labelsBundle.getString("olive");
        PovTree.treesToolTip[7] = labelsBundle.getString("palm");
        PovTree.treesToolTip[8] = labelsBundle.getString("pine");
        PovTree.treesToolTip[9] = labelsBundle.getString("poplar");
        PovTree.treesToolTip[10] = labelsBundle.getString("spruce");
        PovTree.treesToolTip[11] = labelsBundle.getString("willow");
        try {
            UIManager.setLookAndFeel(new PovtreeLookAndFeel(labelsBundle, Constants.greenTheme));
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
        }
        frame = new PovTree(string);
        frame.setDefaultCloseOperation(3);
        Container container = frame.getContentPane();
        container.setLayout(new BorderLayout());
        container.add((Component)mainPanel, "Center");
        ToolBar toolBar = new ToolBar(labelsBundle, messagesBundle, frame);
        previewToggleButton = toolBar.getPreviewButton();
        container.add((Component)toolBar.getToolBar(), "North");
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        int n = PovTree.frame.getPreferredSize().width + 15;
        int n2 = PovTree.frame.getPreferredSize().height + 10;
        frame.setBounds(dimension.width / 2 - n / 2, dimension.height / 2 - n2 / 2, n, n2);
        Runnable runnable = new Runnable(){

            public void run() {
                frame.pack();
                frame.setVisible(true);
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    public String getTreeName() {
        return this.name.getText().trim();
    }
}

