/*
 * Decompiled with CFR 0.152.
 */
package povtree.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.ResourceBundle;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.BevelBorder;
import povtree.gui.Helper;
import povtree.gui.PovTree;
import povtree.gui.PovtreeException;
import povtree.gui.Resources;
import povtree.gui.SwingWorker;
import povtree.gui.TreeView;
import povtree.gui.plaf.ButtonUI;
import povtree.gui.plaf.GradientPanel;
import povtree.interfaces.Leaf;
import povtree.interfaces.Randomizer;
import povtree.objects.Bark;
import povtree.objects.Blossom;
import povtree.objects.Foliage;
import povtree.objects.Tree;
import povtree.objects3D.Blob;
import povtree.objects3D.BlobArray;
import povtree.objects3D.Coordinate;
import povtree.objects3D.DoubleBlobArray;
import povtree.objects3D.QuadroBlobArray;
import povtree.objects3D.QuintetBlobArray;
import povtree.objects3D.Tree3D;
import povtree.objects3D.Triangle;
import povtree.objects3D.TripleBlobArray;
import povtree.povTreeGenerator.Accuracy;
import povtree.povTreeGenerator.MeshGenerator;
import povtree.povTreeGenerator.Statistics;

public class PreviewPanel
extends JPanel {
    private JPanel previewRootPanel = new JPanel(new BorderLayout());
    private int x;
    private int y;
    private int mouseX;
    private int mouseY;
    private Tree tree;
    private Tree3D tree3D;
    private JRadioButton rotateRB = null;
    private JRadioButton scaleRB = null;
    private JRadioButton translateRB = null;
    private JButton centerB = null;
    private JRadioButton min = null;
    private JRadioButton mid = null;
    private JRadioButton high = null;
    private JRadioButton max = null;
    private byte transformationType;
    private boolean toCenter = false;
    private boolean dragged = false;
    private ArrayList allBlobs = null;
    private boolean lines = true;
    private JRadioButton linesRB = null;
    private JRadioButton spheresRB = null;
    private Graphics g;
    private float fraction;
    private float maximumZ;
    private int typeOfSelectedElement;
    private int numOfSelectedElement;
    private int branchNum;
    private int twigNum;
    private JRadioButton viewTreeRB = null;
    private JRadioButton editMeshRB = null;
    private JCheckBox xCB = null;
    private JCheckBox yCB = null;
    private JCheckBox zCB = null;
    private JButton removeB = null;
    private boolean wasPreview = false;
    private JButton refreshB = null;
    private JButton randomizeRoots = null;
    private JButton randomizeBranches = null;
    private JButton randomizeTwigs = null;
    private Randomizer mainFrame;
    private Resources resources = Resources.getInstance();
    private ResourceBundle rb = Resources.getLabelsBundle();
    private ResourceBundle mb = Resources.getMessagesBundle();
    private PovTree frame = null;
    private JTextField triangles = new JTextField(10);
    private JTextField diskSpace = new JTextField(10);
    private JButton getB = null;
    private JComboBox fileType = new JComboBox();
    private boolean inStatistics = false;
    private SwingWorker buhgalter = null;
    private TreeView treeView;
    public Comparator zSorter = new Comparator(){

        public int compare(Object object, Object object2) {
            if (object == null || object2 == null) {
                throw new NullPointerException();
            }
            float f = ((Blob)object).center.z;
            float f2 = ((Blob)object2).center.z;
            if (f > f2) {
                return 1;
            }
            if (f < f2) {
                return -1;
            }
            return 0;
        }
    };

    public PreviewPanel(Object object) {
        this.mainFrame = (Randomizer)object;
        this.frame = (PovTree)object;
        JPanel jPanel = new JPanel(new GridBagLayout());
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        this.rotateRB = new JRadioButton(this.rb.getString("rotate"), true);
        this.scaleRB = new JRadioButton(this.rb.getString("scale"), false);
        this.translateRB = new JRadioButton(this.rb.getString("translate"), false);
        this.centerB = new JButton(this.rb.getString("center"));
        this.min = new JRadioButton(this.rb.getString("min"), false);
        this.mid = new JRadioButton(this.rb.getString("middle"), false);
        this.high = new JRadioButton(this.rb.getString("high"), true);
        this.max = new JRadioButton(this.rb.getString("max"), false);
        this.linesRB = new JRadioButton(this.rb.getString("lines"), true);
        this.spheresRB = new JRadioButton(this.rb.getString("spheres"), false);
        this.viewTreeRB = new JRadioButton(this.rb.getString("viewTree"), true);
        this.editMeshRB = new JRadioButton(this.rb.getString("editMesh"), false);
        this.xCB = new JCheckBox("X", false);
        this.yCB = new JCheckBox("Y", true);
        this.zCB = new JCheckBox("Z", false);
        this.removeB = new JButton(this.rb.getString("remove"));
        this.removeB.setUI(new ButtonUI());
        this.removeB.setEnabled(false);
        this.refreshB = new JButton(this.rb.getString("refresh"));
        this.randomizeRoots = new JButton(this.rb.getString("randomizeRoots"));
        this.randomizeBranches = new JButton(this.rb.getString("randomizeBranches"));
        this.randomizeTwigs = new JButton(this.rb.getString("randomizeTwigs"));
        this.getB = new JButton(this.rb.getString("treeGetStatistics"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 0;
        JPanel jPanel3 = new JPanel(new GridBagLayout());
        gridBagConstraints.gridx = 0;
        gridBagConstraints.anchor = 10;
        jPanel3.add((Component)this.xCB, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        jPanel3.add((Component)this.yCB, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        jPanel3.add((Component)this.zCB, gridBagConstraints);
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(0, 10, 6, 10);
        jPanel.add((Component)jPanel3, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        this.centerB.setUI(new ButtonUI());
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 7, 7, 7);
        jPanel.add((Component)this.centerB, gridBagConstraints);
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.anchor = 17;
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.rotateRB);
        buttonGroup.add(this.scaleRB);
        buttonGroup.add(this.translateRB);
        GradientPanel gradientPanel = new GradientPanel(15, 15);
        gradientPanel.setLayout(new GridLayout(3, 1, 8, 8));
        gradientPanel.setGradientDirection(2);
        gradientPanel.setRound(2);
        this.rotateRB.setOpaque(false);
        this.scaleRB.setOpaque(false);
        this.translateRB.setOpaque(false);
        gradientPanel.add(this.rotateRB);
        gradientPanel.add(this.scaleRB);
        gradientPanel.add(this.translateRB);
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(0, 7, 7, 7);
        gridBagConstraints.fill = 1;
        jPanel.add((Component)gradientPanel, gridBagConstraints);
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new Insets(0, 7, 7, 7);
        gridBagConstraints.fill = 2;
        jPanel.add((Component)this.removeB, gridBagConstraints);
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.fill = 0;
        this.centerB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (PreviewPanel.this.tree3D != null) {
                    PreviewPanel.this.toCenter = false;
                    PreviewPanel.this.repaint();
                }
            }
        });
        this.viewTreeRB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PreviewPanel.this.removeB.setEnabled(false);
                PreviewPanel.this.randomizeRoots.setEnabled(true);
                PreviewPanel.this.randomizeBranches.setEnabled(true);
                PreviewPanel.this.randomizeTwigs.setEnabled(true);
            }
        });
        this.editMeshRB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PreviewPanel.this.removeB.setEnabled(true);
                PreviewPanel.this.randomizeRoots.setEnabled(false);
                PreviewPanel.this.randomizeBranches.setEnabled(false);
                PreviewPanel.this.randomizeTwigs.setEnabled(false);
                PreviewPanel.this.editMesh();
            }
        });
        this.removeB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (PreviewPanel.this.tree3D != null) {
                    if (PreviewPanel.this.numOfSelectedElement == -1) {
                        return;
                    }
                    PreviewPanel.this.removeElement();
                    PreviewPanel.this.dragged = false;
                    PreviewPanel.this.treeView.removeSelectedNode();
                    PreviewPanel.this.repaint();
                }
            }
        });
        this.refreshB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PreviewPanel.this.repaint();
            }
        });
        this.randomizeRoots.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PreviewPanel.this.mainFrame.randomizeRoots();
                PreviewPanel.this.mainFrame.setTreeInPreviewPanel();
            }
        });
        this.randomizeBranches.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PreviewPanel.this.mainFrame.randomizeBranches();
                PreviewPanel.this.mainFrame.setTreeInPreviewPanel();
            }
        });
        this.randomizeTwigs.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PreviewPanel.this.mainFrame.randomizeTwigs();
                PreviewPanel.this.mainFrame.setTreeInPreviewPanel();
            }
        });
        jPanel.setBorder(new BevelBorder(0, Helper.getLighter(jPanel.getBackground(), 40), Helper.getLighter(jPanel.getBackground(), 40), jPanel.getBackground().darker().darker(), jPanel.getBackground().darker().darker()));
        jPanel2.setBorder(new BevelBorder(0, Helper.getLighter(jPanel2.getBackground(), 40), Helper.getLighter(jPanel2.getBackground(), 40), jPanel2.getBackground().darker().darker(), jPanel2.getBackground().darker().darker()));
        buttonGroup = new ButtonGroup();
        buttonGroup.add(this.min);
        buttonGroup.add(this.mid);
        buttonGroup.add(this.high);
        buttonGroup.add(this.max);
        gradientPanel = new GradientPanel(20, 10);
        gradientPanel.setLayout(new GridLayout(4, 1, 4, 4));
        gradientPanel.setGradientDirection(2);
        gradientPanel.setRound(1);
        this.min.setOpaque(false);
        this.mid.setOpaque(false);
        this.high.setOpaque(false);
        this.max.setOpaque(false);
        gradientPanel.add(this.min);
        gradientPanel.add(this.mid);
        gradientPanel.add(this.high);
        gradientPanel.add(this.max);
        JPanel jPanel4 = new JPanel(new BorderLayout());
        jPanel4.add((Component)gradientPanel, "Center");
        GradientPanel gradientPanel2 = new GradientPanel(40, 20);
        gradientPanel2.setLayout(new GridBagLayout());
        gradientPanel2.setGradientDirection(2);
        gradientPanel2.setRound(0);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        JLabel jLabel = new JLabel(this.rb.getString("lod"));
        jLabel.setFont((Font)UIManager.get("TitledBorder.font"));
        jLabel.setForeground(Color.black);
        gradientPanel2.add((Component)jLabel, gridBagConstraints);
        jPanel4.add((Component)gradientPanel2, "North");
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 7, 7, 7);
        jPanel.add((Component)jPanel4, gridBagConstraints);
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.fill = 0;
        buttonGroup = new ButtonGroup();
        buttonGroup.add(this.linesRB);
        buttonGroup.add(this.spheresRB);
        gradientPanel = new GradientPanel(20, 10);
        gradientPanel.setLayout(new GridLayout(2, 1, 4, 4));
        gradientPanel.setGradientDirection(2);
        gradientPanel.setRound(1);
        this.linesRB.setOpaque(false);
        this.spheresRB.setOpaque(false);
        gradientPanel.add(this.linesRB);
        gradientPanel.add(this.spheresRB);
        jPanel4 = new JPanel(new BorderLayout());
        jPanel4.add((Component)gradientPanel, "Center");
        gradientPanel2 = new GradientPanel(40, 20);
        gradientPanel2.setLayout(new GridBagLayout());
        gradientPanel2.setGradientDirection(2);
        gradientPanel2.setRound(0);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        jLabel = new JLabel(this.rb.getString("draw"));
        jLabel.setFont((Font)UIManager.get("TitledBorder.font"));
        jLabel.setForeground(Color.black);
        gradientPanel2.add((Component)jLabel, gridBagConstraints);
        jPanel4.add((Component)gradientPanel2, "North");
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 7, 7, 7);
        jPanel.add((Component)jPanel4, gridBagConstraints);
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.fill = 0;
        this.refreshB.setUI(new ButtonUI());
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(0, 7, 7, 7);
        gridBagConstraints.fill = 2;
        jPanel.add((Component)this.refreshB, gridBagConstraints);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        buttonGroup = new ButtonGroup();
        buttonGroup.add(this.viewTreeRB);
        buttonGroup.add(this.editMeshRB);
        jPanel3 = new JPanel();
        jPanel3.add(this.viewTreeRB);
        jPanel3.add(this.editMeshRB);
        jPanel3.setBorder(new BevelBorder(0, Helper.getLighter(jPanel3.getBackground(), 40), Helper.getLighter(jPanel3.getBackground(), 40), jPanel3.getBackground().darker().darker(), jPanel3.getBackground().darker().darker()));
        this.previewRootPanel.add((Component)jPanel3, "North");
        jPanel3 = new JPanel();
        this.randomizeRoots.setUI(new ButtonUI());
        this.randomizeBranches.setUI(new ButtonUI());
        this.randomizeTwigs.setUI(new ButtonUI());
        jPanel3.add(this.randomizeRoots);
        jPanel3.add(this.randomizeBranches);
        jPanel3.add(this.randomizeTwigs);
        jPanel3.setBorder(new BevelBorder(0, Helper.getLighter(jPanel3.getBackground(), 40), Helper.getLighter(jPanel3.getBackground(), 40), jPanel3.getBackground().darker().darker(), jPanel3.getBackground().darker().darker()));
        this.previewRootPanel.add((Component)jPanel3, "South");
        this.previewRootPanel.add((Component)jPanel, "East");
        GradientPanel gradientPanel3 = new GradientPanel(20, 10);
        gradientPanel3.setLayout(new GridBagLayout());
        gradientPanel3.setGradientDirection(2);
        gradientPanel3.setRound(1);
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 0;
        gridBagConstraints2.anchor = 10;
        gridBagConstraints2.weightx = 1.0;
        gridBagConstraints2.weighty = 1.0;
        GradientPanel gradientPanel4 = new GradientPanel(1, 1);
        gradientPanel4.setLayout(new GridBagLayout());
        gradientPanel4.setGradientDirection(2);
        gradientPanel4.setRound(2);
        JLabel jLabel2 = new JLabel(this.rb.getString("treeNumOfTriangles"));
        jLabel2.setOpaque(false);
        gridBagConstraints2.insets = new Insets(0, 0, 0, 0);
        gradientPanel4.add((Component)jLabel2, gridBagConstraints2);
        gridBagConstraints2.fill = 2;
        gridBagConstraints2.gridy = 1;
        this.triangles.setEditable(false);
        gridBagConstraints2.insets = new Insets(2, 2, 6, 2);
        gradientPanel4.add((Component)this.triangles, gridBagConstraints2);
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 0;
        gridBagConstraints2.insets = new Insets(12, 2, 0, 2);
        gradientPanel3.add((Component)gradientPanel4, gridBagConstraints2);
        gradientPanel4 = new GradientPanel(1, 1);
        gradientPanel4.setLayout(new GridBagLayout());
        gradientPanel4.setGradientDirection(2);
        gradientPanel4.setRound(2);
        this.fileType.addItem(this.rb.getString("treeMeshSize"));
        this.fileType.setEditable(false);
        this.fileType.setOpaque(false);
        ((JLabel)((Object)this.fileType.getRenderer())).setOpaque(false);
        gridBagConstraints2.gridy = 0;
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.insets = new Insets(6, 2, 2, 2);
        gradientPanel4.add((Component)this.fileType, gridBagConstraints2);
        gridBagConstraints2.gridy = 1;
        this.diskSpace.setEditable(false);
        gridBagConstraints2.insets = new Insets(2, 2, 6, 2);
        gradientPanel4.add((Component)this.diskSpace, gridBagConstraints2);
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 1;
        gridBagConstraints2.insets = new Insets(12, 2, 0, 2);
        gradientPanel3.add((Component)gradientPanel4, gridBagConstraints2);
        gridBagConstraints2.gridy = 4;
        gridBagConstraints2.fill = 2;
        this.getB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PreviewPanel.this.showStatistics();
            }
        });
        this.getB.setUI(new ButtonUI());
        gridBagConstraints2.insets = new Insets(12, 2, 12, 2);
        gradientPanel3.add((Component)this.getB, gridBagConstraints2);
        jPanel4 = new JPanel(new BorderLayout());
        jPanel4.add((Component)gradientPanel3, "Center");
        gradientPanel2 = new GradientPanel(40, 20);
        gradientPanel2.setLayout(new GridBagLayout());
        gradientPanel2.setGradientDirection(2);
        gradientPanel2.setRound(0);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        jLabel = new JLabel(this.rb.getString("treeStatistics"));
        jLabel.setFont((Font)UIManager.get("TitledBorder.font"));
        jLabel.setForeground(Color.black);
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gradientPanel2.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.fill = 0;
        jPanel4.add((Component)gradientPanel2, "North");
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(7, 7, 7, 7);
        jPanel2.add((Component)jPanel4, gridBagConstraints);
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 11;
        this.treeView = new TreeView(this.rb, this);
        gridBagConstraints.insets = new Insets(7, 7, 0, 7);
        jPanel2.add((Component)this.treeView, gridBagConstraints);
        gridBagConstraints.fill = 0;
        this.previewRootPanel.add((Component)jPanel2, "West");
        this.setLayout(new BorderLayout());
        this.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseDragged(MouseEvent mouseEvent) {
                PreviewPanel.this.x = mouseEvent.getX();
                PreviewPanel.this.y = mouseEvent.getY();
                PreviewPanel.this.dragged = true;
                PreviewPanel.this.repaint();
            }
        });
        this.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                PreviewPanel.this.mouseX = mouseEvent.getX();
                PreviewPanel.this.mouseY = mouseEvent.getY();
            }
        });
        this.setBackground(Helper.getLighter(this.getBackground(), 20));
        this.previewRootPanel.add((Component)this, "Center");
    }

    public JPanel getPreviewRootPanel() {
        return this.previewRootPanel;
    }

    public void setTypeOfSelectedElement(int n) {
        this.typeOfSelectedElement = n;
        Runnable runnable = new Runnable(){

            public void run() {
                PreviewPanel.this.repaint();
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    public void setNumberOfSelectedElement(int n) {
        this.numOfSelectedElement = n;
    }

    public void setBranchNumber(int n) {
        this.branchNum = n;
    }

    public void setTwigNumber(int n) {
        this.twigNum = n;
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        this.g = graphics;
        Rectangle rectangle = this.getBounds();
        float f = (this.mouseY - this.y) * 360 / rectangle.width;
        float f2 = (this.x - this.mouseX) * 360 / rectangle.height;
        float f3 = (this.x - this.mouseX) * 360 / rectangle.height;
        float f4 = this.x - this.mouseX;
        float f5 = this.y - this.mouseY;
        float f6 = this.x - this.mouseX;
        if (!this.scaleRB.isSelected() && !this.xCB.isSelected()) {
            f = 0.0f;
            f4 = 0.0f;
        }
        if (!this.yCB.isSelected()) {
            f2 = 0.0f;
            f5 = 0.0f;
        }
        if (!this.zCB.isSelected()) {
            f3 = 0.0f;
            f6 = 0.0f;
        }
        if (!this.dragged) {
            f6 = 0.0f;
            f5 = 0.0f;
            f4 = 0.0f;
            f3 = 0.0f;
            f2 = 0.0f;
            f = 0.0f;
        }
        if (this.rotateRB.isSelected()) {
            this.transformationType = 0;
        } else if (this.scaleRB.isSelected()) {
            this.transformationType = 1;
        } else if (this.translateRB.isSelected()) {
            this.transformationType = (byte)2;
        }
        this.drawWireframe(rectangle, f, f2, f3, f4, f5, f6, this.transformationType);
        this.mouseX = this.x;
        this.mouseY = this.y;
        this.dragged = false;
    }

    public void setTree(Tree tree, Tree3D tree3D) throws Exception {
        this.tree = tree;
        this.tree3D = tree3D;
        this.toCenter = false;
        this.treeView.setTree(this.tree3D);
        this.viewTreeRB.setSelected(true);
        this.branchNum = -1;
        this.twigNum = -1;
        this.typeOfSelectedElement = -1;
        this.numOfSelectedElement = -1;
        this.wasPreview = true;
        this.repaint();
    }

    public int getLevelOfDetails() {
        int n = 1;
        if (this.min.isSelected()) {
            n = 24;
        } else if (this.mid.isSelected()) {
            n = 16;
        } else if (this.high.isSelected()) {
            n = 8;
        } else if (this.max.isSelected()) {
            n = 1;
        }
        return n;
    }

    public void drawWireframe(Rectangle rectangle, float f, float f2, float f3, float f4, float f5, float f6, byte by) {
        boolean bl = this.editMeshRB.isSelected();
        this.lines = this.linesRB.isSelected();
        if (this.tree3D == null) {
            return;
        }
        if (!this.toCenter) {
            this.tree3D.center(rectangle);
            this.toCenter = true;
        }
        if (by == 0 && this.dragged) {
            if (!bl) {
                this.tree3D.translateTree(-rectangle.width / 2, -rectangle.height / 2, 0.0f);
                this.tree3D.rotateTreeX(f);
                this.tree3D.rotateTreeY(f2);
                this.tree3D.rotateTreeZ(f3);
                this.tree3D.translateTree(rectangle.width / 2, rectangle.height / 2, 0.0f);
            } else {
                this.tree3D.translateTree(-rectangle.width / 2, -rectangle.height / 2, 0.0f);
                if (this.typeOfSelectedElement == 0 && this.numOfSelectedElement != -1) {
                    this.tree3D.rotateRootX(this.numOfSelectedElement, f);
                    this.tree3D.rotateRootY(this.numOfSelectedElement, f2);
                    this.tree3D.rotateRootZ(this.numOfSelectedElement, f3);
                } else if (this.typeOfSelectedElement == 1 && this.numOfSelectedElement != -1) {
                    this.tree3D.rotateBranchX(this.numOfSelectedElement, f);
                    this.tree3D.rotateBranchY(this.numOfSelectedElement, f2);
                    this.tree3D.rotateBranchZ(this.numOfSelectedElement, f3);
                } else if (this.typeOfSelectedElement == 2 && this.numOfSelectedElement != -1) {
                    this.tree3D.rotateTwigX(this.branchNum, this.numOfSelectedElement, f);
                    this.tree3D.rotateTwigY(this.branchNum, this.numOfSelectedElement, f2);
                    this.tree3D.rotateTwigZ(this.branchNum, this.numOfSelectedElement, f3);
                } else if (this.typeOfSelectedElement == 3 && this.numOfSelectedElement != -1) {
                    this.tree3D.rotateRamiX(this.branchNum, this.twigNum, this.numOfSelectedElement, f);
                    this.tree3D.rotateRamiY(this.branchNum, this.twigNum, this.numOfSelectedElement, f2);
                    this.tree3D.rotateRamiZ(this.branchNum, this.twigNum, this.numOfSelectedElement, f3);
                } else if (this.typeOfSelectedElement == 4) {
                    this.tree3D.rotateTreeX(f);
                    this.tree3D.rotateTreeY(f2);
                    this.tree3D.rotateTreeZ(f3);
                } else if (this.typeOfSelectedElement == 5) {
                    this.tree3D.rotateTrunkX(f);
                    this.tree3D.rotateTrunkY(f2);
                    this.tree3D.rotateTrunkZ(f3);
                }
                this.tree3D.translateTree(rectangle.width / 2, rectangle.height / 2, 0.0f);
            }
        } else if (by == 1 && this.dragged) {
            float f7 = 0.0f;
            f7 = f4 > 0.0f ? 1.1f : 0.9f;
            this.tree3D.translateTree(-rectangle.width / 2, -rectangle.height / 2, 0.0f);
            if (!bl) {
                this.tree3D.scaleTree(f7);
            } else if (this.typeOfSelectedElement == 0 && this.numOfSelectedElement != -1) {
                this.tree3D.scaleRoot(this.numOfSelectedElement, f7);
            } else if (this.typeOfSelectedElement == 1 && this.numOfSelectedElement != -1) {
                this.tree3D.scaleBranch(this.numOfSelectedElement, f7);
            } else if (this.typeOfSelectedElement == 2 && this.numOfSelectedElement != -1) {
                this.tree3D.scaleTwig(this.branchNum, this.numOfSelectedElement, f7);
            } else if (this.typeOfSelectedElement == 3 && this.numOfSelectedElement != -1) {
                this.tree3D.scaleRami(this.branchNum, this.twigNum, this.numOfSelectedElement, f7);
            } else if (this.typeOfSelectedElement == 4) {
                this.tree3D.scaleTree(f7);
            } else if (this.typeOfSelectedElement == 5) {
                this.tree3D.scaleTrunk(f7);
            }
            this.tree3D.translateTree(rectangle.width / 2, rectangle.height / 2, 0.0f);
        } else if (by == 2 && this.dragged) {
            if (!bl) {
                this.tree3D.translateTree(f4, f5, 0.0f);
            } else if (f4 != 0.0f || f5 != 0.0f || f6 != 0.0f) {
                if (this.typeOfSelectedElement == 0 && this.numOfSelectedElement != -1) {
                    this.tree3D.translateRoot(this.numOfSelectedElement, f4, f5, f6);
                } else if (this.typeOfSelectedElement == 1 && this.numOfSelectedElement != -1) {
                    this.tree3D.translateBranch(this.numOfSelectedElement, f4, f5, f6);
                } else if (this.typeOfSelectedElement == 2 && this.numOfSelectedElement != -1) {
                    this.tree3D.translateTwig(this.branchNum, this.numOfSelectedElement, f4, f5, f6);
                } else if (this.typeOfSelectedElement == 3 && this.numOfSelectedElement != -1) {
                    this.tree3D.translateRami(this.branchNum, this.twigNum, this.numOfSelectedElement, f4, f5, f6);
                } else if (this.typeOfSelectedElement == 4) {
                    this.tree3D.translateTree(f4, f5, f6);
                } else if (this.typeOfSelectedElement == 5) {
                    this.tree3D.translateTrunk(f4, f5, f6);
                }
            }
        }
        ArrayList arrayList = this.tree3D.getMinMax();
        Coordinate coordinate = (Coordinate)arrayList.get(0);
        Coordinate coordinate2 = (Coordinate)arrayList.get(1);
        this.fraction = (Math.abs(coordinate.z) + Math.abs(coordinate2.z)) / 180.0f;
        this.maximumZ = coordinate2.z;
        if (this.lines) {
            int n;
            DoubleBlobArray doubleBlobArray;
            ArrayList arrayList2;
            DoubleBlobArray doubleBlobArray2 = this.tree3D.getRoot();
            if (this.tree.getRootFlag() && doubleBlobArray2 != null) {
                int n2 = 0;
                while (n2 < doubleBlobArray2.size()) {
                    arrayList2 = doubleBlobArray2.get(n2).get();
                    if (this.typeOfSelectedElement == 0) {
                        if (this.numOfSelectedElement == n2) {
                            this.drawLines(arrayList2, true);
                        } else {
                            this.drawLines(arrayList2, false);
                        }
                    } else {
                        this.drawLines(arrayList2, false);
                    }
                    ++n2;
                }
            }
            BlobArray blobArray = this.tree3D.getTrunk();
            if (this.tree.getTrunkFlag() && blobArray != null) {
                if (this.typeOfSelectedElement == 5) {
                    this.drawLines(blobArray.get(), true);
                } else {
                    this.drawLines(blobArray.get(), false);
                }
            }
            DoubleBlobArray doubleBlobArray3 = this.tree3D.getBranches();
            if (this.tree.getBranchesFlag() && doubleBlobArray3 != null) {
                int n3 = 0;
                while (n3 < doubleBlobArray3.size()) {
                    arrayList2 = doubleBlobArray3.get(n3).get();
                    if (this.typeOfSelectedElement == 1) {
                        this.branchNum = this.numOfSelectedElement;
                        if (this.numOfSelectedElement == n3) {
                            this.drawLines(arrayList2, true);
                        } else {
                            this.drawLines(arrayList2, false);
                        }
                    } else {
                        this.drawLines(arrayList2, false);
                    }
                    ++n3;
                }
            }
            TripleBlobArray tripleBlobArray = this.tree3D.getTwigs();
            if (this.tree.getTwigsFlag() && tripleBlobArray != null) {
                int n4 = 0;
                while (n4 < tripleBlobArray.size()) {
                    doubleBlobArray = tripleBlobArray.get(n4);
                    n = 0;
                    while (n < doubleBlobArray.size()) {
                        arrayList2 = doubleBlobArray.get(n).get();
                        if (this.typeOfSelectedElement == 2 && n4 == this.branchNum) {
                            this.twigNum = this.numOfSelectedElement;
                            if (this.numOfSelectedElement == n) {
                                this.drawLines(arrayList2, true);
                            } else {
                                this.drawLines(arrayList2, false);
                            }
                        } else {
                            this.drawLines(arrayList2, false);
                        }
                        ++n;
                    }
                    ++n4;
                }
            }
            QuintetBlobArray quintetBlobArray = this.tree3D.getRami();
            if (this.tree.getRamiFlag() && quintetBlobArray != null) {
                n = 0;
                while (n < quintetBlobArray.size()) {
                    QuadroBlobArray quadroBlobArray = quintetBlobArray.get(n);
                    int n5 = 0;
                    while (n5 < quadroBlobArray.size()) {
                        TripleBlobArray tripleBlobArray2 = quadroBlobArray.get(n5);
                        int n6 = 0;
                        while (n6 < tripleBlobArray2.size()) {
                            doubleBlobArray = tripleBlobArray2.get(n6);
                            int n7 = 0;
                            while (n7 < doubleBlobArray.size()) {
                                arrayList2 = doubleBlobArray.get(n7).get();
                                if (this.typeOfSelectedElement == 3 && n5 == this.twigNum && n == this.branchNum) {
                                    if (this.numOfSelectedElement == n6) {
                                        this.drawLines(arrayList2, true);
                                    } else {
                                        this.drawLines(arrayList2, false);
                                    }
                                } else {
                                    this.drawLines(arrayList2, false);
                                }
                                ++n7;
                            }
                            ++n6;
                        }
                        ++n5;
                    }
                    ++n;
                }
            }
        } else {
            this.drawBlobs();
        }
    }

    public void removeElement() {
        if (this.typeOfSelectedElement == 0) {
            this.tree3D.removeRoot(this.numOfSelectedElement);
        } else if (this.typeOfSelectedElement == 1) {
            this.tree3D.removeBranch(this.numOfSelectedElement);
        } else if (this.typeOfSelectedElement == 2) {
            this.tree3D.removeTwig(this.branchNum, this.numOfSelectedElement);
        } else if (this.typeOfSelectedElement == 3) {
            this.tree3D.removeRami(this.branchNum, this.twigNum, this.numOfSelectedElement);
        } else if (this.typeOfSelectedElement == 5) {
            this.tree3D.removeTrunk();
        }
        this.numOfSelectedElement = -1;
    }

    public void drawLines(ArrayList arrayList, boolean bl) {
        int n = arrayList.size();
        int n2 = this.getLevelOfDetails();
        int n3 = 0;
        while (n3 < n) {
            Coordinate coordinate;
            Blob blob;
            Blob blob2 = (Blob)arrayList.get(n3);
            Coordinate coordinate2 = blob2.center;
            if (n3 + n2 < n) {
                blob = (Blob)arrayList.get(n3 + n2);
                coordinate = blob.center;
            } else {
                blob = (Blob)arrayList.get(arrayList.size() - 1);
                coordinate = blob.center;
            }
            if (bl) {
                this.g.setColor(Color.red);
            } else {
                this.g.setColor(this.getColor(blob2, this.fraction, this.maximumZ));
            }
            this.g.drawLine((int)coordinate2.x, (int)coordinate2.y, (int)coordinate.x, (int)coordinate.y);
            n3 += n2;
        }
    }

    public void drawBlobs() {
        Cloneable cloneable;
        Cloneable cloneable2;
        Cloneable cloneable3;
        Blob blob;
        float f = 0.0f;
        float f2 = 0.0f;
        float f3 = 0.0f;
        float f4 = 0.0f;
        float f5 = 0.0f;
        float f6 = 0.0f;
        int n = this.getLevelOfDetails();
        this.allBlobs = this.tree3D.getAllBlobs();
        int n2 = 0;
        while (n2 < this.allBlobs.size()) {
            blob = (Blob)this.allBlobs.get(n2);
            blob.show = n2 % n == 0;
            ++n2;
        }
        ArrayList arrayList = this.tree3D.getLeavesArray();
        if (this.tree.getFoliageFlag() && arrayList != null && arrayList.size() != 0) {
            Collections.sort(arrayList);
            if (arrayList.get(0) instanceof Blob) {
                f = ((Blob)arrayList.get((int)0)).center.z;
                f2 = ((Blob)arrayList.get((int)(arrayList.size() - 1))).center.z;
                f3 = (Math.abs(f) + Math.abs(f2)) / 180.0f;
            } else {
                cloneable3 = (Leaf)arrayList.get(0);
                cloneable2 = cloneable3.getTriangles();
                cloneable = (Triangle)((ArrayList)cloneable2).get(0);
                f = ((Triangle)cloneable).c1.z;
                cloneable3 = (Leaf)arrayList.get(arrayList.size() - 1);
                cloneable2 = cloneable3.getTriangles();
                cloneable = (Triangle)((ArrayList)cloneable2).get(0);
                f2 = ((Triangle)cloneable).c1.z;
                f3 = (Math.abs(f) + Math.abs(f2)) / 180.0f;
            }
        }
        cloneable3 = this.tree3D.getBlossomsArray();
        if (this.tree.getBlossomFlag() && cloneable3 != null && ((ArrayList)cloneable3).size() != 0) {
            Collections.sort(cloneable3);
            if (((ArrayList)cloneable3).get(0) instanceof Blob) {
                f4 = ((Blob)((ArrayList)cloneable3).get((int)0)).center.z;
                f5 = ((Blob)((ArrayList)cloneable3).get((int)(((ArrayList)cloneable3).size() - 1))).center.z;
                f6 = (Math.abs(f4) + Math.abs(f5)) / 180.0f;
            } else {
                cloneable2 = (Leaf)((ArrayList)cloneable3).get(0);
                cloneable = cloneable2.getTriangles();
                Triangle triangle = (Triangle)((ArrayList)cloneable).get(0);
                f4 = triangle.c1.z;
                cloneable2 = (Leaf)((ArrayList)cloneable3).get(((ArrayList)cloneable3).size() - 1);
                cloneable = cloneable2.getTriangles();
                triangle = (Triangle)((ArrayList)cloneable).get(0);
                f5 = triangle.c1.z;
                f6 = (Math.abs(f4) + Math.abs(f5)) / 180.0f;
            }
        }
        Collections.sort(this.allBlobs);
        int n3 = 0;
        while (n3 < this.allBlobs.size()) {
            blob = (Blob)this.allBlobs.get(n3);
            Coordinate coordinate = blob.center;
            if (blob.leaf) {
                this.g.setColor(this.getLeafColor(blob, f3, f2));
            } else if (blob.blossom) {
                this.g.setColor(this.getBlossomColor(blob, f6, f5));
            } else {
                this.g.setColor(this.getColor(blob, this.fraction, this.maximumZ));
            }
            if (blob.show) {
                if ((int)blob.radius > 0) {
                    this.g.fillOval((int)coordinate.x - (int)blob.radius, (int)coordinate.y - (int)blob.radius, (int)blob.radius * 2, (int)blob.radius * 2);
                } else {
                    this.g.fillOval((int)coordinate.x - 1, (int)coordinate.y - 1, 2, 2);
                }
            }
            ++n3;
        }
    }

    public Color getColor(Blob blob, float f, float f2) {
        Coordinate coordinate = blob.center;
        float f3 = f2 - coordinate.z;
        int n = (int)Math.abs(f3 / f);
        return new Color(n, n, n);
    }

    public Color getLeafColor(Blob blob, float f, float f2) {
        Coordinate coordinate = blob.center;
        float f3 = f2 - coordinate.z;
        int n = (int)Math.abs(f3 / f);
        Color color = new Color(0, 200 - n, 0);
        return color;
    }

    public Color getBlossomColor(Blob blob, float f, float f2) {
        Coordinate coordinate = blob.center;
        float f3 = f2 - coordinate.z;
        int n = (int)Math.abs(f3 / f);
        Color color = new Color(255 - n, 0, 0);
        return color;
    }

    public void editMesh() {
        if (this.wasPreview) {
            Foliage foliage = this.tree.getFoliage();
            boolean bl = this.tree.getFoliageFlag();
            if (bl && foliage != null && !foliage.type.startsWith("Mesh") && !foliage.type.startsWith("Custom")) {
                JOptionPane.showMessageDialog(this, this.mb.getString("selectMeshLeaf"), this.rb.getString("error"), 0);
                this.viewTreeRB.setSelected(true);
                return;
            }
            Blossom blossom = this.tree.getBlossom();
            boolean bl2 = this.tree.getBlossomFlag();
            if (bl2 && blossom != null && !blossom.name.startsWith("BlossomMesh") && !blossom.name.startsWith("CustomMeshBlossom")) {
                JOptionPane.showMessageDialog(this, this.mb.getString("selectMeshBlossom"), this.rb.getString("error"), 0);
                this.viewTreeRB.setSelected(true);
                return;
            }
            this.toCenter = false;
            this.wasPreview = false;
        }
        this.linesRB.setSelected(true);
        this.repaint();
    }

    public Tree3D getTree3D() {
        return this.tree3D;
    }

    public void showStatistics() {
        String string = this.frame.getTreeName();
        if (this.tree == null) {
            this.tree = this.frame.getTree();
        }
        Foliage foliage = this.tree.getFoliage();
        boolean bl = this.tree.getFoliageFlag();
        if (bl && foliage != null && !foliage.type.startsWith("Mesh") && !foliage.type.startsWith("Custom")) {
            JOptionPane.showMessageDialog(this, this.mb.getString("selectMeshLeaf"), this.rb.getString("error"), 0);
            return;
        }
        Blossom blossom = this.tree.getBlossom();
        boolean bl2 = this.tree.getBlossomFlag();
        if (bl2 && blossom != null && !blossom.name.startsWith("BlossomMesh") && !blossom.name.startsWith("CustomMeshBlossom")) {
            JOptionPane.showMessageDialog(this, this.mb.getString("selectMeshBlossom"), this.rb.getString("error"), 0);
            return;
        }
        if (this.getTree3D() == null || this.getTree3D() != null && !string.equals(this.getTree3D().name.trim())) {
            JOptionPane.showMessageDialog(this, this.mb.getString("makePreviewFirst"), this.rb.getString("error"), 0);
            return;
        }
        this.buhgalter = new SwingWorker(){

            public Object construct() {
                try {
                    Tree3D tree3D = PreviewPanel.this.getTree3D();
                    int n = PreviewPanel.this.fileType.getSelectedIndex();
                    Accuracy accuracy = PreviewPanel.this.frame.getAccuracy();
                    Statistics statistics = new Statistics(tree3D, accuracy);
                    PreviewPanel.this.triangles.setText(String.valueOf(statistics.getNumberOfTriangles()));
                    if (n == 0) {
                        Bark bark = PreviewPanel.this.tree.getBark();
                        MeshGenerator meshGenerator = new MeshGenerator(PreviewPanel.this.tree, tree3D, null, accuracy, bark.imageType, bark.imageName, bark.bumpType, bark.bumpName, bark.bumpSize, true, PreviewPanel.this.frame);
                        meshGenerator.generateMesh();
                        PreviewPanel.this.diskSpace.setText(String.valueOf(meshGenerator.getNumberOfKBytes()));
                    }
                }
                catch (IOException iOException) {
                    return null;
                }
                catch (PovtreeException povtreeException) {
                    JOptionPane.showMessageDialog(PreviewPanel.this.frame, povtreeException.getMessage(), PreviewPanel.this.rb.getString("error"), 0);
                    return null;
                }
                catch (NumberFormatException numberFormatException) {
                    JOptionPane.showMessageDialog(PreviewPanel.this.frame, PreviewPanel.this.mb.getString("invalidNumber") + " " + numberFormatException.getMessage(), PreviewPanel.this.rb.getString("error"), 0);
                    return null;
                }
                catch (InterruptedException interruptedException) {
                    PreviewPanel.this.frame.updateStatus(0, null);
                    return null;
                }
                return null;
            }

            public void finished() {
                PreviewPanel.this.frame.enableButtons();
                PreviewPanel.this.inStatistics = false;
            }
        };
        this.frame.disableButtons();
        this.inStatistics = true;
        this.buhgalter.start();
    }

    public void clearStatistics() {
        this.triangles.setText("");
        this.diskSpace.setText("");
    }

    public void cancelStatistics() {
        if (this.inStatistics && this.buhgalter != null) {
            this.buhgalter.interrupt();
            this.inStatistics = false;
        }
    }

    public void interruptStatistics() {
        if (this.buhgalter != null) {
            this.buhgalter.interrupt();
        }
    }

    public void enableStatisticsButton() {
        this.getB.setEnabled(true);
    }

    public void disableStatisticsButton() {
        this.getB.setEnabled(false);
    }
}

