/*
 * Decompiled with CFR 0.152.
 */
package povtree.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.UIManager;
import povtree.gui.EnterListener;
import povtree.gui.FloatSliderChangeListener;
import povtree.gui.Helper;
import povtree.gui.IntegerSliderChangeListener;
import povtree.gui.Painter;
import povtree.gui.PovTree;
import povtree.gui.Resources;
import povtree.gui.plaf.ComboBoxRenderer;
import povtree.gui.plaf.GradientPanel;
import povtree.gui.plaf.LabelTip;
import povtree.gui.plaf.LabelUI;
import povtree.interfaces.Paintable;
import povtree.objects.Rami;
import povtree.objects3D.DoubleBlobArray;
import povtree.objects3D.QuadroBlobArray;
import povtree.objects3D.QuintetBlobArray;
import povtree.objects3D.TripleBlobArray;
import povtree.povTreeGenerator.Accuracy;
import povtree.povTreeGenerator.Parameters;
import povtree.povTreeGenerator.RamiGenerator;

public class RamiPanel
extends JPanel
implements Paintable {
    private JSlider ramiRadialSlider = new JSlider(100000, 3000000, 100000);
    private JSlider ramiVertSlider = new JSlider(100000, 1000000, 100000);
    private JSlider ramiNumberSlider = new JSlider(0, 600000, 0);
    private JSlider ramiThicknessSlider = new JSlider(0, 100000, 0);
    private JSlider ramiStrengthSlider = new JSlider(0, 100000, 0);
    private JSlider ramiCurveSlider = new JSlider(0, 200000, 0);
    private JSlider ramiCurveFreqSlider = new JSlider(0, 400000, 0);
    private JComboBox ramiOrder;
    private JTextField ramiRadial = new JTextField(4);
    private JTextField ramiVertical = new JTextField(4);
    private JTextField ramiNumber = new JTextField(7);
    private JTextField ramiThickness = new JTextField(7);
    private JTextField ramiCurveAdjustment = new JTextField(7);
    private JTextField ramiCurveFrequency = new JTextField(7);
    private JTextField ramiStrength = new JTextField(7);
    private String[] orders = new String[]{"0", "1", "2", "3"};
    private String currentOrder;
    private Resources resources = Resources.getInstance();
    private ResourceBundle rb = Resources.getLabelsBundle();
    private ResourceBundle mb = Resources.getMessagesBundle();
    private String invalidNumber = this.mb.getString("invalidNumber");
    private String errorLabel = this.rb.getString("error");
    private Painter painter = new Painter(this.rb);
    private Parameters parameters = null;
    private PovTree povTree = null;
    private RamiGenerator rg = null;
    private Accuracy acc = new Accuracy();
    private QuadroBlobArray qba;
    private TripleBlobArray tba;
    private DoubleBlobArray dba;
    private QuintetBlobArray ramis;

    public RamiPanel(PovTree povTree, String string) {
        this.setLayout(new GridBagLayout());
        this.povTree = povTree;
        this.ramiRadial.addActionListener(new EnterListener(this.ramiRadial, this.ramiRadialSlider, this, this.invalidNumber, this.errorLabel));
        this.ramiRadialSlider.addChangeListener(new IntegerSliderChangeListener(this.ramiRadial, this));
        this.ramiRadial.setText(String.valueOf(this.acc.ramiRadial));
        Helper.setValue(this.ramiRadial, this.ramiRadialSlider, this, this.invalidNumber, this.errorLabel);
        this.ramiVertical.addActionListener(new EnterListener(this.ramiVertical, this.ramiVertSlider, this, this.invalidNumber, this.errorLabel));
        this.ramiVertSlider.addChangeListener(new IntegerSliderChangeListener(this.ramiVertical, this));
        this.ramiVertical.setText(String.valueOf(this.acc.ramiVertical));
        Helper.setValue(this.ramiVertical, this.ramiVertSlider, this, this.invalidNumber, this.errorLabel);
        this.ramiNumber.addActionListener(new EnterListener(this.ramiNumber, this.ramiNumberSlider, this, this.invalidNumber, this.errorLabel));
        this.ramiNumberSlider.addChangeListener(new IntegerSliderChangeListener(this.ramiNumber, this));
        this.ramiThickness.addActionListener(new EnterListener(this.ramiThickness, this.ramiThicknessSlider, this, this.invalidNumber, this.errorLabel));
        this.ramiThicknessSlider.addChangeListener(new FloatSliderChangeListener(this.ramiThickness, this));
        this.ramiStrength.addActionListener(new EnterListener(this.ramiStrength, this.ramiStrengthSlider, this, this.invalidNumber, this.errorLabel));
        this.ramiStrengthSlider.addChangeListener(new FloatSliderChangeListener(this.ramiStrength, this));
        this.ramiCurveAdjustment.addActionListener(new EnterListener(this.ramiCurveAdjustment, this.ramiCurveSlider, this, this.invalidNumber, this.errorLabel));
        this.ramiCurveSlider.addChangeListener(new FloatSliderChangeListener(this.ramiCurveAdjustment, this));
        this.ramiCurveFrequency.addActionListener(new EnterListener(this.ramiCurveFrequency, this.ramiCurveFreqSlider, this, this.invalidNumber, this.errorLabel));
        this.ramiCurveFreqSlider.addChangeListener(new FloatSliderChangeListener(this.ramiCurveFrequency, this));
        this.ramiOrder = new JComboBox<String>(this.orders);
        this.ramiOrder.setRenderer(new ComboBoxRenderer(this.ramiOrder));
        this.ramiOrder.setFocusable(false);
        this.ramiOrder.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = (String)RamiPanel.this.ramiOrder.getSelectedItem();
                if (RamiPanel.this.currentOrder != null && !RamiPanel.this.currentOrder.equals(string)) {
                    RamiPanel.this.currentOrder = string;
                    if (RamiPanel.this.isVisible()) {
                        RamiPanel.this.paintElement();
                    }
                }
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weighty = 10.0;
        gridBagConstraints.fill = 1;
        this.add((Component)this.painter, gridBagConstraints);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 0;
        GradientPanel gradientPanel = new GradientPanel(25, 5);
        gradientPanel.setLayout(new GridBagLayout());
        gradientPanel.setGradientDirection(2);
        gradientPanel.setRound(1);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        JLabel jLabel = new JLabel(this.rb.getString("treeLatitude"));
        LabelUI labelUI = new LabelUI();
        labelUI.setIsUnderlinable(false);
        jLabel.setUI(labelUI);
        gradientPanel.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 1;
        this.ramiRadialSlider.setPreferredSize(new Dimension(150, 16));
        gradientPanel.add((Component)this.ramiRadialSlider, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gradientPanel.add((Component)this.ramiRadial, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        jLabel = new JLabel(this.rb.getString("treeLongitude"));
        labelUI = new LabelUI();
        labelUI.setIsUnderlinable(false);
        jLabel.setUI(labelUI);
        gradientPanel.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 1;
        this.ramiVertSlider.setPreferredSize(new Dimension(150, 16));
        gradientPanel.add((Component)this.ramiVertSlider, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gradientPanel.add((Component)this.ramiVertical, gridBagConstraints);
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setOpaque(false);
        jPanel.add((Component)gradientPanel, "Center");
        GradientPanel gradientPanel2 = new GradientPanel(40, 20);
        gradientPanel2.setLayout(new GridBagLayout());
        gradientPanel2.setGradientDirection(2);
        gradientPanel2.setRound(0);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        JLabel jLabel2 = new JLabel(this.rb.getString("treeMeshAccuracy"));
        jLabel2.setFont((Font)UIManager.get("TitledBorder.font"));
        jLabel2.setForeground(Color.black);
        gradientPanel2.add((Component)jLabel2, gridBagConstraints);
        jPanel.add((Component)gradientPanel2, "North");
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        gridBagConstraints.weightx = 0.5;
        this.add((Component)jPanel, gridBagConstraints);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gradientPanel = new GradientPanel(15, 15);
        gradientPanel.setLayout(new GridBagLayout());
        gradientPanel.setGradientDirection(2);
        gradientPanel.setRound(2);
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        LabelTip labelTip = new LabelTip(this.rb.getString("order"), true, "tipsTwig", "TWIG_RAMIFICATION_ORDER", this, string);
        gradientPanel.add((Component)labelTip, gridBagConstraints);
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 1;
        this.ramiOrder.setOpaque(false);
        gradientPanel.add((Component)this.ramiOrder, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        labelTip = new LabelTip(this.rb.getString("number"), true, "tipsTwig", "LAST_RAMIFICATION_NUMBER", this, string);
        gradientPanel.add((Component)labelTip, gridBagConstraints);
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 1;
        this.ramiNumberSlider.setPreferredSize(new Dimension(150, 16));
        gradientPanel.add((Component)this.ramiNumberSlider, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gradientPanel.add((Component)this.ramiNumber, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        labelTip = new LabelTip(this.rb.getString("thickness"), true, "tipsTwig", "TWIG_RAMIFICATION_THICKNESS_CHANGE", this, string);
        gradientPanel.add((Component)labelTip, gridBagConstraints);
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 1;
        this.ramiThicknessSlider.setPreferredSize(new Dimension(150, 16));
        gradientPanel.add((Component)this.ramiThicknessSlider, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gradientPanel.add((Component)this.ramiThickness, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        labelTip = new LabelTip(this.rb.getString("strength"), true, "tipsTwig", "TWIG_RAMIFICATION_STRENGTH", this, string);
        gradientPanel.add((Component)labelTip, gridBagConstraints);
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 1;
        this.ramiStrengthSlider.setPreferredSize(new Dimension(150, 16));
        gradientPanel.add((Component)this.ramiStrengthSlider, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gradientPanel.add((Component)this.ramiStrength, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        labelTip = new LabelTip(this.rb.getString("curve"), true, "tipsTwig", "TWIG_RAMIFICATION_CURVE_ADJUSTMENT", this, string);
        gradientPanel.add((Component)labelTip, gridBagConstraints);
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 1;
        this.ramiCurveSlider.setPreferredSize(new Dimension(150, 16));
        gradientPanel.add((Component)this.ramiCurveSlider, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gradientPanel.add((Component)this.ramiCurveAdjustment, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        labelTip = new LabelTip(this.rb.getString("curveFrequency"), true, "tipsTwig", "RAMI_CURVE_FREQUENCY_ADJUSTMENT", this, string);
        gradientPanel.add((Component)labelTip, gridBagConstraints);
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 1;
        this.ramiCurveFreqSlider.setPreferredSize(new Dimension(150, 16));
        gradientPanel.add((Component)this.ramiCurveFreqSlider, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gradientPanel.add((Component)this.ramiCurveFrequency, gridBagConstraints);
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 6, 0, 0);
        this.add((Component)gradientPanel, gridBagConstraints);
    }

    public void paintElement() {
        block11: {
            if (this.povTree.getTree() == null) {
                return;
            }
            try {
                this.parameters = new Parameters(this.povTree.getTree());
            }
            catch (NumberFormatException numberFormatException) {
                JOptionPane.showMessageDialog(this, this.invalidNumber + " " + numberFormatException.getMessage(), this.rb.getString("error"), 0);
                return;
            }
            if (this.parameters.twigs >= 1.0f) {
                this.parameters.branches = 1.0f;
                this.parameters.twigs = 1.0f;
                this.parameters.blossoms = 0.0f;
                this.parameters.leaves = 0.0f;
                this.parameters.bunches = 1.0f;
                this.rg = new RamiGenerator(this.parameters);
                try {
                    this.ramis = this.rg.generate();
                    if (this.ramis != null) {
                        this.qba = this.ramis.get(0);
                        this.tba = this.qba.get(0);
                        this.dba = this.tba.get(0);
                        if (this.dba != null) {
                            this.dba.rotateX(180.0f);
                            int n = this.getRadialAccuracy();
                            int n2 = this.getVerticalAccuracy();
                            if (n != 0 && n2 != 0) {
                                this.painter.setElement(this.dba, n, n2);
                            }
                        } else {
                            this.painter.setElement(null, 0, 0);
                        }
                        break block11;
                    }
                    this.painter.setElement(null, 0, 0);
                }
                catch (Exception exception) {
                    this.painter.setElement(null, 0, 0);
                }
            } else {
                this.painter.setElement(null, 0, 0);
            }
        }
    }

    public void setRami(Rami rami) {
        this.ramiOrder.setSelectedItem(rami.ramiOrder);
        this.currentOrder = rami.ramiOrder;
        this.ramiNumber.setText(rami.ramiNumber);
        Helper.setValue(this.ramiNumber, this.ramiNumberSlider, this, this.invalidNumber, this.errorLabel);
        this.ramiThickness.setText(rami.ramiThickness);
        Helper.setValue(this.ramiThickness, this.ramiThicknessSlider, this, this.invalidNumber, this.errorLabel);
        this.ramiCurveAdjustment.setText(rami.ramiCurveAdjustment);
        Helper.setValue(this.ramiCurveAdjustment, this.ramiCurveSlider, this, this.invalidNumber, this.errorLabel);
        this.ramiCurveFrequency.setText(rami.ramiCurveFrequency);
        Helper.setValue(this.ramiCurveFrequency, this.ramiCurveFreqSlider, this, this.invalidNumber, this.errorLabel);
        this.ramiStrength.setText(rami.ramiStrength);
        Helper.setValue(this.ramiStrength, this.ramiStrengthSlider, this, this.invalidNumber, this.errorLabel);
    }

    public Rami getRami() {
        Rami rami = new Rami();
        rami.ramiOrder = (String)this.ramiOrder.getSelectedItem();
        rami.ramiNumber = this.ramiNumber.getText();
        rami.ramiThickness = this.ramiThickness.getText();
        rami.ramiCurveAdjustment = this.ramiCurveAdjustment.getText();
        rami.ramiCurveFrequency = this.ramiCurveFrequency.getText();
        rami.ramiStrength = this.ramiStrength.getText();
        return rami;
    }

    public int getRadialAccuracy() {
        int n = 0;
        String string = this.ramiRadial.getText();
        try {
            n = new Integer(string);
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this, this.invalidNumber + " " + string, this.rb.getString("error"), 0);
        }
        return n;
    }

    public int getVerticalAccuracy() {
        int n = 0;
        String string = this.ramiVertical.getText();
        try {
            n = new Integer(string);
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this, this.invalidNumber + " " + string, this.rb.getString("error"), 0);
        }
        return n;
    }
}

