/*
 * Decompiled with CFR 0.152.
 */
package povtree.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Locale;
import java.util.Random;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.UIManager;
import povtree.gui.EnterListener;
import povtree.gui.FloatSliderChangeListener;
import povtree.gui.Helper;
import povtree.gui.IntegerSliderChangeListener;
import povtree.gui.Painter;
import povtree.gui.PovTree;
import povtree.gui.Resources;
import povtree.gui.plaf.ButtonUI;
import povtree.gui.plaf.GradientPanel;
import povtree.gui.plaf.LabelTip;
import povtree.gui.plaf.LabelUI;
import povtree.interfaces.Paintable;
import povtree.objects.Root;
import povtree.objects3D.BlobArray;
import povtree.objects3D.DoubleBlobArray;
import povtree.povTreeGenerator.Accuracy;
import povtree.povTreeGenerator.Parameters;
import povtree.povTreeGenerator.RootGenerator;

public class RootPanel
extends JPanel
implements Paintable {
    private JSlider rootRadialSlider = new JSlider(100000, 3000000, 100000);
    private JSlider rootVertSlider = new JSlider(100000, 1000000, 100000);
    private JSlider numberSlider = new JSlider(0, 2000000, 0);
    private JSlider startAtSlider = new JSlider(0, 5000000, 0);
    private JSlider lengthSlider = new JSlider(0, 30000000, 0);
    private JSlider ratioSlider = new JSlider(0, 100000, 0);
    private JSlider strengthSlider = new JSlider(0, 100000, 0);
    private JSlider bendValueSlider = new JSlider(0, 1000000, 0);
    private JSlider bendFreqSlider = new JSlider(0, 10000000, 0);
    private JSlider curveValueSlider = new JSlider(0, 10000000, 0);
    private JSlider curveFreqSlider = new JSlider(0, 10000000, 0);
    private JSlider snagValueSlider = new JSlider(0, 10000000, 0);
    private JSlider snagFreqSlider = new JSlider(0, 10000000, 0);
    private JSlider angleSlider = new JSlider(-9000000, 9000000, 0);
    private JSlider alignmentSlider = new JSlider(0, 100000, 0);
    private JSlider turnSlider = new JSlider(0, 100000, 0);
    private JTextField rootRadial = new JTextField(4);
    private JTextField rootVertical = new JTextField(4);
    private JTextField number = new JTextField(7);
    private JTextField randomness = new JTextField(7);
    private JTextField startAt = new JTextField(7);
    private JTextField length = new JTextField(7);
    private JTextField thicknessRatio = new JTextField(7);
    private JTextField strength = new JTextField(7);
    private JTextField bendValue = new JTextField(7);
    private JTextField bendFrequency = new JTextField(7);
    private JTextField curveValue = new JTextField(7);
    private JTextField curveFrequency = new JTextField(7);
    private JTextField snagValue = new JTextField(7);
    private JTextField snagFrequency = new JTextField(7);
    private JTextField angle = new JTextField(7);
    private JTextField alignment = new JTextField(7);
    private JTextField turn = new JTextField(7);
    private JButton random = null;
    private Random r = new Random();
    private Resources resources = Resources.getInstance();
    private Locale locale = Resources.getLocale();
    private ResourceBundle rb = Resources.getLabelsBundle();
    private ResourceBundle mb = Resources.getMessagesBundle();
    private String invalidNumber = this.mb.getString("invalidNumber");
    private String errorLabel = this.rb.getString("error");
    private Painter painter = new Painter(this.rb);
    private Parameters parameters = null;
    private PovTree povTree = null;
    private RootGenerator rg = null;
    private Accuracy acc = new Accuracy();

    public RootPanel(PovTree povTree, String string) {
        this.random = new JButton(this.rb.getString("randomness"));
        this.povTree = povTree;
        this.random.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                RootPanel.this.setNextFloat();
            }
        });
        this.rootRadial.addActionListener(new EnterListener(this.rootRadial, this.rootRadialSlider, this, this.invalidNumber, this.errorLabel));
        this.rootRadialSlider.addChangeListener(new IntegerSliderChangeListener(this.rootRadial, this));
        this.rootRadial.setText(String.valueOf(this.acc.rootRadial));
        Helper.setValue(this.rootRadial, this.rootRadialSlider, this, this.invalidNumber, this.errorLabel);
        this.rootVertical.addActionListener(new EnterListener(this.rootVertical, this.rootVertSlider, this, this.invalidNumber, this.errorLabel));
        this.rootVertSlider.addChangeListener(new IntegerSliderChangeListener(this.rootVertical, this));
        this.rootVertical.setText(String.valueOf(this.acc.rootVertical));
        Helper.setValue(this.rootVertical, this.rootVertSlider, this, this.invalidNumber, this.errorLabel);
        this.number.addActionListener(new EnterListener(this.number, this.numberSlider, this, this.invalidNumber, this.errorLabel));
        this.numberSlider.addChangeListener(new IntegerSliderChangeListener(this.number, this));
        this.startAt.addActionListener(new EnterListener(this.startAt, this.startAtSlider, this, this.invalidNumber, this.errorLabel));
        this.startAtSlider.addChangeListener(new FloatSliderChangeListener(this.startAt, this));
        this.length.addActionListener(new EnterListener(this.length, this.lengthSlider, this, this.invalidNumber, this.errorLabel));
        this.lengthSlider.addChangeListener(new FloatSliderChangeListener(this.length, this));
        this.thicknessRatio.addActionListener(new EnterListener(this.thicknessRatio, this.ratioSlider, this, this.invalidNumber, this.errorLabel));
        this.ratioSlider.addChangeListener(new FloatSliderChangeListener(this.thicknessRatio, this));
        this.strength.addActionListener(new EnterListener(this.strength, this.strengthSlider, this, this.invalidNumber, this.errorLabel));
        this.strengthSlider.addChangeListener(new FloatSliderChangeListener(this.strength, this));
        this.bendValue.addActionListener(new EnterListener(this.bendValue, this.bendValueSlider, this, this.invalidNumber, this.errorLabel));
        this.bendValueSlider.addChangeListener(new FloatSliderChangeListener(this.bendValue, this));
        this.bendFrequency.addActionListener(new EnterListener(this.bendFrequency, this.bendFreqSlider, this, this.invalidNumber, this.errorLabel));
        this.bendFreqSlider.addChangeListener(new FloatSliderChangeListener(this.bendFrequency, this));
        this.curveValue.addActionListener(new EnterListener(this.curveValue, this.curveValueSlider, this, this.invalidNumber, this.errorLabel));
        this.curveValueSlider.addChangeListener(new FloatSliderChangeListener(this.curveValue, this));
        this.curveFrequency.addActionListener(new EnterListener(this.curveFrequency, this.curveFreqSlider, this, this.invalidNumber, this.errorLabel));
        this.curveFreqSlider.addChangeListener(new FloatSliderChangeListener(this.curveFrequency, this));
        this.snagValue.addActionListener(new EnterListener(this.snagValue, this.snagValueSlider, this, this.invalidNumber, this.errorLabel));
        this.snagValueSlider.addChangeListener(new FloatSliderChangeListener(this.snagValue, this));
        this.snagFrequency.addActionListener(new EnterListener(this.snagFrequency, this.snagFreqSlider, this, this.invalidNumber, this.errorLabel));
        this.snagFreqSlider.addChangeListener(new FloatSliderChangeListener(this.snagFrequency, this));
        this.angle.addActionListener(new EnterListener(this.angle, this.angleSlider, this, this.invalidNumber, this.errorLabel));
        this.angleSlider.addChangeListener(new FloatSliderChangeListener(this.angle, this));
        this.alignment.addActionListener(new EnterListener(this.alignment, this.alignmentSlider, this, this.invalidNumber, this.errorLabel));
        this.alignmentSlider.addChangeListener(new FloatSliderChangeListener(this.alignment, this));
        this.turn.addActionListener(new EnterListener(this.turn, this.turnSlider, this, this.invalidNumber, this.errorLabel));
        this.turnSlider.addChangeListener(new FloatSliderChangeListener(this.turn, this));
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        GradientPanel gradientPanel = new GradientPanel(15, 15);
        gradientPanel.setLayout(new GridBagLayout());
        gradientPanel.setGradientDirection(2);
        gradientPanel.setRound(2);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        LabelTip labelTip = new LabelTip(this.rb.getString("number"), true, "tipsRoot", "ROOTS", this, string);
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        gradientPanel.add((Component)labelTip, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = 0;
        this.numberSlider.setPreferredSize(new Dimension(150, 16));
        gradientPanel.add((Component)this.numberSlider, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gradientPanel.add((Component)this.number, gridBagConstraints);
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        labelTip = new LabelTip(this.rb.getString("startAt"), true, "tipsRoot", "FIRST_ROOT_AT_TRUNK", this, string);
        gradientPanel.add((Component)labelTip, gridBagConstraints);
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 1;
        this.startAtSlider.setPreferredSize(new Dimension(150, 16));
        gradientPanel.add((Component)this.startAtSlider, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gradientPanel.add((Component)this.startAt, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        labelTip = new LabelTip(this.rb.getString("length"), true, "tipsRoot", "ROOT_LENGTH", this, string);
        gradientPanel.add((Component)labelTip, gridBagConstraints);
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 1;
        this.lengthSlider.setPreferredSize(new Dimension(150, 16));
        gradientPanel.add((Component)this.lengthSlider, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gradientPanel.add((Component)this.length, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        labelTip = new LabelTip(this.rb.getString("rootThicknessRatio"), true, "tipsRoot", "ROOT_THICKNESS_CHANGE", this, string);
        gradientPanel.add((Component)labelTip, gridBagConstraints);
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 1;
        this.ratioSlider.setPreferredSize(new Dimension(150, 16));
        gradientPanel.add((Component)this.ratioSlider, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gradientPanel.add((Component)this.thicknessRatio, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        labelTip = new LabelTip(this.rb.getString("strength"), true, "tipsRoot", "ROOT_STRENGTH", this, string);
        gradientPanel.add((Component)labelTip, gridBagConstraints);
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 1;
        this.strengthSlider.setPreferredSize(new Dimension(150, 16));
        gradientPanel.add((Component)this.strengthSlider, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gradientPanel.add((Component)this.strength, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        labelTip = new LabelTip(this.rb.getString("angle"), true, "tipsRoot", "ROOT_ANGLE", this, string);
        gradientPanel.add((Component)labelTip, gridBagConstraints);
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 1;
        this.angleSlider.setPreferredSize(new Dimension(150, 16));
        gradientPanel.add((Component)this.angleSlider, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gradientPanel.add((Component)this.angle, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        labelTip = new LabelTip(this.rb.getString("alignment"), true, "tipsRoot", "ROOT_ALIGNMENT", this, string);
        gradientPanel.add((Component)labelTip, gridBagConstraints);
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 1;
        this.alignmentSlider.setPreferredSize(new Dimension(150, 16));
        gradientPanel.add((Component)this.alignmentSlider, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gradientPanel.add((Component)this.alignment, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        labelTip = new LabelTip(this.rb.getString("turn"), true, "tipsRoot", "ROOT_TURN_SWITCH", this, string);
        gradientPanel.add((Component)labelTip, gridBagConstraints);
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 1;
        this.turnSlider.setPreferredSize(new Dimension(150, 16));
        gradientPanel.add((Component)this.turnSlider, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gradientPanel.add((Component)this.turn, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 0;
        this.random.setUI(new ButtonUI());
        gridBagConstraints.insets = new Insets(3, 0, 6, 0);
        gradientPanel.add((Component)this.random, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        this.randomness.setLocale(this.locale);
        gradientPanel.add((Component)this.randomness, gridBagConstraints);
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 6, 0, 0);
        gridBagConstraints.weightx = 0.5;
        this.add((Component)gradientPanel, gridBagConstraints);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        GradientPanel gradientPanel2 = new GradientPanel(20, 10);
        gradientPanel2.setLayout(new GridBagLayout());
        gradientPanel2.setGradientDirection(2);
        gradientPanel2.setRound(1);
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        labelTip = new LabelTip(this.rb.getString("value"), true, "tipsRoot", "ROOT_BEND", this, string);
        gradientPanel2.add((Component)labelTip, gridBagConstraints);
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 1;
        this.bendValueSlider.setPreferredSize(new Dimension(150, 16));
        gradientPanel2.add((Component)this.bendValueSlider, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gradientPanel2.add((Component)this.bendValue, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        labelTip = new LabelTip(this.rb.getString("frequency"), true, "tipsRoot", "ROOT_BEND_FREQUENCY", this, string);
        gradientPanel2.add((Component)labelTip, gridBagConstraints);
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 1;
        this.bendFreqSlider.setPreferredSize(new Dimension(150, 16));
        gradientPanel2.add((Component)this.bendFreqSlider, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gradientPanel2.add((Component)this.bendFrequency, gridBagConstraints);
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)gradientPanel2, "Center");
        GradientPanel gradientPanel3 = new GradientPanel(40, 20);
        gradientPanel3.setLayout(new GridBagLayout());
        gradientPanel3.setGradientDirection(2);
        gradientPanel3.setRound(0);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        JLabel jLabel = new JLabel(this.rb.getString("bend"));
        jLabel.setFont((Font)UIManager.get("TitledBorder.font"));
        jLabel.setForeground(Color.black);
        gradientPanel3.add((Component)jLabel, gridBagConstraints);
        jPanel.add((Component)gradientPanel3, "North");
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        gridBagConstraints.weightx = 0.5;
        this.add((Component)jPanel, gridBagConstraints);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gradientPanel2 = new GradientPanel(20, 10);
        gradientPanel2.setLayout(new GridBagLayout());
        gradientPanel2.setGradientDirection(2);
        gradientPanel2.setRound(1);
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        labelTip = new LabelTip(this.rb.getString("value"), true, "tipsRoot", "ROOT_CURVE", this, string);
        gradientPanel2.add((Component)labelTip, gridBagConstraints);
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 1;
        this.curveValueSlider.setPreferredSize(new Dimension(150, 16));
        gradientPanel2.add((Component)this.curveValueSlider, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gradientPanel2.add((Component)this.curveValue, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        labelTip = new LabelTip(this.rb.getString("frequency"), true, "tipsRoot", "ROOT_CURVE_FREQUENCY", this, string);
        gradientPanel2.add((Component)labelTip, gridBagConstraints);
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 1;
        this.curveFreqSlider.setPreferredSize(new Dimension(150, 16));
        gradientPanel2.add((Component)this.curveFreqSlider, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gradientPanel2.add((Component)this.curveFrequency, gridBagConstraints);
        jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)gradientPanel2, "Center");
        gradientPanel3 = new GradientPanel(40, 20);
        gradientPanel3.setLayout(new GridBagLayout());
        gradientPanel3.setGradientDirection(2);
        gradientPanel3.setRound(0);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        jLabel = new JLabel(this.rb.getString("curve"));
        jLabel.setFont((Font)UIManager.get("TitledBorder.font"));
        jLabel.setForeground(Color.black);
        gradientPanel3.add((Component)jLabel, gridBagConstraints);
        jPanel.add((Component)gradientPanel3, "North");
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        gridBagConstraints.weightx = 0.5;
        this.add((Component)jPanel, gridBagConstraints);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gradientPanel2 = new GradientPanel(20, 10);
        gradientPanel2.setLayout(new GridBagLayout());
        gradientPanel2.setGradientDirection(2);
        gradientPanel2.setRound(1);
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        labelTip = new LabelTip(this.rb.getString("value"), true, "tipsRoot", "ROOT_SNAG", this, string);
        gradientPanel2.add((Component)labelTip, gridBagConstraints);
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 1;
        this.snagValueSlider.setPreferredSize(new Dimension(150, 16));
        gradientPanel2.add((Component)this.snagValueSlider, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gradientPanel2.add((Component)this.snagValue, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        labelTip = new LabelTip(this.rb.getString("frequency"), true, "tipsRoot", "ROOT_SNAG_FREQUENCY", this, string);
        gradientPanel2.add((Component)labelTip, gridBagConstraints);
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 1;
        this.snagFreqSlider.setPreferredSize(new Dimension(150, 16));
        gradientPanel2.add((Component)this.snagFreqSlider, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gradientPanel2.add((Component)this.snagFrequency, gridBagConstraints);
        jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)gradientPanel2, "Center");
        gradientPanel3 = new GradientPanel(40, 20);
        gradientPanel3.setLayout(new GridBagLayout());
        gradientPanel3.setGradientDirection(2);
        gradientPanel3.setRound(0);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        jLabel = new JLabel(this.rb.getString("snag"));
        jLabel.setFont((Font)UIManager.get("TitledBorder.font"));
        jLabel.setForeground(Color.black);
        gradientPanel3.add((Component)jLabel, gridBagConstraints);
        jPanel.add((Component)gradientPanel3, "North");
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        gridBagConstraints.weightx = 0.5;
        this.add((Component)jPanel, gridBagConstraints);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.5;
        this.add((Component)this.painter, gridBagConstraints);
        gridBagConstraints.weightx = 1.0;
        gradientPanel2 = new GradientPanel(25, 5);
        gradientPanel2.setLayout(new GridBagLayout());
        gradientPanel2.setGradientDirection(2);
        gradientPanel2.setRound(1);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        JLabel jLabel2 = new JLabel(this.rb.getString("treeLatitude"));
        LabelUI labelUI = new LabelUI();
        labelUI.setIsUnderlinable(false);
        jLabel2.setUI(labelUI);
        gradientPanel2.add((Component)jLabel2, gridBagConstraints);
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 1;
        this.rootRadialSlider.setPreferredSize(new Dimension(150, 16));
        gradientPanel2.add((Component)this.rootRadialSlider, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gradientPanel2.add((Component)this.rootRadial, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        jLabel2 = new JLabel(this.rb.getString("treeLongitude"));
        labelUI = new LabelUI();
        labelUI.setIsUnderlinable(false);
        jLabel2.setUI(labelUI);
        gradientPanel2.add((Component)jLabel2, gridBagConstraints);
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 1;
        this.rootVertSlider.setPreferredSize(new Dimension(150, 16));
        gradientPanel2.add((Component)this.rootVertSlider, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gradientPanel2.add((Component)this.rootVertical, gridBagConstraints);
        jPanel = new JPanel(new BorderLayout());
        jPanel.setOpaque(false);
        jPanel.add((Component)gradientPanel2, "Center");
        gradientPanel3 = new GradientPanel(40, 20);
        gradientPanel3.setLayout(new GridBagLayout());
        gradientPanel3.setGradientDirection(2);
        gradientPanel3.setRound(0);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        jLabel = new JLabel(this.rb.getString("treeMeshAccuracy"));
        jLabel.setFont((Font)UIManager.get("TitledBorder.font"));
        jLabel.setForeground(Color.black);
        gradientPanel3.add((Component)jLabel, gridBagConstraints);
        jPanel.add((Component)gradientPanel3, "North");
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        gridBagConstraints.weightx = 0.5;
        this.add((Component)jPanel, gridBagConstraints);
    }

    public void paintElement() {
        block8: {
            BlobArray blobArray = null;
            if (this.povTree.getTree() == null) {
                return;
            }
            try {
                this.parameters = new Parameters(this.povTree.getTree());
            }
            catch (NumberFormatException numberFormatException) {
                JOptionPane.showMessageDialog(this, this.invalidNumber + " " + numberFormatException.getMessage(), this.rb.getString("error"), 0);
                return;
            }
            if (this.parameters.roots >= 1.0f) {
                this.parameters.roots = 1.0f;
                this.rg = new RootGenerator(this.parameters);
                try {
                    DoubleBlobArray doubleBlobArray = this.rg.generate();
                    if (doubleBlobArray == null || (blobArray = doubleBlobArray.get(0)) == null) break block8;
                    blobArray.rotateX(180.0f);
                    int n = this.getRadialAccuracy();
                    int n2 = this.getVerticalAccuracy();
                    if (n != 0 && n2 != 0) {
                        this.painter.setElement(blobArray, n, n2);
                    }
                }
                catch (Exception exception) {
                    this.painter.setElement(null, 0, 0);
                }
            } else {
                this.painter.setElement(null, 0, 0);
            }
        }
    }

    public void setNextFloat() {
        float f = this.r.nextFloat();
        String string = String.valueOf(f);
        if (string.length() > 6) {
            string = string.substring(0, 6);
        }
        this.randomness.setText(string);
    }

    public void setRoot(Root root) {
        this.number.setText(root.number);
        Helper.setValue(this.number, this.numberSlider, this, this.invalidNumber, this.errorLabel);
        this.randomness.setText(root.randomness);
        this.startAt.setText(root.startAt);
        Helper.setValue(this.startAt, this.startAtSlider, this, this.invalidNumber, this.errorLabel);
        this.length.setText(root.length);
        Helper.setValue(this.length, this.lengthSlider, this, this.invalidNumber, this.errorLabel);
        this.thicknessRatio.setText(root.thicknessRatio);
        Helper.setValue(this.thicknessRatio, this.ratioSlider, this, this.invalidNumber, this.errorLabel);
        this.strength.setText(root.strength);
        Helper.setValue(this.strength, this.strengthSlider, this, this.invalidNumber, this.errorLabel);
        this.bendValue.setText(root.bendValue);
        Helper.setValue(this.bendValue, this.bendValueSlider, this, this.invalidNumber, this.errorLabel);
        this.bendFrequency.setText(root.bendFrequency);
        Helper.setValue(this.bendFrequency, this.bendFreqSlider, this, this.invalidNumber, this.errorLabel);
        this.curveValue.setText(root.curveValue);
        Helper.setValue(this.curveValue, this.curveValueSlider, this, this.invalidNumber, this.errorLabel);
        this.curveFrequency.setText(root.curveFrequency);
        Helper.setValue(this.curveFrequency, this.curveFreqSlider, this, this.invalidNumber, this.errorLabel);
        this.snagValue.setText(root.snagValue);
        Helper.setValue(this.snagValue, this.snagValueSlider, this, this.invalidNumber, this.errorLabel);
        this.snagFrequency.setText(root.snagFrequency);
        Helper.setValue(this.snagFrequency, this.snagFreqSlider, this, this.invalidNumber, this.errorLabel);
        this.angle.setText(root.angle);
        Helper.setValue(this.angle, this.angleSlider, this, this.invalidNumber, this.errorLabel);
        this.alignment.setText(root.alignment);
        Helper.setValue(this.alignment, this.alignmentSlider, this, this.invalidNumber, this.errorLabel);
        this.turn.setText(root.turn);
        Helper.setValue(this.turn, this.turnSlider, this, this.invalidNumber, this.errorLabel);
    }

    public Root getRoot() {
        Root root = new Root();
        root.number = this.number.getText();
        root.randomness = this.randomness.getText();
        root.startAt = this.startAt.getText();
        root.length = this.length.getText();
        root.thicknessRatio = this.thicknessRatio.getText();
        root.strength = this.strength.getText();
        root.bendValue = this.bendValue.getText();
        root.bendFrequency = this.bendFrequency.getText();
        root.curveValue = this.curveValue.getText();
        root.curveFrequency = this.curveFrequency.getText();
        root.snagValue = this.snagValue.getText();
        root.snagFrequency = this.snagFrequency.getText();
        root.angle = this.angle.getText();
        root.alignment = this.alignment.getText();
        root.turn = this.turn.getText();
        return root;
    }

    public int getRadialAccuracy() {
        int n = 0;
        String string = this.rootRadial.getText();
        try {
            n = new Integer(string);
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this, this.invalidNumber + " " + string, this.rb.getString("error"), 0);
        }
        return n;
    }

    public int getVerticalAccuracy() {
        int n = 0;
        String string = this.rootVertical.getText();
        try {
            n = new Integer(string);
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this, this.invalidNumber + " " + string, this.rb.getString("error"), 0);
        }
        return n;
    }
}

